//start of PostLh5Encoder.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * PostLh5Encoder.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.OutputStream;
import java.lang.Math;
import jp.gr.java_conf.dangan.io.Bits;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;

//import exceptions
import java.io.IOException;
import java.lang.NullPointerException;
import java.lang.IllegalArgumentException;
import jp.gr.java_conf.dangan.util.lha.BadHuffmanTableException;

import java.lang.Error;


/**
 * -lh4-, -lh5-, -lh6-, -lh7- kp PostLzssEncoderB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: PostLh5Encoder.java,v $
 * Revision 1.4  2002/12/08 00:00:00  dangan
 * [change]
 *     NX  PostLh5EncoderCombo  PostLh5Encoder ɕύXB
 *
 * Revision 1.3  2002/12/06 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.2  2002/12/01 00:00:00  dangan
 * [change]
 *     flush() Ȃ 
 *     ڑꂽ OutputStream flush() Ȃ悤ɕύXB
 *
 * Revision 1.1  2002/12/01 00:00:00  dangan
 * [bug fix] 
 *     writeOutGroup Ń[Jϐ offLenFreq gpȂ
 *     ȂȂ this.offLenFreq gpĂB
 * [maintenance]
 *     PostLh5Encoder 󂯌pCX^XtB[h
 *     buffer, codeFreq, offLenFreq p~
 *     \[X
 *
 * Revision 1.0  2002/07/31 00:00:00  dangan
 * add to version control
 * [improvement]
 *     DivideNum 𓱓鎖ɂďp^[̌}B
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.4 $
 */
public class PostLh5Encoder implements PostLzssEncoder{


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  sink
    //------------------------------------------------------------------
    //  private BitOutputStream out
    //------------------------------------------------------------------
    /**
     * -lh4-, -lh5-, -lh6-, -lh7- `̈kf[^̏o͐ rbgo̓Xg[
     */
    private BitOutputStream out;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  LZSS parameter
    //------------------------------------------------------------------
    //  private int DictionarySize
    //  private int MaxMatch
    //  private int Threshold
    //  private int DictionarySizeByteLen
    //------------------------------------------------------------------
    /**
     * LZSS̎TCY
     */
    private int DictionarySize;

    /**
     * LZSS̍őv
     */
    private int MaxMatch;

    /**
     * LZSS k/񈳏k 臒l
     */
    private int Threshold;

    /**
     * TCŶɕKvȃoCg
     */
    private int DictionarySizeByteLen;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  current position
    //------------------------------------------------------------------
    //  private int position
    //  private int flagBit
    //  private int flagPos
    //------------------------------------------------------------------
    /**
     * this.block[ this.currentBlock ] ̌ݏʒu
     */
    private int position;

    /**
     * flag oCg̈k/񈳏ktO
     */
    private int flagBit;

    /**
     * this.block[ this.currentBlock ]  flagoCg̈ʒu
     */
    private int flagPos;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  huffman code blocks
    //------------------------------------------------------------------
    //  private int currentBlock
    //  private byte[][] block
    //  private int[] blockSize
    //  private int[][] blockCodeFreq
    //  private int[][] blockOffLenFreq
    //------------------------------------------------------------------
    /**
     * ݏ̃nt}ubNB
     */
    private int currentBlock;

    /**
     * nt}R[hi[pobt@Q
     */
    private byte[][] block;

    /**
     * eubN code f[^̐
     */
    private int[] blockSize;

    /**
     * YubN code ̕px\px\Q
     */
    private int[][] blockCodeFreq;

    /**
     * YubN offLen ̕px\px\Q
     */
    private int[][] blockOffLenFreq;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  groups of huffman code blocks and patterns of groups
    //------------------------------------------------------------------
    //  private int[][] pattern
    //  private int[][] group
    //------------------------------------------------------------------
    /**
     * SubN̃O[vɕp^[̔zB
     */
    private int[][] pattern;

    /**
     * ubNgݍ킹O[v̔zB
     * this.group[0] SubNO[v
     * this.group[1] this.group[2] ɂ SubNeXŌƍŏ̃ubNO[v
     * cƂ悤Ƀs~bhɍ\B
     */
    private int[][] group;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private PostLh5Encoder()
    //  public PostLh5Encoder( OutputStream out )
    //  public PostLh5Encoder( OutputStream out, String method )
    //  public PostLh5Encoder( OutputStream out, String method, 
    //                              int BufferSize )
    //  public PostLh5Encoder( OutputStream out, String method,
    //                              int BlockNum, int BlockSize, int DivideNum )
    //------------------------------------------------------------------
    /**
     * gpsB
     */
    private PostLh5Encoder(){  }

    /**
     * -lh5- kp PostLzssEncoder \zB<br>
     * obt@TCYɂ̓ftHglgpB
     * 
     * @param out kf[^󂯎 OutputStream
     */
    public PostLh5Encoder( OutputStream out ){
        this( out, CompressMethod.LH5 );
    }

    /**
     * -lh4-, -lh5-, -lh6-, -lh7- kp PostLzssEncoder \zB<br>
     * obt@TCYɂ̓ftHglgpB
     * 
     * @param out    kf[^󂯎 OutputStream
     * @param method k@<br>
     *  &emsp;&emsp; CompressMethod.LH4 <br>
     *  &emsp;&emsp; CompressMethod.LH5 <br>
     *  &emsp;&emsp; CompressMethod.LH6 <br>
     *  &emsp;&emsp; CompressMethod.LH7 <br>
     *  &emsp;&emsp; ̉ꂩw肷B
     * 
     * @exception IllegalArgumentException 
     *               method LȊȌꍇ
     */
    public PostLh5Encoder( OutputStream out, 
                                String       method ){
        this( out, method, 16384 );
    }

    /**
     * -lh4-, -lh5-, -lh6-, -lh7- kp PostLzssEncoder \zB<br>
     * 
     * @param out        kf[^󂯎 OutputStream
     * @param method     k@<br>
     *      &emsp;&emsp; CompressMethod.LH4 <br>
     *      &emsp;&emsp; CompressMethod.LH5 <br>
     *      &emsp;&emsp; CompressMethod.LH6 <br>
     *      &emsp;&emsp; CompressMethod.LH7 <br>
     *      &emsp;&emsp; ̉ꂩw肷B
     * @param BufferSize LZSSkf[^ޔĂ
     *                   obt@̃TCY
     * 
     * @exception IllegalArgumentException <br>
     *      &emsp;&emsp; (1) method LȊȌꍇ<br>
     *      &emsp;&emsp; (2) BufferSize ꍇ<br>
     *      &emsp;&emsp; ̉ꂩ
     */
    public PostLh5Encoder( OutputStream out,
                                String       method,
                                int          BufferSize ){
        this( out, method, 1, BufferSize, 0 );
    }

    /**
     * -lh4-, -lh5-, -lh6-, -lh7- kp PostLzssEncoder \zB<br>
     * 1 BlockSizeoCg  BlockNum ̃ubNgݍ킹
     * ło̓rbg̏Ȃ\ŏo͂B
     * gݍ킹 SubN DivideNum + 1 ɕē
     * Sp^[B
     * 
     * @param out       kf[^󂯎 OutputStream
     * @param method    k@<br>
     *     &emsp;&emsp; CompressMethod.LH4 <br>
     *     &emsp;&emsp; CompressMethod.LH5 <br>
     *     &emsp;&emsp; CompressMethod.LH6 <br>
     *     &emsp;&emsp; CompressMethod.LH7 <br>
     *     &emsp;&emsp; ̉ꂩw肷B
     * @param BlockNum  ubN
     * @param BlockSize 1ubÑoCg
     * @param DivideNum ő啪
     * 
     * @exception IllegalArgumentException <br>
     *     &emsp;&emsp; (1) CompressMethod LȊȌꍇ<br>
     *     &emsp;&emsp; (2) BlockNum  0ȉ̏ꍇ<br>
     *     &emsp;&emsp; (3) BlockSize ꍇ<br>
     *     &emsp;&emsp; (4) DivideNum  0ł邩ABlockNumȏ̏ꍇ<br>
     *     &emsp;&emsp; ̂ꂩB
     */
    public PostLh5Encoder( OutputStream out,
                                String       method,
                                int          BlockNum,
                                int          BlockSize,
                                int          DivideNum ){

        if( CompressMethod.LH4.equals( method )
         || CompressMethod.LH5.equals( method )
         || CompressMethod.LH6.equals( method )
         || CompressMethod.LH7.equals( method ) ){

            this.DictionarySize        = CompressMethod.toDictionarySize( method );
            this.MaxMatch              = CompressMethod.toMaxMatch( method );
            this.Threshold             = CompressMethod.toThreshold( method );
            this.DictionarySizeByteLen = ( Bits.len( this.DictionarySize - 1 ) + 7 ) / 8;

            final int MinCapacity = ( DictionarySizeByteLen + 1 ) * 8 + 1;

            if( out != null
             && 0 < BlockNum
             && 0 <= DivideNum && DivideNum < BlockNum
             && MinCapacity <= BlockSize ){

                if( out instanceof BitOutputStream ){
                    this.out = (BitOutputStream)out;
                }else{
                    this.out = new BitOutputStream( out );
                }

                this.currentBlock    = 0;
                this.block           = new byte[ BlockNum ][];
                this.blockSize       = new int[ BlockNum ];
                this.blockCodeFreq   = new int[ BlockNum ][];
                this.blockOffLenFreq = new int[ BlockNum ][];

                int codeFreqSize   = 256 + this.MaxMatch - this.Threshold + 1;
                int offLenFreqSize = Bits.len( this.DictionarySize );
                for( int i = 0 ; i < BlockNum ; i++ ){
                    this.block[i]           = new byte[ BlockSize ];
                    this.blockCodeFreq[i]   = new int[ codeFreqSize ];
                    this.blockOffLenFreq[i] = new int[ offLenFreqSize ];
                }

                this.group      = PostLh5Encoder.createGroup( BlockNum, DivideNum );
                this.pattern    = PostLh5Encoder.createPattern( BlockNum, DivideNum );

                this.position   = 0;
                this.flagBit    = 0;
                this.flagPos    = 0;

            }else if( out == null ){
                throw new NullPointerException( "out" );
            }else if( BlockNum <= 0 ){
                throw new IllegalArgumentException( "BlockNum too small. BlockNum must be 1 or more." );
            }else if( DivideNum < 0 || BlockNum <= DivideNum ){
                throw new IllegalArgumentException( "DivideNum out of bounds( 0 to BlockNum - 1(" + ( BlockNum - 1 ) + ") )." );
            }else{
                throw new IllegalArgumentException( "BlockSize too small. BlockSize must be larger than " + MinCapacity );
            }


        }else if( method == null ){
            throw new NullPointerException( "method" );
        }else{
            throw new IllegalArgumentException( "Unknown compress method. " + method );
        }
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  write
    //------------------------------------------------------------------
    //  public void writeCode( int code )
    //  public void writeOffset( int offset )
    //------------------------------------------------------------------
    /**
     * 1byte  LZSSk̃f[^́A
     * LZSS ňkꂽkR[ĥvށB<br>
     * 
     * @param code 1byte  LZSSk̃f[^́A
     *             LZSS ňkꂽkR[ĥv
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void writeCode( int code ) throws IOException {
        int need = ( ( 0x100 <= code ? this.DictionarySizeByteLen + 1 : 1 )
                   + ( this.flagBit == 0 ? 1 : 0 ) );

        if( this.block[ this.currentBlock ].length - this.position < need
         || 65535 <= this.blockSize[ this.currentBlock ] ){

            this.currentBlock++;
            if( this.block.length <= this.currentBlock ){
                this.writeOut();
            }else{
                this.position   = 0;
            }

            this.flagBit = 0x80;
            this.flagPos = this.position++;
            this.block[ this.currentBlock ][ this.flagPos ] = 0;
        }else if( this.flagBit == 0 ){
            this.flagBit = 0x80;
            this.flagPos = this.position++;
            this.block[ this.currentBlock ][ this.flagPos ] = 0;
        }

        //f[^i[
        this.block[ this.currentBlock ][ this.position++ ] = (byte)code;

        //1rbgtOƂĊi[
        if( 0x100 <= code ){
            this.block[ this.currentBlock ][ this.flagPos ] |= this.flagBit;
        }
        this.flagBit >>= 1;

        //px\XV
        this.blockCodeFreq[ this.currentBlock ][ code ]++;

        //ubNTCYXV
        this.blockSize[ this.currentBlock ]++;
    }

    /**
     * LZSS ňkꂽkR[ĥvʒuށB<br>
     * 
     * @param offset LZSS ňkꂽkR[ĥvʒu
     */
    public void writeOffset( int offset ){
        //f[^i[
        int shift = ( this.DictionarySizeByteLen - 1 ) << 3;
        while( 0 <= shift ){
            this.block[ this.currentBlock ][ this.position++ ] = (byte)( offset >> shift );
            shift -= 8;
        }

        //px\XV
        this.blockOffLenFreq[ this.currentBlock ][ Bits.len( offset ) ]++;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  other 
    //------------------------------------------------------------------
    //  public void flush()
    //  public void close()
    //------------------------------------------------------------------
    /**
     *  PostLzssEncoder Ƀobt@OĂSĂ
     * 8rbgPʂ̃f[^o͐ OutputStream ɏo͂A
     * o͐ OutputStream  flush() B<br>
     * ̃\bh͈kωB
     * 
     * @exception IOException o̓G[ꍇ
     * 
     * @see PostLzssEncoder#flush()
     * @see BitOutputStream#flush()
     */
    public void flush() throws IOException {
        this.writeOut();
        this.out.flush();
    }

    /**
     * ̏o̓Xg[ƁAڑꂽo̓Xg[A
     * gpĂ\[XJB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        this.writeOut();                                                        //throws IOException
        this.out.close();                                                       //throws IOException

        this.out             = null;
        this.block           = null;
        this.blockCodeFreq   = null;
        this.blockOffLenFreq = null;
        this.group           = null;
        this.pattern         = null;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  get LZSS parameter
    //------------------------------------------------------------------
    //  public int getDictionarySize()
    //  public int getMaxMatch()
    //  public int getThreshold()
    //------------------------------------------------------------------
    /**
     *  PostLh5Encoder LZSS̃TCY𓾂B
     * 
     * @return  PostLh5Encoder LZSS̃TCY
     */
    public int getDictionarySize(){
        return this.DictionarySize;
    }

    /**
     *  PostLh5Encoder LZSS̍Œv𓾂B
     * 
     * @return  PostLh5Encoder LZSS̍őv
     */
    public int getMaxMatch(){
        return this.MaxMatch;
    }

    /**
     *  PostLh5Encoder LZSS̈kA񈳏k臒l𓾂B
     * 
     * @return  PostLh5Encoder LZSS̈kA񈳏k臒l
     */
    public int getThreshold(){
        return this.Threshold;
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  write huffman code
    //------------------------------------------------------------------
    //  private void writeOut()
    //  private void writeOutBestPattern()
    //  private void writeOutGroup( int[] group )
    //------------------------------------------------------------------
    /**
     * obt@OꂽSẴf[^ this.out ɏo͂B<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    private void writeOut() throws IOException {
        if( 1 < this.block.length ){
            this.writeOutBestPattern();
        }else{
            this.writeOutGroup( new int[]{ 0 } );
            this.currentBlock = 0;
        }

        this.position   = 0;
        this.flagBit    = 0;
    }

    /**
     * obt@OꂽSẴf[^ŗǂ̍\ this.out ɏo͂B<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    private void writeOutBestPattern() throws IOException {
        int[] bestPattern  = null;
        int[] groupHuffLen = new int[ this.group.length  ];

        //------------------------------------------------------------------
        //  group o͂Ƃ bit ߂B
        for( int i = 0 ; i < this.group.length ; i++ ){
            if( this.group != null ){
                int blockSize = 0;
                for( int j = 0 ; j < this.group[i].length ; j++ ){
                    blockSize += this.blockSize[ this.group[i][j] ];
                }
                if( 0 < blockSize && blockSize < 65536 ){
                    groupHuffLen[i] = 
                        PostLh5Encoder.calcHuffmanCodeLength(
                            this.DictionarySize,
                            PostLh5Encoder.margeArrays( this.group[i], this.blockCodeFreq ),
                            PostLh5Encoder.margeArrays( this.group[i], this.blockOffLenFreq ) );
                }else if( 0 == blockSize ){
                    groupHuffLen[i] = 0;
                }else{
                    groupHuffLen[i] = -1;
                }
            }else{
                groupHuffLen[i] = -1;
            }
        }

        //------------------------------------------------------------------
        //  o bit ŏƂȂ pattern 𑍓ŋ߂B
        int smallest = Integer.MAX_VALUE;
        for( int i = 0 ; i < this.pattern.length ; i++ ){
            int length = 0;

            for( int j = 0 ; j < this.pattern[i].length ; j++ ){
                if( 0 <= groupHuffLen[ this.pattern[i][j] ] ){
                    length += groupHuffLen[ this.pattern[i][j] ];
                }else{
                    length = Integer.MAX_VALUE;
                    break;
                }
            }
            if( length < smallest ){
                bestPattern = this.pattern[i];
                smallest    = length;
            }
        }

        //------------------------------------------------------------------
        //  ło bit ̏Ȃp^[ŏo
        //  ǂ p^[ ubNTCY 65536 ȏ
        //  O[vꍇ̓ubNPʂŏóB
        if( bestPattern != null ){
            for( int i = 0 ; i < bestPattern.length ; i++ ){
                this.writeOutGroup( this.group[ bestPattern[i] ] );             //throws IOException
            }
        }else{
            for( int i = 0 ; i < this.block.length ; i++ ){
                this.writeOutGroup( new int[]{ i } );
            }
        }

        this.currentBlock = 0;
    }

    /**
     * group Ŏw肳ꂽ ubNQnt} this.out ɏo͂B<br>
     * 
     * @param group o͂ubNԍz
     * 
     * @exception IOException o̓G[ꍇ
     */
    private void writeOutGroup( int[] group ) throws IOException {
        int[] codeFreq   = PostLh5Encoder.margeArrays( group, this.blockCodeFreq );
        int[] offLenFreq = PostLh5Encoder.margeArrays( group, this.blockOffLenFreq );

        int blockSize = 0;
        for( int i = 0 ; i < group.length ; i++ ){
            blockSize += this.blockSize[ group[i] ];
        }

        if( 0 < blockSize ){
            //------------------------------------------------------------------
            //  ubNTCYo
            this.out.writeBits( 16, blockSize );

            //------------------------------------------------------------------
            //  nt}\
            int[] codeLen    = StaticHuffman.FreqListToLenList( codeFreq );
            int[] codeCode   = StaticHuffman.LenListToCodeList( codeLen );
            int[] offLenLen  = StaticHuffman.FreqListToLenList( offLenFreq );
            int[] offLenCode = StaticHuffman.LenListToCodeList( offLenLen );


            //------------------------------------------------------------------
            //  code ̃nt}\o
            if( 2 <= PostLh5Encoder.countNoZeroElement( codeFreq ) ){
                int[] codeLenFreq = PostLh5Encoder.createCodeLenFreq( codeLen );
                int[] codeLenLen  = StaticHuffman.FreqListToLenList( codeLenFreq );
                int[] codeLenCode = StaticHuffman.LenListToCodeList( codeLenLen );

                if( 2 <= PostLh5Encoder.countNoZeroElement( codeLenFreq ) ){
                    this.writeCodeLenLen( codeLenLen );                         //throws IOException
                }else{
                    this.out.writeBits( 5, 0 );                                 //throws IOException
                    this.out.writeBits( 5, 
                        PostLh5Encoder.getNoZeroElementIndex( codeLenFreq ) );//throws IOException
                }
                this.writeCodeLen( codeLen, codeLenLen, codeLenCode );          //throws IOException
            }else{
                this.out.writeBits( 10, 0 );                                    //throws IOException
                this.out.writeBits( 18, 
                        PostLh5Encoder.getNoZeroElementIndex( codeFreq ) );//throws IOException
            }

            //------------------------------------------------------------------
            //  offLen ̃nt}\o
            if( 2 <= PostLh5Encoder.countNoZeroElement( offLenFreq ) ){
                this.writeOffLenLen( offLenLen );                               //throws IOException
            }else{
                int len = Bits.len( Bits.len( this.DictionarySize ) );
                this.out.writeBits( len, 0 );                                   //throws IOException
                this.out.writeBits( len, 
                        PostLh5Encoder.getNoZeroElementIndex( offLenFreq ) );//throws IOException
            }


            //------------------------------------------------------------------
            //  nt}o
            for( int i = 0 ; i < group.length ; i++ ){
                this.position = 0;
                this.flagBit  = 0;
                byte[] buffer = this.block[ group[i] ];

                for( int j = 0 ; j < this.blockSize[ group[i] ] ; j++ ){
                    if( this.flagBit == 0 ){
                        this.flagBit = 0x80;
                        this.flagPos = this.position++;
                    }
                    if( 0 == ( buffer[ this.flagPos ] & this.flagBit ) ){
                        int code = buffer[ this.position++ ] & 0xFF;
                        this.out.writeBits( codeLen[ code ], codeCode[ code ] );    //throws IOException
                    }else{
                        int code = ( buffer[ this.position++ ] & 0xFF ) | 0x100;
                        int offset = 0;
                        for( int k = 0 ; k < this.DictionarySizeByteLen ; k++ ){
                           offset = ( offset << 8 ) | ( buffer[ this.position++ ] & 0xFF );
                        }
                        int offlen = Bits.len( offset );
                        this.out.writeBits( codeLen[ code ], codeCode[ code ]  );   //throws IOException
                        this.out.writeBits( offLenLen[ offlen ], offLenCode[ offlen ] ); //throws IOException
                        if( 1 < offlen ) this.out.writeBits( offlen - 1, offset );  //throws IOException
                    }
                    this.flagBit >>= 1;
                }
            }

            //------------------------------------------------------------------
            //  ̃ubN̂߂̏
            for( int i = 0 ; i < group.length ; i++ ){
                this.blockSize[ group[i] ] = 0;

                codeFreq = this.blockCodeFreq[ group[i] ];
                for( int j = 0 ; j < codeFreq.length ; j++ ){
                    codeFreq[j] = 0;
                }

                offLenFreq = this.blockOffLenFreq[ group[i] ];
                for( int j = 0 ; j < offLenFreq.length ; j++ ){
                    offLenFreq[j] = 0;
                }
            }
        }//if( 0 < blockSize )
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  write out huffman list
    //------------------------------------------------------------------
    //  private void writeCodeLenLen( int[] codeLenLen )
    //  private void writeCodeLen( int[] codeLen,
    //           int[] codeLenLen, int[] codeLenCode )
    //  private void writeOffLenLen( int[] offLenLen )
    //------------------------------------------------------------------
    /**
     * codeLen  nt}̃XgoB
     * 
     * @param codeLenLen codeLenFreq ̃nt}̃Xg
     * 
     * @exception IOException o̓G[ꍇ
     */
    private void writeCodeLenLen( int[] codeLenLen ) throws IOException {
        int end = codeLenLen.length;
        while( 0 < end && codeLenLen[end - 1] == 0 ){
            end--;
        }

        this.out.writeBits( 5, end );                                           //throws IOException
        int index = 0;
        while( index < end ){
            int len = codeLenLen[ index++ ];
            if( len <= 6 ) this.out.writeBits( 3, len );                        //throws IOException
            else           this.out.writeBits( len - 3, ( 1 << ( len - 3 ) ) - 2 );//throws IOException

            if( index == 3 ){
                while( codeLenLen[index] == 0 && index < 6 ){
                    index++;
                }
                this.out.writeBits( 2, ( index - 3 ) & 0x03 );                  //throws IOException
            }
        }
    }

    /**
     * code ̃nt}̃Xg
     * nt}ƃOXŕȂ珑oB
     * 
     * @param codeLen     codeFreq ̃nt}̃Xg
     * @param codeLenLen  codeLenFreq ̃nt}̃Xg
     * @param codeLenCode codeLenFreq ̃nt}̃Xg
     * 
     * @exception IOException o̓G[ꍇ
     */
    private void writeCodeLen( int[] codeLen,
                               int[] codeLenLen,
                               int[] codeLenCode ) throws IOException {
        int end = codeLen.length;
        while( 0 < end && codeLen[end - 1] == 0 ){
            end--;
        }

        this.out.writeBits( 9, end );                                           //throws IOException
        int index = 0;
        while( index < end ){
            int len = codeLen[ index++ ];

            if( 0 < len ){
                this.out.writeBits( codeLenLen[len + 2], codeLenCode[len + 2] );//throws IOException
            }else{
                int count = 1;
                while( codeLen[ index ] == 0 && index < end ){
                    count++;
                    index++;
                }

                if( count <= 2 ){
                    for( int i = 0 ; i < count ; i++ )
                        this.out.writeBits(codeLenLen[0], codeLenCode[0]);      //throws IOException
                }else if( count <= 18 ){
                    this.out.writeBits( codeLenLen[1], codeLenCode[1] );        //throws IOException
                    this.out.writeBits( 4, count - 3 );                         //throws IOException
                }else if( count == 19 ){
                    this.out.writeBits( codeLenLen[0], codeLenCode[0] );        //throws IOException
                    this.out.writeBits( codeLenLen[1], codeLenCode[1] );        //throws IOException
                    this.out.writeBits( 4, 0x0F );                              //throws IOException
                }else{
                    this.out.writeBits( codeLenLen[2], codeLenCode[2] );        //throws IOException
                    this.out.writeBits( 9, count - 20 );                        //throws IOException
                }
            }
        }
    }

    /**
     * offLen ̃nt}̃Xgo
     * 
     * @param offLenLen offLenFreq ̃nt}̃Xg
     * 
     * @exception IOException o̓G[ꍇ
     */
    private void writeOffLenLen( int[] offLenLen ) throws IOException {
        int end = offLenLen.length;
        while( 0 < end && offLenLen[end - 1] == 0 ){
            end--;
        }
        
        int len = Bits.len( Bits.len( this.DictionarySize ) );
        this.out.writeBits( len, end );                                         //throws IOException
        int index = 0;
        while( index < end ){
            len = offLenLen[ index++ ];
            if( len <= 6) this.out.writeBits( 3, len );                         //throws IOException
            else          this.out.writeBits( len - 3, ( 1 << ( len - 3 ) ) - 2 );//throws IOException
        }
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  staff of huffman encoder
    //------------------------------------------------------------------
    //  private static int countNoZeroElement( int[] array )
    //  private static int getNoZeroElementIndex( int[] array )
    //  private static int[] margeArrays( int[] indexes, int[][] arrays )
    //  private static int[] createCodeLenFreq( int[] CodeLenList )
    //------------------------------------------------------------------
    /**
     * z 0łȂvf𓾂B
     * 
     * @param array z
     * 
     * @return z 0łȂvf
     */
    private static int countNoZeroElement( int[] array ){
        int count = 0;
        for( int i = 0 ; i < array.length ; i++ ){
            if( 0 != array[i] ){
                count++;
            }
        }
        return count;
    }

    /**
     * z 0łȂŏ̗vf𓾂B
     * 
     * @param array z
     * 
     * @return z 0łȂŏ̗vf
     *         SĂ̗vf0̏ꍇ 0ԂB
     */
    private static int getNoZeroElementIndex( int[] array ){
        for( int i = 0 ; i < array.length ; i++ ){
            if( 0 != array[i] ){
                return i;
            }
        }
        return 0;
    }

    /**
     * arrays ̒Aindexes Ŏw肳ꂽzAB
     * 
     * @param indexes arrays̑Ώۂ̔zY̕\
     * @param arrays  Ώۂ̔z܂񂾃Xg
     */
    private static int[] margeArrays( int[] indexes, int[][] arrays ){
        if( 1 < indexes.length ){
            int[] array = new int[ arrays[0].length ];

            for( int i = 0 ; i < indexes.length ; i++ ){
                int[] src = arrays[ indexes[i] ];

                for( int j = 0 ; j < src.length ; j++ ){
                    array[j] += src[j];
                }
            }
            return array;
        }else{
            return arrays[ indexes[0] ];
        }
    }


    /**
     * codeLen OXƃnt}ŕ邽߂̕px\쐬B
     * 쐬px\ 
     * codeLenFreq[0]ɂ͗vf0̗vf1ēǂݔ΂w
     * codeLenFreq[1]ɂ͗vf0̗vf3`18āA5bit̃f[^݂
     * ̒̃f[^ǂݔ΂w
     * codeLenFreq[2]ɂ͗vf0̗vf20ȏ゠āA9bit̃f[^݂
     * ̒̃f[^ǂݔ΂w
     * ƂȈӖvf܂܂B
     * ]̕px +2ꂽʒuɂꂼzuB
     * 
     * @param codeLen codeFreq ̃nt}̃Xg
     * 
     * @return codeLen ̕px\
     */
    private static int[] createCodeLenFreq( int[] codeLen ){
        int[] codeLenFreq = new int[ StaticHuffman.LimitLen + 3 ];

        int end = codeLen.length;
        while( 0 < end && codeLen[end - 1] == 0 ){
            end--;
        }

        int index = 0;
        while( index < end ){
            int len = codeLen[ index++ ];

            if( 0 < len ){
                codeLenFreq[ len + 2 ]++;
            }else{
                int count = 1;
                while( codeLen[ index ] == 0 && index < end ){
                    count++;
                    index++;
                }

                if( count <= 2 ){
                    codeLenFreq[0] += count;
                }else if( count <= 18 ){
                    codeLenFreq[1]++;
                }else if( count == 19 ){
                    codeLenFreq[0]++;
                    codeLenFreq[1]++;
                }else{
                    codeLenFreq[2]++;
                }
            }
        }
        return codeLenFreq;
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  calc the langth of encoded data
    //------------------------------------------------------------------
    //  private static int calcHuffmanCodeLength( int DictionarySize, 
    //                            int[] CodeFreq, int[] OffLenFreq )
    //  private static int calcCodeLenLen( int[] codeLenLen )
    //  private static int calcCodeLen( int[] codeLen, int[] codeLenLen )
    //  private static int calcOffLenLen( int DictionarySize, int[] offLenLen )
    //------------------------------------------------------------------
    /**
     * w肳ꂽpxŃnt}
     * o͂ꍇ̃rbg𓾂B
     * 
     * @param DictionarySize LZSSTCY
     * @param codeFreq       R[h̕px
     * @param offLenFreq     ItZbg̒̕px
     * 
     * @return ̕pxŃnt}o͂ꍇ̃rbg𓾂B
     */
    private static int calcHuffmanCodeLength( int   DictionarySize,
                                              int[] codeFreq,
                                              int[] offLenFreq ){

        //------------------------------------------------------------------
        //  
        int length = 0;
        int[] codeLen, codeCode, offLenLen;
        try{
            codeLen   = StaticHuffman.FreqListToLenList( codeFreq );
            codeCode  = StaticHuffman.LenListToCodeList( codeLen );
            offLenLen = StaticHuffman.FreqListToLenList( offLenFreq );
        }catch( BadHuffmanTableException exception ){ //Ȃ
            throw new Error( "caught the BadHuffmanTableException which should be never thrown." );
        }

        //------------------------------------------------------------------
        //  code ̃nt}px\̒ZoB
        length += 16;
        if( 2 <= PostLh5Encoder.countNoZeroElement( codeFreq ) ){
            int[] codeLenFreq = PostLh5Encoder.createCodeLenFreq( codeLen );
            int[] codeLenLen  = StaticHuffman.FreqListToLenList( codeLenFreq );
            if( 2 <= PostLh5Encoder.countNoZeroElement( codeLenFreq ) ){
                length += PostLh5Encoder.calcCodeLenLen( codeLenLen );
            }else{
                length += 5;
                length += 5;
            }
            length += PostLh5Encoder.calcCodeLen( codeLen, codeLenLen );
        }else{
            length += 10;
            length += 18;
        }

        //------------------------------------------------------------------
        //  offLen ̃nt}px\̒ZoB
        if( 2 <= PostLh5Encoder.countNoZeroElement( offLenFreq ) ){
            length += PostLh5Encoder.calcOffLenLen( DictionarySize, offLenLen );
        }else{
            int len = Bits.len( Bits.len( DictionarySize ) );
            length += len;
            length += len;
        }

        //------------------------------------------------------------------
        //  LZSSk̃f[^Ƀnt}ZoB
        for( int i = 0 ; i < codeFreq.length ; i++ ){
            length += codeFreq[i] * codeLen[i];
        }
        for( int i = 0 ; i < offLenFreq.length ; i++ ){
            length += offLenFreq[i] * ( offLenLen[i] + i - 1 );
        }
        return length;
    }

    /**
     * w肵nt}̕\o͂ꍇ̃rbg𓾂B
     * 
     * @param codeLenLen R[h̃nt}
     *                   Ƀnt}̂̕\
     * 
     * @return w肵nt}̕\o͂ꍇ̃rbg
     */
    private static int calcCodeLenLen( int[] codeLenLen ){
        int length = 0;
        int end    = codeLenLen.length;
        while( 0 < end && codeLenLen[end - 1] == 0 ){
            end--;
        }

        length += 5;

        int index = 0;
        while( index < end ){
            int len = codeLenLen[ index++ ];
            if( len <= 6 ) length += len;
            else           length += len - 3;

            if( index == 3 ){
                while( codeLenLen[index] == 0 && index < 6 ){
                    index++;
                }
                length += 2;
            }
        }
        return length;
    }

    /**
     * w肵nt}̕\o͂ꍇ̃rbg𓾂B
     * 
     * @param codeLen    R[h̃nt}̕\
     * @param codeLenLen R[h̃nt}
     *                   Ƀnt}̂̕\
     * 
     * @return w肵nt}̕\o͂ꍇ̃rbg
     */
    private static int calcCodeLen( int[] codeLen,
                                    int[] codeLenLen ){
        int length = 0;
        int end    = codeLen.length;
        while( 0 < end && codeLen[end - 1] == 0 ){
            end--;
        }

        length += 9;

        int index = 0;
        while( index < end ){
            int len = codeLen[ index++ ];

            if( 0 < len ){
                length += codeLenLen[ len + 2 ];
            }else{
                int count = 1;
                while( codeLen[ index ] == 0 && index < end ){
                    count++;
                    index++;
                }

                if( count <= 2 ){
                    for( int i = 0 ; i < count ; i++ )
                        length += codeLenLen[0];
                }else if( count <= 18 ){
                    length += codeLenLen[1];
                    length += 4;
                }else if( count == 19 ){
                    length += codeLenLen[0];
                    length += codeLenLen[1];
                    length += 4;
                }else{
                    length += codeLenLen[2];
                    length += 9;
                }
            }
        }
        return length;
    }

    /**
     * w肵nt}̕\o͂ꍇ̃rbg𓾂B
     * 
     * @param DictionarySize LZSSTCY
     * @param offLenLen      ItZbg̒̃nt}̕\
     * 
     * @return w肵nt}̕\o͂ꍇ̃rbg
     */
    private static int calcOffLenLen( int   DictionarySize,
                                      int[] offLenLen ){
        int length = 0;
        int end    = offLenLen.length;
        while( 0 < end && offLenLen[end - 1] == 0 ){
            end--;
        }

        length += Bits.len( Bits.len( DictionarySize ) );

        int index = 0;
        while( index < end ){
            int len = offLenLen[ index++ ];
            if( len <= 6) length += 3;
            else          length += len - 3;
        }
        return length;
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  create group and pattern
    //------------------------------------------------------------------
    //  private static int[][] createGroup( int BlockNum, int DivideNum )
    //  private static int[][] createPattern( int BlockNum, int DivideNum )
    //  private static int calcPatternNum( int BlockNum, int DivideNum )
    //------------------------------------------------------------------
    /**
     * BlockNum̃ubNAubN
     * O[v̂̃XgԂB
     * <pre>
     * group = new int[]{ 0,1,2 }
     * </pre>
     * ̂悤ȏꍇ 
     * block[0]  block[1]  block[2] 
     * 琬O[vł邱ƂB
     * ܂O[v 
     * group[0] ͑SubN琬O[vA
     * group[1]  group[2] ͂ꂼSubN
     * Ō̃ubNƍŏ̃ubŃA
     * Ƃ悤 s~bhɋKĐA
     * createPattern ͂̋K𗘗p邽 
     * ̃\bhςꍇ͒ӂ邱ƁB
     * ܂AgpȂ group ɂ null Ă̂Œӂ邱ƁB
     * 
     * @param BlockNum  ubŇ
     * @param DivideNum ő啪
     * 
     * @reutrn ꂽO[ṽXg
     */
    private static int[][] createGroup( int BlockNum, int DivideNum ){
        int[][] group = new int[ ( BlockNum + 1 ) * BlockNum / 2 ][];

        if( DivideNum == 0 ){
            //------------------------------------------------------------------
            //  SubNO[v̂ݐ
            group[0] = new int[ BlockNum ];
            for( int i = 0 ; i < BlockNum ; i++ ){
                group[0][i] = i;
            }
        }else if( 2 < BlockNum && DivideNum == 1 ){
            //------------------------------------------------------------------
            //  TCỸO[v̂ŏ̂̂ƍŌ̂̂B
            int index = 0;
            for( int size = BlockNum ; 0 < size ; size-- ){
                group[ index ] = new int[ size ];
                for( int i = 0 ; i < size ; i++  ){
                    group[index][i] = i;
                }
                if( size < BlockNum ){
                    index +=  BlockNum - size;
                    group[ index ] = new int[ size ];
                    for( int i = 0 ; i < size ; i++ ){
                        group[index][i] = i + BlockNum - size;
                    }
                }
                index++;
            }
        }else{
            //------------------------------------------------------------------
            //  SO[v𐶐B
            int index = 0;
            for( int size = BlockNum ; 0 < size ; size-- ){
                for( int start = 0 ; size + start <= BlockNum ; start++ ){
                    group[index] = new int[ size ];

                    for( int i = 0 ; i < size ; i++  ){
                        group[index][i] = start + i;
                    }
                    index++;
                }
            }
        }
        return group;
    }

    /**
     * BlockNum̃ubNő DivideNum + 1̗̈
     * Ƃ p^[̕\𐶐B
     * 1̃p^[ createGroup Ő
     * O[vzւ̓Y̗񋓂ŎB
     * <pre>
     * pattern = new int[]{ 1,3 }; 
     * </pre>
     * ̂悤 p^[ group[1]  group[3] ̊Ԃ
     * ꂽƂB
     * 
     * @param BlockNum  ubŇ
     * @param DivideNum ő啪
     * 
     * @return ꂽp^[̃Xg
     */
    private static int[][] createPattern( int BlockNum, int DivideNum ){
        int index = 0;
        int patternNum = PostLh5Encoder.calcPatternNum( BlockNum, DivideNum );
        int[][] pattern = new int[ patternNum ][];

        for( int div = 0 ; div < Math.min( BlockNum, DivideNum + 1 ) ; div++ ){
            //ʒuێzB 
            //z̒ĺAႦ 0̏ꍇ Block[0]  Block[1] ̊Ԃŕ邱ƂӖB
            int[] divPos = new int[ div ]; 
            for( int i = 0 ; i < divPos.length ; i++ ){
                divPos[i] = i;
            }

            // ̃p^[𐶐郋[v
            //more  ̕ŁA܂p^[ł鎖B
            boolean more;
            do{
                pattern[index] = new int[ div + 1 ];

                int start = 0;
                for( int i = 0 ; i < divPos.length ; i++ ){
                    int len = ( divPos[i] - start ) + 1;
                    int num = BlockNum - len;
                    pattern[index][i] = ( num + 1 ) * num / 2 + start;
                    start += len;
                }
                int num = BlockNum - ( BlockNum - start );
                pattern[index][divPos.length] = ( num + 1 ) * num / 2 + start;
                index++;

                //ʒuړBʒuړł΁A
                //̕ł܂o͂łp^[ƔfłB
                more = false;
                int move  = divPos.length - 1;
                int range = BlockNum - 2;
                while( 0 <= move && !more ){
                    if( divPos[move] < range ){
                        divPos[move]++;
                        if( move < divPos.length - 1 ){
                            for( int i = move ; i < divPos.length - 1 ; i++ )
                                divPos[i+1] = divPos[i] + 1;
                        }
                        more = true;
                    }
                    range = divPos[move] - 1;
                    move--;
                }
            }while( more );
        }
        return pattern;
    }

    /**
     * BlockNum ̃ubN 
     * ő DivideNum + 1 ɘÄɕꍇ
     * p^[ł邩𓾂B
     * 
     * @param BlockNum  ubŇ
     * @param DivideNum 
     * 
     * @return p^[B
     */
    private static int calcPatternNum( int BlockNum, int DivideNum ){
        int patternNum = 0;
        for( int div = 0 ; div <= DivideNum ; div++ ){
            int count = ( div <= ( BlockNum / 2 ) ? div : BlockNum - 1 - div );

            int numerator = 1;
            for( int i = 1 ; i <= count ; i++ ){
                numerator *= ( BlockNum - i );
            }

            int denominator = 1;
            for( int i = 1 ; i <= count ; i++ ){
                denominator *= i;
            }
            
            patternNum += numerator / denominator;
        }
        return patternNum;
    }

}
//end of PostLh5Encoder.java
