/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.pdf;

import de.erichseifert.vectorgraphics2d.GraphicsState;
import de.erichseifert.vectorgraphics2d.SizedDocument;
import de.erichseifert.vectorgraphics2d.intermediate.CommandSequence;
import de.erichseifert.vectorgraphics2d.intermediate.commands.AffineTransformCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.Command;
import de.erichseifert.vectorgraphics2d.intermediate.commands.CreateCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DisposeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DrawImageCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DrawShapeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DrawStringCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.FillShapeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.Group;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetBackgroundCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetClipCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetColorCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetFontCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetHintCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetPaintCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetStrokeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetTransformCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.StateCommand;
import de.erichseifert.vectorgraphics2d.pdf.DefaultPDFObject;
import de.erichseifert.vectorgraphics2d.pdf.PDFObject;
import de.erichseifert.vectorgraphics2d.pdf.Payload;
import de.erichseifert.vectorgraphics2d.pdf.Resources;
import de.erichseifert.vectorgraphics2d.pdf.Stream;
import de.erichseifert.vectorgraphics2d.pdf.TrueTypeFont;
import de.erichseifert.vectorgraphics2d.util.DataUtils;
import de.erichseifert.vectorgraphics2d.util.FlateEncodeStream;
import de.erichseifert.vectorgraphics2d.util.FormattingWriter;
import de.erichseifert.vectorgraphics2d.util.GraphicsUtils;
import de.erichseifert.vectorgraphics2d.util.ImageDataStream;
import de.erichseifert.vectorgraphics2d.util.PageSize;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

class PDFDocument
extends SizedDocument {
    private static final String EOL = "\n";
    private static final String CHARSET = "ISO-8859-1";
    private static final String HEADER = "%PDF-1.4";
    private static final String FOOTER = "%%EOF";
    private static final double MM_IN_UNITS = 2.834645669291339;
    private static final Map<Integer, Integer> STROKE_ENDCAPS = DataUtils.map(new Integer[]{0, 1, 2}, new Integer[]{0, 1, 2});
    private static final Map<Integer, Integer> STROKE_LINEJOIN = DataUtils.map(new Integer[]{0, 1, 2}, new Integer[]{0, 1, 2});
    private final List<PDFObject> objects;
    private final Map<PDFObject, Long> crossReferences;
    private Stream contents;
    private Resources resources;
    private final Map<Integer, PDFObject> images;
    private final Stack<GraphicsState> states = new Stack();
    private boolean transformed;

    public PDFDocument(CommandSequence commandSequence, PageSize pageSize, boolean bl) {
        super(pageSize, bl);
        this.states.push(new GraphicsState());
        this.objects = new LinkedList<PDFObject>();
        this.crossReferences = new HashMap<PDFObject, Long>();
        this.images = new HashMap<Integer, PDFObject>();
        this.contents = this.initPage();
        for (Command command : commandSequence) {
            String string = this.toString(command);
            try {
                this.contents.write(string.getBytes(CHARSET));
                this.contents.write(EOL.getBytes(CHARSET));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.close();
    }

    private GraphicsState getCurrentState() {
        return this.states.peek();
    }

    private Stream initPage() {
        Stream.Filter[] filterArray;
        DefaultPDFObject defaultPDFObject = this.addCatalog();
        LinkedList<PDFObject> linkedList = new LinkedList<PDFObject>();
        PDFObject pDFObject = this.addPageTree(defaultPDFObject, linkedList);
        DefaultPDFObject defaultPDFObject2 = this.addPage(pDFObject);
        linkedList.add(defaultPDFObject2);
        if (this.isCompressed()) {
            Stream.Filter[] filterArray2 = new Stream.Filter[1];
            filterArray = filterArray2;
            filterArray2[0] = Stream.Filter.FLATE;
        } else {
            filterArray = new Stream.Filter[]{};
        }
        Stream.Filter[] filterArray3 = filterArray;
        Stream stream = new Stream(filterArray3);
        this.objects.add(stream);
        defaultPDFObject2.dict.put("Contents", stream);
        try {
            stream.write(DataUtils.join("", new Object[]{"q", EOL, this.getOutput(this.getCurrentState().getColor()), EOL, 2.834645669291339, " 0 0 ", -2.834645669291339, " 0 ", this.getPageSize().getHeight() * 2.834645669291339, " cm", EOL}).getBytes(CHARSET));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.resources = new Resources();
        this.objects.add(this.resources);
        defaultPDFObject2.dict.put("Resources", this.resources);
        Font font = this.getCurrentState().getFont();
        String string = this.resources.getId(font);
        float f = font.getSize2D();
        this.setFont(string, f, stream);
        return stream;
    }

    private void setFont(String string, float f, Stream stream) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/").append(string).append(" ").append(f).append(" Tf").append(EOL);
        try {
            stream.write(stringBuilder.toString().getBytes(CHARSET));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private DefaultPDFObject addObject(Map<String, Object> map, Payload payload) {
        DefaultPDFObject defaultPDFObject = new DefaultPDFObject(map, payload, true);
        this.objects.add(defaultPDFObject);
        return defaultPDFObject;
    }

    private DefaultPDFObject addCatalog() {
        Map<String, Object> map = DataUtils.map(new String[]{"Type"}, new Object[]{"Catalog"});
        return this.addDictionary(map);
    }

    private PDFObject addPageTree(DefaultPDFObject defaultPDFObject, List<PDFObject> list) {
        Map<String, Object> map = DataUtils.map(new String[]{"Type", "Kids", "Count"}, new Object[]{"Pages", list, 1});
        DefaultPDFObject defaultPDFObject2 = this.addDictionary(map);
        defaultPDFObject.dict.put("Pages", defaultPDFObject2);
        return defaultPDFObject2;
    }

    private DefaultPDFObject addPage(PDFObject pDFObject) {
        double d = this.getPageSize().getX() * 2.834645669291339;
        double d2 = this.getPageSize().getY() * 2.834645669291339;
        double d3 = this.getPageSize().getWidth() * 2.834645669291339;
        double d4 = this.getPageSize().getHeight() * 2.834645669291339;
        Map<String, Object> map = DataUtils.map(new String[]{"Type", "Parent", "MediaBox"}, new Object[]{"Page", pDFObject, new double[]{d, d2, d3, d4}});
        DefaultPDFObject defaultPDFObject = this.addDictionary(map);
        return defaultPDFObject;
    }

    private DefaultPDFObject addDictionary(Map<String, Object> map) {
        DefaultPDFObject defaultPDFObject = new DefaultPDFObject(map, null, false);
        this.objects.add(defaultPDFObject);
        return defaultPDFObject;
    }

    private DefaultPDFObject addObject(Image image) {
        BufferedImage bufferedImage = GraphicsUtils.toBufferedImage(image);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = DataUtils.max(bufferedImage.getSampleModel().getSampleSize());
        int n4 = bufferedImage.getSampleModel().getNumBands();
        String string = n4 == 1 ? "DeviceGray" : "DeviceRGB";
        Payload payload = new Payload();
        String[] stringArray = new String[]{};
        if (this.isCompressed()) {
            payload.addFilter(FlateEncodeStream.class);
            stringArray = new String[]{"FlateDecode"};
        }
        ImageDataStream imageDataStream = new ImageDataStream(bufferedImage, ImageDataStream.Interleaving.WITHOUT_ALPHA);
        try {
            DataUtils.transfer(imageDataStream, payload, 1024);
            payload.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        int n5 = payload.getBytes().length;
        Map<String, Object> map = DataUtils.map(new String[]{"Type", "Subtype", "Width", "Height", "ColorSpace", "BitsPerComponent", "Length", "Filter"}, new Object[]{"XObject", "Image", n, n2, string, n3, n5, stringArray});
        DefaultPDFObject defaultPDFObject = this.addObject(map, payload);
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        if (bl) {
            boolean bl2;
            BufferedImage bufferedImage2 = GraphicsUtils.getAlphaImage(bufferedImage);
            DefaultPDFObject defaultPDFObject2 = this.addObject(bufferedImage2);
            boolean bl3 = bl2 = bufferedImage2.getSampleModel().getSampleSize(0) == 1;
            if (bl2) {
                defaultPDFObject2.dict.put("ImageMask", true);
                defaultPDFObject2.dict.remove("ColorSpace");
                defaultPDFObject.dict.put("Mask", defaultPDFObject2);
            } else {
                defaultPDFObject.dict.put("SMask", defaultPDFObject2);
            }
        }
        return defaultPDFObject;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        FormattingWriter formattingWriter = new FormattingWriter(outputStream, CHARSET, EOL);
        formattingWriter.writeln(HEADER);
        for (PDFObject pDFObject : this.objects) {
            this.crossReferences.put(pDFObject, formattingWriter.tell());
            String string = pDFObject instanceof Resources ? this.toString((Resources)pDFObject) : (pDFObject instanceof Stream ? this.toString((Stream)pDFObject) : this.toString(pDFObject));
            formattingWriter.writeln(string);
            formattingWriter.flush();
        }
        long l = formattingWriter.tell();
        formattingWriter.writeln("xref");
        formattingWriter.write(0).write(" ").writeln(this.objects.size() + 1);
        formattingWriter.format("%010d %05d f ", 0, 65535).writeln();
        for (PDFObject pDFObject : this.objects) {
            formattingWriter.format("%010d %05d n ", this.crossReferences.get(pDFObject), 0).writeln();
        }
        formattingWriter.flush();
        formattingWriter.writeln("trailer");
        formattingWriter.writeln(this.serialize(DataUtils.map(new String[]{"Size", "Root"}, new Object[]{this.objects.size() + 1, this.objects.get(0)})));
        formattingWriter.writeln("startxref");
        formattingWriter.writeln(l);
        formattingWriter.writeln(FOOTER);
        formattingWriter.flush();
    }

    private int getId(PDFObject pDFObject) {
        int n = this.objects.indexOf(pDFObject);
        if (n < 0) {
            throw new IllegalArgumentException("Object " + pDFObject + " is not part of this document.");
        }
        return n + 1;
    }

    private int getVersion(PDFObject pDFObject) {
        return 0;
    }

    private String toString(Resources resources) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getId(resources)).append(" ").append(this.getVersion(resources)).append(" obj").append(EOL);
        stringBuilder.append("<<").append(EOL);
        if (!resources.getProcSet().isEmpty()) {
            stringBuilder.append("/ProcSet ").append(this.serialize(resources.getProcSet())).append(EOL);
        }
        if (!resources.getFont().isEmpty()) {
            stringBuilder.append("/Font ").append(this.serialize(resources.getFont())).append(EOL);
        }
        if (resources.dict.get("ExtGState") != null) {
            stringBuilder.append("/ExtGState ").append(this.serialize(resources.dict.get("ExtGState"))).append(EOL);
        }
        if (resources.dict.get("XObject") != null) {
            stringBuilder.append("/XObject ").append(this.serialize(resources.dict.get("XObject"))).append(EOL);
        }
        stringBuilder.append(">>").append(EOL);
        stringBuilder.append("endobj");
        return stringBuilder.toString();
    }

    private String toString(Stream stream) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getId(stream)).append(" ").append(this.getVersion(stream)).append(" obj").append(EOL);
        stringBuilder.append(PDFDocument.serialize(stream)).append(EOL);
        stringBuilder.append("endobj");
        return stringBuilder.toString();
    }

    protected static String serialize(Stream stream) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<<").append(EOL);
        stringBuilder.append("/Length ").append(stream.getLength()).append(EOL);
        if (stream.getFilters().contains((Object)Stream.Filter.FLATE)) {
            stringBuilder.append("/Filter /FlateDecode").append(EOL);
        }
        stringBuilder.append(">>").append(EOL);
        stringBuilder.append("stream").append(EOL);
        stringBuilder.append(new String(stream.getContent())).append(EOL);
        stringBuilder.append("endstream");
        return stringBuilder.toString();
    }

    protected static String serialize(TrueTypeFont trueTypeFont) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<<").append(EOL);
        stringBuilder.append("/Type ").append("/").append(trueTypeFont.getType()).append(EOL);
        stringBuilder.append("/Subtype ").append("/").append(trueTypeFont.getSubtype()).append(EOL);
        stringBuilder.append("/Encoding ").append("/").append(trueTypeFont.getEncoding()).append(EOL);
        stringBuilder.append("/BaseFont ").append("/").append(trueTypeFont.getBaseFont()).append(EOL);
        stringBuilder.append(">>");
        return stringBuilder.toString();
    }

    public String toString(PDFObject pDFObject) {
        DefaultPDFObject defaultPDFObject = (DefaultPDFObject)pDFObject;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getId(defaultPDFObject)).append(" ").append(this.getVersion(defaultPDFObject)).append(" obj").append(EOL);
        if (!defaultPDFObject.dict.isEmpty()) {
            stringBuilder.append(this.serialize(defaultPDFObject.dict)).append(EOL);
        }
        if (defaultPDFObject.payload != null) {
            String string;
            try {
                string = new String(defaultPDFObject.payload.getBytes(), CHARSET);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = "";
            }
            if (string.length() > 0) {
                if (defaultPDFObject.stream) {
                    stringBuilder.append("stream").append(EOL);
                }
                stringBuilder.append(string);
                if (defaultPDFObject.stream) {
                    stringBuilder.append("endstream");
                }
                stringBuilder.append(EOL);
            }
        }
        stringBuilder.append("endobj");
        return stringBuilder.toString();
    }

    private String serialize(Object object) {
        if (object instanceof String) {
            return "/" + object.toString();
        }
        if (object instanceof float[]) {
            return this.serialize(DataUtils.asList((float[])object));
        }
        if (object instanceof double[]) {
            return this.serialize(DataUtils.asList((double[])object));
        }
        if (object instanceof Object[]) {
            return this.serialize(Arrays.asList((Object[])object));
        }
        if (object instanceof List) {
            List list = (List)object;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            int n = 0;
            for (Object e : list) {
                if (n++ > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(this.serialize(e));
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<<").append(EOL);
            for (Map.Entry entry : map.entrySet()) {
                String string = entry.getKey().toString();
                stringBuilder.append(this.serialize(string)).append(" ");
                Object v = entry.getValue();
                stringBuilder.append(this.serialize(v)).append(EOL);
            }
            stringBuilder.append(">>");
            return stringBuilder.toString();
        }
        if (object instanceof TrueTypeFont) {
            return PDFDocument.serialize((TrueTypeFont)object);
        }
        if (object instanceof PDFObject) {
            PDFObject pDFObject = (PDFObject)object;
            return String.valueOf(this.getId(pDFObject)) + " " + this.getVersion(pDFObject) + " R";
        }
        return DataUtils.format(object);
    }

    private String toString(Command<?> command) {
        String string = "";
        if (command instanceof Group) {
            Group group = (Group)command;
            this.applyStateCommands((List)group.getValue());
            string = this.getOutput(this.getCurrentState(), this.resources, !this.transformed);
            this.transformed = true;
        } else if (command instanceof DrawShapeCommand) {
            DrawShapeCommand drawShapeCommand = (DrawShapeCommand)command;
            string = this.getOutput((Shape)drawShapeCommand.getValue()) + " S";
        } else if (command instanceof FillShapeCommand) {
            FillShapeCommand fillShapeCommand = (FillShapeCommand)command;
            string = this.getOutput((Shape)fillShapeCommand.getValue()) + " f";
        } else if (command instanceof DrawStringCommand) {
            DrawStringCommand drawStringCommand = (DrawStringCommand)command;
            string = PDFDocument.getOutput((String)drawStringCommand.getValue(), drawStringCommand.getX(), drawStringCommand.getY());
        } else if (command instanceof DrawImageCommand) {
            DrawImageCommand drawImageCommand = (DrawImageCommand)command;
            Image image = (Image)drawImageCommand.getValue();
            PDFObject pDFObject = this.images.get(image.hashCode());
            if (pDFObject == null) {
                pDFObject = this.addObject(image);
                this.images.put(image.hashCode(), pDFObject);
            }
            string = PDFDocument.getOutput(pDFObject, drawImageCommand.getX(), drawImageCommand.getY(), drawImageCommand.getWidth(), drawImageCommand.getHeight(), this.resources);
        }
        return string;
    }

    private void applyStateCommands(List<Command<?>> list) {
        for (Command<?> command : list) {
            StateCommand stateCommand;
            if (command instanceof SetHintCommand) {
                stateCommand = (SetHintCommand)command;
                this.getCurrentState().getHints().put(((SetHintCommand)stateCommand).getKey(), stateCommand.getValue());
                continue;
            }
            if (command instanceof SetBackgroundCommand) {
                stateCommand = (SetBackgroundCommand)command;
                this.getCurrentState().setBackground((Color)stateCommand.getValue());
                continue;
            }
            if (command instanceof SetColorCommand) {
                stateCommand = (SetColorCommand)command;
                this.getCurrentState().setColor((Color)stateCommand.getValue());
                continue;
            }
            if (command instanceof SetPaintCommand) {
                stateCommand = (SetPaintCommand)command;
                this.getCurrentState().setPaint((Paint)stateCommand.getValue());
                continue;
            }
            if (command instanceof SetStrokeCommand) {
                stateCommand = (SetStrokeCommand)command;
                this.getCurrentState().setStroke((Stroke)stateCommand.getValue());
                continue;
            }
            if (command instanceof SetFontCommand) {
                stateCommand = (SetFontCommand)command;
                this.getCurrentState().setFont((Font)stateCommand.getValue());
                continue;
            }
            if (command instanceof SetTransformCommand) {
                throw new UnsupportedOperationException("The PDF format has no means of setting the transformation matrix.");
            }
            if (command instanceof AffineTransformCommand) {
                stateCommand = (AffineTransformCommand)command;
                AffineTransform affineTransform = this.getCurrentState().getTransform();
                AffineTransform affineTransform2 = (AffineTransform)stateCommand.getValue();
                affineTransform.concatenate(affineTransform2);
                this.getCurrentState().setTransform(affineTransform);
                continue;
            }
            if (command instanceof SetClipCommand) {
                stateCommand = (SetClipCommand)command;
                this.getCurrentState().setClip((Shape)stateCommand.getValue());
                continue;
            }
            if (command instanceof CreateCommand) {
                try {
                    this.states.push((GraphicsState)this.getCurrentState().clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
                continue;
            }
            if (!(command instanceof DisposeCommand)) continue;
            this.states.pop();
        }
    }

    private String getOutput(Color color) {
        if (color.getColorSpace().getType() == 9) {
            float[] fArray = color.getComponents(null);
            String string = this.serialize(Float.valueOf(fArray[0]));
            String string2 = this.serialize(Float.valueOf(fArray[1]));
            String string3 = this.serialize(Float.valueOf(fArray[2]));
            String string4 = this.serialize(Float.valueOf(fArray[3]));
            return string + " " + string2 + " " + string3 + " " + string4 + " k " + string + " " + string2 + " " + string3 + " " + string4 + " K";
        }
        String string = this.serialize((double)color.getRed() / 255.0);
        String string5 = this.serialize((double)color.getGreen() / 255.0);
        String string6 = this.serialize((double)color.getBlue() / 255.0);
        return string + " " + string5 + " " + string6 + " rg " + string + " " + string5 + " " + string6 + " RG";
    }

    private String getOutput(Shape shape) {
        StringBuilder stringBuilder = new StringBuilder();
        PathIterator pathIterator = shape.getPathIterator(null);
        double[] dArray = new double[6];
        double[] dArray2 = new double[2];
        int n = 0;
        while (!pathIterator.isDone()) {
            if (n > 0) {
                stringBuilder.append(" ");
            }
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    stringBuilder.append(this.serialize(dArray[0])).append(" ").append(this.serialize(dArray[1])).append(" m");
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                    break;
                }
                case 1: {
                    stringBuilder.append(this.serialize(dArray[0])).append(" ").append(this.serialize(dArray[1])).append(" l");
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                    break;
                }
                case 3: {
                    stringBuilder.append(this.serialize(dArray[0])).append(" ").append(this.serialize(dArray[1])).append(" ").append(this.serialize(dArray[2])).append(" ").append(this.serialize(dArray[3])).append(" ").append(this.serialize(dArray[4])).append(" ").append(this.serialize(dArray[5])).append(" c");
                    dArray2[0] = dArray[4];
                    dArray2[1] = dArray[5];
                    break;
                }
                case 2: {
                    double d = dArray2[0] + 0.6666666666666666 * (dArray[0] - dArray2[0]);
                    double d2 = dArray2[1] + 0.6666666666666666 * (dArray[1] - dArray2[1]);
                    double d3 = dArray[0] + 0.3333333333333333 * (dArray[2] - dArray[0]);
                    double d4 = dArray[1] + 0.3333333333333333 * (dArray[3] - dArray[1]);
                    double d5 = dArray[2];
                    double d6 = dArray[3];
                    stringBuilder.append(this.serialize(d)).append(" ").append(this.serialize(d2)).append(" ").append(this.serialize(d3)).append(" ").append(this.serialize(d4)).append(" ").append(this.serialize(d5)).append(" ").append(this.serialize(d6)).append(" c");
                    dArray2[0] = d5;
                    dArray2[1] = d6;
                    break;
                }
                case 4: {
                    stringBuilder.append("h");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown path operation.");
                }
            }
            ++n;
            pathIterator.next();
        }
        return stringBuilder.toString();
    }

    private String getOutput(GraphicsState graphicsState, Resources resources, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            stringBuilder.append("Q").append(EOL);
        }
        stringBuilder.append("q").append(EOL);
        if (!graphicsState.getColor().equals(GraphicsState.DEFAULT_COLOR)) {
            if (graphicsState.getColor().getAlpha() != GraphicsState.DEFAULT_COLOR.getAlpha()) {
                double d = (double)graphicsState.getColor().getAlpha() / 255.0;
                String string = resources.getId(d);
                stringBuilder.append("/").append(string).append(" gs").append(EOL);
            }
            stringBuilder.append(this.getOutput(graphicsState.getColor())).append(EOL);
        }
        if (!graphicsState.getTransform().equals(GraphicsState.DEFAULT_TRANSFORM)) {
            stringBuilder.append(PDFDocument.getOutput(graphicsState.getTransform())).append(" cm").append(EOL);
        }
        if (!graphicsState.getStroke().equals(GraphicsState.DEFAULT_STROKE)) {
            stringBuilder.append(this.getOutput(graphicsState.getStroke())).append(EOL);
        }
        if (graphicsState.getClip() != GraphicsState.DEFAULT_CLIP) {
            stringBuilder.append(this.getOutput(graphicsState.getClip())).append(" W n").append(EOL);
        }
        if (!graphicsState.getFont().equals(GraphicsState.DEFAULT_FONT)) {
            Font font = graphicsState.getFont();
            String string = resources.getId(font);
            float f = font.getSize2D();
            stringBuilder.append("/").append(string).append(" ").append(f).append(" Tf").append(EOL);
        }
        return DataUtils.stripTrailing(stringBuilder.toString(), EOL);
    }

    private String getOutput(Stroke stroke) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)GraphicsState.DEFAULT_STROKE;
            BasicStroke basicStroke2 = (BasicStroke)stroke;
            if (basicStroke2.getLineWidth() != basicStroke.getLineWidth()) {
                stringBuilder.append(this.serialize(Float.valueOf(basicStroke2.getLineWidth()))).append(" w").append(EOL);
            }
            if (basicStroke2.getLineJoin() == 0 && basicStroke2.getMiterLimit() != basicStroke.getMiterLimit()) {
                stringBuilder.append(this.serialize(Float.valueOf(basicStroke2.getMiterLimit()))).append(" M").append(EOL);
            }
            if (basicStroke2.getLineJoin() != basicStroke.getLineJoin()) {
                stringBuilder.append(this.serialize(STROKE_LINEJOIN.get(basicStroke2.getLineJoin()))).append(" j").append(EOL);
            }
            if (basicStroke2.getEndCap() != basicStroke.getEndCap()) {
                stringBuilder.append(this.serialize(STROKE_ENDCAPS.get(basicStroke2.getEndCap()))).append(" J").append(EOL);
            }
            if (basicStroke2.getDashArray() != basicStroke.getDashArray()) {
                if (basicStroke2.getDashArray() != null) {
                    stringBuilder.append(this.serialize(basicStroke2.getDashArray())).append(" ").append(this.serialize(Float.valueOf(basicStroke2.getDashPhase()))).append(" d").append(EOL);
                } else {
                    stringBuilder.append(EOL).append("[] 0 d").append(EOL);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String getOutput(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        return DataUtils.join(" ", dArray);
    }

    private static String getOutput(String string, double d, double d2) {
        return "q 1 0 0 -1 " + d + " " + d2 + " cm " + "BT " + PDFDocument.getOutput(string) + " Tj ET " + "Q";
    }

    private static StringBuilder getOutput(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        string = string.replaceAll("\\\\", "\\\\\\\\").replaceAll("\t", "\\\\t").replaceAll("\b", "\\\\b").replaceAll("\f", "\\\\f").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("[\r\n]", "");
        stringBuilder.append("(").append(string).append(")");
        return stringBuilder;
    }

    private static String getOutput(PDFObject pDFObject, double d, double d2, double d3, double d4, Resources resources) {
        String string = resources.getId(pDFObject);
        return "q " + d3 + " 0 0 " + d4 + " " + d + " " + d2 + " cm " + "1 0 0 -1 0 1 cm " + "/" + string + " Do " + "Q";
    }

    public void close() {
        try {
            String string = "Q";
            if (this.transformed) {
                string = string + "\nQ";
            }
            this.contents.write(string.getBytes(CHARSET));
            this.contents.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

