// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Standard_AncestorIterator_HeaderFile
#define _Standard_AncestorIterator_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_Standard_Type.hxx>
#include <Standard_Integer.hxx>
#include <Standard_Boolean.hxx>
class Standard_Type;
class Standard_NoMoreObject;



//! The class <AncestorIterator> is a iterator which provides
//! information about inheritance.
//! An AncestorIterator object is used to scan sequentially the
//! hierarchy of a type object from its direct super-type to the root.
//!
//! Warning:
//! The near parents are first.
class Standard_AncestorIterator 
{
public:

  DEFINE_STANDARD_ALLOC

  

  //! The copy constructor for a AncestorIterator .
  Standard_EXPORT Standard_AncestorIterator(const Standard_AncestorIterator& anOther);
  

  //! Creates an iterator on the type <aType>.
  //! Set the iterator at the beginning of the ancestors;
  //! this means near parents are first.
  Standard_EXPORT Standard_AncestorIterator(const Handle(Standard_Type)& aType);
  

  //! Assigns an  AncestorIterator from another AncestorIterator.
  Standard_EXPORT   void Assign (const Standard_AncestorIterator& anOther) ;
  void operator = (const Standard_AncestorIterator& anOther) 
{
  Assign(anOther);
}
  

  //! Returns True if there are other ancestors.
  //!
  //! Example:
  //!
  //! Handle(Standard_Type) type;
  //! Standard_AncestorIterator super(TYPE(Geom_Circle));
  //! while(super.More()) { type = super.Value();
  //! super.Next();
  //! }
  Standard_EXPORT   Standard_Boolean More()  const;
  

  //! Moves the position of the iterator to the next super-type.
  //! If the current position corresponds to a root class, it becomes undefined.
  //!
  //! Exceptions:
  //! Standard_NoMoreObject if the position of the iterator is undefined
  //! If there are no more ancestors.
  Standard_EXPORT   void Next() ;
  

  //! Returns an <AncestorIterator> corresponding to the current position
  //! of the iterator.
  //! If there are no more Ancestors.
  Standard_EXPORT   Standard_AncestorIterator Iterator()  const;
  

  //! Returns the type corresponding to the current position of
  //! the iterator.
  //!
  //! Example:
  //!
  //! Standard_AncestorIterator super(TYPE(Geom_Circle));
  //! assert (super.Value() == TYPE(Geom_Conic));
  //!
  //! Exceptions:
  //! Standard_NoSuchObject if the position of the iterator is undefined.
  //! If there are no more ancestors.
  Standard_EXPORT   Handle(Standard_Type) Value()  const;




protected:





private:



  Handle(Standard_Type) myType;
  Standard_Integer myNbIter;


};







#endif // _Standard_AncestorIterator_HeaderFile
