/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           |
     \\/     M anipulation  |
-------------------------------------------------------------------------------
                            | Copyright (C) 2016-2017 Wikki Ltd
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

InNamespace
    Foam::fam

Description
    Calculate the matrix for implicit and explicit sources.

SourceFiles
    famSup.C

\*---------------------------------------------------------------------------*/

#ifndef famSup_H
#define famSup_H

#include "areaFieldsFwd.H"
#include "faMatrix.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                      Namespace fam functions Declaration
\*---------------------------------------------------------------------------*/

namespace fam
{
   // Explicit source

        template<class Type>
        tmp<faMatrix<Type>> Su
        (
            const GeometricField<Type, faPatchField, areaMesh>&,
            const GeometricField<Type, faPatchField, areaMesh>&
        );

        template<class Type>
        tmp<faMatrix<Type>> Su
        (
            const tmp<GeometricField<Type, faPatchField, areaMesh>>&,
            const GeometricField<Type, faPatchField, areaMesh>&
        );


    // Implicit source

        template<class Type>
        tmp<faMatrix<Type>> Sp
        (
            const areaScalarField&,
            const GeometricField<Type, faPatchField, areaMesh>&
        );

        template<class Type>
        tmp<faMatrix<Type>> Sp
        (
            const tmp<areaScalarField>&,
            const GeometricField<Type, faPatchField, areaMesh>&
        );


        template<class Type>
        tmp<faMatrix<Type>> Sp
        (
            const dimensionedScalar&,
            const GeometricField<Type, faPatchField, areaMesh>&
        );


    // Implicit/Explicit source depending on sign of coefficient

        template<class Type>
        tmp<faMatrix<Type>> SuSp
        (
            const areaScalarField&,
            const GeometricField<Type, faPatchField, areaMesh>&
        );

        template<class Type>
        tmp<faMatrix<Type>> SuSp
        (
            const tmp<areaScalarField>&,
            const GeometricField<Type, faPatchField, areaMesh>&
        );
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "famSup.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
