/*
 * Copyright © 2017 Miklós Máté
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/** Paragraph 4 of the Errors section:
 *
 * The error INVALID_OPERATION is generated by EndFragmentShaderATI if
 * <argN> passed to ColorFragmentOp[1..3]ATI or
 * AlphaFragmentOp[1..3]ATI is PRIMARY_COLOR_ARB or
 * SECONDARY_INTERPOLATOR_ATI on the first pass of a two-pass shader,
 * or if the shader cannot be compiled due to some other
 * implementation-dependent limitation.  EndFragmentShaderATI will
 * still have a side-effect if this error is encountered: the
 * Begin/EndFragmentShaderATI pair will be closed, and the current
 * shader will be undefined.
 */

#include "piglit-util-gl.h"

PIGLIT_GL_TEST_CONFIG_BEGIN

	config.supports_gl_compat_version = 10;
	config.window_visual = PIGLIT_GL_VISUAL_DOUBLE | PIGLIT_GL_VISUAL_RGBA;

PIGLIT_GL_TEST_CONFIG_END

enum piglit_result
piglit_display(void)
{
	/* UNREACHED */
	return PIGLIT_FAIL;
}

void
piglit_init(int argc, char **argv)
{
	bool pass = true;

	piglit_require_extension("GL_ATI_fragment_shader");

	/* use GL_PRIMARY_COLOR_ARB in the first pass */
	glBeginFragmentShaderATI();
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_PRIMARY_COLOR_ARB, GL_NONE, GL_NONE);
	glPassTexCoordATI(GL_REG_0_ATI, GL_REG_0_ATI, GL_SWIZZLE_STR_ATI);
	/* note: Mesa requires at least 1 arith instruction per pass,
	 * but this is not in the spec */
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_REG_0_ATI, GL_NONE, GL_NONE);
	pass &= piglit_check_gl_error(GL_NO_ERROR);
	glEndFragmentShaderATI();
	pass &= piglit_check_gl_error(GL_INVALID_OPERATION);

	/* see if EndFragmentShaderATI really ended the shader */
	glEndFragmentShaderATI();
	pass &= piglit_check_gl_error(GL_INVALID_OPERATION);

	/* use GL_SECONDARY_INTERPOLATOR_ATI in the first pass */
	glBeginFragmentShaderATI();
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_SECONDARY_INTERPOLATOR_ATI, GL_NONE, GL_NONE);
	glPassTexCoordATI(GL_REG_0_ATI, GL_REG_0_ATI, GL_SWIZZLE_STR_ATI);
	/* note: Mesa requires at least 1 arith instruction per pass,
	 * but this is not in the spec */
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_REG_0_ATI, GL_NONE, GL_NONE);
	pass &= piglit_check_gl_error(GL_NO_ERROR);
	glEndFragmentShaderATI();
	pass &= piglit_check_gl_error(GL_INVALID_OPERATION);

	/* see if EndFragmentShaderATI really ended the shader */
	glEndFragmentShaderATI();
	pass &= piglit_check_gl_error(GL_INVALID_OPERATION);

	/* use them in a single-pass shader */
	glBeginFragmentShaderATI();
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_PRIMARY_COLOR_ARB, GL_NONE, GL_NONE);
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_SECONDARY_INTERPOLATOR_ATI, GL_NONE, GL_NONE);
	glEndFragmentShaderATI();
	pass &= piglit_check_gl_error(GL_NO_ERROR);

	/* use them in the second pass */
	glBeginFragmentShaderATI();
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_REG_0_ATI, GL_NONE, GL_NONE);
	glPassTexCoordATI(GL_REG_0_ATI, GL_REG_0_ATI, GL_SWIZZLE_STR_ATI);
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_PRIMARY_COLOR_ARB, GL_NONE, GL_NONE);
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_SECONDARY_INTERPOLATOR_ATI, GL_NONE, GL_NONE);
	glEndFragmentShaderATI();
	pass &= piglit_check_gl_error(GL_NO_ERROR);

	/* use color in first pass, but the instruction is not added because
	 * the other argument is invalid, so EndFragmentShader should not
	 * complain about color in first pass */
	glBeginFragmentShaderATI();
	glColorFragmentOp2ATI(GL_ADD_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_PRIMARY_COLOR_ARB, GL_NONE, GL_NONE,
			GL_TEXTURE0_ARB, GL_NONE, GL_NONE);
	pass &= piglit_check_gl_error(GL_INVALID_ENUM);
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_REG_0_ATI, GL_NONE, GL_NONE);
	glPassTexCoordATI(GL_REG_0_ATI, GL_REG_0_ATI, GL_SWIZZLE_STR_ATI);
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_REG_0_ATI, GL_NONE, GL_NONE);
	glEndFragmentShaderATI();
	pass &= piglit_check_gl_error(GL_NO_ERROR);

	/* use color, then start a second pass, but the PassTexCoord is
	 * invalid, so it should register as a valid single pass shader */
	glBeginFragmentShaderATI();
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_PRIMARY_COLOR_ARB, GL_NONE, GL_NONE);
	glPassTexCoordATI(GL_TEXTURE0_ARB, GL_REG_0_ATI, GL_SWIZZLE_STR_ATI);
	pass &= piglit_check_gl_error(GL_INVALID_ENUM);
	glColorFragmentOp1ATI(GL_MOV_ATI, GL_REG_0_ATI, GL_NONE, GL_NONE,
			GL_REG_0_ATI, GL_NONE, GL_NONE);
	glEndFragmentShaderATI();
	pass &= piglit_check_gl_error(GL_NO_ERROR);

	/* TODO what implementation-dependent limitation to check here? */

	piglit_report_result(pass ? PIGLIT_PASS : PIGLIT_FAIL);
}
