# A debhelper build system class for handling pkg-js-autopkgtest test.
#
# Copyright: 2019, Xavier Guimard <yadd@debian.org>
# License: GPL-2+

package Debian::Debhelper::Buildsystem::nodejs;

use strict;
use warnings;
use Debian::Debhelper::Dh_Lib;
use parent qw(Debian::Debhelper::Buildsystem);

sub DESCRIPTION {
    "pkg-js-autopkgtest test"
}

sub new {
	my $class=shift;
	return $class->SUPER::new(@_);
}

sub check_auto_buildable {
    my $self = shift;
    if ( -e 'package.json' ) {
        return 1;
    }
    return 0;
}

sub test {
    my $self = shift;
    if ( -e 'debian/tests/pkg-js/test' ) {
        $self->doit_in_builddir('/bin/sh','-e','debian/tests/pkg-js/test');
    }
    else {
        $self->doit_in_builddir('/usr/bin/node','-e','require(".")');
    }
}

1;
