# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AppPatch(Model):
    """The description of the IoT Central application.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param tags: Instance tags
    :type tags: dict[str, str]
    :ivar application_id: The ID of the application.
    :vartype application_id: str
    :param display_name: The display name of the application.
    :type display_name: str
    :param subdomain: The subdomain of the application.
    :type subdomain: str
    :param template: The ID of the application template, which is a blueprint
     that defines the characteristics and behaviors of an application.
     Optional; if not specified, defaults to a blank blueprint and allows the
     application to be defined from scratch.
    :type template: str
    """

    _validation = {
        'application_id': {'readonly': True},
        'display_name': {'pattern': r'^.{1,200}$'},
        'subdomain': {'pattern': r'^[a-z0-9-]{1,63}$'},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'application_id': {'key': 'properties.applicationId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'subdomain': {'key': 'properties.subdomain', 'type': 'str'},
        'template': {'key': 'properties.template', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AppPatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.application_id = None
        self.display_name = kwargs.get('display_name', None)
        self.subdomain = kwargs.get('subdomain', None)
        self.template = kwargs.get('template', None)
