# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ContentKeyPolicyOption(Model):
    """Represents a policy option.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar policy_option_id: The legacy Policy Option ID.
    :vartype policy_option_id: str
    :param name: The Policy Option description.
    :type name: str
    :param configuration: Required. The key delivery configuration.
    :type configuration:
     ~azure.mgmt.media.models.ContentKeyPolicyConfiguration
    :param restriction: Required. The requirements that must be met to deliver
     keys with this configuration
    :type restriction: ~azure.mgmt.media.models.ContentKeyPolicyRestriction
    """

    _validation = {
        'policy_option_id': {'readonly': True},
        'configuration': {'required': True},
        'restriction': {'required': True},
    }

    _attribute_map = {
        'policy_option_id': {'key': 'policyOptionId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'configuration': {'key': 'configuration', 'type': 'ContentKeyPolicyConfiguration'},
        'restriction': {'key': 'restriction', 'type': 'ContentKeyPolicyRestriction'},
    }

    def __init__(self, *, configuration, restriction, name: str=None, **kwargs) -> None:
        super(ContentKeyPolicyOption, self).__init__(**kwargs)
        self.policy_option_id = None
        self.name = name
        self.configuration = configuration
        self.restriction = restriction
