% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkPathForOutput.R
\name{checkPathForOutput}
\alias{checkPathForOutput}
\alias{check_path_for_output}
\alias{assertPathForOutput}
\alias{assert_path_for_output}
\alias{testPathForOutput}
\alias{test_path_for_output}
\alias{expect_path_for_output}
\title{Check if a path is suited for creating an output file}
\usage{
checkPathForOutput(x, overwrite = FALSE)

check_path_for_output(x, overwrite = FALSE)

assertPathForOutput(x, overwrite = FALSE, .var.name = vname(x),
  add = NULL)

assert_path_for_output(x, overwrite = FALSE, .var.name = vname(x),
  add = NULL)

testPathForOutput(x, overwrite = FALSE)

test_path_for_output(x, overwrite = FALSE)

expect_path_for_output(x, overwrite = FALSE, info = NULL,
  label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{overwrite}{[\code{logical(1)}]\cr
If \code{TRUE}, an existing file in place is allowed if it
it is both readable and writable.
Default is \code{FALSE}.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertPathForOutput}/\code{assert_path_for_output} return 
 \code{x} invisibly, whereas
 \code{checkPathForOutput}/\code{check_path_for_output} and 
 \code{testPathForOutput}/\code{test_path_for_output} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertPathForOutput}/\code{assert_path_for_output}
 throws an error message, 
 \code{testPathForOutput}/\code{test_path_for_output}
 returns \code{FALSE},
 and \code{checkPathForOutput} returns a string with the error message.
 The function \code{expect_path_for_output} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if a file path can be used safely to create a file and write to it.

This is checked:
\itemize{
 \item{Does \code{dirname(x)} exist?}
 \item{Does no file under path \code{x} exist?}
 \item{Is \code{dirname(x)} writable?}
}
Paths are relative to the current working directory.
}
\examples{
# Can we create a file in the tempdir?
testPathForOutput(file.path(tempdir(), "process.log"))
}
\seealso{
Other filesystem: \code{\link{checkAccess}},
  \code{\link{checkDirectoryExists}},
  \code{\link{checkFileExists}}
}
\concept{filesystem}
