#include <gsl/gsl_sf_erf.h>
#include <gsl/gsl_errno.h>

/* function names generated by removing  "gsl_sf" from the beginning
   of the name.  Thus gsl_sf_airy_Ai goes to airy_Ai. */


void erf_e(double *x, int *len, int *mode, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_erf_e(x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void erfc_e(double *x, int *len, int *mode, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_erfc_e(x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void log_erfc_e(double *x, int *len, int *mode, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_log_erfc_e(x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void log_erf_Z_e(double *x, int *len, int *mode, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_erf_Z_e(x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void log_erf_Q_e(double *x, int *len, int *mode, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_erf_Q_e(x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void hazard_e(double *x, int *len, int *mode, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_erf_Q_e(x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  
