% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.R
\name{st_as_sf}
\alias{st_as_sf}
\alias{st_as_sfc.stars}
\alias{st_as_sf.stars}
\title{Convert stars object into an sf object}
\usage{
\method{st_as_sfc}{stars}(x, ..., as_points,
  which = seq_len(prod(dim(x)[1:2])))

\method{st_as_sf}{stars}(x, ..., as_points = !merge, na.rm = TRUE,
  merge = has_raster(x) && !(is_curvilinear(x) || is_rectilinear(x)),
  use_integer = is.logical(x[[1]]) || is.integer(x[[1]]))
}
\arguments{
\item{x}{object of class \code{stars}}

\item{...}{ignored}

\item{as_points}{logical; should cells be converted to points or to polygons? See details.}

\item{which}{linear index of cells to keep (this argument is not recommended to be used)}

\item{na.rm}{logical; should missing valued cells be removed, or also be converted to features?}

\item{merge}{logical; if \code{TRUE}, cells with identical values are merged (using \code{GDAL_Polygonize} or \code{GDAL_FPolygonize}); if \code{FALSE}, a polygon for each raster cell is returned; see details}

\item{use_integer}{(relevant only if \code{merge} is \code{TRUE}): if \code{TRUE}, before polygonizing values are rounded to 32-bits signed integer values (GDALPolygonize), otherwise they are converted to 32-bit floating point values (GDALFPolygonize).}
}
\description{
Convert stars object into an sf object
}
\details{
If \code{merge} is \code{TRUE}, only the first attribute is converted into an \code{sf} object. If \code{na.rm} is \code{FALSE}, areas with \code{NA} values are also written out as polygons.
}
\examples{
tif = system.file("tif/L7_ETMs.tif", package = "stars")
x = read_stars(tif)
x = x[,,,6] # a band with lower values in it
x[[1]][x[[1]] < 30] = NA # set lower values to NA
x[[1]] = x[[1]] < 100 # make the rest binary
x
(p = st_as_sf(x)) # removes NA areas
plot(p, axes = TRUE)
(p = st_as_sf(x, na.rm = FALSE)) # includes polygons with NA values
plot(p, axes = TRUE)
}
