/******************************************************************************
 *
 * Copyright(c) 2020 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *****************************************************************************/
#include "phl_headers.h"
#include "phl_chnlplan.h"

const struct chdef_2ghz chdef2g[MAX_CHDEF_2GHZ] = {
    {0, {0x00, 0x00}, {0x00, 0x00}},
    {1, {0xff, 0x1f}, {0x00, 0x18}},
    {2, {0xff, 0x1f}, {0x00, 0x00}},
    {3, {0xff, 0x07}, {0x00, 0x00}},
    {4, {0xff, 0x3f}, {0x00, 0x00}},
    {5, {0x00, 0x1e}, {0x00, 0x00}},
    {6, {0xff, 0x3f}, {0x00, 0x38}},
};


const struct chdef_5ghz chdef5g[MAX_CHDEF_5GHZ] = {
    {0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x00, 0x00, 0x00},
    {1, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x1f, 0x00, 0x00},
    {2, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x07}, {0x00, 0x00}, {0xff, 0x07}, 0x00, 0x00, 0x00},
    {3, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x07}, {0x00, 0x00}, {0xff, 0x07}, 0x1f, 0x00, 0x00},
    {4, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x01}, {0x00, 0x00}, {0xff, 0x01}, 0x1f, 0x00, 0x00},
    {5, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x7f, 0x00}, {0x00, 0x00}, {0x7f, 0x00}, 0x0f, 0x00, 0x00},
    {6, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {7, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {8, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x0f, 0x00, 0x00},
    {9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {10, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x00, 0x00, 0x00},
    {11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, {0xff, 0x07}, {0x00, 0x00}, {0xff, 0x07}, 0x00, 0x00, 0x00},
    {12, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x1f, 0x00, 0x00},
    {13, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x0e, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {14, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x00, 0x00, 0x00},
    {15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x0f, 0x00, 0x00},
    {16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, {0xff, 0x07}, {0x00, 0x00}, {0x00, 0x00}, 0x00, 0x00, 0x00},
    {17, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x00, 0x07}, {0x00, 0x00}, {0x00, 0x07}, 0x1f, 0x00, 0x00},
    {18, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x1f, 0x00, 0x00},
    {19, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x00, 0x00, 0x00},
    {20, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x0f, 0x00, 0x00},
    {21, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x00, 0x07}, {0x00, 0x00}, {0x00, 0x07}, 0x00, 0x00, 0x00},
    {22, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x0f}, {0x00, 0x00}, {0xff, 0x0f}, 0x1f, 0x00, 0x00},
    {23, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x00}, {0x00, 0x00}, {0xff, 0x00}, 0x1f, 0x00, 0x00},
    {24, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, {0xff, 0x07}, {0xff, 0x07}, {0x00, 0x00}, 0x1f, 0x1f, 0x00},
    {25, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, {0xff, 0x07}, {0xff, 0x07}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {26, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0xff, 0x07}, {0xff, 0x07}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {27, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, {0x1f, 0x07}, {0x1f, 0x07}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {28, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {29, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {30, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x1f, 0x00},
    {31, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0xff, 0x07}, {0xff, 0x07}, {0x00, 0x00}, 0x1f, 0x1f, 0x00},
    {32, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x00, 0x00},
    {33, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x1f, 0x0f}, {0x00, 0x00}, {0x1f, 0x0f}, 0x1f, 0x00, 0x00},
    {34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x1f, 0x00, 0x00},
    {35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x00, 0x00, 0x00},
    {36, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x0f, {0xff, 0x0f}, {0xff, 0x0f}, {0xff, 0x0f}, 0x1f, 0x1f, 0x00},
    {37, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x00, 0x00, 0x00},
    {38, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x0f}, {0x00, 0x00}, {0xff, 0x0f}, 0x00, 0x00, 0x00},
    {39, 0x0f, 0x0f, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x00}, {0x00, 0x00}, {0xff, 0x00}, 0x1f, 0x00, 0x1f},
    {40, 0x0f, 0x0f, 0x00, 0x0f, 0x00, 0x0f, {0x1f, 0x07}, {0x00, 0x00}, {0x1f, 0x07}, 0x1f, 0x00, 0x00},
    {41, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x07}, {0x00, 0x00}, {0xff, 0x07}, 0x1f, 0x1f, 0x00},
    {42, 0x0f, 0x0f, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x07}, {0x00, 0x00}, {0xff, 0x07}, 0x1f, 0x1f, 0x00},
    {43, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0xff, 0x06}, {0xff, 0x06}, {0x00, 0x00}, 0x1f, 0x1f, 0x00},
    {44, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0x1f, 0x07}, {0x1f, 0x07}, {0x00, 0x00}, 0x1f, 0x1f, 0x00},
    {45, 0x0f, 0x0f, 0x00, 0x0f, 0x0f, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x1f, 0x1f, 0x00},
    {46, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, 0x0f, 0x00, 0x00},
    {47, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, {0xff, 0x07}, {0xff, 0x07}, {0x00, 0x00}, 0x00, 0x00, 0x00},
    {48, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x0f}, {0x00, 0x00}, {0xff, 0x0f}, 0x00, 0x00, 0x00},
    {49, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x01}, {0x00, 0x00}, {0xff, 0x01}, 0x00, 0x00, 0x00},
    {50, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x00, 0x0f}, {0x00, 0x00}, {0x00, 0x0f}, 0x1f, 0x00, 0x00},
    {51, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x1f, 0x00}, {0x00, 0x00}, {0x1f, 0x00}, 0x00, 0x00, 0x00},
    {52, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0xff, 0x0f}, {0x00, 0x00}, {0xff, 0x0f}, 0xff, 0x00, 0x00},
    {53, 0x0f, 0x00, 0x00, 0x0f, 0x00, 0x0f, {0x0f, 0x00}, {0x00, 0x00}, {0x0f, 0x00}, 0x1f, 0x00, 0x00},
};


const struct regulatory_domain_mapping rdmap[MAX_RD_MAP_NUM] = {
    {0x00, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 49}},
    {0x01, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 50}},
    {0x02, {REGULATION_ETSI, 3}, {REGULATION_ETSI, 7}},
    {0x03, {REGULATION_ACMA, 2}, {REGULATION_ACMA, 33}},
    {0x04, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 51}},
    {0x05, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 6}},
    {0x06, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 7}},
    {0x07, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 23}},
    {0x08, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 21}},
    {0x09, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 17}},
    {0x1b, {REGULATION_FCC, 2}, {REGULATION_FCC, 52}},
    {0x1c, {REGULATION_KCC, 2}, {REGULATION_KCC, 53}},
    {0x20, {REGULATION_WW, 1}, {REGULATION_NA, 0}},
    {0x21, {REGULATION_ETSI, 2}, {REGULATION_NA, 0}},
    {0x22, {REGULATION_FCC, 3}, {REGULATION_NA, 0}},
    {0x23, {REGULATION_MKK, 4}, {REGULATION_NA, 0}},
    {0x24, {REGULATION_ETSI, 5}, {REGULATION_NA, 0}},
    {0x25, {REGULATION_FCC, 3}, {REGULATION_FCC, 3}},
    {0x26, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 2}},
    {0x27, {REGULATION_MKK, 4}, {REGULATION_MKK, 2}},
    {0x28, {REGULATION_KCC, 1}, {REGULATION_KCC, 5}},
    {0x29, {REGULATION_FCC, 1}, {REGULATION_FCC, 6}},
    {0x2a, {REGULATION_FCC, 2}, {REGULATION_NA, 0}},
    {0x2b, {REGULATION_IC, 2}, {REGULATION_IC, 33}},
    {0x2c, {REGULATION_MKK, 2}, {REGULATION_NA, 0}},
    {0x2d, {REGULATION_CHILE, 1}, {REGULATION_CHILE, 22}},
    {0x2e, {REGULATION_WW, 3}, {REGULATION_WW, 37}},
    {0x2f, {REGULATION_CHILE, 1}, {REGULATION_CHILE, 38}},
    {0x30, {REGULATION_FCC, 1}, {REGULATION_FCC, 7}},
    {0x31, {REGULATION_FCC, 1}, {REGULATION_FCC, 8}},
    {0x32, {REGULATION_FCC, 1}, {REGULATION_FCC, 9}},
    {0x33, {REGULATION_FCC, 1}, {REGULATION_FCC, 10}},
    {0x34, {REGULATION_FCC, 3}, {REGULATION_FCC, 1}},
    {0x35, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 3}},
    {0x36, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 4}},
    {0x37, {REGULATION_MKK, 4}, {REGULATION_MKK, 10}},
    {0x38, {REGULATION_MKK, 4}, {REGULATION_MKK, 11}},
    {0x39, {REGULATION_NCC, 3}, {REGULATION_NCC, 12}},
    {0x3a, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 2}},
    {0x3b, {REGULATION_ACMA, 2}, {REGULATION_ACMA, 1}},
    {0x3c, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 10}},
    {0x3d, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 15}},
    {0x3e, {REGULATION_KCC, 2}, {REGULATION_KCC, 3}},
    {0x3f, {REGULATION_FCC, 3}, {REGULATION_FCC, 22}},
    {0x40, {REGULATION_NCC, 3}, {REGULATION_NCC, 13}},
    {0x41, {REGULATION_WW, 6}, {REGULATION_NA, 0}},
    {0x42, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 14}},
    {0x43, {REGULATION_FCC, 3}, {REGULATION_FCC, 6}},
    {0x44, {REGULATION_NCC, 3}, {REGULATION_NCC, 9}},
    {0x45, {REGULATION_ACMA, 1}, {REGULATION_ACMA, 1}},
    {0x46, {REGULATION_FCC, 3}, {REGULATION_FCC, 15}},
    {0x47, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 10}},
    {0x48, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 7}},
    {0x49, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 6}},
    {0x4a, {REGULATION_IC, 3}, {REGULATION_IC, 33}},
    {0x4b, {REGULATION_KCC, 2}, {REGULATION_KCC, 22}},
    {0x4c, {REGULATION_FCC, 3}, {REGULATION_FCC, 28}},
    {0x4d, {REGULATION_MEX, 2}, {REGULATION_MEX, 1}},
    {0x4e, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 42}},
    {0x4f, {REGULATION_NA, 0}, {REGULATION_MKK, 43}},
    {0x50, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 16}},
    {0x51, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 9}},
    {0x52, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 17}},
    {0x53, {REGULATION_NCC, 3}, {REGULATION_NCC, 18}},
    {0x54, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 15}},
    {0x55, {REGULATION_FCC, 3}, {REGULATION_FCC, 1}},
    {0x56, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 19}},
    {0x57, {REGULATION_FCC, 3}, {REGULATION_FCC, 20}},
    {0x58, {REGULATION_MKK, 2}, {REGULATION_MKK, 14}},
    {0x59, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 21}},
    {0x5a, {REGULATION_NA, 0}, {REGULATION_FCC, 44}},
    {0x5b, {REGULATION_NA, 0}, {REGULATION_FCC, 45}},
    {0x5c, {REGULATION_NA, 0}, {REGULATION_FCC, 43}},
    {0x5d, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 8}},
    {0x5e, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 3}},
    {0x5f, {REGULATION_MKK, 2}, {REGULATION_MKK, 47}},
    {0x60, {REGULATION_FCC, 3}, {REGULATION_FCC, 9}},
    {0x61, {REGULATION_FCC, 2}, {REGULATION_FCC, 1}},
    {0x62, {REGULATION_FCC, 2}, {REGULATION_FCC, 3}},
    {0x63, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 23}},
    {0x64, {REGULATION_MKK, 2}, {REGULATION_MKK, 24}},
    {0x65, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 24}},
    {0x66, {REGULATION_FCC, 3}, {REGULATION_FCC, 27}},
    {0x67, {REGULATION_FCC, 3}, {REGULATION_FCC, 25}},
    {0x68, {REGULATION_FCC, 2}, {REGULATION_FCC, 27}},
    {0x69, {REGULATION_FCC, 2}, {REGULATION_FCC, 25}},
    {0x6a, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 25}},
    {0x6b, {REGULATION_FCC, 1}, {REGULATION_FCC, 29}},
    {0x6c, {REGULATION_FCC, 1}, {REGULATION_FCC, 26}},
    {0x6d, {REGULATION_FCC, 2}, {REGULATION_FCC, 28}},
    {0x6e, {REGULATION_FCC, 1}, {REGULATION_FCC, 25}},
    {0x6f, {REGULATION_NA, 0}, {REGULATION_ETSI, 6}},
    {0x70, {REGULATION_NA, 0}, {REGULATION_ETSI, 30}},
    {0x71, {REGULATION_NA, 0}, {REGULATION_ETSI, 25}},
    {0x72, {REGULATION_NA, 0}, {REGULATION_ETSI, 31}},
    {0x73, {REGULATION_FCC, 1}, {REGULATION_FCC, 1}},
    {0x74, {REGULATION_FCC, 2}, {REGULATION_FCC, 19}},
    {0x75, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 32}},
    {0x76, {REGULATION_FCC, 2}, {REGULATION_FCC, 22}},
    {0x77, {REGULATION_ETSI, 1}, {REGULATION_ETSI, 34}},
    {0x78, {REGULATION_FCC, 3}, {REGULATION_FCC, 35}},
    {0x79, {REGULATION_MKK, 2}, {REGULATION_MKK, 2}},
    {0x7a, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 28}},
    {0x7b, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 46}},
    {0x7c, {REGULATION_ETSI, 2}, {REGULATION_ETSI, 47}},
    {0x7d, {REGULATION_MKK, 4}, {REGULATION_MKK, 48}},
    {0x7e, {REGULATION_MKK, 2}, {REGULATION_MKK, 48}},
    {0x7f, {REGULATION_WW, 1}, {REGULATION_WW, 36}},
};



