#ifndef _MAC_FWCMD_INTF_H_
#define _MAC_FWCMD_INTF_H_

#define FWCMD_VER 0x0

// ID definition//

//
//H2CREG
//
#define FWCMD_H2CREG_FUNC_H2CREG_LB 0x0
#define FWCMD_H2CREG_FUNC_CNSL_CMD 0x1
#define FWCMD_H2CREG_FUNC_FWERR 0x2
#define FWCMD_H2CREG_FUNC_HIDDEN_GET 0x3
#define FWCMD_H2CREG_FUNC_GETPKT_INFORM 0x4
#define FWCMD_H2CREG_FUNC_SCH_TX_EN 0x5
#define FWCMD_H2CREG_FUNC_WOW_TRX_STOP 0x6

//
//C2HREG
//
#define FWCMD_C2HREG_FUNC_C2HREG_LB 0x0
#define FWCMD_C2HREG_FUNC_ERR_RPT 0x1
#define FWCMD_C2HREG_FUNC_ERR_MSG 0x2
#define FWCMD_C2HREG_FUNC_EFUSE_HIDDEN 0x3
#define FWCMD_C2HREG_FUNC_TX_PAUSE_RPT 0x4
#define FWCMD_C2HREG_FUNC_AOAC_RPT_1 0x5
#define FWCMD_C2HREG_FUNC_AOAC_RPT_2 0x6
#define FWCMD_C2HREG_FUNC_AOAC_RPT_3 0x7
#define FWCMD_C2HREG_FUNC_WOW_TRX_STOP 0x8
#define FWCMD_C2HREG_FUNC_IO_OFLD_RESULT 0x9

//
//H2CPKT - CAT(TEST)
//
#define FWCMD_H2C_CAT_TEST 0x0
#define FWCMD_H2C_CAT_MAC 0x1
#define FWCMD_H2C_CAT_OUTSRC 0x2
#define FWCMD_H2C_CL_CMD_PATH 0x0
#define FWCMD_H2C_CL_SND_TEST 0x1
#define FWCMD_H2C_CL_PLAT_AUTO_TEST 0x2
#define FWCMD_H2C_CL_MAC_TEST 0x3
#define FWCMD_H2C_CL_FW_AUTO_TEST 0x4
#define FWCMD_H2C_CL_FW_STATUS_TEST 0x5

// CLASS 0 - CMD_PATH
#define FWCMD_H2C_FUNC_H2C_LB 0x0

// CLASS 1 - SND_Test

// CLASS 2 - PLATFORM_AUTO_TEST
#define FWCMD_H2C_FUNC_PLAT_SPIC_TEST 0x0
#define FWCMD_H2C_FUNC_PLAT_CPU_PLATFORM 0x1
#define FWCMD_H2C_FUNC_PLAT_EFUSE_CTRL 0x2
#define FWCMD_H2C_FUNC_PLAT_IDDMA 0x3
#define FWCMD_H2C_FUNC_PLAT_AXIDMA 0x4
#define FWCMD_H2C_FUNC_PLAT_IPSEC 0x5
#define FWCMD_H2C_FUNC_PLAT_UART 0x6
#define FWCMD_H2C_FUNC_PLAT_HIOE 0x7
#define FWCMD_H2C_FUNC_PLAT_WATCHDOG 0x8
#define FWCMD_H2C_FUNC_PLAT_SECURITY 0x9
#define FWCMD_H2C_FUNC_PLAT_FL_WRITE 0xa
#define FWCMD_H2C_FUNC_PLAT_FL_ERASE 0xb
#define FWCMD_H2C_FUNC_PL_FLASH_READ 0xc
#define FWCMD_H2C_FUNC_PLAT_MODULE_MAX 0x10
#define FWCMD_H2C_FUNC_PLAT_INVALID 0x11

// CLASS 3 - MAC_TEST
#define FWCMD_H2C_FUNC_LONG_RUN 0x0

// CLASS 4 - FW_AUTO_TEST
#define FWCMD_H2C_FUNC_LPS_TEST 0x0
#define FWCMD_H2C_FUNC_LPS_ONOFF_TEST 0x1

// CLASS 5 - FW_STATUS_TEST
#define FWCMD_H2C_FUNC_FW_STATUS 0x0

//
//H2CPKT - CAT(MAC)
//
#define FWCMD_H2C_CAT_TEST 0x0
#define FWCMD_H2C_CAT_MAC 0x1
#define FWCMD_H2C_CAT_OUTSRC 0x2
#define FWCMD_H2C_CL_FW_INFO 0x0
#define FWCMD_H2C_CL_WOW 0x1
#define FWCMD_H2C_CL_PS 0x2
#define FWCMD_H2C_CL_FWDL 0x3
#define FWCMD_H2C_CL_TWT 0x4
#define FWCMD_H2C_CL_FR_EXCHG 0x5
#define FWCMD_H2C_CL_ADDR_CAM_UPDATE 0x6
#define FWCMD_H2C_CL_BSSID_CAM_UPDATE 0x7
#define FWCMD_H2C_CL_MEDIA_RPT 0x8
#define FWCMD_H2C_CL_FW_OFLD 0x9
#define FWCMD_H2C_CL_SEC_CAM 0xA
#define FWCMD_H2C_CL_SOUND 0xB
#define FWCMD_H2C_CL_BA_CAM 0xC
#define FWCMD_H2C_CL_IE_CAM 0xD
#define FWCMD_H2C_CL_MCC 0xE
#define FWCMD_H2C_CL_SCSI 0xF
#define FWCMD_H2C_CL_FLASH 0x10
#define FWCMD_H2C_CL_FCS 0x11
#define FWCMD_H2C_CL_MISC 0x12
#define FWCMD_H2C_CL_MPORT 0x13

// CLASS 0 - FW_INFO
#define FWCMD_H2C_FUNC_LOG_CFG 0x0
#define FWCMD_H2C_FUNC_GENERAL_PKT 0x1
#define FWCMD_H2C_FUNC_C2H_RPT_CFG 0x2
#define FWCMD_H2C_FUNC_WLAN_DUMP_CMD 0x2
#define FWCMD_H2C_FUNC_FW_DBGREG_CFG 0x3

// CLASS 1 - WOW
#define FWCMD_H2C_FUNC_KEEP_ALIVE 0x0
#define FWCMD_H2C_FUNC_DISCONNECT_DETECT 0x1
#define FWCMD_H2C_FUNC_WOW_GLOBAL 0x2
#define FWCMD_H2C_FUNC_GTK_OFLD 0x3
#define FWCMD_H2C_FUNC_ARP_OFLD 0x4
#define FWCMD_H2C_FUNC_NDP_OFLD 0x5
#define FWCMD_H2C_FUNC_REALWOW 0x6
#define FWCMD_H2C_FUNC_NLO 0x7
#define FWCMD_H2C_FUNC_WAKEUP_CTRL 0x8
#define FWCMD_H2C_FUNC_NEGATIVE_PATTERN 0x9
#define FWCMD_H2C_FUNC_DEV2HST_GPIO 0xA
#define FWCMD_H2C_FUNC_UPHY_CTRL 0xB
#define FWCMD_H2C_FUNC_WOW_CAM_UPD 0xC
#define FWCMD_H2C_FUNC_AOAC_REPORT_REQ 0xD
#define FWCMD_H2C_FUNC_WOW_STOP_FW_TRX 0xE

// CLASS 2 - PS
#define FWCMD_H2C_FUNC_LPS_PARM 0x0
#define FWCMD_H2C_FUNC_P2P_ACT 0x1

// CLASS 3 - FWDL
#define FWCMD_H2C_FUNC_FWHDR_DL 0x0
#define FWCMD_H2C_FUNC_FWHDR_REDL 0x1

// CLASS 4 - TWT
#define FWCMD_H2C_FUNC_TWT_ANNOUNCE_UPD 0x00
#define FWCMD_H2C_FUNC_TWTINFO_UPD 0x1
#define FWCMD_H2C_FUNC_TWT_STANSP_UPD 0x2

// CLASS 5 - Frame Exchange
#define FWCMD_H2C_FUNC_TBLUD 0x0
#define FWCMD_H2C_FUNC_DCTLINFO_UD 0x1
#define FWCMD_H2C_FUNC_CCTLINFO_UD 0x2
#define FWCMD_H2C_FUNC_F2P_TEST 0x3
#define FWCMD_H2C_FUNC_SHCUT_UPDATE 0x4
#define FWCMD_H2C_FUNC_BCN_UPD 0x5
#define FWCMD_H2C_FUNC_SS_ULSTA_UPD 0x6
#define FWCMD_H2C_FUNC_F2PDBG_SET 0x7
#define FWCMD_H2C_FUNC_WLANINFO_GET 0x8

// CLASS 6 - Address CAM
#define FWCMD_H2C_FUNC_ADDRCAM_INFO 0x0

// CLASS 8 - Media Status Report
#define FWCMD_H2C_FUNC_JOININFO 0x0
#define FWCMD_H2C_FUNC_DL_GRP_UPD 0x1
#define FWCMD_H2C_FUNC_UL_GRP_UPD 0x2
#define FWCMD_H2C_FUNC_MU_STA_UPD 0x3
#define FWCMD_H2C_FUNC_FWROLE_MAINTAIN 0x4

// CLASS 9 - FW_OFLD
#define FWCMD_H2C_FUNC_DUMP_EFUSE 0x0
#define FWCMD_H2C_FUNC_PACKET_OFLD 0x1
#define FWCMD_H2C_FUNC_READ_OFLD 0x2
#define FWCMD_H2C_FUNC_WRITE_OFLD 0x3
#define FWCMD_H2C_FUNC_CONF_OFLD 0x4
#define FWCMD_H2C_FUNC_SYS_INIT 0x5
#define FWCMD_H2C_FUNC_TRX_INIT 0x6
#define FWCMD_H2C_FUNC_INTF_INIT 0x7
#define FWCMD_H2C_FUNC_MACID_PAUSE 0x8
#define FWCMD_H2C_FUNC_RX_FWD 0x9
#define FWCMD_H2C_FUNC_EN_MAC_HDR_CONV 0xB
#define FWCMD_H2C_FUNC_SET_HWSEQ_REG 0xA
#define FWCMD_H2C_FUNC_HWAMSDU_REG 0xC
#define FWCMD_H2C_FUNC_AMSDU_CUT_REG 0xD
#define FWCMD_H2C_FUNC_TCPIP_CHKSUM_OFFLOAD_REG 0xE
#define FWCMD_H2C_FUNC_USR_EDCA 0xF
#define FWCMD_H2C_FUNC_TSF32_TOGL 0x10
#define FWCMD_H2C_FUNC_CMD_OFLD_REG 0x11
#define FWCMD_H2C_FUNC_USR_TX_RPT 0x12
#define FWCMD_H2C_FUNC_CMD_OFLD_PKT 0x13
#define FWCMD_H2C_FUNC_OFLD_CFG 0x14
#define FWCMD_H2C_FUNC_H2C_AGG 0x15

// CLASS 10 - SECCAM
#define FWCMD_H2C_FUNC_SEC_CAM_INIT 0x0
#define FWCMD_H2C_FUNC_SECCAM_INFO 0x1

// CLASS 11 - Sound
#define FWCMD_H2C_FUNC_SET_SND_PARA 0x0
#define FWCMD_H2C_FUNC_GET_CSI_BUF 0x1
#define FWCMD_H2C_FUNC_SET_CSI_BUF 0x2
#define FWCMD_H2C_FUNC_GET_SND_STS 0x3
#define FWCMD_H2C_FUNC_SET_SND_STS 0x4
#define FWCMD_H2C_FUNC_INIT_SND_MER 0x5
#define FWCMD_H2C_FUNC_INIT_SND_MEE 0x6
#define FWCMD_H2C_FUNC_CSI_FIX_RATE 0x7
#define FWCMD_H2C_FUNC_CSI_RRSC 0x8
#define FWCMD_H2C_FUNC_SET_MU_TABLE 0x9
#define FWCMD_H2C_FUNC_SET_CSI_PARA_REG 0xA
#define FWCMD_H2C_FUNC_HW_SND_PR 0xB
#define FWCMD_H2C_FUNC_BYPASS_SND_STS 0xC
#define FWCMD_H2C_FUNC_SET_SND_PARA_V1 0xD

// CLASS 12 - BACAM
#define FWCMD_H2C_FUNC_BA_CAM 0x0

// CLASS 13 - IECAM
#define FWCMD_H2C_FUNC_IE_CAM 0x0

// CLASS 14 - MCC
#define FWCMD_H2C_FUNC_ADD_MCC 0x0
#define FWCMD_H2C_FUNC_START_MCC 0x1
#define FWCMD_H2C_FUNC_STOP_MCC 0x2
#define FWCMD_H2C_FUNC_DEL_MCC_GROUP 0x3
#define FWCMD_H2C_FUNC_RESET_MCC_GROUP 0x4
#define FWCMD_H2C_FUNC_MCC_REQ_TSF 0x5
#define FWCMD_H2C_FUNC_MCC_MACID_BITMAP 0x6
#define FWCMD_H2C_FUNC_MCC_SYNC 0x7
#define FWCMD_H2C_FUNC_MCC_SET_DURATION 0x8

// CLASS 15 - SCSI
#define FWCMD_H2C_FUNC_SCSI_TX 0x0
#define FWCMD_H2C_FUNC_USB_SWITCH 0x1

// CLASS 16 - FLASH
#define FWCMD_H2C_FUNC_PLAT_FLASH_WRITE 0x0
#define FWCMD_H2C_FUNC_PLAT_FLASH_ERASE 0x1
#define FWCMD_H2C_FUNC_PLAT_FLASH_READ 0x2

// CLASS 17 - FCS
#define FWCMD_H2C_FUNC_FCS 0x0

// CLASS 18 - MISC
#define FWCMD_H2C_FUNC_CFG_WPS 0x0
#define FWCMD_C2H_FUNC_CCXRPT 0x01

// CLASS 19 - MPORT
#define FWCMD_H2C_FUNC_PORT_INIT 0x0
#define FWCMD_H2C_FUNC_PORT_CFG 0x1

//
//H2CPKT - CAT(Table)
//

//
//H2CPKT - CAT(OutSrc,Phydm)
//
#define FWCMD_H2C_CAT_TEST 0x0
#define FWCMD_H2C_CAT_MAC 0x1
#define FWCMD_H2C_CAT_OUTSRC 0x2
#define FWCMD_H2C_CL_RUA 0x0
#define FWCMD_H2C_CL_RA 0x1

// CLASS 0 (RUA)
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 1 (RA)
#define FWCMD_H2C_FUNC_MACID_CFG 0x0
#define FWCMD_H2C_FUNC_RSSI_RA_CONFIG 0x1
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 2
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 3
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 4
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 5
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 6
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 7
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

//
//H2CPKT - CAT(OutSrc, RF)
//
#define FWCMD_H2C_CAT_TEST 0x0
#define FWCMD_H2C_CAT_MAC 0x1
#define FWCMD_H2C_CAT_OUTSRC 0x2

// CLASS 8
#define FWCMD_H2C_FUNC_RADIO_INIT_0 0x0
#define FWCMD_H2C_FUNC_RADIO_INIT_1 0x1
#define FWCMD_H2C_FUNC_RADIO_INIT_2 0x2
#define FWCMD_H2C_FUNC_RADIO_INIT_3 0x3
#define FWCMD_H2C_FUNC_RADIO_INIT_4 0x4
#define FWCMD_H2C_FUNC_RADIO_INIT_5 0x5
#define FWCMD_H2C_FUNC_RADIO_INIT_6 0x6
#define FWCMD_H2C_FUNC_RADIO_INIT_7 0x7
#define FWCMD_H2C_FUNC_RADIO_INIT_8 0x8
#define FWCMD_H2C_FUNC_RADIO_INIT_9 0x9

// CLASS 9
#define FWCMD_H2C_FUNC_DACK_BACKUP 0x0
#define FWCMD_H2C_FUNC_DACK_RELOAD 0x1

// CLASS 10
#define FWCMD_H2C_FUNC_FCS_BACKUP_RFK 0x0
#define FWCMD_H2C_FUNC_FCS_RELOAD_RFK 0x1
#define FWCMD_H2C_FUNC_GET_MCCCH 0x2
#define FWCMD_H2C_FUNC_FWIQK_TRIGGER 0x4

// CLASS 11
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 12
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 13
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 14
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

// CLASS 15
#define FWCMD_H2C_FUNC_EXAMPLE 0x0

//
//H2CPKT - CAT(OutSrc, BTC)
//
#define FWCMD_H2C_CAT_TEST 0x0
#define FWCMD_H2C_CAT_MAC 0x1
#define FWCMD_H2C_CAT_OUTSRC 0x2

// CLASS 16
#define FWCMD_H2C_FUNC_TDMA 0x0

//
//C2HPKT - CAT(TEST)
//
#define FWCMD_C2H_CAT_TEST 0x0
#define FWCMD_C2H_CAT_MAC 0x1
#define FWCMD_C2H_CAT_OUTSRC 0x2
#define FWCMD_C2H_CL_CMD_PATH 0x0
#define FWCMD_C2H_CL_PLAT_AUTO 0x2
#define FWCMD_C2H_CL_FW_AUTO 0x3
#define FWCMD_C2H_CL_FW_STATUS 0x4

// CLASS 0 - CMD_PATH
#define FWCMD_C2H_FUNC_C2H_LB 0x00
#define FWCMD_C2H_FUNC_TEST_PHY_RPT 0x01

// CLASS 2 - PLATFORM_AUTO_TEST
#define FWCMD_C2H_FUNC_SPIC 0x00
#define FWCMD_C2H_FUNC_SPIC2 0x01

// CLASS 3 - FW_AUTO_TEST
#define FWCMD_C2H_FUNC_LPS_TEST 0x00
#define FWCMD_C2H_FUNC_LPS_ONOFF_TEST 0x1

// CLASS 4 - FW_STATUS
#define FWCMD_C2H_FUNC_FW_STATUS 0x00

//
//C2HPKT - CAT(MAC)
//
#define FWCMD_C2H_CAT_TEST 0x0
#define FWCMD_C2H_CAT_MAC 0x1
#define FWCMD_C2H_CAT_OUTSRC 0x2
#define FWCMD_C2H_CL_FW_INFO 0x0
#define FWCMD_C2H_CL_FW_OFLD 0x1
#define FWCMD_C2H_CL_TWT 0x2
#define FWCMD_C2H_CL_WOW 0x3
#define FWCMD_C2H_CL_MCC 0x4
#define FWCMD_C2H_CL_FW_DBG 0x5
#define FWCMD_C2H_CL_FLASH 0x6
#define FWCMD_C2H_CL_SCSI 0x7
#define FWCMD_C2H_CL_FCS 0x8
#define FWCMD_C2H_CL_MISC 0x9
#define FWCMD_C2H_CL_MPORT 0xA

// CLASS 0 - FW_INFO
#define FWCMD_C2H_FUNC_REC_ACK 0x00
#define FWCMD_C2H_FUNC_DONE_ACK 0x01
#define FWCMD_C2H_FUNC_C2H_LOG 0x02
#define FWCMD_C2H_FUNC_BCN_CNT 0x03
#define FWCMD_C2H_FUNC_BCN_CSAZERO 0x04

// CLASS 1 - FW_OFLD
#define FWCMD_C2H_FUNC_EFUSE_DUMP 0x00
#define FWCMD_C2H_FUNC_READ_RSP 0x01
#define FWCMD_C2H_FUNC_PKT_OFLD_RSP 0x02
#define FWCMD_C2H_FUNC_BEACON_RESEND 0x3
#define FWCMD_C2H_FUNC_MACID_PAUSE 0x4
#define FWCMD_C2H_FUNC_FW_GETPKT_RPT 0x5
#define FWCMD_C2H_FUNC_TSF32_TOGL_RPT 0x6
#define FWCMD_C2H_FUNC_USR_TX_RPT_INFO 0x7
#define FWCMD_C2H_FUNC_CMD_OFLD_RSP 0x8

// CLASS 2 - TWT
#define FWCMD_C2H_FUNC_WAIT_ANNOUNCE 0x00

// CLASS 3 - WOW
#define FWCMD_C2H_FUNC_AOAC_REPORT 0x00
#define FWCMD_C2H_FUNC_READ_WOW_CAM 0x01

// CLASS 4 - MCC
#define FWCMD_C2H_FUNC_MCC_RCV_ACK 0x00
#define FWCMD_C2H_FUNC_MCC_REQ_ACK 0x01
#define FWCMD_C2H_FUNC_MCC_TSF_RPT 0x02
#define FWCMD_C2H_FUNC_MCC_STATUS_RPT 0x03

// CLASS 5 - FW_DBG
#define FWCMD_C2H_FUNC_RX_DBG 0x00

// CLASS 6 - FLASH
#define FWCMD_C2H_FUNC_PLAT_FLASH_WRITE 0x0
#define FWCMD_C2H_FUNC_PLAT_FLASH_ERASE 0x1
#define FWCMD_C2H_FUNC_PLAT_FLASH_READ 0x2

// CLASS 7 - SCSI
#define FWCMD_C2H_FUNC_SCSI_RX 0x00

// CLASS 8 - FCS
#define FWCMD_C2H_FUNC_FCS_RPT 0x00

// CLASS 9 - MISC
#define FWCMD_C2H_FUNC_WPS_RPT 0x0

// CLASS 10 - MPORT
#define FWCMD_C2H_FUNC_PORT_INIT_STAT 0x0
#define FWCMD_C2H_FUNC_PORT_CFG_STAT 0x1

//
//C2HPKT - CAT(OutSrc, Phydm)
//
#define FWCMD_C2H_CAT_TEST 0x0
#define FWCMD_C2H_CAT_MAC 0x1
#define FWCMD_C2H_CAT_OUTSRC 0x2
#define FWCMD_C2H_CL_RUA 0x0
#define FWCMD_C2H_CL_RA 0x1
#define FWCMD_C2H_CL_HALBB 0x2
#define FWCMD_C2H_CL_DBG 0x7

// CLASS 0
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 1
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 2
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 3
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 4
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 5
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 6
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 7
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

//
//C2HPKT - CAT(OutSrc, RF)
//
#define FWCMD_C2H_CAT_TEST 0x0
#define FWCMD_C2H_CAT_MAC 0x1
#define FWCMD_C2H_CAT_OUTSRC 0x2

// CLASS 9
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 10
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 11
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 12
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 13
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 14
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// CLASS 15
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

//
//C2HPKT - CAT(OutSrc, BTC)
//
#define FWCMD_C2H_CAT_TEST 0x0
#define FWCMD_C2H_CAT_MAC 0x1
#define FWCMD_C2H_CAT_OUTSRC 0x2

// CLASS 16
#define FWCMD_C2H_FUNC_EXAMPLE 0x0

// Bit definition//

//
//H2CREG
//
#define FWCMD_H2CREG_H2CREG_HDR_FUNC_SH 0
#define FWCMD_H2CREG_H2CREG_HDR_FUNC_MSK 0x7f
#define FWCMD_H2CREG_H2CREG_HDR_ACK BIT(7)
#define FWCMD_H2CREG_H2CREG_HDR_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_H2CREG_HDR_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_H2CREG_HDR_SEQ_NUM_SH 12
#define FWCMD_H2CREG_H2CREG_HDR_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_H2CREG_DWORD0_SH 0
#define FWCMD_H2CREG_H2CREG_DWORD0_MSK 0xffffffff
#define FWCMD_H2CREG_H2CREG_DWORD1_SH 0
#define FWCMD_H2CREG_H2CREG_DWORD1_MSK 0xffffffff
#define FWCMD_H2CREG_H2CREG_DWORD2_SH 0
#define FWCMD_H2CREG_H2CREG_DWORD2_MSK 0xffffffff
#define FWCMD_H2CREG_H2CREG_DWORD3_SH 0
#define FWCMD_H2CREG_H2CREG_DWORD3_MSK 0xffffffff
#define FWCMD_H2CREG_H2CREG_LB_FUNC_SH 0
#define FWCMD_H2CREG_H2CREG_LB_FUNC_MSK 0x7f
#define FWCMD_H2CREG_H2CREG_LB_ACK BIT(7)
#define FWCMD_H2CREG_H2CREG_LB_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_H2CREG_LB_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_H2CREG_LB_SEQ_NUM_SH 12
#define FWCMD_H2CREG_H2CREG_LB_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_H2CREG_LB_PAYLOAD0_SH 16
#define FWCMD_H2CREG_H2CREG_LB_PAYLOAD0_MSK 0xffff
#define FWCMD_H2CREG_H2CREG_LB_PAYLOAD1_SH 0
#define FWCMD_H2CREG_H2CREG_LB_PAYLOAD1_MSK 0xffffffff
#define FWCMD_H2CREG_CNSL_CMD_FUNC_SH 0
#define FWCMD_H2CREG_CNSL_CMD_FUNC_MSK 0x7f
#define FWCMD_H2CREG_CNSL_CMD_ACK BIT(7)
#define FWCMD_H2CREG_CNSL_CMD_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_CNSL_CMD_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_CNSL_CMD_SEQ_NUM_SH 12
#define FWCMD_H2CREG_CNSL_CMD_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_CNSL_CMD_CMD_ID_SH 16
#define FWCMD_H2CREG_CNSL_CMD_CMD_ID_MSK 0xff
#define FWCMD_H2CREG_CNSL_CMD_ARG_NUM_SH 24
#define FWCMD_H2CREG_CNSL_CMD_ARG_NUM_MSK 0xf
#define FWCMD_H2CREG_CNSL_CMD_ARG_UNIT_SH 28
#define FWCMD_H2CREG_CNSL_CMD_ARG_UNIT_MSK 0x3
#define FWCMD_H2CREG_FWERR_FUNC_SH 0
#define FWCMD_H2CREG_FWERR_FUNC_MSK 0x7f
#define FWCMD_H2CREG_FWERR_ACK BIT(7)
#define FWCMD_H2CREG_FWERR_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_FWERR_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_FWERR_SEQ_NUM_SH 12
#define FWCMD_H2CREG_FWERR_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_FWERR_OP_SH 16
#define FWCMD_H2CREG_FWERR_OP_MSK 0xf
#define FWCMD_H2CREG_FWERR_IDX_SH 0
#define FWCMD_H2CREG_FWERR_IDX_MSK 0xffffffff
#define FWCMD_H2CREG_HIDDEN_GET_FUNC_SH 0
#define FWCMD_H2CREG_HIDDEN_GET_FUNC_MSK 0x7f
#define FWCMD_H2CREG_HIDDEN_GET_ACK BIT(7)
#define FWCMD_H2CREG_HIDDEN_GET_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_HIDDEN_GET_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_HIDDEN_GET_SEQ_NUM_SH 12
#define FWCMD_H2CREG_HIDDEN_GET_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_GETPKT_INFORM_FUNC_SH 0
#define FWCMD_H2CREG_GETPKT_INFORM_FUNC_MSK 0x7f
#define FWCMD_H2CREG_GETPKT_INFORM_ACK BIT(7)
#define FWCMD_H2CREG_GETPKT_INFORM_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_GETPKT_INFORM_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_GETPKT_INFORM_SEQ_NUM_SH 12
#define FWCMD_H2CREG_GETPKT_INFORM_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_GETPKT_INFORM_MACID_SH 16
#define FWCMD_H2CREG_GETPKT_INFORM_MACID_MSK 0xff
#define FWCMD_H2CREG_GETPKT_INFORM_PKTTYPE_SH 24
#define FWCMD_H2CREG_GETPKT_INFORM_PKTTYPE_MSK 0xff
#define FWCMD_H2CREG_SCH_TX_EN_FUNC_SH 0
#define FWCMD_H2CREG_SCH_TX_EN_FUNC_MSK 0x7f
#define FWCMD_H2CREG_SCH_TX_EN_ACK BIT(7)
#define FWCMD_H2CREG_SCH_TX_EN_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_SCH_TX_EN_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_SCH_TX_EN_SEQ_NUM_SH 12
#define FWCMD_H2CREG_SCH_TX_EN_SEQ_NUM_MSK 0xf
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_BE0 BIT(16)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_BK0 BIT(17)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_VI0 BIT(18)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_VO0 BIT(19)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_BE1 BIT(20)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_BK1 BIT(21)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_VI1 BIT(22)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_VO1 BIT(23)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_MG0 BIT(24)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_MG1 BIT(25)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_MG2 BIT(26)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_HI BIT(27)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_BCN BIT(28)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_UL BIT(29)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_TWT0 BIT(30)
#define FWCMD_H2CREG_SCH_TX_EN_TX_EN_TWT1 BIT(31)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_BE0 BIT(0)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_BK0 BIT(1)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_VI0 BIT(2)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_VO0 BIT(3)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_BE1 BIT(4)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_BK1 BIT(5)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_VI1 BIT(6)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_VO1 BIT(7)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_MG0 BIT(8)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_MG1 BIT(9)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_MG2 BIT(10)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_HI BIT(11)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_BCN BIT(12)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_UL BIT(13)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_TWT0 BIT(14)
#define FWCMD_H2CREG_SCH_TX_EN_MASK_TWT1 BIT(15)
#define FWCMD_H2CREG_SCH_TX_EN_BAND BIT(16)
#define FWCMD_H2CREG_WOW_TRX_STOP_FUNC_SH 0
#define FWCMD_H2CREG_WOW_TRX_STOP_FUNC_MSK 0x7f
#define FWCMD_H2CREG_WOW_TRX_STOP_ACK BIT(7)
#define FWCMD_H2CREG_WOW_TRX_STOP_TOTAL_LEN_SH 8
#define FWCMD_H2CREG_WOW_TRX_STOP_TOTAL_LEN_MSK 0xf
#define FWCMD_H2CREG_WOW_TRX_STOP_SEQ_NUM_SH 12
#define FWCMD_H2CREG_WOW_TRX_STOP_SEQ_NUM_MSK 0xf

//
//C2HREG
//
#define FWCMD_C2HREG_C2HREG_HDR_FUNC_SH 0
#define FWCMD_C2HREG_C2HREG_HDR_FUNC_MSK 0x7f
#define FWCMD_C2HREG_C2HREG_HDR_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_C2HREG_HDR_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_C2HREG_HDR_SEQ_NUM_SH 12
#define FWCMD_C2HREG_C2HREG_HDR_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_C2HREG_DWORD0_SH 0
#define FWCMD_C2HREG_C2HREG_DWORD0_MSK 0xffffffff
#define FWCMD_C2HREG_C2HREG_DWORD1_SH 0
#define FWCMD_C2HREG_C2HREG_DWORD1_MSK 0xffffffff
#define FWCMD_C2HREG_C2HREG_DWORD2_SH 0
#define FWCMD_C2HREG_C2HREG_DWORD2_MSK 0xffffffff
#define FWCMD_C2HREG_C2HREG_DWORD3_SH 0
#define FWCMD_C2HREG_C2HREG_DWORD3_MSK 0xffffffff
#define FWCMD_C2HREG_C2HREG_LB_FUNC_SH 0
#define FWCMD_C2HREG_C2HREG_LB_FUNC_MSK 0x7f
#define FWCMD_C2HREG_C2HREG_LB_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_C2HREG_LB_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_C2HREG_LB_SEQ_NUM_SH 12
#define FWCMD_C2HREG_C2HREG_LB_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_C2HREG_LB_PAYLOAD0_SH 16
#define FWCMD_C2HREG_C2HREG_LB_PAYLOAD0_MSK 0xffff
#define FWCMD_C2HREG_C2HREG_LB_PAYLOAD1_SH 0
#define FWCMD_C2HREG_C2HREG_LB_PAYLOAD1_MSK 0xffffffff
#define FWCMD_C2HREG_ERR_RPT_FUNC_SH 0
#define FWCMD_C2HREG_ERR_RPT_FUNC_MSK 0x7f
#define FWCMD_C2HREG_ERR_RPT_ACK BIT(7)
#define FWCMD_C2HREG_ERR_RPT_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_ERR_RPT_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_ERR_RPT_SEQ_NUM_SH 12
#define FWCMD_C2HREG_ERR_RPT_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_ERR_RPT_IDX_SH 16
#define FWCMD_C2HREG_ERR_RPT_IDX_MSK 0xf
#define FWCMD_C2HREG_ERR_RPT_CODE_SH 0
#define FWCMD_C2HREG_ERR_RPT_CODE_MSK 0xffffffff
#define FWCMD_C2HREG_ERR_MSG_FUNC_SH 0
#define FWCMD_C2HREG_ERR_MSG_FUNC_MSK 0x7f
#define FWCMD_C2HREG_ERR_MSG_ACK BIT(7)
#define FWCMD_C2HREG_ERR_MSG_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_ERR_MSG_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_ERR_MSG_SEQ_NUM_SH 12
#define FWCMD_C2HREG_ERR_MSG_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_ERR_MSG_MSG_SH 16
#define FWCMD_C2HREG_ERR_MSG_MSG_MSK 0xffff
#define FWCMD_C2HREG_EFUSE_HIDDEN_FUNC_SH 0
#define FWCMD_C2HREG_EFUSE_HIDDEN_FUNC_MSK 0x7f
#define FWCMD_C2HREG_EFUSE_HIDDEN_ACK BIT(7)
#define FWCMD_C2HREG_EFUSE_HIDDEN_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_EFUSE_HIDDEN_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_EFUSE_HIDDEN_SEQ_NUM_SH 12
#define FWCMD_C2HREG_EFUSE_HIDDEN_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_EFUSE_HIDDEN_RX_NSS_SH 16
#define FWCMD_C2HREG_EFUSE_HIDDEN_RX_NSS_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_BW_SH 24
#define FWCMD_C2HREG_EFUSE_HIDDEN_BW_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_TX_NSS_SH 0
#define FWCMD_C2HREG_EFUSE_HIDDEN_TX_NSS_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_PROT80211_SH 8
#define FWCMD_C2HREG_EFUSE_HIDDEN_PROT80211_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_NIC_ROUTER_SH 16
#define FWCMD_C2HREG_EFUSE_HIDDEN_NIC_ROUTER_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_WL_FUNC_SUPPORT_SH 24
#define FWCMD_C2HREG_EFUSE_HIDDEN_WL_FUNC_SUPPORT_MSK 0xff
#define FWCMD_C2HREG_EFUSE_HIDDEN_HW_SPECIAL_TYPE_SH 0
#define FWCMD_C2HREG_EFUSE_HIDDEN_HW_SPECIAL_TYPE_MSK 0xff
#define FWCMD_C2HREG_TX_PAUSE_RPT_FUNC_SH 0
#define FWCMD_C2HREG_TX_PAUSE_RPT_FUNC_MSK 0x7f
#define FWCMD_C2HREG_TX_PAUSE_RPT_ACK BIT(7)
#define FWCMD_C2HREG_TX_PAUSE_RPT_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_TX_PAUSE_RPT_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_TX_PAUSE_RPT_SEQ_NUM_SH 12
#define FWCMD_C2HREG_TX_PAUSE_RPT_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_TX_PAUSE_RPT_RPT_SH 16
#define FWCMD_C2HREG_TX_PAUSE_RPT_RPT_MSK 0xffff
#define FWCMD_C2HREG_AOAC_RPT_1_FUNC_SH 0
#define FWCMD_C2HREG_AOAC_RPT_1_FUNC_MSK 0x7f
#define FWCMD_C2HREG_AOAC_RPT_1_ACK BIT(7)
#define FWCMD_C2HREG_AOAC_RPT_1_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_AOAC_RPT_1_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_AOAC_RPT_1_SEQ_NUM_SH 12
#define FWCMD_C2HREG_AOAC_RPT_1_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_AOAC_RPT_1_RPT_SH 16
#define FWCMD_C2HREG_AOAC_RPT_1_RPT_MSK 0xffff
#define FWCMD_C2HREG_AOAC_RPT_2_FUNC_SH 0
#define FWCMD_C2HREG_AOAC_RPT_2_FUNC_MSK 0x7f
#define FWCMD_C2HREG_AOAC_RPT_2_ACK BIT(7)
#define FWCMD_C2HREG_AOAC_RPT_2_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_AOAC_RPT_2_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_AOAC_RPT_2_SEQ_NUM_SH 12
#define FWCMD_C2HREG_AOAC_RPT_2_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_AOAC_RPT_2_RPT_SH 16
#define FWCMD_C2HREG_AOAC_RPT_2_RPT_MSK 0xffff
#define FWCMD_C2HREG_AOAC_RPT_3_FUNC_SH 0
#define FWCMD_C2HREG_AOAC_RPT_3_FUNC_MSK 0x7f
#define FWCMD_C2HREG_AOAC_RPT_3_ACK BIT(7)
#define FWCMD_C2HREG_AOAC_RPT_3_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_AOAC_RPT_3_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_AOAC_RPT_3_SEQ_NUM_SH 12
#define FWCMD_C2HREG_AOAC_RPT_3_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_AOAC_RPT_3_RPT_SH 16
#define FWCMD_C2HREG_AOAC_RPT_3_RPT_MSK 0xffff
#define FWCMD_C2HREG_WOW_TRX_STOP_FUNC_SH 0
#define FWCMD_C2HREG_WOW_TRX_STOP_FUNC_MSK 0x7f
#define FWCMD_C2HREG_WOW_TRX_STOP_ACK BIT(7)
#define FWCMD_C2HREG_WOW_TRX_STOP_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_WOW_TRX_STOP_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_WOW_TRX_STOP_SEQ_NUM_SH 12
#define FWCMD_C2HREG_WOW_TRX_STOP_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_WOW_TRX_STOP_RPT_SH 16
#define FWCMD_C2HREG_WOW_TRX_STOP_RPT_MSK 0xffff
#define FWCMD_C2HREG_IO_OFLD_RESULT_FUNC_SH 0
#define FWCMD_C2HREG_IO_OFLD_RESULT_FUNC_MSK 0x7f
#define FWCMD_C2HREG_IO_OFLD_RESULT_TOTAL_LEN_SH 8
#define FWCMD_C2HREG_IO_OFLD_RESULT_TOTAL_LEN_MSK 0xf
#define FWCMD_C2HREG_IO_OFLD_RESULT_SEQ_NUM_SH 12
#define FWCMD_C2HREG_IO_OFLD_RESULT_SEQ_NUM_MSK 0xf
#define FWCMD_C2HREG_IO_OFLD_RESULT_RET_SH 16
#define FWCMD_C2HREG_IO_OFLD_RESULT_RET_MSK 0xff
#define FWCMD_C2HREG_IO_OFLD_RESULT_CMD_NUM_SH 24
#define FWCMD_C2HREG_IO_OFLD_RESULT_CMD_NUM_MSK 0xff
#define FWCMD_C2HREG_IO_OFLD_RESULT_OFFSET_SH 0
#define FWCMD_C2HREG_IO_OFLD_RESULT_OFFSET_MSK 0xffffffff
#define FWCMD_C2HREG_IO_OFLD_RESULT_EXP_VAL_SH 0
#define FWCMD_C2HREG_IO_OFLD_RESULT_EXP_VAL_MSK 0xffffffff
#define FWCMD_C2HREG_IO_OFLD_RESULT_R_VAL_SH 0
#define FWCMD_C2HREG_IO_OFLD_RESULT_R_VAL_MSK 0xffffffff

//
//H2CPKT - CAT(TEST)
//
#define H2C_HDR_CAT_SH 0
#define H2C_HDR_CAT_MSK 0x3
#define H2C_HDR_CLASS_SH 2
#define H2C_HDR_CLASS_MSK 0x3f
#define H2C_HDR_FUNC_SH 8
#define H2C_HDR_FUNC_MSK 0xff
#define H2C_HDR_DEL_TYPE_SH 16
#define H2C_HDR_DEL_TYPE_MSK 0xf
#define H2C_HDR_H2C_SEQ_SH 24
#define H2C_HDR_H2C_SEQ_MSK 0xff
#define H2C_HDR_TOTAL_LEN_SH 0
#define H2C_HDR_TOTAL_LEN_MSK 0x3fff
#define H2C_HDR_REC_ACK BIT(14)
#define H2C_HDR_DONE_ACK BIT(15)
#define H2C_HDR_SEQ_VALID BIT(16)
#define H2C_HDR_SEQ_SH 17
#define H2C_HDR_SEQ_MSK 0x7
#define H2C_HDR_SEQ_STOP BIT(20)
#define FWCMD_H2C_H2C_LB_PAYLOAD0_SH 0
#define FWCMD_H2C_H2C_LB_PAYLOAD0_MSK 0xffffffff
#define FWCMD_H2C_H2C_LB_PAYLOAD1_SH 0
#define FWCMD_H2C_H2C_LB_PAYLOAD1_MSK 0xffffffff
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD0_SH 0
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD0_MSK 0xffffffff
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD1_SH 0
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD1_MSK 0xffffffff
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD2_SH 0
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD2_MSK 0xffffffff
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD3_SH 0
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD3_MSK 0xffffffff
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD4_SH 0
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD4_MSK 0xffffffff
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD5_SH 0
#define FWCMD_H2C_PLAT_SPIC_TEST_PAYLOAD5_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FL_WRITE_ADDR_SH 0
#define FWCMD_H2C_PLAT_FL_WRITE_ADDR_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FL_WRITE_LENGTH_SH 0
#define FWCMD_H2C_PLAT_FL_WRITE_LENGTH_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FL_ERASE_ADDR_SH 0
#define FWCMD_H2C_PLAT_FL_ERASE_ADDR_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FL_ERASE_LENGTH_SH 0
#define FWCMD_H2C_PLAT_FL_ERASE_LENGTH_MSK 0xffffffff
#define FWCMD_H2C_PL_FLASH_READ_ADDR_SH 0
#define FWCMD_H2C_PL_FLASH_READ_ADDR_MSK 0xffffffff
#define FWCMD_H2C_PL_FLASH_READ_LENGTH_SH 0
#define FWCMD_H2C_PL_FLASH_READ_LENGTH_MSK 0xffffffff
#define FWCMD_H2C_LONG_RUN_PAYLOAD0_SH 0
#define FWCMD_H2C_LONG_RUN_PAYLOAD0_MSK 0xffffffff
#define FWCMD_H2C_LONG_RUN_PAYLOAD1_SH 0
#define FWCMD_H2C_LONG_RUN_PAYLOAD1_MSK 0xffffffff
#define FWCMD_H2C_LPS_TEST_COUNT_SH 0
#define FWCMD_H2C_LPS_TEST_COUNT_MSK 0xffffffff
#define FWCMD_H2C_LPS_ONOFF_TEST_TYPE_SH 0
#define FWCMD_H2C_LPS_ONOFF_TEST_TYPE_MSK 0xffffffff
#define FWCMD_H2C_LPS_ONOFF_TEST_PARA_SH 0
#define FWCMD_H2C_LPS_ONOFF_TEST_PARA_MSK 0xffffffff
#define FWCMD_H2C_FW_STATUS_COUNT_SH 0
#define FWCMD_H2C_FW_STATUS_COUNT_MSK 0xffffffff

//
//H2CPKT - CAT(MAC)
//
#define H2C_HDR_CAT_SH 0
#define H2C_HDR_CAT_MSK 0x3
#define H2C_HDR_CLASS_SH 2
#define H2C_HDR_CLASS_MSK 0x3f
#define H2C_HDR_FUNC_SH 8
#define H2C_HDR_FUNC_MSK 0xff
#define H2C_HDR_DEL_TYPE_SH 16
#define H2C_HDR_DEL_TYPE_MSK 0xf
#define H2C_HDR_H2C_SEQ_SH 24
#define H2C_HDR_H2C_SEQ_MSK 0xff
#define H2C_HDR_TOTAL_LEN_SH 0
#define H2C_HDR_TOTAL_LEN_MSK 0x3fff
#define H2C_HDR_REC_ACK BIT(14)
#define H2C_HDR_DONE_ACK BIT(15)
#define H2C_HDR_SEQ_VALID BIT(16)
#define H2C_HDR_SEQ_SH 17
#define H2C_HDR_SEQ_MSK 0x7
#define H2C_HDR_SEQ_STOP BIT(20)
#define FWCMD_H2C_LOG_CFG_DBG_LV_SH 0
#define FWCMD_H2C_LOG_CFG_DBG_LV_MSK 0xff
#define FWCMD_H2C_LOG_CFG_PATH_SH 8
#define FWCMD_H2C_LOG_CFG_PATH_MSK 0xff
#define FWCMD_H2C_LOG_CFG_COMP_SH 0
#define FWCMD_H2C_LOG_CFG_COMP_MSK 0xffffffff
#define FWCMD_H2C_LOG_CFG_COMP_EXT_SH 0
#define FWCMD_H2C_LOG_CFG_COMP_EXT_MSK 0xffffffff
#define FWCMD_H2C_GENERAL_PKT_MACID_SH 0
#define FWCMD_H2C_GENERAL_PKT_MACID_MSK 0xff
#define FWCMD_H2C_GENERAL_PKT_PROBRSP_ID_SH 8
#define FWCMD_H2C_GENERAL_PKT_PROBRSP_ID_MSK 0xff
#define FWCMD_H2C_GENERAL_PKT_PSPOLL_ID_SH 16
#define FWCMD_H2C_GENERAL_PKT_PSPOLL_ID_MSK 0xff
#define FWCMD_H2C_GENERAL_PKT_NULL_ID_SH 24
#define FWCMD_H2C_GENERAL_PKT_NULL_ID_MSK 0xff
#define FWCMD_H2C_GENERAL_PKT_QOS_NULL_ID_SH 0
#define FWCMD_H2C_GENERAL_PKT_QOS_NULL_ID_MSK 0xff
#define FWCMD_H2C_GENERAL_PKT_CTS2SELF_ID_SH 8
#define FWCMD_H2C_GENERAL_PKT_CTS2SELF_ID_MSK 0xff
#define FWCMD_H2C_GENERAL_PKT_PROBREQ_ID_SH 16
#define FWCMD_H2C_GENERAL_PKT_PROBREQ_ID_MSK 0xff
#define FWCMD_H2C_GENERAL_PKT_APCSA_ID_SH 24
#define FWCMD_H2C_GENERAL_PKT_APCSA_ID_MSK 0xff
#define FWCMD_H2C_C2H_RPT_CFG_TX_STATISTIC_EN BIT(0)
#define FWCMD_H2C_C2H_RPT_CFG_RX_STATISTIC_EN BIT(1)
#define FWCMD_H2C_C2H_RPT_CFG_BEACON_STATISTIC_EN BIT(2)
#define FWCMD_H2C_C2H_RPT_CFG_DL_STATISTIC_EN BIT(3)
#define FWCMD_H2C_C2H_RPT_CFG_RPT_INTERVAL_SH 0
#define FWCMD_H2C_C2H_RPT_CFG_RPT_INTERVAL_MSK 0xffff
#define FWCMD_H2C_WLAN_DUMP_CMD_CMD_ID_SH 0
#define FWCMD_H2C_WLAN_DUMP_CMD_CMD_ID_MSK 0xf
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV0_SH 8
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV0_MSK 0xff
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV1_SH 16
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV1_MSK 0xff
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV2_SH 24
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV2_MSK 0xff
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV3_SH 0
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV3_MSK 0xff
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV4_SH 8
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV4_MSK 0xff
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV5_SH 16
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV5_MSK 0xff
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV6_SH 24
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV6_MSK 0xff
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV7_SH 0
#define FWCMD_H2C_WLAN_DUMP_CMD_ARGV7_MSK 0xff
#define FWCMD_H2C_FW_DBGREG_CFG_FW_DBG_LOCK BIT(0)
#define FWCMD_H2C_KEEP_ALIVE_KEEPALIVE_EN BIT(0)
#define FWCMD_H2C_KEEP_ALIVE_PACKET_ID_SH 8
#define FWCMD_H2C_KEEP_ALIVE_PACKET_ID_MSK 0xff
#define FWCMD_H2C_KEEP_ALIVE_PERIOD_SH 16
#define FWCMD_H2C_KEEP_ALIVE_PERIOD_MSK 0xff
#define FWCMD_H2C_KEEP_ALIVE_MAC_ID_SH 24
#define FWCMD_H2C_KEEP_ALIVE_MAC_ID_MSK 0xff
#define FWCMD_H2C_DISCONNECT_DETECT_DISCONNECT_DETECT_EN BIT(0)
#define FWCMD_H2C_DISCONNECT_DETECT_TRYOK_BCNFAIL_COUNT_EN BIT(1)
#define FWCMD_H2C_DISCONNECT_DETECT_DISCONNECT_EN BIT(2)
#define FWCMD_H2C_DISCONNECT_DETECT_MAC_ID_SH 8
#define FWCMD_H2C_DISCONNECT_DETECT_MAC_ID_MSK 0xff
#define FWCMD_H2C_DISCONNECT_DETECT_CHECK_PERIOD_SH 16
#define FWCMD_H2C_DISCONNECT_DETECT_CHECK_PERIOD_MSK 0xff
#define FWCMD_H2C_DISCONNECT_DETECT_TRY_PKT_COUNT_SH 24
#define FWCMD_H2C_DISCONNECT_DETECT_TRY_PKT_COUNT_MSK 0xff
#define FWCMD_H2C_DISCONNECT_DETECT_TRYOK_BCNFAIL_COUNT_LIMIT_SH 0
#define FWCMD_H2C_DISCONNECT_DETECT_TRYOK_BCNFAIL_COUNT_LIMIT_MSK 0xff
#define FWCMD_H2C_WOW_GLOBAL_WOW_EN BIT(0)
#define FWCMD_H2C_WOW_GLOBAL_DROP_ALL_PKT BIT(1)
#define FWCMD_H2C_WOW_GLOBAL_RX_PARSE_AFTER_WAKE BIT(2)
#define FWCMD_H2C_WOW_GLOBAL_WAKE_BAR_PULLED BIT(3)
#define FWCMD_H2C_WOW_GLOBAL_MAC_ID_SH 8
#define FWCMD_H2C_WOW_GLOBAL_MAC_ID_MSK 0xff
#define FWCMD_H2C_WOW_GLOBAL_PAIRWISE_SEC_ALGO_SH 16
#define FWCMD_H2C_WOW_GLOBAL_PAIRWISE_SEC_ALGO_MSK 0xff
#define FWCMD_H2C_WOW_GLOBAL_GROUP_SEC_ALGO_SH 24
#define FWCMD_H2C_WOW_GLOBAL_GROUP_SEC_ALGO_MSK 0xff
#define FWCMD_H2C_WOW_GLOBAL_REMOTECTRL_INFO_CONTENT_SH 0
#define FWCMD_H2C_WOW_GLOBAL_REMOTECTRL_INFO_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_GTK_OFLD_GTK_EN BIT(0)
#define FWCMD_H2C_GTK_OFLD_TKIP_EN BIT(1)
#define FWCMD_H2C_GTK_OFLD_IEEE80211W_EN BIT(2)
#define FWCMD_H2C_GTK_OFLD_PAIRWISE_WAKEUP BIT(3)
#define FWCMD_H2C_GTK_OFLD_AOAC_REPORT_ID_SH 8
#define FWCMD_H2C_GTK_OFLD_AOAC_REPORT_ID_MSK 0xff
#define FWCMD_H2C_GTK_OFLD_MAC_ID_SH 16
#define FWCMD_H2C_GTK_OFLD_MAC_ID_MSK 0xff
#define FWCMD_H2C_GTK_OFLD_GTK_RSP_ID_SH 24
#define FWCMD_H2C_GTK_OFLD_GTK_RSP_ID_MSK 0xff
#define FWCMD_H2C_GTK_OFLD_PMF_SA_QUERY_ID_SH 0
#define FWCMD_H2C_GTK_OFLD_PMF_SA_QUERY_ID_MSK 0xff
#define FWCMD_H2C_GTK_OFLD_PMF_BIP_SEC_ALGO_SH 8
#define FWCMD_H2C_GTK_OFLD_PMF_BIP_SEC_ALGO_MSK 0x3
#define FWCMD_H2C_GTK_OFLD_ALGO_AKM_SUIT_SH 10
#define FWCMD_H2C_GTK_OFLD_ALGO_AKM_SUIT_MSK 0xff
#define FWCMD_H2C_GTK_OFLD_GTK_INFO_CONTENT_SH 0
#define FWCMD_H2C_GTK_OFLD_GTK_INFO_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_ARP_OFLD_ARP_EN BIT(0)
#define FWCMD_H2C_ARP_OFLD_ARP_ACTION BIT(1)
#define FWCMD_H2C_ARP_OFLD_MAC_ID_SH 16
#define FWCMD_H2C_ARP_OFLD_MAC_ID_MSK 0xff
#define FWCMD_H2C_ARP_OFLD_ARP_RSP_ID_SH 24
#define FWCMD_H2C_ARP_OFLD_ARP_RSP_ID_MSK 0xff
#define FWCMD_H2C_ARP_OFLD_ARP_INFO_CONTENT_SH 0
#define FWCMD_H2C_ARP_OFLD_ARP_INFO_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_NDP_OFLD_NDP_EN BIT(0)
#define FWCMD_H2C_NDP_OFLD_MAC_ID_SH 16
#define FWCMD_H2C_NDP_OFLD_MAC_ID_MSK 0xff
#define FWCMD_H2C_NDP_OFLD_NA_ID_SH 24
#define FWCMD_H2C_NDP_OFLD_NA_ID_MSK 0xff
#define FWCMD_H2C_NDP_OFLD_NDP_INFO_CONTENT_SH 0
#define FWCMD_H2C_NDP_OFLD_NDP_INFO_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_REALWOW_REALWOW_EN BIT(0)
#define FWCMD_H2C_REALWOW_AUTO_WAKEUP BIT(1)
#define FWCMD_H2C_REALWOW_MAC_ID_SH 24
#define FWCMD_H2C_REALWOW_MAC_ID_MSK 0xff
#define FWCMD_H2C_REALWOW_KEEPALIVE_ID_SH 0
#define FWCMD_H2C_REALWOW_KEEPALIVE_ID_MSK 0xff
#define FWCMD_H2C_REALWOW_WAKEUP_PATTERN_ID_SH 8
#define FWCMD_H2C_REALWOW_WAKEUP_PATTERN_ID_MSK 0xff
#define FWCMD_H2C_REALWOW_ACK_PATTERN_ID_SH 16
#define FWCMD_H2C_REALWOW_ACK_PATTERN_ID_MSK 0xff
#define FWCMD_H2C_REALWOW_REALWOW_INFO_CONTENT_SH 0
#define FWCMD_H2C_REALWOW_REALWOW_INFO_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_NLO_NLO_EN BIT(0)
#define FWCMD_H2C_NLO_NLO_32K_EN BIT(1)
#define FWCMD_H2C_NLO_IGNORE_CIPHER_TYPE BIT(2)
#define FWCMD_H2C_NLO_MAC_ID_SH 24
#define FWCMD_H2C_NLO_MAC_ID_MSK 0xff
#define FWCMD_H2C_NLO_NLO_NETWORKLISTINFO_CONTENT_SH 0
#define FWCMD_H2C_NLO_NLO_NETWORKLISTINFO_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_WAKEUP_CTRL_PATTERN_MATCH_EN BIT(0)
#define FWCMD_H2C_WAKEUP_CTRL_MAGIC_EN BIT(1)
#define FWCMD_H2C_WAKEUP_CTRL_HW_UNICAST_EN BIT(2)
#define FWCMD_H2C_WAKEUP_CTRL_FW_UNICAST_EN BIT(3)
#define FWCMD_H2C_WAKEUP_CTRL_DEAUTH_WAKEUP BIT(4)
#define FWCMD_H2C_WAKEUP_CTRL_REKEY_WAKEUP BIT(5)
#define FWCMD_H2C_WAKEUP_CTRL_EAP_WAKEUP BIT(6)
#define FWCMD_H2C_WAKEUP_CTRL_ALL_DATA_WAKEUP BIT(7)
#define FWCMD_H2C_WAKEUP_CTRL_MAC_ID_SH 24
#define FWCMD_H2C_WAKEUP_CTRL_MAC_ID_MSK 0xff
#define FWCMD_H2C_NEGATIVE_PATTERN_NEGATIVE_PATTERN_EN BIT(0)
#define FWCMD_H2C_NEGATIVE_PATTERN_PATTERN_COUNT_SH 20
#define FWCMD_H2C_NEGATIVE_PATTERN_PATTERN_COUNT_MSK 0xf
#define FWCMD_H2C_NEGATIVE_PATTERN_MAC_ID_SH 24
#define FWCMD_H2C_NEGATIVE_PATTERN_MAC_ID_MSK 0xff
#define FWCMD_H2C_NEGATIVE_PATTERN_PATTERN_CONTENT_SH 0
#define FWCMD_H2C_NEGATIVE_PATTERN_PATTERN_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_DEV2HST_GPIO_DEV2HST_GPIO_EN BIT(0)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_ACTIVE BIT(1)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_INPUT_EN BIT(2)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_INPUT_FOR_LOW BIT(3)
#define FWCMD_H2C_DEV2HST_GPIO_DISABLE_INBAND BIT(4)
#define FWCMD_H2C_DEV2HST_GPIO_DATA_PIN_WAKEUP BIT(5)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_EN BIT(8)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_NONSTOP BIT(9)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_DURATION_UNIT BIT(10)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_NUM_SH 16
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_NUM_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_COUNT_SH 24
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_COUNT_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_DURATION_SH 0
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_DURATION_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_CUSTOMER_ID_SH 0
#define FWCMD_H2C_DEV2HST_GPIO_CUSTOMER_ID_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_EN_A BIT(0)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_DURATION_UNIT_A BIT(1)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_NONSTOP_A BIT(2)
#define FWCMD_H2C_DEV2HST_GPIO_SPECIAL_REASON_A_SH 8
#define FWCMD_H2C_DEV2HST_GPIO_SPECIAL_REASON_A_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_DURATION_A_SH 16
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_DURATION_A_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_COUNT_A_SH 24
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_COUNT_A_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_EN_B BIT(0)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_DURATION_UNIT_B BIT(1)
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_NONSTOP_B BIT(2)
#define FWCMD_H2C_DEV2HST_GPIO_SPECIAL_REASON_B_SH 8
#define FWCMD_H2C_DEV2HST_GPIO_SPECIAL_REASON_B_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_DURATION_B_SH 16
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_DURATION_B_MSK 0xff
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_COUNT_B_SH 24
#define FWCMD_H2C_DEV2HST_GPIO_GPIO_PULSE_COUNT_B_MSK 0xff
#define FWCMD_H2C_UPHY_CTRL_DISABLE_UPHY BIT(0)
#define FWCMD_H2C_UPHY_CTRL_HANDSHAKE_MODE_SH 1
#define FWCMD_H2C_UPHY_CTRL_HANDSHAKE_MODE_MSK 0x7
#define FWCMD_H2C_UPHY_CTRL_RISE_HST2DEV_DIS_UPHY BIT(8)
#define FWCMD_H2C_UPHY_CTRL_UPHY_DIS_DELAY_UNIT BIT(9)
#define FWCMD_H2C_UPHY_CTRL_PDN_AS_UPHY_DIS BIT(10)
#define FWCMD_H2C_UPHY_CTRL_PDN_TO_ENABLE_UPHY BIT(11)
#define FWCMD_H2C_UPHY_CTRL_HST2DEV_GPIO_NUM_SH 16
#define FWCMD_H2C_UPHY_CTRL_HST2DEV_GPIO_NUM_MSK 0xff
#define FWCMD_H2C_UPHY_CTRL_UPHY_DIS_DELAY_COUNT_SH 24
#define FWCMD_H2C_UPHY_CTRL_UPHY_DIS_DELAY_COUNT_MSK 0xff
#define FWCMD_H2C_WOW_CAM_UPD_R_W BIT(0)
#define FWCMD_H2C_WOW_CAM_UPD_IDX_SH 1
#define FWCMD_H2C_WOW_CAM_UPD_IDX_MSK 0x7f
#define FWCMD_H2C_WOW_CAM_UPD_WKFM1_SH 0
#define FWCMD_H2C_WOW_CAM_UPD_WKFM1_MSK 0xffffffff
#define FWCMD_H2C_WOW_CAM_UPD_WKFM2_SH 0
#define FWCMD_H2C_WOW_CAM_UPD_WKFM2_MSK 0xffffffff
#define FWCMD_H2C_WOW_CAM_UPD_WKFM3_SH 0
#define FWCMD_H2C_WOW_CAM_UPD_WKFM3_MSK 0xffffffff
#define FWCMD_H2C_WOW_CAM_UPD_WKFM4_SH 0
#define FWCMD_H2C_WOW_CAM_UPD_WKFM4_MSK 0xffffffff
#define FWCMD_H2C_WOW_CAM_UPD_CRC_SH 0
#define FWCMD_H2C_WOW_CAM_UPD_CRC_MSK 0xffff
#define FWCMD_H2C_WOW_CAM_UPD_NEGATIVE_PATTERN_MATCH BIT(22)
#define FWCMD_H2C_WOW_CAM_UPD_SKIP_MAC_HDR BIT(23)
#define FWCMD_H2C_WOW_CAM_UPD_UC BIT(24)
#define FWCMD_H2C_WOW_CAM_UPD_MC BIT(25)
#define FWCMD_H2C_WOW_CAM_UPD_BC BIT(26)
#define FWCMD_H2C_WOW_CAM_UPD_VALID BIT(31)
#define FWCMD_H2C_AOAC_REPORT_REQ_RX_READY BIT(0)
#define FWCMD_H2C_LPS_PARM_MACID_SH 0
#define FWCMD_H2C_LPS_PARM_MACID_MSK 0xff
#define FWCMD_H2C_LPS_PARM_PSMODE_SH 8
#define FWCMD_H2C_LPS_PARM_PSMODE_MSK 0xff
#define FWCMD_H2C_LPS_PARM_RLBM_SH 16
#define FWCMD_H2C_LPS_PARM_RLBM_MSK 0xf
#define FWCMD_H2C_LPS_PARM_SMARTPS_SH 20
#define FWCMD_H2C_LPS_PARM_SMARTPS_MSK 0xf
#define FWCMD_H2C_LPS_PARM_AWAKEINTERVAL_SH 24
#define FWCMD_H2C_LPS_PARM_AWAKEINTERVAL_MSK 0xff
#define FWCMD_H2C_LPS_PARM_VOUAPSD BIT(0)
#define FWCMD_H2C_LPS_PARM_VIUAPSD BIT(1)
#define FWCMD_H2C_LPS_PARM_BEUAPSD BIT(2)
#define FWCMD_H2C_LPS_PARM_BKUAPSD BIT(3)
#define FWCMD_H2C_LPS_PARM_LASTRPWM_SH 8
#define FWCMD_H2C_LPS_PARM_LASTRPWM_MSK 0xff
#define FWCMD_H2C_P2P_ACT_MACID_SH 0
#define FWCMD_H2C_P2P_ACT_MACID_MSK 0xff
#define FWCMD_H2C_P2P_ACT_P2PID_SH 8
#define FWCMD_H2C_P2P_ACT_P2PID_MSK 0xf
#define FWCMD_H2C_P2P_ACT_NOAID_SH 12
#define FWCMD_H2C_P2P_ACT_NOAID_MSK 0xf
#define FWCMD_H2C_P2P_ACT_ACT_SH 16
#define FWCMD_H2C_P2P_ACT_ACT_MSK 0xf
#define FWCMD_H2C_P2P_ACT_TYPE BIT(20)
#define FWCMD_H2C_P2P_ACT_ALL_SLEP BIT(21)
#define FWCMD_H2C_P2P_ACT_SRT_SH 0
#define FWCMD_H2C_P2P_ACT_SRT_MSK 0xffffffff
#define FWCMD_H2C_P2P_ACT_ITVL_SH 0
#define FWCMD_H2C_P2P_ACT_ITVL_MSK 0xffffffff
#define FWCMD_H2C_P2P_ACT_DUR_SH 0
#define FWCMD_H2C_P2P_ACT_DUR_MSK 0xffffffff
#define FWCMD_H2C_P2P_ACT_CNT_SH 0
#define FWCMD_H2C_P2P_ACT_CNT_MSK 0xff
#define FWCMD_H2C_P2P_ACT_CTW_SH 8
#define FWCMD_H2C_P2P_ACT_CTW_MSK 0xffff
#define FWCMD_H2C_FWHDR_DL_FWHDR_SH 0
#define FWCMD_H2C_FWHDR_DL_FWHDR_MSK 0xffffffff
#define FWCMD_H2C_FWHDR_REDL_FWHDR_SH 0
#define FWCMD_H2C_FWHDR_REDL_FWHDR_MSK 0xffffffff
#define FWCMD_H2C_TWT_ANNOUNCE_UPD_MACID_SH 0
#define FWCMD_H2C_TWT_ANNOUNCE_UPD_MACID_MSK 0xff
#define FWCMD_H2C_TWTINFO_UPD_NEGOTYPE_SH 0
#define FWCMD_H2C_TWTINFO_UPD_NEGOTYPE_MSK 0x3
#define FWCMD_H2C_TWTINFO_UPD_TRIGGER BIT(2)
#define FWCMD_H2C_TWTINFO_UPD_FLOWTYPE BIT(3)
#define FWCMD_H2C_TWTINFO_UPD_IMPT BIT(4)
#define FWCMD_H2C_TWTINFO_UPD_WAKEDURUNIT BIT(5)
#define FWCMD_H2C_TWTINFO_UPD_RSPPM BIT(6)
#define FWCMD_H2C_TWTINFO_UPD_FLOWID_SH 7
#define FWCMD_H2C_TWTINFO_UPD_FLOWID_MSK 0x7
#define FWCMD_H2C_TWTINFO_UPD_PROT BIT(10)
#define FWCMD_H2C_TWTINFO_UPD_ACT_SH 11
#define FWCMD_H2C_TWTINFO_UPD_ACT_MSK 0x7
#define FWCMD_H2C_TWTINFO_UPD_ID_SH 14
#define FWCMD_H2C_TWTINFO_UPD_ID_MSK 0x7
#define FWCMD_H2C_TWTINFO_UPD_BAND BIT(17)
#define FWCMD_H2C_TWTINFO_UPD_PORT_SH 18
#define FWCMD_H2C_TWTINFO_UPD_PORT_MSK 0x7
#define FWCMD_H2C_TWTINFO_UPD_WAKE_MAN_SH 0
#define FWCMD_H2C_TWTINFO_UPD_WAKE_MAN_MSK 0xffff
#define FWCMD_H2C_TWTINFO_UPD_WAKE_EXP_SH 16
#define FWCMD_H2C_TWTINFO_UPD_WAKE_EXP_MSK 0x1f
#define FWCMD_H2C_TWTINFO_UPD_ULFIXMODE_SH 21
#define FWCMD_H2C_TWTINFO_UPD_ULFIXMODE_MSK 0x7
#define FWCMD_H2C_TWTINFO_UPD_DUR_SH 24
#define FWCMD_H2C_TWTINFO_UPD_DUR_MSK 0xff
#define FWCMD_H2C_TWTINFO_UPD_TGT_L_SH 0
#define FWCMD_H2C_TWTINFO_UPD_TGT_L_MSK 0xffffffff
#define FWCMD_H2C_TWTINFO_UPD_TGT_H_SH 0
#define FWCMD_H2C_TWTINFO_UPD_TGT_H_MSK 0xffffffff
#define FWCMD_H2C_TWT_STANSP_UPD_MACID_SH 0
#define FWCMD_H2C_TWT_STANSP_UPD_MACID_MSK 0xff
#define FWCMD_H2C_TWT_STANSP_UPD_ID_SH 8
#define FWCMD_H2C_TWT_STANSP_UPD_ID_MSK 0x7
#define FWCMD_H2C_TWT_STANSP_UPD_ACT_SH 11
#define FWCMD_H2C_TWT_STANSP_UPD_ACT_MSK 0xf
#define FWCMD_H2C_TBLUD_R_W BIT(0)
#define FWCMD_H2C_TBLUD_MACID_GROUP_SH 1
#define FWCMD_H2C_TBLUD_MACID_GROUP_MSK 0x7f
#define FWCMD_H2C_TBLUD_OFFSET_SH 8
#define FWCMD_H2C_TBLUD_OFFSET_MSK 0x1f
#define FWCMD_H2C_TBLUD_LENGTH_SH 13
#define FWCMD_H2C_TBLUD_LENGTH_MSK 0x3ff
#define FWCMD_H2C_TBLUD_TYPE BIT(23)
#define FWCMD_H2C_TBLUD_TABLE_CLASS_SH 24
#define FWCMD_H2C_TBLUD_TABLE_CLASS_MSK 0xff
#define FWCMD_H2C_DCTLINFO_UD_MACID_SH 0
#define FWCMD_H2C_DCTLINFO_UD_MACID_MSK 0x7f
#define FWCMD_H2C_DCTLINFO_UD_OP BIT(7)
#define FWCMD_H2C_DCTLINFO_UD_DCTRL0_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL0_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_DCTRL1_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL1_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_DCTRL2_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL2_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_DCTRL3_VAL_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL3_VAL_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_DCTRL0_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL0_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_DCTRL1_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL1_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_DCTRL2_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL2_MSK_MSK 0xffffffff
#define FWCMD_H2C_DCTLINFO_UD_DCTRL3_MSK_SH 0
#define FWCMD_H2C_DCTLINFO_UD_DCTRL3_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_MACID_SH 0
#define FWCMD_H2C_CCTLINFO_UD_MACID_MSK 0x7f
#define FWCMD_H2C_CCTLINFO_UD_OP BIT(7)
#define FWCMD_H2C_CCTLINFO_UD_CCTRL0_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL0_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL1_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL1_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL2_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL2_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL3_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL3_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL4_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL4_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL5_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL5_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL6_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL6_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL7_VAL_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL7_VAL_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL0_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL0_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL1_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL1_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL2_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL2_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL3_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL3_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL4_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL4_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL5_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL5_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL6_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL6_MSK_MSK 0xffffffff
#define FWCMD_H2C_CCTLINFO_UD_CCTRL7_MSK_SH 0
#define FWCMD_H2C_CCTLINFO_UD_CCTRL7_MSK_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D0_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D0_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D1_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D1_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D2_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D2_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D3_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D3_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D4_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D4_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D5_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D5_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D6_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D6_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D7_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D7_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D8_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D8_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D9_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D9_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D10_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D10_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D11_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D11_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D12_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D12_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D13_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D13_MSK 0xffffffff
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D14_SH 0
#define FWCMD_H2C_SHCUT_UPDATE_SHCUT_UPDATE_D14_MSK 0xffffffff
#define FWCMD_H2C_BCN_UPD_PORT_SH 0
#define FWCMD_H2C_BCN_UPD_PORT_MSK 0xff
#define FWCMD_H2C_BCN_UPD_MBSSID_SH 8
#define FWCMD_H2C_BCN_UPD_MBSSID_MSK 0xff
#define FWCMD_H2C_BCN_UPD_BAND_SH 16
#define FWCMD_H2C_BCN_UPD_BAND_MSK 0xff
#define FWCMD_H2C_BCN_UPD_GRP_IE_OFST_SH 24
#define FWCMD_H2C_BCN_UPD_GRP_IE_OFST_MSK 0xff
#define FWCMD_H2C_BCN_UPD_MACID_SH 0
#define FWCMD_H2C_BCN_UPD_MACID_MSK 0xff
#define FWCMD_H2C_BCN_UPD_SSN_SEL_SH 8
#define FWCMD_H2C_BCN_UPD_SSN_SEL_MSK 0x3
#define FWCMD_H2C_BCN_UPD_SSN_MODE_SH 10
#define FWCMD_H2C_BCN_UPD_SSN_MODE_MSK 0x3
#define FWCMD_H2C_BCN_UPD_RATE_SH 12
#define FWCMD_H2C_BCN_UPD_RATE_MSK 0x1ff
#define FWCMD_H2C_BCN_UPD_TXPWR_SH 21
#define FWCMD_H2C_BCN_UPD_TXPWR_MSK 0x7
#define FWCMD_H2C_BCN_UPD_TXINFO_CTRL_EN BIT(0)
#define FWCMD_H2C_BCN_UPD_NTX_PATH_EN_SH 1
#define FWCMD_H2C_BCN_UPD_NTX_PATH_EN_MSK 0xf
#define FWCMD_H2C_BCN_UPD_PATH_MAP_A_SH 5
#define FWCMD_H2C_BCN_UPD_PATH_MAP_A_MSK 0x3
#define FWCMD_H2C_BCN_UPD_PATH_MAP_B_SH 7
#define FWCMD_H2C_BCN_UPD_PATH_MAP_B_MSK 0x3
#define FWCMD_H2C_BCN_UPD_PATH_MAP_C_SH 9
#define FWCMD_H2C_BCN_UPD_PATH_MAP_C_MSK 0x3
#define FWCMD_H2C_BCN_UPD_PATH_MAP_D_SH 11
#define FWCMD_H2C_BCN_UPD_PATH_MAP_D_MSK 0x3
#define FWCMD_H2C_BCN_UPD_ANTSEL_A BIT(13)
#define FWCMD_H2C_BCN_UPD_ANTSEL_B BIT(14)
#define FWCMD_H2C_BCN_UPD_ANTSEL_C BIT(15)
#define FWCMD_H2C_BCN_UPD_ANTSEL_D BIT(16)
#define FWCMD_H2C_BCN_UPD_CSA_OFST_SH 17
#define FWCMD_H2C_BCN_UPD_CSA_OFST_MSK 0x7fff
#define FWCMD_H2C_SS_ULSTA_UPD_MODE_SH 0
#define FWCMD_H2C_SS_ULSTA_UPD_MODE_MSK 0xff
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U0_SH 0
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U0_MSK 0xff
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U1_SH 8
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U1_MSK 0xff
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U2_SH 16
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U2_MSK 0xff
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U3_SH 24
#define FWCMD_H2C_SS_ULSTA_UPD_MACID_U3_MSK 0xff
#define FWCMD_H2C_SS_ULSTA_UPD_BSR_LEN_U0_SH 0
#define FWCMD_H2C_SS_ULSTA_UPD_BSR_LEN_U0_MSK 0xffff
#define FWCMD_H2C_SS_ULSTA_UPD_BSR_LEN_U1_SH 16
#define FWCMD_H2C_SS_ULSTA_UPD_BSR_LEN_U1_MSK 0xffff
#define FWCMD_H2C_F2PDBG_SET_SET_TXDBG BIT(0)
#define FWCMD_H2C_F2PDBG_SET_TXDBG_EN BIT(1)
#define FWCMD_H2C_F2PDBG_SET_SET_TPPKTSIZE BIT(2)
#define FWCMD_H2C_F2PDBG_SET_PKT_SIZE_SH 3
#define FWCMD_H2C_F2PDBG_SET_PKT_SIZE_MSK 0xffff
#define FWCMD_H2C_WLANINFO_GET_INFO_SEL_SH 0
#define FWCMD_H2C_WLANINFO_GET_INFO_SEL_MSK 0xf
#define FWCMD_H2C_WLANINFO_GET_ARGV0_SH 8
#define FWCMD_H2C_WLANINFO_GET_ARGV0_MSK 0xff
#define FWCMD_H2C_WLANINFO_GET_ARGV1_SH 16
#define FWCMD_H2C_WLANINFO_GET_ARGV1_MSK 0xff
#define FWCMD_H2C_WLANINFO_GET_ARGV2_SH 24
#define FWCMD_H2C_WLANINFO_GET_ARGV2_MSK 0xff
#define FWCMD_H2C_WLANINFO_GET_ARGV3_SH 0
#define FWCMD_H2C_WLANINFO_GET_ARGV3_MSK 0xff
#define FWCMD_H2C_WLANINFO_GET_ARGV4_SH 8
#define FWCMD_H2C_WLANINFO_GET_ARGV4_MSK 0xff
#define FWCMD_H2C_WLANINFO_GET_ARGV5_SH 16
#define FWCMD_H2C_WLANINFO_GET_ARGV5_MSK 0xff
#define FWCMD_H2C_WLANINFO_GET_ARGV6_SH 24
#define FWCMD_H2C_WLANINFO_GET_ARGV6_MSK 0xff
#define FWCMD_H2C_WLANINFO_GET_ARGV7_SH 0
#define FWCMD_H2C_WLANINFO_GET_ARGV7_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_R_W BIT(0)
#define FWCMD_H2C_ADDRCAM_INFO_IDX_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_IDX_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_OFFSET_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_OFFSET_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_LEN_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_LEN_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_VALID BIT(0)
#define FWCMD_H2C_ADDRCAM_INFO_NET_TYPE_SH 1
#define FWCMD_H2C_ADDRCAM_INFO_NET_TYPE_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_BCN_HIT_COND_SH 3
#define FWCMD_H2C_ADDRCAM_INFO_BCN_HIT_COND_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_HIT_RULE_SH 5
#define FWCMD_H2C_ADDRCAM_INFO_HIT_RULE_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_BB_SEL BIT(7)
#define FWCMD_H2C_ADDRCAM_INFO_ADDR_MASK_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_ADDR_MASK_MSK 0x3f
#define FWCMD_H2C_ADDRCAM_INFO_MASK_SEL_SH 14
#define FWCMD_H2C_ADDRCAM_INFO_MASK_SEL_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SMA_HASH_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_SMA_HASH_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_TMA_HASH_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_TMA_HASH_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_BSSID_CAM_IDX_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_BSSID_CAM_IDX_MSK 0x3f
#define FWCMD_H2C_ADDRCAM_INFO_IS_MUL_ENT BIT(8)
#define FWCMD_H2C_ADDRCAM_INFO_SMA0_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_SMA0_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SMA1_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_SMA1_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SMA2_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_SMA2_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SMA3_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_SMA3_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SMA4_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_SMA4_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SMA5_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_SMA5_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_TMA0_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_TMA0_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_TMA1_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_TMA1_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_TMA2_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_TMA2_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_TMA3_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_TMA3_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_TMA4_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_TMA4_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_TMA5_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_TMA5_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_MACID_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_MACID_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_PORT_INT_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_PORT_INT_MSK 0x7
#define FWCMD_H2C_ADDRCAM_INFO_TSF_SYNC_SH 11
#define FWCMD_H2C_ADDRCAM_INFO_TSF_SYNC_MSK 0x7
#define FWCMD_H2C_ADDRCAM_INFO_TF_TRS BIT(14)
#define FWCMD_H2C_ADDRCAM_INFO_LSIG_TXOP BIT(15)
#define FWCMD_H2C_ADDRCAM_INFO_TGT_IND_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_TGT_IND_MSK 0x7
#define FWCMD_H2C_ADDRCAM_INFO_FRM_TGT_IND_SH 27
#define FWCMD_H2C_ADDRCAM_INFO_FRM_TGT_IND_MSK 0x7
#define FWCMD_H2C_ADDRCAM_INFO_AID12_0_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_AID12_0_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_AID12_1_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_AID12_1_MSK 0xf
#define FWCMD_H2C_ADDRCAM_INFO_WOL_PATTERN BIT(12)
#define FWCMD_H2C_ADDRCAM_INFO_WOL_UC BIT(13)
#define FWCMD_H2C_ADDRCAM_INFO_WOL_MAGIC BIT(14)
#define FWCMD_H2C_ADDRCAM_INFO_WAPI BIT(15)
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT_MODE_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT_MODE_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT0_KEYID_SH 18
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT0_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT1_KEYID_SH 20
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT1_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT2_KEYID_SH 22
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT2_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT3_KEYID_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT3_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT4_KEYID_SH 26
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT4_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT5_KEYID_SH 28
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT5_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT6_KEYID_SH 30
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT6_KEYID_MSK 0x3
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT_VALID_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT_VALID_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT0_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT0_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT1_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT1_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT2_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT2_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT3_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT3_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT4_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT4_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT5_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT5_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT6_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_SEC_ENT6_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_B_IDX_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_B_IDX_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_B_OFFSET_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_B_OFFSET_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_B_LEN_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_B_LEN_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_B_VALID BIT(0)
#define FWCMD_H2C_ADDRCAM_INFO_B_BB_SEL BIT(1)
#define FWCMD_H2C_ADDRCAM_INFO_BSS_COLOR_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_BSS_COLOR_MSK 0x7f
#define FWCMD_H2C_ADDRCAM_INFO_BSSID0_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_BSSID0_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_BSSID1_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_BSSID1_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_BSSID2_SH 0
#define FWCMD_H2C_ADDRCAM_INFO_BSSID2_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_BSSID3_SH 8
#define FWCMD_H2C_ADDRCAM_INFO_BSSID3_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_BSSID4_SH 16
#define FWCMD_H2C_ADDRCAM_INFO_BSSID4_MSK 0xff
#define FWCMD_H2C_ADDRCAM_INFO_BSSID5_SH 24
#define FWCMD_H2C_ADDRCAM_INFO_BSSID5_MSK 0xff
#define FWCMD_H2C_JOININFO_MACID_SH 0
#define FWCMD_H2C_JOININFO_MACID_MSK 0xff
#define FWCMD_H2C_JOININFO_OPMODE BIT(8)
#define FWCMD_H2C_JOININFO_BAND BIT(9)
#define FWCMD_H2C_JOININFO_WMM_SH 10
#define FWCMD_H2C_JOININFO_WMM_MSK 0x3
#define FWCMD_H2C_JOININFO_TRIGGER BIT(12)
#define FWCMD_H2C_JOININFO_ISHESTA BIT(13)
#define FWCMD_H2C_JOININFO_DL_BW_SH 14
#define FWCMD_H2C_JOININFO_DL_BW_MSK 0x3
#define FWCMD_H2C_JOININFO_TF_MAC_PADDING_SH 16
#define FWCMD_H2C_JOININFO_TF_MAC_PADDING_MSK 0x3
#define FWCMD_H2C_JOININFO_DL_T_PE_SH 18
#define FWCMD_H2C_JOININFO_DL_T_PE_MSK 0x7
#define FWCMD_H2C_JOININFO_PORT_ID_SH 21
#define FWCMD_H2C_JOININFO_PORT_ID_MSK 0x7
#define FWCMD_H2C_JOININFO_NET_TYPE_SH 24
#define FWCMD_H2C_JOININFO_NET_TYPE_MSK 0x3
#define FWCMD_H2C_JOININFO_WIFI_ROLE_SH 26
#define FWCMD_H2C_JOININFO_WIFI_ROLE_MSK 0xf
#define FWCMD_H2C_JOININFO_SELF_ROLE_SH 30
#define FWCMD_H2C_JOININFO_SELF_ROLE_MSK 0x3
#define FWCMD_H2C_DL_GRP_UPD_GRP_VALID BIT(0)
#define FWCMD_H2C_DL_GRP_UPD_GRP_ID_SH 1
#define FWCMD_H2C_DL_GRP_UPD_GRP_ID_MSK 0x1f
#define FWCMD_H2C_DL_GRP_UPD_IS_HWGRP BIT(6)
#define FWCMD_H2C_DL_GRP_UPD_MACID_U0_SH 8
#define FWCMD_H2C_DL_GRP_UPD_MACID_U0_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_MACID_U1_SH 16
#define FWCMD_H2C_DL_GRP_UPD_MACID_U1_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_MACID_U2_SH 24
#define FWCMD_H2C_DL_GRP_UPD_MACID_U2_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_MACID_U3_SH 0
#define FWCMD_H2C_DL_GRP_UPD_MACID_U3_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_MACID_U4_SH 8
#define FWCMD_H2C_DL_GRP_UPD_MACID_U4_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_MACID_U5_SH 16
#define FWCMD_H2C_DL_GRP_UPD_MACID_U5_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_MACID_U6_SH 24
#define FWCMD_H2C_DL_GRP_UPD_MACID_U6_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_MACID_U7_SH 0
#define FWCMD_H2C_DL_GRP_UPD_MACID_U7_MSK 0xff
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U0_SH 8
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U0_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U1_SH 12
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U1_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U2_SH 16
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U2_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U3_SH 20
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U3_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U4_SH 24
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U4_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U5_SH 28
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U5_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U6_SH 0
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U6_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U7_SH 4
#define FWCMD_H2C_DL_GRP_UPD_AC_BITMAP_U7_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_NEXT_PROTECTTYPE_SH 8
#define FWCMD_H2C_DL_GRP_UPD_NEXT_PROTECTTYPE_MSK 0xf
#define FWCMD_H2C_DL_GRP_UPD_NEXT_RSPTYPE_SH 12
#define FWCMD_H2C_DL_GRP_UPD_NEXT_RSPTYPE_MSK 0xf
#define FWCMD_H2C_UL_GRP_UPD_MACID_U0_SH 0
#define FWCMD_H2C_UL_GRP_UPD_MACID_U0_MSK 0xff
#define FWCMD_H2C_UL_GRP_UPD_MACID_U1_SH 8
#define FWCMD_H2C_UL_GRP_UPD_MACID_U1_MSK 0xff
#define FWCMD_H2C_UL_GRP_UPD_GRP_BITMAP_SH 16
#define FWCMD_H2C_UL_GRP_UPD_GRP_BITMAP_MSK 0xffff
#define FWCMD_H2C_MU_STA_UPD_MACID_SH 0
#define FWCMD_H2C_MU_STA_UPD_MACID_MSK 0xff
#define FWCMD_H2C_MU_STA_UPD_MU_IDX_SH 8
#define FWCMD_H2C_MU_STA_UPD_MU_IDX_MSK 0xff
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_0_SH 16
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_0_MSK 0xff
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_1_SH 24
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_1_MSK 0xff
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_2_SH 0
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_2_MSK 0xff
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_3_SH 8
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_3_MSK 0xff
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_4_SH 16
#define FWCMD_H2C_MU_STA_UPD_PROT_RSP_TYPE_4_MSK 0xff
#define FWCMD_H2C_MU_STA_UPD_MUGRP_BITMAP_SH 24
#define FWCMD_H2C_MU_STA_UPD_MUGRP_BITMAP_MSK 0x1f
#define FWCMD_H2C_MU_STA_UPD_DIS_256Q BIT(29)
#define FWCMD_H2C_MU_STA_UPD_DIS_1024Q BIT(30)
#define FWCMD_H2C_FWROLE_MAINTAIN_MACID_SH 0
#define FWCMD_H2C_FWROLE_MAINTAIN_MACID_MSK 0xff
#define FWCMD_H2C_FWROLE_MAINTAIN_SELF_ROLE_SH 8
#define FWCMD_H2C_FWROLE_MAINTAIN_SELF_ROLE_MSK 0x3
#define FWCMD_H2C_FWROLE_MAINTAIN_UPD_MODE_SH 10
#define FWCMD_H2C_FWROLE_MAINTAIN_UPD_MODE_MSK 0x7
#define FWCMD_H2C_FWROLE_MAINTAIN_WIFI_ROLE_SH 13
#define FWCMD_H2C_FWROLE_MAINTAIN_WIFI_ROLE_MSK 0xf
#define FWCMD_H2C_DUMP_EFUSE_DUMP_SIZE_SH 0
#define FWCMD_H2C_DUMP_EFUSE_DUMP_SIZE_MSK 0x7ff
#define FWCMD_H2C_DUMP_EFUSE_IS_HIDDEN BIT(11)
#define FWCMD_H2C_PACKET_OFLD_PKT_IDX_SH 0
#define FWCMD_H2C_PACKET_OFLD_PKT_IDX_MSK 0xff
#define FWCMD_H2C_PACKET_OFLD_PKT_OP_SH 8
#define FWCMD_H2C_PACKET_OFLD_PKT_OP_MSK 0x7
#define FWCMD_H2C_PACKET_OFLD_PKT_LENGTH_SH 16
#define FWCMD_H2C_PACKET_OFLD_PKT_LENGTH_MSK 0xffff
#define FWCMD_H2C_PACKET_OFLD_PKT_START_SH 0
#define FWCMD_H2C_PACKET_OFLD_PKT_START_MSK 0xffffffff
#define FWCMD_H2C_READ_OFLD_VALUE_LEN_SH 0
#define FWCMD_H2C_READ_OFLD_VALUE_LEN_MSK 0x7ff
#define FWCMD_H2C_READ_OFLD_LS BIT(15)
#define FWCMD_H2C_READ_OFLD_OFLD_ID_SH 16
#define FWCMD_H2C_READ_OFLD_OFLD_ID_MSK 0xff
#define FWCMD_H2C_READ_OFLD_ENTRY_NUM_SH 24
#define FWCMD_H2C_READ_OFLD_ENTRY_NUM_MSK 0xff
#define FWCMD_H2C_READ_OFLD_OFFSET_SH 0
#define FWCMD_H2C_READ_OFLD_OFFSET_MSK 0xffff
#define FWCMD_H2C_WRITE_OFLD_VALUE_LEN_SH 0
#define FWCMD_H2C_WRITE_OFLD_VALUE_LEN_MSK 0x7ff
#define FWCMD_H2C_WRITE_OFLD_POLLING BIT(13)
#define FWCMD_H2C_WRITE_OFLD_MASK_EN BIT(14)
#define FWCMD_H2C_WRITE_OFLD_LS BIT(15)
#define FWCMD_H2C_WRITE_OFLD_OFLD_ID_SH 16
#define FWCMD_H2C_WRITE_OFLD_OFLD_ID_MSK 0xff
#define FWCMD_H2C_WRITE_OFLD_ENTRY_NUM_SH 24
#define FWCMD_H2C_WRITE_OFLD_ENTRY_NUM_MSK 0xff
#define FWCMD_H2C_WRITE_OFLD_OFFSET_SH 0
#define FWCMD_H2C_WRITE_OFLD_OFFSET_MSK 0xffff
#define FWCMD_H2C_WRITE_OFLD_START_SH 0
#define FWCMD_H2C_WRITE_OFLD_START_MSK 0xffffffff
#define FWCMD_H2C_CONF_OFLD_PATTERN_COUNT_SH 0
#define FWCMD_H2C_CONF_OFLD_PATTERN_COUNT_MSK 0xffff
#define FWCMD_H2C_CONF_OFLD_START_SH 0
#define FWCMD_H2C_CONF_OFLD_START_MSK 0xffffffff
#define FWCMD_H2C_TRX_INIT_TRX_MODE_SH 0
#define FWCMD_H2C_TRX_INIT_TRX_MODE_MSK 0xff
#define FWCMD_H2C_TRX_INIT_QTA_MODE_SH 8
#define FWCMD_H2C_TRX_INIT_QTA_MODE_MSK 0x1ff
#define FWCMD_H2C_INTF_INIT_TXBD_TRUNC_MODE BIT(0)
#define FWCMD_H2C_INTF_INIT_RXBD_TRUNC_MODE BIT(1)
#define FWCMD_H2C_INTF_INIT_RXBD_MODE BIT(2)
#define FWCMD_H2C_INTF_INIT_TAG_MODE BIT(3)
#define FWCMD_H2C_INTF_INIT_TX_BURST_MODE_SH 4
#define FWCMD_H2C_INTF_INIT_TX_BURST_MODE_MSK 0xf
#define FWCMD_H2C_INTF_INIT_RX_BURST_MODE_SH 8
#define FWCMD_H2C_INTF_INIT_RX_BURST_MODE_MSK 0xf
#define FWCMD_H2C_INTF_INIT_WD_DMA_IDLE_INTVL_SH 12
#define FWCMD_H2C_INTF_INIT_WD_DMA_IDLE_INTVL_MSK 0xf
#define FWCMD_H2C_INTF_INIT_WD_DMA_ACT_INTVL_SH 16
#define FWCMD_H2C_INTF_INIT_WD_DMA_ACT_INTVL_MSK 0xf
#define FWCMD_H2C_INTF_INIT_SKIP_ALL_SH 24
#define FWCMD_H2C_INTF_INIT_SKIP_ALL_MSK 0xff
#define FWCMD_H2C_INTF_INIT_RX_SEP_APPEND_LEN_SH 0
#define FWCMD_H2C_INTF_INIT_RX_SEP_APPEND_LEN_MSK 0xffff
#define FWCMD_H2C_INTF_INIT_TXBD_BUF_SH 16
#define FWCMD_H2C_INTF_INIT_TXBD_BUF_MSK 0xff
#define FWCMD_H2C_INTF_INIT_RXBD_BUF_SH 24
#define FWCMD_H2C_INTF_INIT_RXBD_BUF_MSK 0xff
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_1_SH 0
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_1_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_2_SH 0
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_2_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_3_SH 0
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_3_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_4_SH 0
#define FWCMD_H2C_MACID_PAUSE_PAUSE_GRP_4_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_1_SH 0
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_1_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_2_SH 0
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_2_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_3_SH 0
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_3_MSK 0xffffffff
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_4_SH 0
#define FWCMD_H2C_MACID_PAUSE_MASK_GRP_4_MSK 0xffffffff
#define FWCMD_H2C_RX_FWD_TYPE_SH 0
#define FWCMD_H2C_RX_FWD_TYPE_MSK 0xff
#define FWCMD_H2C_RX_FWD_FRAME_SH 8
#define FWCMD_H2C_RX_FWD_FRAME_MSK 0xff
#define FWCMD_H2C_RX_FWD_FWD_TG_SH 16
#define FWCMD_H2C_RX_FWD_FWD_TG_MSK 0xff
#define FWCMD_H2C_RX_FWD_AF_UD_INDEX_SH 0
#define FWCMD_H2C_RX_FWD_AF_UD_INDEX_MSK 0xff
#define FWCMD_H2C_RX_FWD_AF_UD_FWD_TG_SH 8
#define FWCMD_H2C_RX_FWD_AF_UD_FWD_TG_MSK 0xff
#define FWCMD_H2C_RX_FWD_AF_UD_CATEGORY_SH 16
#define FWCMD_H2C_RX_FWD_AF_UD_CATEGORY_MSK 0xff
#define FWCMD_H2C_RX_FWD_AF_UD_ACTION_FIELD_SH 24
#define FWCMD_H2C_RX_FWD_AF_UD_ACTION_FIELD_MSK 0xff
#define FWCMD_H2C_RX_FWD_PM_CAM_VALID BIT(0)
#define FWCMD_H2C_RX_FWD_PM_CAM_TYPE_SH 1
#define FWCMD_H2C_RX_FWD_PM_CAM_TYPE_MSK 0x3
#define FWCMD_H2C_RX_FWD_PM_CAM_SUBTYPE_SH 3
#define FWCMD_H2C_RX_FWD_PM_CAM_SUBTYPE_MSK 0xf
#define FWCMD_H2C_RX_FWD_PM_CAM_SKIP_MAC_IV_HDR BIT(7)
#define FWCMD_H2C_RX_FWD_PM_CAM_TARGET_IND_SH 8
#define FWCMD_H2C_RX_FWD_PM_CAM_TARGET_IND_MSK 0x7
#define FWCMD_H2C_RX_FWD_PM_CAM_INDEX_SH 12
#define FWCMD_H2C_RX_FWD_PM_CAM_INDEX_MSK 0xf
#define FWCMD_H2C_RX_FWD_PM_CAM_CRC16_SH 16
#define FWCMD_H2C_RX_FWD_PM_CAM_CRC16_MSK 0xffff
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK0_SH 0
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK0_MSK 0xffffffff
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK1_SH 0
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK1_MSK 0xffffffff
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK2_SH 0
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK2_MSK 0xffffffff
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK3_SH 0
#define FWCMD_H2C_RX_FWD_PM_CAM_PLD_MASK3_MSK 0xffffffff
#define FWCMD_H2C_EN_MAC_HDR_CONV_ENABLE BIT(0)
#define FWCMD_H2C_SET_HWSEQ_REG_REG_IDX_SH 0
#define FWCMD_H2C_SET_HWSEQ_REG_REG_IDX_MSK 0x3
#define FWCMD_H2C_SET_HWSEQ_REG_SEQ_VAL_SH 2
#define FWCMD_H2C_SET_HWSEQ_REG_SEQ_VAL_MSK 0xfff
#define FWCMD_H2C_HWAMSDU_REG_ENABLE BIT(0)
#define FWCMD_H2C_HWAMSDU_REG_MAX_AMSDU_SUBFRAME_NUMBER_SH 1
#define FWCMD_H2C_HWAMSDU_REG_MAX_AMSDU_SUBFRAME_NUMBER_MSK 0x3
#define FWCMD_H2C_HWAMSDU_REG_ENABLE_SINGLE_AMSDU BIT(3)
#define FWCMD_H2C_HWAMSDU_REG_ENABLE_LAST_AMSDU_PADDING BIT(4)
#define FWCMD_H2C_AMSDU_CUT_REG_ENABLE BIT(0)
#define FWCMD_H2C_AMSDU_CUT_REG_LOW_THRESHOLD_SH 1
#define FWCMD_H2C_AMSDU_CUT_REG_LOW_THRESHOLD_MSK 0x1ff
#define FWCMD_H2C_AMSDU_CUT_REG_HIGH_THRESHOLD_SH 10
#define FWCMD_H2C_AMSDU_CUT_REG_HIGH_THRESHOLD_MSK 0xffff
#define FWCMD_H2C_AMSDU_CUT_REG_EXTRA_SHIFT_SH 26
#define FWCMD_H2C_AMSDU_CUT_REG_EXTRA_SHIFT_MSK 0x3
#define FWCMD_H2C_TCPIP_CHKSUM_OFFLOAD_REG_ENABLE_TX_TCPIP_CHECKSUM_OFFLOAD BIT(0)
#define FWCMD_H2C_TCPIP_CHKSUM_OFFLOAD_REG_ENABLE_RX_TCPIP_CHECKSUM_OFFLOAD BIT(1)
#define FWCMD_H2C_USR_EDCA_PARAM_SEL_SH 0
#define FWCMD_H2C_USR_EDCA_PARAM_SEL_MSK 0x3
#define FWCMD_H2C_USR_EDCA_ENABLE BIT(2)
#define FWCMD_H2C_USR_EDCA_BAND BIT(3)
#define FWCMD_H2C_USR_EDCA_WMM BIT(4)
#define FWCMD_H2C_USR_EDCA_AC_SH 5
#define FWCMD_H2C_USR_EDCA_AC_MSK 0x3
#define FWCMD_H2C_USR_EDCA_AGGRESSIVE_SH 0
#define FWCMD_H2C_USR_EDCA_AGGRESSIVE_MSK 0xffffffff
#define FWCMD_H2C_USR_EDCA_MODERATE_SH 0
#define FWCMD_H2C_USR_EDCA_MODERATE_MSK 0xffffffff
#define FWCMD_H2C_TSF32_TOGL_BAND BIT(0)
#define FWCMD_H2C_TSF32_TOGL_EN BIT(1)
#define FWCMD_H2C_TSF32_TOGL_PORT_SH 2
#define FWCMD_H2C_TSF32_TOGL_PORT_MSK 0x7
#define FWCMD_H2C_TSF32_TOGL_EARLY_SH 16
#define FWCMD_H2C_TSF32_TOGL_EARLY_MSK 0xffff
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D0_SH 0
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D0_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D1_SH 0
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D1_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D2_SH 0
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D2_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D3_SH 0
#define FWCMD_H2C_CMD_OFLD_REG_CMD_OFLD_D3_MSK 0xffffffff
#define FWCMD_H2C_USR_TX_RPT_MODE_SH 0
#define FWCMD_H2C_USR_TX_RPT_MODE_MSK 0x7
#define FWCMD_H2C_USR_TX_RPT_RTP_START BIT(3)
#define FWCMD_H2C_USR_TX_RPT_MACID_SH 0
#define FWCMD_H2C_USR_TX_RPT_MACID_MSK 0xff
#define FWCMD_H2C_USR_TX_RPT_AC_SH 8
#define FWCMD_H2C_USR_TX_RPT_AC_MSK 0x3
#define FWCMD_H2C_USR_TX_RPT_BAND BIT(10)
#define FWCMD_H2C_USR_TX_RPT_PORT_SH 11
#define FWCMD_H2C_USR_TX_RPT_PORT_MSK 0x7
#define FWCMD_H2C_USR_TX_RPT_RPT_PERIOD_SH 0
#define FWCMD_H2C_USR_TX_RPT_RPT_PERIOD_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D0_SH 0
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D0_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D1_SH 0
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D1_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D2_SH 0
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D2_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D3_SH 0
#define FWCMD_H2C_CMD_OFLD_PKT_CMD_OFLD_D3_MSK 0xffffffff
#define FWCMD_H2C_OFLD_CFG_MODE_SH 0
#define FWCMD_H2C_OFLD_CFG_MODE_MSK 0x7
#define FWCMD_H2C_OFLD_CFG_USR_TXOP_BE BIT(3)
#define FWCMD_H2C_OFLD_CFG_USR_TXOP_BE_VAL_SH 0
#define FWCMD_H2C_OFLD_CFG_USR_TXOP_BE_VAL_MSK 0xffff
#define FWCMD_H2C_SECCAM_INFO_IDX_SH 0
#define FWCMD_H2C_SECCAM_INFO_IDX_MSK 0xff
#define FWCMD_H2C_SECCAM_INFO_OFFSET_SH 8
#define FWCMD_H2C_SECCAM_INFO_OFFSET_MSK 0xff
#define FWCMD_H2C_SECCAM_INFO_LEN_SH 16
#define FWCMD_H2C_SECCAM_INFO_LEN_MSK 0xff
#define FWCMD_H2C_SECCAM_INFO_TYPE_SH 0
#define FWCMD_H2C_SECCAM_INFO_TYPE_MSK 0xf
#define FWCMD_H2C_SECCAM_INFO_EXT_KEY BIT(4)
#define FWCMD_H2C_SECCAM_INFO_SPP_MODE BIT(5)
#define FWCMD_H2C_SECCAM_INFO_KEY_0_SH 0
#define FWCMD_H2C_SECCAM_INFO_KEY_0_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_KEY_1_SH 0
#define FWCMD_H2C_SECCAM_INFO_KEY_1_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_KEY_2_SH 0
#define FWCMD_H2C_SECCAM_INFO_KEY_2_MSK 0xffffffff
#define FWCMD_H2C_SECCAM_INFO_KEY_3_SH 0
#define FWCMD_H2C_SECCAM_INFO_KEY_3_MSK 0xffffffff
#define FWCMD_H2C_H2C_AGG_PLD_SH 0
#define FWCMD_H2C_H2C_AGG_PLD_MSK 0xffffffffL
#define FWCMD_H2C_SET_SND_PARA_FREXCH_TYPE_SH 0
#define FWCMD_H2C_SET_SND_PARA_FREXCH_TYPE_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_MODE_SH 6
#define FWCMD_H2C_SET_SND_PARA_MODE_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_USER_NUM_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_USER_NUM_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_USER_NUM_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_USER_NUM_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_MACID0_SH 0
#define FWCMD_H2C_SET_SND_PARA_MACID0_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_MACID1_SH 8
#define FWCMD_H2C_SET_SND_PARA_MACID1_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_MACID2_SH 16
#define FWCMD_H2C_SET_SND_PARA_MACID2_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_MACID3_SH 24
#define FWCMD_H2C_SET_SND_PARA_MACID3_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_MACID4_SH 0
#define FWCMD_H2C_SET_SND_PARA_MACID4_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_MACID5_SH 8
#define FWCMD_H2C_SET_SND_PARA_MACID5_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_MACID6_SH 16
#define FWCMD_H2C_SET_SND_PARA_MACID6_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_MACID7_SH 24
#define FWCMD_H2C_SET_SND_PARA_MACID7_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_NDPA_FRAME_CTRL_SH 0
#define FWCMD_H2C_SET_SND_PARA_NDPA_FRAME_CTRL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_NDPA_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_NDPA_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_NDPA_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_NDPA_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_NDPA_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_NDPA_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_NDPA_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_NDPA_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_NDPA_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_NDPA_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_NDPA_SND_DLG_HE BIT(0)
#define FWCMD_H2C_SET_SND_PARA_NDPA_SND_DLG_DIALOG_SH 1
#define FWCMD_H2C_SET_SND_PARA_NDPA_SND_DLG_DIALOG_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HT_NDPA_A3_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_HT_NDPA_A3_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_HT_NDPA_A3_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_HT_NDPA_A3_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_HT_SEQ_CONTROL_SH 16
#define FWCMD_H2C_SET_SND_PARA_HT_SEQ_CONTROL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_VHT_STA0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_VHT_STA0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_VHT_STA0_FEEDBACK_TYPE BIT(12)
#define FWCMD_H2C_SET_SND_PARA_VHT_STA0_NC_SH 13
#define FWCMD_H2C_SET_SND_PARA_VHT_STA0_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_VHT_STA1_AID12_SH 16
#define FWCMD_H2C_SET_SND_PARA_VHT_STA1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_VHT_STA1_FEEDBACK_TYPE BIT(28)
#define FWCMD_H2C_SET_SND_PARA_VHT_STA1_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_VHT_STA1_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_VHT_STA2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_VHT_STA2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_VHT_STA2_FEEDBACK_TYPE BIT(12)
#define FWCMD_H2C_SET_SND_PARA_VHT_STA2_NC_SH 13
#define FWCMD_H2C_SET_SND_PARA_VHT_STA2_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_VHT_STA3_AID12_SH 16
#define FWCMD_H2C_SET_SND_PARA_VHT_STA3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_VHT_STA3_FEEDBACK_TYPE BIT(28)
#define FWCMD_H2C_SET_SND_PARA_VHT_STA3_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_VHT_STA3_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA0_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA1_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA2_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA3_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA4_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA5_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA6_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_HE_STA7_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_BFRP0_FRAME_CTL_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP0_FRAME_CTL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP0_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_BFRP0_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP0_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_BFRP1_FRAME_CTL_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP1_FRAME_CTL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP1_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_BFRP1_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP1_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_BFRP2_FRAME_CTL_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP2_FRAME_CTL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP2_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_BFRP2_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_BFRP2_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_TRIGGER_INFO_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_TRIGGER_INFO_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_LENGTH_SH 4
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_LENGTH_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_MORE_TF BIT(16)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_CS_REQUIRED BIT(17)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_BW_SH 18
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_BW_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_GI_LTF_SH 20
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_GI_LTF_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_MU_MIMO_LTF_MODE BIT(22)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_NUM_OF_HE_LTF_SH 23
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_NUM_OF_HE_LTF_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_PKTEXT_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_PKTEXT_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_STBC BIT(29)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_LDPC_EXTRA_SYMBOL BIT(30)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_DOPPLER BIT(31)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_AP_TX_POWER_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_AP_TX_POWER_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_SPATIAL_REUSE_SH 6
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_UL_SPATIAL_REUSE_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U0_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U1_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U2_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP0_U3_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_TRIGGER_INFO_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_TRIGGER_INFO_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_LENGTH_SH 4
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_LENGTH_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_MORE_TF BIT(16)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_CS_REQUIRED BIT(17)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_BW_SH 18
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_BW_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_GI_LTF_SH 20
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_GI_LTF_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_MU_MIMO_LTF_MODE BIT(22)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_NUM_OF_HE_LTF_SH 23
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_NUM_OF_HE_LTF_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_PKTEXT_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_PKTEXT_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_STBC BIT(29)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_LDPC_EXTRA_SYMBOL BIT(30)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_DOPPLER BIT(31)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_AP_TX_POWER_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_AP_TX_POWER_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_SPATIAL_REUSE_SH 6
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_UL_SPATIAL_REUSE_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U0_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U1_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U2_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_HE_BFRP1_U3_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_VHT_BFRP0_FB_REXMIT_SH 0
#define FWCMD_H2C_SET_SND_PARA_VHT_BFRP0_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_VHT_BFRP1_FB_REXMIT_SH 8
#define FWCMD_H2C_SET_SND_PARA_VHT_BFRP1_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_VHT_BFRP2_FB_REXMIT_SH 16
#define FWCMD_H2C_SET_SND_PARA_VHT_BFRP2_FB_REXMIT_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD0_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD0_SH 16
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD0_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD0_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD0_SH 9
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD0_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_WD_FORCE_TXOP_WD0 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD0_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD0_SH 19
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_ER_WD0 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_DCM_WD0 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_STBC_WD0 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_LDPC_WD0 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_ER_WD0 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_WD_MULTIPORT_ID_WD0 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD0_SH 28
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD0_SH 4
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD0_SH 8
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD0_SH 11
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_STF_MODE_WD0 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_WD_DISDATAFB_WD0 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_SEL_WD0 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD0_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD0_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_WD_SIFS_TX_WD0 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD0_SH 24
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD0_SH 27
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD1_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD1_SH 16
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD1_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD1_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD1_SH 9
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD1_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_WD_FORCE_TXOP_WD1 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD1_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD1_SH 19
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_ER_WD1 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_DCM_WD1 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_STBC_WD1 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_LDPC_WD1 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_ER_WD1 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_WD_MULTIPORT_ID_WD1 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD1_SH 28
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD1_SH 4
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD1_SH 8
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD1_SH 11
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_STF_MODE_WD1 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_WD_DISDATAFB_WD1 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_SEL_WD1 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD1_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD1_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_WD_SIFS_TX_WD1 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD1_SH 24
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD1_SH 27
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD2_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD2_SH 16
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD2_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD2_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD2_SH 9
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD2_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_WD_FORCE_TXOP_WD2 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD2_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD2_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD2_SH 19
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_ER_WD2 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_DCM_WD2 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_STBC_WD2 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_LDPC_WD2 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_ER_WD2 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_WD_MULTIPORT_ID_WD2 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD2_SH 28
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD2_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD2_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD2_SH 4
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD2_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD2_SH 8
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD2_SH 11
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_STF_MODE_WD2 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_WD_DISDATAFB_WD2 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_SEL_WD2 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD2_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD2_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_WD_SIFS_TX_WD2 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD2_SH 24
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD2_SH 27
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD2_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD3_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD3_SH 16
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD3_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD3_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD3_SH 9
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD3_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_WD_FORCE_TXOP_WD3 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD3_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD3_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD3_SH 19
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_ER_WD3 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_DCM_WD3 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_STBC_WD3 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_LDPC_WD3 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_ER_WD3 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_WD_MULTIPORT_ID_WD3 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD3_SH 28
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD3_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD3_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD3_SH 4
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD3_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD3_SH 8
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD3_SH 11
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_STF_MODE_WD3 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_WD_DISDATAFB_WD3 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_SEL_WD3 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD3_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD3_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_WD_SIFS_TX_WD3 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD3_SH 24
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD3_SH 27
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD3_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_TXPKTSIZE_WD4_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD4_SH 16
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_DURATION_WD4_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_DATARATE_WD4_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD4_SH 9
#define FWCMD_H2C_SET_SND_PARA_WD_MACID_WD4_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_WD_FORCE_TXOP_WD4 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD4_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_WD4_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD4_SH 19
#define FWCMD_H2C_SET_SND_PARA_WD_GI_LTF_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_ER_WD4 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_DCM_WD4 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_STBC_WD4 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_LDPC_WD4 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_BW_ER_WD4 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_WD_MULTIPORT_ID_WD4 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD4_SH 28
#define FWCMD_H2C_SET_SND_PARA_WD_MBSSID_WD4_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_WD_SIGNALING_TA_PKT_SC_WD4_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD4_SH 4
#define FWCMD_H2C_SET_SND_PARA_WD_SW_DEFINE_WD4_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD4_SH 8
#define FWCMD_H2C_SET_SND_PARA_WD_TXPWR_OFSET_TYPE_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD4_SH 11
#define FWCMD_H2C_SET_SND_PARA_WD_LIFETIME_SEL_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_STF_MODE_WD4 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_WD_DISDATAFB_WD4 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_SEL_WD4 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD4_SH 17
#define FWCMD_H2C_SET_SND_PARA_WD_DATA_TXCNT_LMT_WD4_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_WD_SIFS_TX_WD4 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD4_SH 24
#define FWCMD_H2C_SET_SND_PARA_WD_SND_PKT_SEL_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD4_SH 27
#define FWCMD_H2C_SET_SND_PARA_WD_NDPA_WD4_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_CSI_LEN_BFRP0_SH 0
#define FWCMD_H2C_SET_SND_PARA_CSI_LEN_BFRP0_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_TB_T_PE_BFRP0_SH 12
#define FWCMD_H2C_SET_SND_PARA_TB_T_PE_BFRP0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_TRI_PAD_BFRP0_SH 14
#define FWCMD_H2C_SET_SND_PARA_TRI_PAD_BFRP0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_UL_CQI_RPT_TRI_BFRP0 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_RF_GAIN_IDX_BFRP0_SH 17
#define FWCMD_H2C_SET_SND_PARA_RF_GAIN_IDX_BFRP0_MSK 0x3ff
#define FWCMD_H2C_SET_SND_PARA_FIX_GAIN_EN_BFRP0 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_CSI_LEN_BFRP1_SH 0
#define FWCMD_H2C_SET_SND_PARA_CSI_LEN_BFRP1_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_TB_T_PE_BFRP1_SH 12
#define FWCMD_H2C_SET_SND_PARA_TB_T_PE_BFRP1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_TRI_PAD_BFRP1_SH 14
#define FWCMD_H2C_SET_SND_PARA_TRI_PAD_BFRP1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_UL_CQI_RPT_TRI_BFRP1 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_RF_GAIN_IDX_BFRP1_SH 17
#define FWCMD_H2C_SET_SND_PARA_RF_GAIN_IDX_BFRP1_MSK 0x3ff
#define FWCMD_H2C_SET_SND_PARA_FIX_GAIN_EN_BFRP1 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_F2P_TYPE_SH 0
#define FWCMD_H2C_SET_SND_PARA_F2P_TYPE_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_INDEX_SH 8
#define FWCMD_H2C_SET_SND_PARA_F2P_INDEX_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_PERIOD_SH 16
#define FWCMD_H2C_SET_SND_PARA_F2P_PERIOD_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX0_SH 0
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX0_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX1_SH 8
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX1_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX2_SH 16
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX2_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX3_SH 24
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX3_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX4_SH 0
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX4_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX5_SH 8
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX5_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX6_SH 16
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX6_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX7_SH 24
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX7_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX8_SH 0
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX8_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX9_SH 8
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX9_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX10_SH 16
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX10_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX11_SH 24
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX11_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX12_SH 0
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX12_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX13_SH 8
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX13_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX14_SH 16
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX14_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX15_SH 24
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX15_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX16_SH 0
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX16_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX17_SH 8
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX17_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX18_SH 16
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX18_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX19_SH 24
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX19_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX20_SH 0
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX20_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX21_SH 8
#define FWCMD_H2C_SET_SND_PARA_F2P_IDX21_MSK 0xff
#define FWCMD_H2C_GET_CSI_BUF_BAND_SH 0
#define FWCMD_H2C_GET_CSI_BUF_BAND_MSK 0xff
#define FWCMD_H2C_GET_CSI_BUF_CSI_BUF_ID_SH 8
#define FWCMD_H2C_GET_CSI_BUF_CSI_BUF_ID_MSK 0xff
#define FWCMD_H2C_SET_CSI_BUF_BAND_SH 0
#define FWCMD_H2C_SET_CSI_BUF_BAND_MSK 0xff
#define FWCMD_H2C_SET_CSI_BUF_MACID_SH 8
#define FWCMD_H2C_SET_CSI_BUF_MACID_MSK 0xff
#define FWCMD_H2C_SET_CSI_BUF_CSI_BUF_ID_SH 16
#define FWCMD_H2C_SET_CSI_BUF_CSI_BUF_ID_MSK 0xffff
#define FWCMD_H2C_SET_CSI_BUF_BUF_IDX_SH 0
#define FWCMD_H2C_SET_CSI_BUF_BUF_IDX_MSK 0xffff
#define FWCMD_H2C_GET_SND_STS_BAND_SH 0
#define FWCMD_H2C_GET_SND_STS_BAND_MSK 0xff
#define FWCMD_H2C_GET_SND_STS_INDEX_SH 8
#define FWCMD_H2C_GET_SND_STS_INDEX_MSK 0xff
#define FWCMD_H2C_SET_SND_STS_BAND_SH 0
#define FWCMD_H2C_SET_SND_STS_BAND_MSK 0xff
#define FWCMD_H2C_SET_SND_STS_MACID_SH 8
#define FWCMD_H2C_SET_SND_STS_MACID_MSK 0xff
#define FWCMD_H2C_SET_SND_STS_INDEX_SH 16
#define FWCMD_H2C_SET_SND_STS_INDEX_MSK 0xff
#define FWCMD_H2C_INIT_SND_MER_BAND_SH 0
#define FWCMD_H2C_INIT_SND_MER_BAND_MSK 0xff
#define FWCMD_H2C_INIT_SND_MEE_BAND_SH 0
#define FWCMD_H2C_INIT_SND_MEE_BAND_MSK 0xff
#define FWCMD_H2C_CSI_FIX_RATE_BAND_SH 0
#define FWCMD_H2C_CSI_FIX_RATE_BAND_MSK 0xff
#define FWCMD_H2C_CSI_FIX_RATE_HT_RATE_SH 8
#define FWCMD_H2C_CSI_FIX_RATE_HT_RATE_MSK 0xff
#define FWCMD_H2C_CSI_FIX_RATE_VHT_RATE_SH 16
#define FWCMD_H2C_CSI_FIX_RATE_VHT_RATE_MSK 0xff
#define FWCMD_H2C_CSI_FIX_RATE_HE_RATE_SH 24
#define FWCMD_H2C_CSI_FIX_RATE_HE_RATE_MSK 0xff
#define FWCMD_H2C_CSI_RRSC_BAND_SH 0
#define FWCMD_H2C_CSI_RRSC_BAND_MSK 0xff
#define FWCMD_H2C_CSI_RRSC_RRSC_SH 0
#define FWCMD_H2C_CSI_RRSC_RRSC_MSK 0xffffffff
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_CTRL_SH 0
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_CTRL_MSK 0xffffffff
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_0_SH 0
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_0_MSK 0xffffffff
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_1_SH 0
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_1_MSK 0xffffffff
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_2_SH 0
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_2_MSK 0xffffffff
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_3_SH 0
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_3_MSK 0xffffffff
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_4_SH 0
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_4_MSK 0xffffffff
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_5_SH 0
#define FWCMD_H2C_SET_MU_TABLE_MU_TBL_5_MSK 0xffffffff
#define FWCMD_H2C_SET_CSI_PARA_REG_BAND BIT(0)
#define FWCMD_H2C_SET_CSI_PARA_REG_PORT_SEL BIT(1)
#define FWCMD_H2C_SET_CSI_PARA_REG_NC_SH 2
#define FWCMD_H2C_SET_CSI_PARA_REG_NC_MSK 0x7
#define FWCMD_H2C_SET_CSI_PARA_REG_NR_SH 5
#define FWCMD_H2C_SET_CSI_PARA_REG_NR_MSK 0x7
#define FWCMD_H2C_SET_CSI_PARA_REG_NG_SH 8
#define FWCMD_H2C_SET_CSI_PARA_REG_NG_MSK 0x3
#define FWCMD_H2C_SET_CSI_PARA_REG_CB_SH 10
#define FWCMD_H2C_SET_CSI_PARA_REG_CB_MSK 0x3
#define FWCMD_H2C_SET_CSI_PARA_REG_CS_SH 12
#define FWCMD_H2C_SET_CSI_PARA_REG_CS_MSK 0x3
#define FWCMD_H2C_SET_CSI_PARA_REG_LDPC_EN BIT(14)
#define FWCMD_H2C_SET_CSI_PARA_REG_STBC_EN BIT(15)
#define FWCMD_H2C_SET_CSI_PARA_REG_BF_EN BIT(16)
#define FWCMD_H2C_HW_SND_PR_BAND_SH 0
#define FWCMD_H2C_HW_SND_PR_BAND_MSK 0xff
#define FWCMD_H2C_HW_SND_PR_PR_SH 8
#define FWCMD_H2C_HW_SND_PR_PR_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_FREXCH_TYPE_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_FREXCH_TYPE_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_MODE_SH 6
#define FWCMD_H2C_SET_SND_PARA_V1_MODE_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_USER_NUM_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_USER_NUM_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_USER_NUM_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_USER_NUM_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_MACID0_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID1_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_MACID1_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID2_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_MACID2_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID3_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_MACID3_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_MACID4_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID5_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_MACID5_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID6_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_MACID6_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID7_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_MACID7_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID8_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_MACID8_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID9_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_MACID9_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID10_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_MACID10_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID11_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_MACID11_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_MACID12_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID13_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_MACID13_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID14_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_MACID14_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_MACID15_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_MACID15_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_FRAME_CTRL_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_FRAME_CTRL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_SND_DLG_HE BIT(0)
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_SND_DLG_DIALOG_SH 1
#define FWCMD_H2C_SET_SND_PARA_V1_NDPA_SND_DLG_DIALOG_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HT_NDPA_A3_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HT_NDPA_A3_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_HT_NDPA_A3_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HT_NDPA_A3_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_HT_SEQ_CONTROL_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_HT_SEQ_CONTROL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA0_FEEDBACK_TYPE BIT(12)
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA0_NC_SH 13
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA0_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA1_AID12_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA1_FEEDBACK_TYPE BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA1_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA1_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA2_FEEDBACK_TYPE BIT(12)
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA2_NC_SH 13
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA2_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA3_AID12_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA3_FEEDBACK_TYPE BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA3_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_STA3_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA0_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA1_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA2_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA3_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA4_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA5_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA6_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA7_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA8_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA9_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA10_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA11_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA12_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA13_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA14_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_AID11_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_AID11_MSK 0x7ff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_BW_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_BW_MSK 0x3fff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_FB_NG_SH 25
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_FB_NG_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_DISAMBIGUATION BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_CB BIT(28)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_NC_SH 29
#define FWCMD_H2C_SET_SND_PARA_V1_HE_STA15_NC_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_FRAME_CTL_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_FRAME_CTL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP0_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_FRAME_CTL_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_FRAME_CTL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP1_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_FRAME_CTL_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_FRAME_CTL_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_DURATION_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_DURATION_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A1_L_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A1_L_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A1_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A1_H_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A2_L_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A2_L_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A2_H_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_BFRP2_A2_H_MSK 0xffffffff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_TRIGGER_INFO_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_TRIGGER_INFO_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_LENGTH_SH 4
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_LENGTH_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_MORE_TF BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_CS_REQUIRED BIT(17)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_BW_SH 18
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_BW_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_GI_LTF_SH 20
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_GI_LTF_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_MU_MIMO_LTF_MODE BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_NUM_OF_HE_LTF_SH 23
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_NUM_OF_HE_LTF_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_PKTEXT_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_PKTEXT_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_STBC BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_LDPC_EXTRA_SYMBOL BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_DOPPLER BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_AP_TX_POWER_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_AP_TX_POWER_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_SPATIAL_REUSE_SH 6
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_UL_SPATIAL_REUSE_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U0_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U1_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U2_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U3_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U4_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U5_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U6_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP0_U7_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_TRIGGER_INFO_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_TRIGGER_INFO_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_LENGTH_SH 4
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_LENGTH_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_MORE_TF BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_CS_REQUIRED BIT(17)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_BW_SH 18
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_BW_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_GI_LTF_SH 20
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_GI_LTF_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_MU_MIMO_LTF_MODE BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_NUM_OF_HE_LTF_SH 23
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_NUM_OF_HE_LTF_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_PKTEXT_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_PKTEXT_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_STBC BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_LDPC_EXTRA_SYMBOL BIT(30)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_DOPPLER BIT(31)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_AP_TX_POWER_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_AP_TX_POWER_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_SPATIAL_REUSE_SH 6
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_UL_SPATIAL_REUSE_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U0_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U1_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U2_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U3_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U4_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U5_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U6_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_AID12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_AID12_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_RU_POS_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_RU_POS_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_UL_FEC_CODE BIT(20)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_UL_MCS_SH 21
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_UL_MCS_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_UL_DCM BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_SS_ALLOC_SH 26
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_SS_ALLOC_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_UL_TGT_RSSI_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_HE_BFRP1_U7_UL_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_BFRP0_FEEDBACKSEG_REXMIT_BITMAP_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_BFRP0_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_BFRP1_FEEDBACKSEG_REXMIT_BITMAP_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_BFRP1_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_BFRP2_FEEDBACKSEG_REXMIT_BITMAP_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_VHT_BFRP2_FEEDBACKSEG_REXMIT_BITMAP_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD0_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD0_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD0_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD0_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD0_SH 9
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD0_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_FORCE_TXOP_WD0 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD0_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD0_SH 19
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_ER_WD0 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_DCM_WD0 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_STBC_WD0 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_LDPC_WD0 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_ER_WD0 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MULTIPORT_ID_WD0 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD0_SH 28
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD0_SH 4
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD0_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD0_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_STF_MODE_WD0 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DISDATAFB_WD0 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_SEL_WD0 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD0_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD0_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIFS_TX_WD0 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD0_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD0_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD0_SH 27
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_CQI_WD0 BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD1_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD1_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD1_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD1_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD1_SH 9
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD1_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_FORCE_TXOP_WD1 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD1_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD1_SH 19
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_ER_WD1 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_DCM_WD1 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_STBC_WD1 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_LDPC_WD1 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_ER_WD1 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MULTIPORT_ID_WD1 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD1_SH 28
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD1_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD1_SH 4
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD1_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD1_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_STF_MODE_WD1 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DISDATAFB_WD1 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_SEL_WD1 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD1_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD1_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIFS_TX_WD1 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD1_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD1_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD1_SH 27
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_CQI_WD1 BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD2_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD2_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD2_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD2_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD2_SH 9
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD2_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_FORCE_TXOP_WD2 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD2_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD2_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD2_SH 19
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_ER_WD2 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_DCM_WD2 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_STBC_WD2 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_LDPC_WD2 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_ER_WD2 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MULTIPORT_ID_WD2 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD2_SH 28
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD2_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD2_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD2_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD2_SH 4
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD2_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD2_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD2_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_STF_MODE_WD2 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DISDATAFB_WD2 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_SEL_WD2 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD2_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD2_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIFS_TX_WD2 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD2_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD2_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD2_SH 27
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD2_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_CQI_WD2 BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD3_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD3_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD3_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD3_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD3_SH 9
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD3_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_FORCE_TXOP_WD3 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD3_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD3_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD3_SH 19
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_ER_WD3 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_DCM_WD3 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_STBC_WD3 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_LDPC_WD3 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_ER_WD3 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MULTIPORT_ID_WD3 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD3_SH 28
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD3_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD3_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD3_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD3_SH 4
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD3_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD3_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD3_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_STF_MODE_WD3 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DISDATAFB_WD3 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_SEL_WD3 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD3_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD3_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIFS_TX_WD3 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD3_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD3_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD3_SH 27
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD3_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_CQI_WD3 BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPKTSIZE_WD4_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD4_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_DURATION_WD4_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATARATE_WD4_MSK 0x1ff
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD4_SH 9
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MACID_WD4_MSK 0x7f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_FORCE_TXOP_WD4 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD4_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_WD4_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD4_SH 19
#define FWCMD_H2C_SET_SND_PARA_V1_WD_GI_LTF_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_ER_WD4 BIT(22)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_DCM_WD4 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_STBC_WD4 BIT(24)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_LDPC_WD4 BIT(25)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_BW_ER_WD4 BIT(26)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MULTIPORT_ID_WD4 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD4_SH 28
#define FWCMD_H2C_SET_SND_PARA_V1_WD_MBSSID_WD4_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIGNALING_TA_PKT_SC_WD4_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD4_SH 4
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SW_DEFINE_WD4_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD4_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_WD_TXPWR_OFSET_TYPE_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD4_SH 11
#define FWCMD_H2C_SET_SND_PARA_V1_WD_LIFETIME_SEL_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_STF_MODE_WD4 BIT(14)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DISDATAFB_WD4 BIT(15)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_SEL_WD4 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD4_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_WD_DATA_TXCNT_LMT_WD4_MSK 0x3f
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SIFS_TX_WD4 BIT(23)
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD4_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_WD_SND_PKT_SEL_WD4_MSK 0x7
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD4_SH 27
#define FWCMD_H2C_SET_SND_PARA_V1_WD_NDPA_WD4_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_WD_CQI_WD4 BIT(29)
#define FWCMD_H2C_SET_SND_PARA_V1_CSI_LEN_BFRP0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_CSI_LEN_BFRP0_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_TB_T_PE_BFRP0_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_TB_T_PE_BFRP0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_TRI_PAD_BFRP0_SH 14
#define FWCMD_H2C_SET_SND_PARA_V1_TRI_PAD_BFRP0_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_UL_CQI_RPT_TRI_BFRP0 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_RF_GAIN_IDX_BFRP0_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_RF_GAIN_IDX_BFRP0_MSK 0x3ff
#define FWCMD_H2C_SET_SND_PARA_V1_FIX_GAIN_EN_BFRP0 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_UL_LEN_REF_BFRP0_SH 28
#define FWCMD_H2C_SET_SND_PARA_V1_UL_LEN_REF_BFRP0_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_CSI_LEN_BFRP1_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_CSI_LEN_BFRP1_MSK 0xfff
#define FWCMD_H2C_SET_SND_PARA_V1_TB_T_PE_BFRP1_SH 12
#define FWCMD_H2C_SET_SND_PARA_V1_TB_T_PE_BFRP1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_TRI_PAD_BFRP1_SH 14
#define FWCMD_H2C_SET_SND_PARA_V1_TRI_PAD_BFRP1_MSK 0x3
#define FWCMD_H2C_SET_SND_PARA_V1_UL_CQI_RPT_TRI_BFRP1 BIT(16)
#define FWCMD_H2C_SET_SND_PARA_V1_RF_GAIN_IDX_BFRP1_SH 17
#define FWCMD_H2C_SET_SND_PARA_V1_RF_GAIN_IDX_BFRP1_MSK 0x3ff
#define FWCMD_H2C_SET_SND_PARA_V1_FIX_GAIN_EN_BFRP1 BIT(27)
#define FWCMD_H2C_SET_SND_PARA_V1_UL_LEN_REF_BFRP1_SH 28
#define FWCMD_H2C_SET_SND_PARA_V1_UL_LEN_REF_BFRP1_MSK 0xf
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_TYPE_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_TYPE_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_INDEX_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_INDEX_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_PERIOD_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_PERIOD_MSK 0xffff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX0_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX0_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX1_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX1_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX2_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX2_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX3_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX3_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX4_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX4_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX5_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX5_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX6_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX6_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX7_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX7_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX8_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX8_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX9_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX9_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX10_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX10_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX11_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX11_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX12_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX12_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX13_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX13_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX14_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX14_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX15_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX15_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX16_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX16_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX17_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX17_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX18_SH 16
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX18_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX19_SH 24
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX19_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX20_SH 0
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX20_MSK 0xff
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX21_SH 8
#define FWCMD_H2C_SET_SND_PARA_V1_F2P_IDX21_MSK 0xff
#define FWCMD_H2C_BA_CAM_VALID BIT(0)
#define FWCMD_H2C_BA_CAM_INIT_REQ BIT(1)
#define FWCMD_H2C_BA_CAM_ENTRY_IDX_SH 2
#define FWCMD_H2C_BA_CAM_ENTRY_IDX_MSK 0x3
#define FWCMD_H2C_BA_CAM_TID_SH 4
#define FWCMD_H2C_BA_CAM_TID_MSK 0xf
#define FWCMD_H2C_BA_CAM_MACID_SH 8
#define FWCMD_H2C_BA_CAM_MACID_MSK 0xff
#define FWCMD_H2C_BA_CAM_BMAP_SIZE_SH 16
#define FWCMD_H2C_BA_CAM_BMAP_SIZE_MSK 0xf
#define FWCMD_H2C_BA_CAM_SSN_SH 20
#define FWCMD_H2C_BA_CAM_SSN_MSK 0xfff
#define FWCMD_H2C_BA_CAM_UID_VALUE_SH 0
#define FWCMD_H2C_BA_CAM_UID_VALUE_MSK 0xff
#define FWCMD_H2C_BA_CAM_STD_ENTRY_EN BIT(8)
#define FWCMD_H2C_BA_CAM_BAND_SEL BIT(9)
#define FWCMD_H2C_BA_CAM_ENTRY_IDX_V1_SH 28
#define FWCMD_H2C_BA_CAM_ENTRY_IDX_V1_MSK 0xf
#define FWCMD_H2C_IE_CAM_BAND BIT(0)
#define FWCMD_H2C_IE_CAM_PORT_SH 1
#define FWCMD_H2C_IE_CAM_PORT_MSK 0x7
#define FWCMD_H2C_IE_CAM_CAM_EN BIT(4)
#define FWCMD_H2C_IE_CAM_HIT_FRWD_EN BIT(5)
#define FWCMD_H2C_IE_CAM_HIT_FRWD_SH 6
#define FWCMD_H2C_IE_CAM_HIT_FRWD_MSK 0x3
#define FWCMD_H2C_IE_CAM_MISS_FRWD_EN BIT(8)
#define FWCMD_H2C_IE_CAM_MISS_FRWD_SH 9
#define FWCMD_H2C_IE_CAM_MISS_FRWD_MSK 0x3
#define FWCMD_H2C_IE_CAM_UPD_NUM_SH 11
#define FWCMD_H2C_IE_CAM_UPD_NUM_MSK 0x1f
#define FWCMD_H2C_IE_CAM_RST BIT(16)
#define FWCMD_H2C_IE_CAM_IDX_SH 0
#define FWCMD_H2C_IE_CAM_IDX_MSK 0xff
#define FWCMD_H2C_IE_CAM_CAM_INFO0_SH 8
#define FWCMD_H2C_IE_CAM_CAM_INFO0_MSK 0xffffff
#define FWCMD_H2C_IE_CAM_CAM_INFO1_SH 0
#define FWCMD_H2C_IE_CAM_CAM_INFO1_MSK 0xffffffff
#define FWCMD_H2C_ADD_MCC_MACID_SH 0
#define FWCMD_H2C_ADD_MCC_MACID_MSK 0xff
#define FWCMD_H2C_ADD_MCC_CENTRAL_CH_SEG0_SH 8
#define FWCMD_H2C_ADD_MCC_CENTRAL_CH_SEG0_MSK 0xff
#define FWCMD_H2C_ADD_MCC_CENTRAL_CH_SEG1_SH 16
#define FWCMD_H2C_ADD_MCC_CENTRAL_CH_SEG1_MSK 0xff
#define FWCMD_H2C_ADD_MCC_PRIMARY_CH_SH 24
#define FWCMD_H2C_ADD_MCC_PRIMARY_CH_MSK 0xff
#define FWCMD_H2C_ADD_MCC_BANDWIDTH_SH 0
#define FWCMD_H2C_ADD_MCC_BANDWIDTH_MSK 0xf
#define FWCMD_H2C_ADD_MCC_GROUP_SH 4
#define FWCMD_H2C_ADD_MCC_GROUP_MSK 0x3
#define FWCMD_H2C_ADD_MCC_C2H_RPT_SH 6
#define FWCMD_H2C_ADD_MCC_C2H_RPT_MSK 0x3
#define FWCMD_H2C_ADD_MCC_DIS_TX_NULL BIT(8)
#define FWCMD_H2C_ADD_MCC_DIS_SW_RETRY BIT(9)
#define FWCMD_H2C_ADD_MCC_IN_CURR_CH BIT(10)
#define FWCMD_H2C_ADD_MCC_SW_RETRY_COUNT_SH 11
#define FWCMD_H2C_ADD_MCC_SW_RETRY_COUNT_MSK 0x7
#define FWCMD_H2C_ADD_MCC_TX_NULL_EARLY_SH 14
#define FWCMD_H2C_ADD_MCC_TX_NULL_EARLY_MSK 0xf
#define FWCMD_H2C_ADD_MCC_BTC_IN_2G BIT(18)
#define FWCMD_H2C_ADD_MCC_PTA_EN BIT(19)
#define FWCMD_H2C_ADD_MCC_RFK_BY_PASS BIT(20)
#define FWCMD_H2C_ADD_MCC_DURATION_SH 0
#define FWCMD_H2C_ADD_MCC_DURATION_MSK 0xffffffff
#define FWCMD_H2C_ADD_MCC_COURTESY_EN BIT(0)
#define FWCMD_H2C_ADD_MCC_COURTESY_NUM_SH 8
#define FWCMD_H2C_ADD_MCC_COURTESY_NUM_MSK 0xff
#define FWCMD_H2C_ADD_MCC_COURTESY_TARGET_SH 16
#define FWCMD_H2C_ADD_MCC_COURTESY_TARGET_MSK 0xff
#define FWCMD_H2C_START_MCC_GROUP_SH 0
#define FWCMD_H2C_START_MCC_GROUP_MSK 0x3
#define FWCMD_H2C_START_MCC_BTC_IN_GROUP BIT(2)
#define FWCMD_H2C_START_MCC_OLD_GROUP_ACTION_SH 3
#define FWCMD_H2C_START_MCC_OLD_GROUP_ACTION_MSK 0x3
#define FWCMD_H2C_START_MCC_OLD_GROUP_SH 5
#define FWCMD_H2C_START_MCC_OLD_GROUP_MSK 0x3
#define FWCMD_H2C_START_MCC_MACID_SH 24
#define FWCMD_H2C_START_MCC_MACID_MSK 0xff
#define FWCMD_H2C_START_MCC_TSF_LOW_SH 0
#define FWCMD_H2C_START_MCC_TSF_LOW_MSK 0xffffffff
#define FWCMD_H2C_START_MCC_TSF_HIGH_SH 0
#define FWCMD_H2C_START_MCC_TSF_HIGH_MSK 0xffffffff
#define FWCMD_H2C_STOP_MCC_MACID_SH 0
#define FWCMD_H2C_STOP_MCC_MACID_MSK 0xff
#define FWCMD_H2C_STOP_MCC_GROUP_SH 8
#define FWCMD_H2C_STOP_MCC_GROUP_MSK 0x3
#define FWCMD_H2C_STOP_MCC_PREV_GROUPS BIT(10)
#define FWCMD_H2C_DEL_MCC_GROUP_GROUP_SH 0
#define FWCMD_H2C_DEL_MCC_GROUP_GROUP_MSK 0x3
#define FWCMD_H2C_DEL_MCC_GROUP_PREV_GROUPS BIT(2)
#define FWCMD_H2C_RESET_MCC_GROUP_GROUP_SH 0
#define FWCMD_H2C_RESET_MCC_GROUP_GROUP_MSK 0x3
#define FWCMD_H2C_MCC_REQ_TSF_GROUP_SH 0
#define FWCMD_H2C_MCC_REQ_TSF_GROUP_MSK 0x3
#define FWCMD_H2C_MCC_REQ_TSF_MACID_X_SH 8
#define FWCMD_H2C_MCC_REQ_TSF_MACID_X_MSK 0xff
#define FWCMD_H2C_MCC_REQ_TSF_MACID_Y_SH 16
#define FWCMD_H2C_MCC_REQ_TSF_MACID_Y_MSK 0xff
#define FWCMD_H2C_MCC_MACID_BITMAP_GROUP_SH 0
#define FWCMD_H2C_MCC_MACID_BITMAP_GROUP_MSK 0x3
#define FWCMD_H2C_MCC_MACID_BITMAP_MACID_SH 8
#define FWCMD_H2C_MCC_MACID_BITMAP_MACID_MSK 0xff
#define FWCMD_H2C_MCC_MACID_BITMAP_BITMAP_LENGTH_SH 16
#define FWCMD_H2C_MCC_MACID_BITMAP_BITMAP_LENGTH_MSK 0xff
#define FWCMD_H2C_MCC_MACID_BITMAP_BITMAP_SH 0
#define FWCMD_H2C_MCC_MACID_BITMAP_BITMAP_MSK 0xffffffff
#define FWCMD_H2C_MCC_SYNC_GROUP_SH 0
#define FWCMD_H2C_MCC_SYNC_GROUP_MSK 0x3
#define FWCMD_H2C_MCC_SYNC_MACID_SOURCE_SH 8
#define FWCMD_H2C_MCC_SYNC_MACID_SOURCE_MSK 0xff
#define FWCMD_H2C_MCC_SYNC_MACID_TARGET_SH 16
#define FWCMD_H2C_MCC_SYNC_MACID_TARGET_MSK 0xff
#define FWCMD_H2C_MCC_SYNC_SYNC_OFFSET_SH 24
#define FWCMD_H2C_MCC_SYNC_SYNC_OFFSET_MSK 0xff
#define FWCMD_H2C_MCC_SET_DURATION_GROUP_SH 0
#define FWCMD_H2C_MCC_SET_DURATION_GROUP_MSK 0x3
#define FWCMD_H2C_MCC_SET_DURATION_BTC_IN_GROUP BIT(2)
#define FWCMD_H2C_MCC_SET_DURATION_START_MACID_SH 8
#define FWCMD_H2C_MCC_SET_DURATION_START_MACID_MSK 0xff
#define FWCMD_H2C_MCC_SET_DURATION_MACID_X_SH 16
#define FWCMD_H2C_MCC_SET_DURATION_MACID_X_MSK 0xff
#define FWCMD_H2C_MCC_SET_DURATION_MACID_Y_SH 24
#define FWCMD_H2C_MCC_SET_DURATION_MACID_Y_MSK 0xff
#define FWCMD_H2C_MCC_SET_DURATION_START_TSF_LOW_SH 0
#define FWCMD_H2C_MCC_SET_DURATION_START_TSF_LOW_MSK 0xffffffff
#define FWCMD_H2C_MCC_SET_DURATION_START_TSF_HIGH_SH 0
#define FWCMD_H2C_MCC_SET_DURATION_START_TSF_HIGH_MSK 0xffffffff
#define FWCMD_H2C_MCC_SET_DURATION_DURATION_X_SH 0
#define FWCMD_H2C_MCC_SET_DURATION_DURATION_X_MSK 0xffffffff
#define FWCMD_H2C_MCC_SET_DURATION_DURATION_Y_SH 0
#define FWCMD_H2C_MCC_SET_DURATION_DURATION_Y_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FLASH_WRITE_ADDR_SH 0
#define FWCMD_H2C_PLAT_FLASH_WRITE_ADDR_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FLASH_WRITE_LENGTH_SH 0
#define FWCMD_H2C_PLAT_FLASH_WRITE_LENGTH_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FLASH_WRITE_PAYLOAD0_SH 0
#define FWCMD_H2C_PLAT_FLASH_WRITE_PAYLOAD0_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FLASH_ERASE_ADDR_SH 0
#define FWCMD_H2C_PLAT_FLASH_ERASE_ADDR_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FLASH_ERASE_LENGTH_SH 0
#define FWCMD_H2C_PLAT_FLASH_ERASE_LENGTH_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FLASH_READ_ADDR_SH 0
#define FWCMD_H2C_PLAT_FLASH_READ_ADDR_MSK 0xffffffff
#define FWCMD_H2C_PLAT_FLASH_READ_LENGTH_SH 0
#define FWCMD_H2C_PLAT_FLASH_READ_LENGTH_MSK 0xffffffff
#define FWCMD_H2C_FCS_AP_PORT_ID_SH 0
#define FWCMD_H2C_FCS_AP_PORT_ID_MSK 0xf
#define FWCMD_H2C_FCS_CH_IDX_SH 4
#define FWCMD_H2C_FCS_CH_IDX_MSK 0xf
#define FWCMD_H2C_FCS_THERMAL_IDX_SH 8
#define FWCMD_H2C_FCS_THERMAL_IDX_MSK 0xf
#define FWCMD_H2C_FCS_PAUSE_REL_MODE_SH 12
#define FWCMD_H2C_FCS_PAUSE_REL_MODE_MSK 0xf
#define FWCMD_H2C_FCS_CON_STA_NUM_SH 16
#define FWCMD_H2C_FCS_CON_STA_NUM_MSK 0xff
#define FWCMD_H2C_FCS_BAND BIT(24)
#define FWCMD_H2C_FCS_BANDWIDTH_SH 25
#define FWCMD_H2C_FCS_BANDWIDTH_MSK 0x3
#define FWCMD_H2C_FCS_PRI_CH_SH 0
#define FWCMD_H2C_FCS_PRI_CH_MSK 0xff
#define FWCMD_H2C_FCS_CENTRAL_CH_SH 8
#define FWCMD_H2C_FCS_CENTRAL_CH_MSK 0xff
#define FWCMD_H2C_FCS_REL_PAUSE_TSFL_SH 0
#define FWCMD_H2C_FCS_REL_PAUSE_TSFL_MSK 0xffffffff
#define FWCMD_H2C_FCS_REL_PAUSE_TSFH_SH 0
#define FWCMD_H2C_FCS_REL_PAUSE_TSFH_MSK 0xffffffff
#define FWCMD_H2C_FCS_REL_PAUSE_DELAY_TIME_SH 0
#define FWCMD_H2C_FCS_REL_PAUSE_DELAY_TIME_MSK 0xffffffff
#define FWCMD_H2C_FCS_CSA_PKT_ID0_SH 0
#define FWCMD_H2C_FCS_CSA_PKT_ID0_MSK 0xff
#define FWCMD_H2C_FCS_CSA_PKT_ID1_SH 8
#define FWCMD_H2C_FCS_CSA_PKT_ID1_MSK 0xff
#define FWCMD_H2C_FCS_CSA_PKT_ID2_SH 16
#define FWCMD_H2C_FCS_CSA_PKT_ID2_MSK 0xff
#define FWCMD_H2C_FCS_CSA_PKT_ID3_SH 24
#define FWCMD_H2C_FCS_CSA_PKT_ID3_MSK 0xff
#define FWCMD_H2C_CFG_WPS_EN BIT(0)
#define FWCMD_H2C_CFG_WPS_GPIO_SH 8
#define FWCMD_H2C_CFG_WPS_GPIO_MSK 0xff
#define FWCMD_H2C_CFG_WPS_INTL_SH 16
#define FWCMD_H2C_CFG_WPS_INTL_MSK 0xff
#define FWCMD_H2C_PORT_INIT_BAND BIT(0)
#define FWCMD_H2C_PORT_INIT_PORT_SH 1
#define FWCMD_H2C_PORT_INIT_PORT_MSK 0x7
#define FWCMD_H2C_PORT_INIT_NET_TYPE_SH 4
#define FWCMD_H2C_PORT_INIT_NET_TYPE_MSK 0x7
#define FWCMD_H2C_PORT_INIT_DTIM_PRD_SH 8
#define FWCMD_H2C_PORT_INIT_DTIM_PRD_MSK 0xff
#define FWCMD_H2C_PORT_INIT_MBSSID_NUM_SH 16
#define FWCMD_H2C_PORT_INIT_MBSSID_NUM_MSK 0xff
#define FWCMD_H2C_PORT_INIT_BSS_COLOR_SH 24
#define FWCMD_H2C_PORT_INIT_BSS_COLOR_MSK 0xff
#define FWCMD_H2C_PORT_INIT_BCN_ITVL_SH 0
#define FWCMD_H2C_PORT_INIT_BCN_ITVL_MSK 0xffff
#define FWCMD_H2C_PORT_INIT_HIQ_WND_SH 16
#define FWCMD_H2C_PORT_INIT_HIQ_WND_MSK 0xff
#define FWCMD_H2C_PORT_CFG_BAND BIT(0)
#define FWCMD_H2C_PORT_CFG_PORT_SH 1
#define FWCMD_H2C_PORT_CFG_PORT_MSK 0x7
#define FWCMD_H2C_PORT_CFG_MBSSID_IDX_SH 8
#define FWCMD_H2C_PORT_CFG_MBSSID_IDX_MSK 0xff
#define FWCMD_H2C_PORT_CFG_TYPE_SH 16
#define FWCMD_H2C_PORT_CFG_TYPE_MSK 0xff
#define FWCMD_H2C_PORT_CFG_VAL_SH 0
#define FWCMD_H2C_PORT_CFG_VAL_MSK 0xffffffff

//
//H2CPKT - CAT(Table)
//
#define FWCMD_H2C_MUDE_PARA_TBLUD_TBLUD_SH 0
#define FWCMD_H2C_MUDE_PARA_TBLUD_TBLUD_MSK 0xffffffff
#define FWCMD_H2C_MUDE_PARA_TBLUD_MUDECISION_PARA0_SH 0
#define FWCMD_H2C_MUDE_PARA_TBLUD_MUDECISION_PARA0_MSK 0xffffffff
#define FWCMD_H2C_MUDE_PARA_TBLUD_MUDECISION_PARA1_SH 0
#define FWCMD_H2C_MUDE_PARA_TBLUD_MUDECISION_PARA1_MSK 0xffffffff
#define FWCMD_H2C_MUDECISION_PARA_MUINFO_THOLD_SH 0
#define FWCMD_H2C_MUDECISION_PARA_MUINFO_THOLD_MSK 0x3fffffff
#define FWCMD_H2C_MUDECISION_PARA_BYPASS_THOLD BIT(30)
#define FWCMD_H2C_MUDECISION_PARA_BYPASS_TP BIT(31)
#define FWCMD_H2C_MUDECISION_PARA_INIT_RATE_SH 0
#define FWCMD_H2C_MUDECISION_PARA_INIT_RATE_MSK 0xf
#define FWCMD_H2C_MUDECISION_PARA_RETRY_TH_SH 4
#define FWCMD_H2C_MUDECISION_PARA_RETRY_TH_MSK 0x7
#define FWCMD_H2C_MU_FIXINFO_MUINFO_THOLDEN BIT(0)
#define FWCMD_H2C_MU_FIXINFO_MUINFO_THOLD_SH 1
#define FWCMD_H2C_MU_FIXINFO_MUINFO_THOLD_MSK 0x3fffffff
#define FWCMD_H2C_MU_FIXINFO_BYPASS_THOLD BIT(31)
#define FWCMD_H2C_MU_FIXINFO_FIXMU_EN BIT(0)
#define FWCMD_H2C_MU_FIXINFO_FIXMU_ID_SH 1
#define FWCMD_H2C_MU_FIXINFO_FIXMU_ID_MSK 0x7f
#define FWCMD_H2C_UL_FIXINFO_TBLUD_TBLUD_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_TBLUD_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D2_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D2_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D3_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D3_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D4_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D4_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D5_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D5_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D6_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D6_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D7_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D7_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D8_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D8_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D9_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D9_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D10_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D10_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D11_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D11_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D12_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D12_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D13_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D13_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D14_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D14_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D15_SH 0
#define FWCMD_H2C_UL_FIXINFO_TBLUD_UL_FIXINFO_D15_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_CFG_MODE_SH 0
#define FWCMD_H2C_UL_FIXINFO_CFG_MODE_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_CFG_INTERVAL_SH 2
#define FWCMD_H2C_UL_FIXINFO_CFG_INTERVAL_MSK 0x3f
#define FWCMD_H2C_UL_FIXINFO_CFG_BSR_THOLD_SH 8
#define FWCMD_H2C_UL_FIXINFO_CFG_BSR_THOLD_MSK 0xff
#define FWCMD_H2C_UL_FIXINFO_CFG_STOREMODE_SH 16
#define FWCMD_H2C_UL_FIXINFO_CFG_STOREMODE_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULINFO_NDPA_DUR_SH 0
#define FWCMD_H2C_UL_FIXINFO_ULINFO_NDPA_DUR_MSK 0xffff
#define FWCMD_H2C_UL_FIXINFO_ULINFO_TF_TYPE_SH 16
#define FWCMD_H2C_UL_FIXINFO_ULINFO_TF_TYPE_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_ULINFO_SIGEN BIT(19)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_SIGSC_SH 20
#define FWCMD_H2C_UL_FIXINFO_ULINFO_SIGSC_MSK 0xf
#define FWCMD_H2C_UL_FIXINFO_ULINFO_MURTS BIT(24)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_NDPA_SH 25
#define FWCMD_H2C_UL_FIXINFO_ULINFO_NDPA_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULINFO_SNDPKT_SH 27
#define FWCMD_H2C_UL_FIXINFO_ULINFO_SNDPKT_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULINFO_GI_LTF_SH 29
#define FWCMD_H2C_UL_FIXINFO_ULINFO_GI_LTF_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_ULINFO_DATART_SH 0
#define FWCMD_H2C_UL_FIXINFO_ULINFO_DATART_MSK 0x1ff
#define FWCMD_H2C_UL_FIXINFO_ULINFO_DATAER BIT(9)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_DATABW_SH 10
#define FWCMD_H2C_UL_FIXINFO_ULINFO_DATABW_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULINFO_STBC_SH 12
#define FWCMD_H2C_UL_FIXINFO_ULINFO_STBC_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULINFO_LDPC BIT(14)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_DATADCM BIT(15)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_APEPLEN_SH 16
#define FWCMD_H2C_UL_FIXINFO_ULINFO_APEPLEN_MSK 0xfff
#define FWCMD_H2C_UL_FIXINFO_ULINFO_MORETF BIT(28)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_DATA_VWER BIT(29)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_ISTWT BIT(30)
#define FWCMD_H2C_UL_FIXINFO_ULINFO_MULTIPORT_SH 0
#define FWCMD_H2C_UL_FIXINFO_ULINFO_MULTIPORT_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_ULINFO_MBSSID_SH 3
#define FWCMD_H2C_UL_FIXINFO_ULINFO_MBSSID_MSK 0xf
#define FWCMD_H2C_UL_FIXINFO_ULINFO_TXPWR_MODE_SH 7
#define FWCMD_H2C_UL_FIXINFO_ULINFO_TXPWR_MODE_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_ULINFO_ULFIX_USAGE_SH 10
#define FWCMD_H2C_UL_FIXINFO_ULINFO_ULFIX_USAGE_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_ULINFO_TWTGRP_STANUM_SEL_SH 13
#define FWCMD_H2C_UL_FIXINFO_ULINFO_TWTGRP_STANUM_SEL_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULINFO_STORE_IDX_SH 15
#define FWCMD_H2C_UL_FIXINFO_ULINFO_STORE_IDX_MSK 0xf
#define FWCMD_H2C_UL_FIXINFO_UL_FIXINFO_STA_INFO_0_1_SH 0
#define FWCMD_H2C_UL_FIXINFO_UL_FIXINFO_STA_INFO_0_1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_UL_FIXINFO_STA_INFO_2_3_SH 0
#define FWCMD_H2C_UL_FIXINFO_UL_FIXINFO_STA_INFO_2_3_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_ULRUA_RU2SU BIT(0)
#define FWCMD_H2C_UL_FIXINFO_ULRUA_PPDU_BW_SH 1
#define FWCMD_H2C_UL_FIXINFO_ULRUA_PPDU_BW_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULRUA_GI_LTF_SH 3
#define FWCMD_H2C_UL_FIXINFO_ULRUA_GI_LTF_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_ULRUA_STBC BIT(6)
#define FWCMD_H2C_UL_FIXINFO_ULRUA_DOPPLER BIT(7)
#define FWCMD_H2C_UL_FIXINFO_ULRUA_LTF_MA_SH 8
#define FWCMD_H2C_UL_FIXINFO_ULRUA_LTF_MA_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_ULRUA_STANUM_SH 11
#define FWCMD_H2C_UL_FIXINFO_ULRUA_STANUM_MSK 0xf
#define FWCMD_H2C_UL_FIXINFO_ULRUA_RFGFIX BIT(16)
#define FWCMD_H2C_UL_FIXINFO_ULRUA_RFGIDX_SH 17
#define FWCMD_H2C_UL_FIXINFO_ULRUA_RFGIDX_MSK 0x3ff
#define FWCMD_H2C_UL_FIXINFO_ULRUA_TB_NOM_SH 27
#define FWCMD_H2C_UL_FIXINFO_ULRUA_TB_NOM_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_ULRUA_GRP_MODE BIT(0)
#define FWCMD_H2C_UL_FIXINFO_ULRUA_GRP_ID_SH 1
#define FWCMD_H2C_UL_FIXINFO_ULRUA_GRP_ID_MSK 0x3f
#define FWCMD_H2C_UL_FIXINFO_ULRUA_FIX_MODE BIT(7)
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U0_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U0_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U0_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U0_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U1_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U1_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U1_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U1_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U2_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U2_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U2_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U2_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U3_D0_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U3_D0_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U3_D1_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_ENT_U3_D1_MSK 0xffffffff
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_MACID_0_SH 0
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_MACID_0_MSK 0xff
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_PREF_AC_0_SH 8
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_PREF_AC_0_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_MACID_1_SH 16
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_MACID_1_MSK 0xff
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_PREF_AC_1_SH 24
#define FWCMD_H2C_UL_FIXINFO_STA_INFO_PREF_AC_1_MSK 0x3
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_DROP BIT(0)
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_TGT_RSSI_SH 1
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_TGT_RSSI_MSK 0x7f
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_MAC_ID_SH 8
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_MAC_ID_MSK 0xff
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_RU_POS_SH 16
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_RU_POS_MSK 0xff
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_CODE BIT(24)
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_VIP BIT(25)
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_BSRLEN_SH 0
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_BSRLEN_MSK 0x7fff
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_DCM BIT(16)
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_SS_SH 17
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_SS_MSK 0x7
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_MCS_SH 20
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_MCS_MSK 0xf
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_RT_TBLCOL_SH 24
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_RT_TBLCOL_MSK 0x3f
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_PRTL_ALLOC BIT(30)
#define FWCMD_H2C_UL_FIXINFO_UL_RUA_STA_ENT_RATE_CHG BIT(31)
#define FWCMD_H2C_ADDR_CAM_VALID BIT(0)
#define FWCMD_H2C_ADDR_CAM_NET_TYPE_SH 1
#define FWCMD_H2C_ADDR_CAM_NET_TYPE_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_BCN_HIT_COND_SH 3
#define FWCMD_H2C_ADDR_CAM_BCN_HIT_COND_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_HIT_RULE_SH 5
#define FWCMD_H2C_ADDR_CAM_HIT_RULE_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_BB_SEL BIT(7)
#define FWCMD_H2C_ADDR_CAM_ADDR_MASK_SH 8
#define FWCMD_H2C_ADDR_CAM_ADDR_MASK_MSK 0x3f
#define FWCMD_H2C_ADDR_CAM_MASK_SEL_SH 14
#define FWCMD_H2C_ADDR_CAM_MASK_SEL_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SMA_HASH_SH 16
#define FWCMD_H2C_ADDR_CAM_SMA_HASH_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_TMA_HASH_SH 24
#define FWCMD_H2C_ADDR_CAM_TMA_HASH_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_BSSID_CAM_IDX_SH 0
#define FWCMD_H2C_ADDR_CAM_BSSID_CAM_IDX_MSK 0x3f
#define FWCMD_H2C_ADDR_CAM_SMA0_SH 0
#define FWCMD_H2C_ADDR_CAM_SMA0_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SMA1_SH 8
#define FWCMD_H2C_ADDR_CAM_SMA1_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SMA2_SH 16
#define FWCMD_H2C_ADDR_CAM_SMA2_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SMA3_SH 24
#define FWCMD_H2C_ADDR_CAM_SMA3_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SMA4_SH 0
#define FWCMD_H2C_ADDR_CAM_SMA4_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SMA5_SH 8
#define FWCMD_H2C_ADDR_CAM_SMA5_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_TMA0_SH 16
#define FWCMD_H2C_ADDR_CAM_TMA0_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_TMA1_SH 24
#define FWCMD_H2C_ADDR_CAM_TMA1_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_TMA2_SH 0
#define FWCMD_H2C_ADDR_CAM_TMA2_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_TMA3_SH 8
#define FWCMD_H2C_ADDR_CAM_TMA3_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_TMA4_SH 16
#define FWCMD_H2C_ADDR_CAM_TMA4_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_TMA5_SH 24
#define FWCMD_H2C_ADDR_CAM_TMA5_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_MACID_SH 0
#define FWCMD_H2C_ADDR_CAM_MACID_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_PORT_INT_SH 8
#define FWCMD_H2C_ADDR_CAM_PORT_INT_MSK 0x7
#define FWCMD_H2C_ADDR_CAM_TSF_SYNC_SH 11
#define FWCMD_H2C_ADDR_CAM_TSF_SYNC_MSK 0x7
#define FWCMD_H2C_ADDR_CAM_TF_TRS BIT(14)
#define FWCMD_H2C_ADDR_CAM_LSIG_TXOP BIT(15)
#define FWCMD_H2C_ADDR_CAM_TGT_IND_SH 24
#define FWCMD_H2C_ADDR_CAM_TGT_IND_MSK 0x7
#define FWCMD_H2C_ADDR_CAM_FRM_TGT_IND_SH 27
#define FWCMD_H2C_ADDR_CAM_FRM_TGT_IND_MSK 0x7
#define FWCMD_H2C_ADDR_CAM_AID12_0_SH 0
#define FWCMD_H2C_ADDR_CAM_AID12_0_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_AID12_1_SH 8
#define FWCMD_H2C_ADDR_CAM_AID12_1_MSK 0xf
#define FWCMD_H2C_ADDR_CAM_WOL_PATTERN BIT(12)
#define FWCMD_H2C_ADDR_CAM_WOL_UC BIT(13)
#define FWCMD_H2C_ADDR_CAM_WOL_MAGIC BIT(14)
#define FWCMD_H2C_ADDR_CAM_WAPI BIT(15)
#define FWCMD_H2C_ADDR_CAM_SEC_ENT_MODE_SH 16
#define FWCMD_H2C_ADDR_CAM_SEC_ENT_MODE_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT0_KEYID_SH 18
#define FWCMD_H2C_ADDR_CAM_SEC_ENT0_KEYID_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT1_KEYID_SH 20
#define FWCMD_H2C_ADDR_CAM_SEC_ENT1_KEYID_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT2_KEYID_SH 22
#define FWCMD_H2C_ADDR_CAM_SEC_ENT2_KEYID_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT3_KEYID_SH 24
#define FWCMD_H2C_ADDR_CAM_SEC_ENT3_KEYID_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT4_KEYID_SH 26
#define FWCMD_H2C_ADDR_CAM_SEC_ENT4_KEYID_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT5_KEYID_SH 28
#define FWCMD_H2C_ADDR_CAM_SEC_ENT5_KEYID_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT6_KEYID_SH 30
#define FWCMD_H2C_ADDR_CAM_SEC_ENT6_KEYID_MSK 0x3
#define FWCMD_H2C_ADDR_CAM_SEC_ENT_VALID_SH 0
#define FWCMD_H2C_ADDR_CAM_SEC_ENT_VALID_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SEC_ENT0_SH 8
#define FWCMD_H2C_ADDR_CAM_SEC_ENT0_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SEC_ENT1_SH 16
#define FWCMD_H2C_ADDR_CAM_SEC_ENT1_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SEC_ENT2_SH 24
#define FWCMD_H2C_ADDR_CAM_SEC_ENT2_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SEC_ENT3_SH 0
#define FWCMD_H2C_ADDR_CAM_SEC_ENT3_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SEC_ENT4_SH 8
#define FWCMD_H2C_ADDR_CAM_SEC_ENT4_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SEC_ENT5_SH 16
#define FWCMD_H2C_ADDR_CAM_SEC_ENT5_MSK 0xff
#define FWCMD_H2C_ADDR_CAM_SEC_ENT6_SH 24
#define FWCMD_H2C_ADDR_CAM_SEC_ENT6_MSK 0xff
#define FWCMD_H2C_BSSID_CAM_BSSID_VALID BIT(0)
#define FWCMD_H2C_BSSID_CAM_BB_SEL BIT(1)
#define FWCMD_H2C_BSSID_CAM_BSS_COLOR_SH 8
#define FWCMD_H2C_BSSID_CAM_BSS_COLOR_MSK 0x7f
#define FWCMD_H2C_BSSID_CAM_BSSID0_SH 16
#define FWCMD_H2C_BSSID_CAM_BSSID0_MSK 0xff
#define FWCMD_H2C_BSSID_CAM_BSSID1_SH 24
#define FWCMD_H2C_BSSID_CAM_BSSID1_MSK 0xff
#define FWCMD_H2C_BSSID_CAM_BSSID2_SH 0
#define FWCMD_H2C_BSSID_CAM_BSSID2_MSK 0xff
#define FWCMD_H2C_BSSID_CAM_BSSID3_SH 8
#define FWCMD_H2C_BSSID_CAM_BSSID3_MSK 0xff
#define FWCMD_H2C_BSSID_CAM_BSSID4_SH 16
#define FWCMD_H2C_BSSID_CAM_BSSID4_MSK 0xff
#define FWCMD_H2C_BSSID_CAM_BSSID5_SH 24
#define FWCMD_H2C_BSSID_CAM_BSSID5_MSK 0xff
#define FWCMD_H2C_SEC_CAM_SEC_TYPE_SH 0
#define FWCMD_H2C_SEC_CAM_SEC_TYPE_MSK 0xf
#define FWCMD_H2C_SEC_CAM_EXT_KEY BIT(4)
#define FWCMD_H2C_SEC_CAM_SPP_MODE BIT(5)
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_TBLUD_SH 0
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_TBLUD_MSK 0xffffffff
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_FIXMODE_PARA_D0_SH 0
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_FIXMODE_PARA_D0_MSK 0xffffffff
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_FIXMODE_PARA_D1_SH 0
#define FWCMD_H2C_FIXMODE_PARA_TBLUD_FIXMODE_PARA_D1_MSK 0xffffffff
#define FWCMD_H2C_FIXMODE_PARA_FORCE_SUMURU_EN BIT(0)
#define FWCMD_H2C_FIXMODE_PARA_FORCESU BIT(1)
#define FWCMD_H2C_FIXMODE_PARA_FORCEMU BIT(2)
#define FWCMD_H2C_FIXMODE_PARA_FORCERU BIT(3)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FE_SU_EN BIT(4)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FE_VHTMU_EN BIT(5)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FE_HEMU_EN BIT(6)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FE_HERU_EN BIT(7)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FE_UL_EN BIT(8)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FRAME_SEQ_SU BIT(9)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FRAME_SEQ_VHTMU BIT(10)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FRAME_SEQ_HEMU BIT(11)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FRAME_SEQ_HERU BIT(12)
#define FWCMD_H2C_FIXMODE_PARA_FIX_FRAME_SEQ_UL BIT(13)
#define FWCMD_H2C_FIXMODE_PARA_IS_DLRUHWGRP BIT(14)
#define FWCMD_H2C_FIXMODE_PARA_IS_ULRUHWGRP BIT(15)
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_SU_SH 16
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_SU_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_VHTMU_SH 20
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_VHTMU_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_RESP_TYPE_VHTMU_SH 24
#define FWCMD_H2C_FIXMODE_PARA_RESP_TYPE_VHTMU_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_HEMU_SH 28
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_HEMU_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_RESP_TYPE_HEMU_SH 0
#define FWCMD_H2C_FIXMODE_PARA_RESP_TYPE_HEMU_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_HERU_SH 4
#define FWCMD_H2C_FIXMODE_PARA_PROT_TYPE_HERU_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_RESP_TYPE_HERU_SH 8
#define FWCMD_H2C_FIXMODE_PARA_RESP_TYPE_HERU_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_UL_PROT_TYPE_SH 12
#define FWCMD_H2C_FIXMODE_PARA_UL_PROT_TYPE_MSK 0xf
#define FWCMD_H2C_FIXMODE_PARA_RUGRPID_SH 16
#define FWCMD_H2C_FIXMODE_PARA_RUGRPID_MSK 0x1f
#define FWCMD_H2C_FIXMODE_PARA_MUGRPID_SH 21
#define FWCMD_H2C_FIXMODE_PARA_MUGRPID_MSK 0x1f
#define FWCMD_H2C_FIXMODE_PARA_ULGRPID_SH 26
#define FWCMD_H2C_FIXMODE_PARA_ULGRPID_MSK 0x1f
#define FWCMD_H2C_WRITE_OFLD_REQ_VALUE_LEN_SH 0
#define FWCMD_H2C_WRITE_OFLD_REQ_VALUE_LEN_MSK 0x7ff
#define FWCMD_H2C_WRITE_OFLD_REQ_POLLING BIT(13)
#define FWCMD_H2C_WRITE_OFLD_REQ_MASK_EN BIT(14)
#define FWCMD_H2C_WRITE_OFLD_REQ_LS BIT(15)
#define FWCMD_H2C_WRITE_OFLD_REQ_OFLD_ID_SH 16
#define FWCMD_H2C_WRITE_OFLD_REQ_OFLD_ID_MSK 0xff
#define FWCMD_H2C_WRITE_OFLD_REQ_ENTRY_NUM_SH 24
#define FWCMD_H2C_WRITE_OFLD_REQ_ENTRY_NUM_MSK 0xff
#define FWCMD_H2C_WRITE_OFLD_REQ_OFFSET_SH 0
#define FWCMD_H2C_WRITE_OFLD_REQ_OFFSET_MSK 0xffff
#define FWCMD_H2C_READ_OFLD_REQ_VALUE_LEN_SH 0
#define FWCMD_H2C_READ_OFLD_REQ_VALUE_LEN_MSK 0x7ff
#define FWCMD_H2C_READ_OFLD_REQ_LS BIT(15)
#define FWCMD_H2C_READ_OFLD_REQ_OFLD_ID_SH 16
#define FWCMD_H2C_READ_OFLD_REQ_OFLD_ID_MSK 0xff
#define FWCMD_H2C_READ_OFLD_REQ_ENTRY_NUM_SH 24
#define FWCMD_H2C_READ_OFLD_REQ_ENTRY_NUM_MSK 0xff
#define FWCMD_H2C_READ_OFLD_REQ_OFFSET_SH 0
#define FWCMD_H2C_READ_OFLD_REQ_OFFSET_MSK 0xffff
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_DEVICE_SH 0
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_DEVICE_MSK 0xff
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_HIOE_OP_SH 0
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_HIOE_OP_MSK 0xff
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_INST_TYPE_SH 8
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_INST_TYPE_MSK 0xff
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_DATA_MODE_SH 24
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_DATA_MODE_MSK 0xff
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_REGISTER_ADDR_SH 0
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_REGISTER_ADDR_MSK 0xffffffff
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_BYTE_DATA_H_SH 0
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_BYTE_DATA_H_MSK 0xffff
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_BYTE_DATA_L_SH 16
#define FWCMD_H2C_CONF_OFLD_REQ_CMD_BYTE_DATA_L_MSK 0xffff
#define FWCMD_H2C_DCTRL_QOS_FIELD_H_SH 0
#define FWCMD_H2C_DCTRL_QOS_FIELD_H_MSK 0xff
#define FWCMD_H2C_DCTRL_HW_EXSEQ_MACID_SH 8
#define FWCMD_H2C_DCTRL_HW_EXSEQ_MACID_MSK 0x7f
#define FWCMD_H2C_DCTRL_QOS_FIELD_H_EN BIT(15)
#define FWCMD_H2C_DCTRL_AES_IV_L_SH 16
#define FWCMD_H2C_DCTRL_AES_IV_L_MSK 0xffff
#define FWCMD_H2C_DCTRL_AES_IV_H_SH 0
#define FWCMD_H2C_DCTRL_AES_IV_H_MSK 0xffffffff
#define FWCMD_H2C_DCTRL_SEQ0_SH 0
#define FWCMD_H2C_DCTRL_SEQ0_MSK 0xfff
#define FWCMD_H2C_DCTRL_SEQ1_SH 12
#define FWCMD_H2C_DCTRL_SEQ1_MSK 0xfff
#define FWCMD_H2C_DCTRL_AMSDU_MAX_LEN_SH 24
#define FWCMD_H2C_DCTRL_AMSDU_MAX_LEN_MSK 0x7
#define FWCMD_H2C_DCTRL_STA_AMSDU_EN BIT(27)
#define FWCMD_H2C_DCTRL_CHKSUM_OFLD_EN BIT(28)
#define FWCMD_H2C_DCTRL_WITH_LLC BIT(29)
#define FWCMD_H2C_DCTRL_SEC_HW_ENC BIT(31)
#define FWCMD_H2C_DCTRL_SEQ2_SH 0
#define FWCMD_H2C_DCTRL_SEQ2_MSK 0xfff
#define FWCMD_H2C_DCTRL_SEQ3_SH 12
#define FWCMD_H2C_DCTRL_SEQ3_MSK 0xfff
#define FWCMD_H2C_DCTRL_SEC_CAM_IDX_SH 24
#define FWCMD_H2C_DCTRL_SEC_CAM_IDX_MSK 0xff
#define FWCMD_H2C_CCTRL_DATARATE_SH 0
#define FWCMD_H2C_CCTRL_DATARATE_MSK 0x1ff
#define FWCMD_H2C_CCTRL_FORCE_TXOP BIT(9)
#define FWCMD_H2C_CCTRL_DATA_BW_SH 10
#define FWCMD_H2C_CCTRL_DATA_BW_MSK 0x3
#define FWCMD_H2C_CCTRL_DATA_GI_LTF_SH 12
#define FWCMD_H2C_CCTRL_DATA_GI_LTF_MSK 0x7
#define FWCMD_H2C_CCTRL_DARF_TC_INDEX BIT(15)
#define FWCMD_H2C_CCTRL_ARFR_CTRL_SH 16
#define FWCMD_H2C_CCTRL_ARFR_CTRL_MSK 0xf
#define FWCMD_H2C_CCTRL_ACQ_RPT_EN BIT(20)
#define FWCMD_H2C_CCTRL_MGQ_RPT_EN BIT(21)
#define FWCMD_H2C_CCTRL_ULQ_RPT_EN BIT(22)
#define FWCMD_H2C_CCTRL_TWTQ_RPT_EN BIT(23)
#define FWCMD_H2C_CCTRL_DISRTSFB BIT(25)
#define FWCMD_H2C_CCTRL_DISDATAFB BIT(26)
#define FWCMD_H2C_CCTRL_TRYRATE BIT(27)
#define FWCMD_H2C_CCTRL_AMPDU_DENSITY_SH 28
#define FWCMD_H2C_CCTRL_AMPDU_DENSITY_MSK 0xf
#define FWCMD_H2C_CCTRL_DATA_RTY_LOWEST_RATE_SH 0
#define FWCMD_H2C_CCTRL_DATA_RTY_LOWEST_RATE_MSK 0x1ff
#define FWCMD_H2C_CCTRL_AMPDU_TIME_SEL BIT(9)
#define FWCMD_H2C_CCTRL_AMPDU_LEN_SEL BIT(10)
#define FWCMD_H2C_CCTRL_RTS_TXCNT_LMT_SEL BIT(11)
#define FWCMD_H2C_CCTRL_RTS_TXCNT_LMT_SH 12
#define FWCMD_H2C_CCTRL_RTS_TXCNT_LMT_MSK 0xf
#define FWCMD_H2C_CCTRL_RTSRATE_SH 16
#define FWCMD_H2C_CCTRL_RTSRATE_MSK 0x1ff
#define FWCMD_H2C_CCTRL_VCS_STBC BIT(27)
#define FWCMD_H2C_CCTRL_RTS_RTY_LOWEST_RATE_SH 28
#define FWCMD_H2C_CCTRL_RTS_RTY_LOWEST_RATE_MSK 0xf
#define FWCMD_H2C_CCTRL_DATA_TX_CNT_LMT_SH 0
#define FWCMD_H2C_CCTRL_DATA_TX_CNT_LMT_MSK 0x3f
#define FWCMD_H2C_CCTRL_DATA_TXCNT_LMT_SEL BIT(6)
#define FWCMD_H2C_CCTRL_MAX_AGG_NUM_SEL BIT(7)
#define FWCMD_H2C_CCTRL_RTS_EN BIT(8)
#define FWCMD_H2C_CCTRL_CTS2SELF_EN BIT(9)
#define FWCMD_H2C_CCTRL_CCA_RTS_SH 10
#define FWCMD_H2C_CCTRL_CCA_RTS_MSK 0x3
#define FWCMD_H2C_CCTRL_HW_RTS_EN BIT(12)
#define FWCMD_H2C_CCTRL_RTS_DROP_DATA_MODE_SH 13
#define FWCMD_H2C_CCTRL_RTS_DROP_DATA_MODE_MSK 0x3
#define FWCMD_H2C_CCTRL_PRELD_EN BIT(15)
#define FWCMD_H2C_CCTRL_AMPDU_MAX_LEN_SH 16
#define FWCMD_H2C_CCTRL_AMPDU_MAX_LEN_MSK 0x7ff
#define FWCMD_H2C_CCTRL_UL_MU_DIS BIT(27)
#define FWCMD_H2C_CCTRL_AMPDU_MAX_TIME_SH 28
#define FWCMD_H2C_CCTRL_AMPDU_MAX_TIME_MSK 0xf
#define FWCMD_H2C_CCTRL_MAX_AGG_NUM_SH 0
#define FWCMD_H2C_CCTRL_MAX_AGG_NUM_MSK 0xff
#define FWCMD_H2C_CCTRL_BA_BMAP_SH 8
#define FWCMD_H2C_CCTRL_BA_BMAP_MSK 0x3
#define FWCMD_H2C_CCTRL_VO_LFTIME_SEL_SH 16
#define FWCMD_H2C_CCTRL_VO_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_VI_LFTIME_SEL_SH 19
#define FWCMD_H2C_CCTRL_VI_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_BE_LFTIME_SEL_SH 22
#define FWCMD_H2C_CCTRL_BE_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_BK_LFTIME_SEL_SH 25
#define FWCMD_H2C_CCTRL_BK_LFTIME_SEL_MSK 0x7
#define FWCMD_H2C_CCTRL_SECTYPE_SH 28
#define FWCMD_H2C_CCTRL_SECTYPE_MSK 0xf
#define FWCMD_H2C_CCTRL_MULTI_PORT_ID_SH 0
#define FWCMD_H2C_CCTRL_MULTI_PORT_ID_MSK 0x7
#define FWCMD_H2C_CCTRL_BMC BIT(3)
#define FWCMD_H2C_CCTRL_MBSSID_SH 4
#define FWCMD_H2C_CCTRL_MBSSID_MSK 0xf
#define FWCMD_H2C_CCTRL_NAVUSEHDR BIT(8)
#define FWCMD_H2C_CCTRL_TXPWR_MODE_SH 9
#define FWCMD_H2C_CCTRL_TXPWR_MODE_MSK 0x7
#define FWCMD_H2C_CCTRL_DATA_DCM BIT(12)
#define FWCMD_H2C_CCTRL_DATA_ER BIT(13)
#define FWCMD_H2C_CCTRL_DATA_LDPC BIT(14)
#define FWCMD_H2C_CCTRL_DATA_STBC BIT(15)
#define FWCMD_H2C_CCTRL_A_CTRL_BQR BIT(16)
#define FWCMD_H2C_CCTRL_A_CTRL_UPH BIT(17)
#define FWCMD_H2C_CCTRL_A_CTRL_BSR BIT(18)
#define FWCMD_H2C_CCTRL_A_CTRL_CAS BIT(19)
#define FWCMD_H2C_CCTRL_DATA_BW_ER BIT(20)
#define FWCMD_H2C_CCTRL_LSIG_TXOP_EN BIT(21)
#define FWCMD_H2C_CCTRL_CTRL_CNT_VLD BIT(27)
#define FWCMD_H2C_CCTRL_CTRL_CNT_SH 28
#define FWCMD_H2C_CCTRL_CTRL_CNT_MSK 0xf
#define FWCMD_H2C_CCTRL_RESP_REF_RATE_SH 0
#define FWCMD_H2C_CCTRL_RESP_REF_RATE_MSK 0x1ff
#define FWCMD_H2C_CCTRL_ALL_ACK_SUPPORT BIT(12)
#define FWCMD_H2C_CCTRL_BSR_QUEUE_SIZE_FORMAT BIT(13)
#define FWCMD_H2C_CCTRL_NTX_PATH_EN_SH 16
#define FWCMD_H2C_CCTRL_NTX_PATH_EN_MSK 0xf
#define FWCMD_H2C_CCTRL_PATH_MAP_A_SH 20
#define FWCMD_H2C_CCTRL_PATH_MAP_A_MSK 0x3
#define FWCMD_H2C_CCTRL_PATH_MAP_B_SH 22
#define FWCMD_H2C_CCTRL_PATH_MAP_B_MSK 0x3
#define FWCMD_H2C_CCTRL_PATH_MAP_C_SH 24
#define FWCMD_H2C_CCTRL_PATH_MAP_C_MSK 0x3
#define FWCMD_H2C_CCTRL_PATH_MAP_D_SH 26
#define FWCMD_H2C_CCTRL_PATH_MAP_D_MSK 0x3
#define FWCMD_H2C_CCTRL_ANTSEL_A BIT(28)
#define FWCMD_H2C_CCTRL_ANTSEL_B BIT(29)
#define FWCMD_H2C_CCTRL_ANTSEL_C BIT(30)
#define FWCMD_H2C_CCTRL_ANTSEL_D BIT(31)
#define FWCMD_H2C_CCTRL_ADDR_CAM_INDEX_SH 0
#define FWCMD_H2C_CCTRL_ADDR_CAM_INDEX_MSK 0xff
#define FWCMD_H2C_CCTRL_PAID_SH 8
#define FWCMD_H2C_CCTRL_PAID_MSK 0x1ff
#define FWCMD_H2C_CCTRL_ULDL BIT(17)
#define FWCMD_H2C_CCTRL_DOPPLER_CTRL_SH 18
#define FWCMD_H2C_CCTRL_DOPPLER_CTRL_MSK 0x3
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING_SH 20
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING_MSK 0x3
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING40_SH 22
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING40_MSK 0x3
#define FWCMD_H2C_CCTRL_TXPWR_TOLERENCE_SH 24
#define FWCMD_H2C_CCTRL_TXPWR_TOLERENCE_MSK 0x3f
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING80_SH 30
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING80_MSK 0x3
#define FWCMD_H2C_CCTRL_NC_SH 0
#define FWCMD_H2C_CCTRL_NC_MSK 0x7
#define FWCMD_H2C_CCTRL_NR_SH 3
#define FWCMD_H2C_CCTRL_NR_MSK 0x7
#define FWCMD_H2C_CCTRL_NG_SH 6
#define FWCMD_H2C_CCTRL_NG_MSK 0x3
#define FWCMD_H2C_CCTRL_CB_SH 8
#define FWCMD_H2C_CCTRL_CB_MSK 0x3
#define FWCMD_H2C_CCTRL_CS_SH 10
#define FWCMD_H2C_CCTRL_CS_MSK 0x3
#define FWCMD_H2C_CCTRL_CSI_TXBF_EN BIT(12)
#define FWCMD_H2C_CCTRL_CSI_STBC_EN BIT(13)
#define FWCMD_H2C_CCTRL_CSI_LDPC_EN BIT(14)
#define FWCMD_H2C_CCTRL_CSI_PARA_EN BIT(15)
#define FWCMD_H2C_CCTRL_CSI_FIX_RATE_SH 16
#define FWCMD_H2C_CCTRL_CSI_FIX_RATE_MSK 0x1ff
#define FWCMD_H2C_CCTRL_CSI_GI_LTF_SH 25
#define FWCMD_H2C_CCTRL_CSI_GI_LTF_MSK 0x7
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING160_SH 28
#define FWCMD_H2C_CCTRL_NOMINAL_PKT_PADDING160_MSK 0x3
#define FWCMD_H2C_CCTRL_CSI_BW_SH 30
#define FWCMD_H2C_CCTRL_CSI_BW_MSK 0x3
#define FWCMD_H2C_IE_CAM_INFO_TYPE_SH 0
#define FWCMD_H2C_IE_CAM_INFO_TYPE_MSK 0xff
#define FWCMD_H2C_IE_CAM_INFO_DATA0_SH 8
#define FWCMD_H2C_IE_CAM_INFO_DATA0_MSK 0xff
#define FWCMD_H2C_IE_CAM_INFO_DATA1_SH 16
#define FWCMD_H2C_IE_CAM_INFO_DATA1_MSK 0xff
#define FWCMD_H2C_IE_CAM_INFO_DATA2_SH 24
#define FWCMD_H2C_IE_CAM_INFO_DATA2_MSK 0xff
#define FWCMD_H2C_IE_CAM_INFO_DATA3_SH 0
#define FWCMD_H2C_IE_CAM_INFO_DATA3_MSK 0xff
#define FWCMD_H2C_PLAT_AUTO_TEST_D0_SH 0
#define FWCMD_H2C_PLAT_AUTO_TEST_D0_MSK 0xffffffff
#define FWCMD_H2C_PLAT_AUTO_TEST_D1_SH 0
#define FWCMD_H2C_PLAT_AUTO_TEST_D1_MSK 0xffffffff
#define FWCMD_H2C_PLAT_AUTO_TEST_D2_SH 0
#define FWCMD_H2C_PLAT_AUTO_TEST_D2_MSK 0xffffffff
#define FWCMD_H2C_PLAT_AUTO_TEST_D3_SH 0
#define FWCMD_H2C_PLAT_AUTO_TEST_D3_MSK 0xffffffff
#define FWCMD_H2C_PLAT_AUTO_TEST_D4_SH 0
#define FWCMD_H2C_PLAT_AUTO_TEST_D4_MSK 0xffffffff
#define FWCMD_H2C_PLAT_AUTO_TEST_D5_SH 0
#define FWCMD_H2C_PLAT_AUTO_TEST_D5_MSK 0xffffffff
#define FWCMD_H2C_PLAT_AUTO_TEST_D6_SH 0
#define FWCMD_H2C_PLAT_AUTO_TEST_D6_MSK 0xffffffff
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_FUNC_SH 0
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_FUNC_MSK 0x7f
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_ACK BIT(7)
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_TOTAL_LEN_SH 8
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_TOTAL_LEN_MSK 0xf
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_SEQ_NUM_SH 12
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_SEQ_NUM_MSK 0xf
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_TX_EN_SH 16
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_TX_EN_MSK 0xffff
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_MASK_SH 0
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_MASK_MSK 0xffff
#define FWCMD_H2C_H2CREG_SCH_TX_PAUSE_BAND BIT(16)
#define FWCMD_H2C_CMD_OFLD_SRC_SH 0
#define FWCMD_H2C_CMD_OFLD_SRC_MSK 0x3
#define FWCMD_H2C_CMD_OFLD_TYPE_SH 2
#define FWCMD_H2C_CMD_OFLD_TYPE_MSK 0x3
#define FWCMD_H2C_CMD_OFLD_LC BIT(4)
#define FWCMD_H2C_CMD_OFLD_PATH_SH 5
#define FWCMD_H2C_CMD_OFLD_PATH_MSK 0x3
#define FWCMD_H2C_CMD_OFLD_CMD_NUM_SH 8
#define FWCMD_H2C_CMD_OFLD_CMD_NUM_MSK 0x7f
#define FWCMD_H2C_CMD_OFLD_OFFSET_SH 16
#define FWCMD_H2C_CMD_OFLD_OFFSET_MSK 0xffff
#define FWCMD_H2C_CMD_OFLD_ID_SH 0
#define FWCMD_H2C_CMD_OFLD_ID_MSK 0xffff
#define FWCMD_H2C_CMD_OFLD_VALUE_SH 0
#define FWCMD_H2C_CMD_OFLD_VALUE_MSK 0xffffffff
#define FWCMD_H2C_CMD_OFLD_MASK_SH 0
#define FWCMD_H2C_CMD_OFLD_MASK_MSK 0xffffffff

//
//H2CPKT - CAT(OutSrc,Phydm)
//
#define H2C_HDR_CAT_SH 0
#define H2C_HDR_CAT_MSK 0x3
#define H2C_HDR_CLASS_SH 2
#define H2C_HDR_CLASS_MSK 0x3f
#define H2C_HDR_FUNC_SH 8
#define H2C_HDR_FUNC_MSK 0xff
#define H2C_HDR_DEL_TYPE_SH 16
#define H2C_HDR_DEL_TYPE_MSK 0xf
#define H2C_HDR_H2C_SEQ_SH 24
#define H2C_HDR_H2C_SEQ_MSK 0xff
#define H2C_HDR_TOTAL_LEN_SH 0
#define H2C_HDR_TOTAL_LEN_MSK 0x3fff
#define H2C_HDR_REC_ACK BIT(14)
#define H2C_HDR_DONE_ACK BIT(15)
#define H2C_HDR_SEQ_VALID BIT(16)
#define H2C_HDR_SEQ_SH 17
#define H2C_HDR_SEQ_MSK 0x7
#define H2C_HDR_SEQ_STOP BIT(20)
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_MACID_CFG_IS_DISRA BIT(0)
#define FWCMD_H2C_MACID_CFG_MODE_CTRL_SH 1
#define FWCMD_H2C_MACID_CFG_MODE_CTRL_MSK 0x1f
#define FWCMD_H2C_MACID_CFG_BW_CAP_SH 6
#define FWCMD_H2C_MACID_CFG_BW_CAP_MSK 0x3
#define FWCMD_H2C_MACID_CFG_MACID_SH 8
#define FWCMD_H2C_MACID_CFG_MACID_MSK 0xff
#define FWCMD_H2C_MACID_CFG_DCM_CAP BIT(16)
#define FWCMD_H2C_MACID_CFG_ER_CAP BIT(17)
#define FWCMD_H2C_MACID_CFG_INIT_RATE_LV_SH 18
#define FWCMD_H2C_MACID_CFG_INIT_RATE_LV_MSK 0x3
#define FWCMD_H2C_MACID_CFG_BW_NOUPDATE BIT(20)
#define FWCMD_H2C_MACID_CFG_EN_SGI BIT(21)
#define FWCMD_H2C_MACID_CFG_LDPC_CAP BIT(22)
#define FWCMD_H2C_MACID_CFG_STBC_CAP BIT(23)
#define FWCMD_H2C_MACID_CFG_SS_NUM_SH 24
#define FWCMD_H2C_MACID_CFG_SS_NUM_MSK 0x7
#define FWCMD_H2C_MACID_CFG_GI_LTF_SH 27
#define FWCMD_H2C_MACID_CFG_GI_LTF_MSK 0x7
#define FWCMD_H2C_MACID_CFG_RA_MASK_LOW_SH 0
#define FWCMD_H2C_MACID_CFG_RA_MASK_LOW_MSK 0xffffffff
#define FWCMD_H2C_MACID_CFG_RA_MASK_HI_SH 0
#define FWCMD_H2C_MACID_CFG_RA_MASK_HI_MSK 0xfffffff
#define FWCMD_H2C_RSSI_RA_CONFIG_IS_DISRA BIT(0)
#define FWCMD_H2C_RSSI_RA_CONFIG_RA_MASK_LOW_SH 0
#define FWCMD_H2C_RSSI_RA_CONFIG_RA_MASK_LOW_MSK 0xffffffff
#define FWCMD_H2C_RSSI_RA_CONFIG_RA_MASK_HI_SH 0
#define FWCMD_H2C_RSSI_RA_CONFIG_RA_MASK_HI_MSK 0xffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff

//
//H2CPKT - CAT(OutSrc, RF)
//
#define H2C_HDR_CAT_SH 0
#define H2C_HDR_CAT_MSK 0x3
#define H2C_HDR_CLASS_SH 2
#define H2C_HDR_CLASS_MSK 0x3f
#define H2C_HDR_FUNC_SH 8
#define H2C_HDR_FUNC_MSK 0xff
#define H2C_HDR_DEL_TYPE_SH 16
#define H2C_HDR_DEL_TYPE_MSK 0xf
#define H2C_HDR_H2C_SEQ_SH 24
#define H2C_HDR_H2C_SEQ_MSK 0xff
#define H2C_HDR_TOTAL_LEN_SH 0
#define H2C_HDR_TOTAL_LEN_MSK 0x3fff
#define H2C_HDR_REC_ACK BIT(14)
#define H2C_HDR_DONE_ACK BIT(15)
#define H2C_HDR_SEQ_VALID BIT(16)
#define H2C_HDR_SEQ_SH 17
#define H2C_HDR_SEQ_MSK 0x7
#define H2C_HDR_SEQ_STOP BIT(20)
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_H2C_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff

//
//H2CPKT - CAT(OutSrc, BTC)
//
#define H2C_HDR_CAT_SH 0
#define H2C_HDR_CAT_MSK 0x3
#define H2C_HDR_CLASS_SH 2
#define H2C_HDR_CLASS_MSK 0x3f
#define H2C_HDR_FUNC_SH 8
#define H2C_HDR_FUNC_MSK 0xff
#define H2C_HDR_DEL_TYPE_SH 16
#define H2C_HDR_DEL_TYPE_MSK 0xf
#define H2C_HDR_H2C_SEQ_SH 24
#define H2C_HDR_H2C_SEQ_MSK 0xff
#define H2C_HDR_TOTAL_LEN_SH 0
#define H2C_HDR_TOTAL_LEN_MSK 0x3fff
#define H2C_HDR_REC_ACK BIT(14)
#define H2C_HDR_DONE_ACK BIT(15)
#define H2C_HDR_SEQ_VALID BIT(16)
#define H2C_HDR_SEQ_SH 17
#define H2C_HDR_SEQ_MSK 0x7
#define H2C_HDR_SEQ_STOP BIT(20)
#define FWCMD_H2C_TDMA_EN BIT(0)
#define FWCMD_H2C_TDMA_PRO_PS BIT(1)
#define FWCMD_H2C_TDMA_NULL BIT(2)
#define FWCMD_H2C_TDMA_QOS_NULL BIT(3)
#define FWCMD_H2C_TDMA_WL_SLOT_SH 8
#define FWCMD_H2C_TDMA_WL_SLOT_MSK 0xff

//
//C2HPKT - CAT(TEST)
//
#define C2H_HDR_CAT_SH 0
#define C2H_HDR_CAT_MSK 0x3
#define C2H_HDR_CLASS_SH 2
#define C2H_HDR_CLASS_MSK 0x3f
#define C2H_HDR_FUNC_SH 8
#define C2H_HDR_FUNC_MSK 0xff
#define C2H_HDR_DEL_TYPE_SH 16
#define C2H_HDR_DEL_TYPE_MSK 0xf
#define C2H_HDR_C2H_SEQ_SH 24
#define C2H_HDR_C2H_SEQ_MSK 0xff
#define C2H_HDR_TOTAL_LEN_SH 0
#define C2H_HDR_TOTAL_LEN_MSK 0x3fff
#define FWCMD_C2H_C2H_LB_PAYLOAD_SH 0
#define FWCMD_C2H_C2H_LB_PAYLOAD_MSK 0xffffffff
#define FWCMD_C2H_TEST_PHY_RPT_PAYLOAD_SH 0
#define FWCMD_C2H_TEST_PHY_RPT_PAYLOAD_MSK 0xffffffff
#define FWCMD_C2H_SPIC_PAYLOAD0_SH 0
#define FWCMD_C2H_SPIC_PAYLOAD0_MSK 0xff
#define FWCMD_C2H_SPIC_PAYLOAD1_SH 8
#define FWCMD_C2H_SPIC_PAYLOAD1_MSK 0xff
#define FWCMD_C2H_SPIC_PAYLOAD2_SH 16
#define FWCMD_C2H_SPIC_PAYLOAD2_MSK 0xff
#define FWCMD_C2H_SPIC_PAYLOAD3_SH 24
#define FWCMD_C2H_SPIC_PAYLOAD3_MSK 0x1ff
#define FWCMD_C2H_SPIC_PAYLOAD4_SH 0
#define FWCMD_C2H_SPIC_PAYLOAD4_MSK 0xff
#define FWCMD_C2H_SPIC_PAYLOAD5_SH 8
#define FWCMD_C2H_SPIC_PAYLOAD5_MSK 0xff
#define FWCMD_C2H_SPIC_PAYLOAD6_SH 16
#define FWCMD_C2H_SPIC_PAYLOAD6_MSK 0xff
#define FWCMD_C2H_SPIC_PAYLOAD7_SH 24
#define FWCMD_C2H_SPIC_PAYLOAD7_MSK 0x1ff
#define FWCMD_C2H_SPIC2_PAYLOAD0_SH 0
#define FWCMD_C2H_SPIC2_PAYLOAD0_MSK 0xff
#define FWCMD_C2H_SPIC2_PAYLOAD1_SH 8
#define FWCMD_C2H_SPIC2_PAYLOAD1_MSK 0xff
#define FWCMD_C2H_SPIC2_PAYLOAD2_SH 16
#define FWCMD_C2H_SPIC2_PAYLOAD2_MSK 0xff
#define FWCMD_C2H_SPIC2_PAYLOAD3_SH 24
#define FWCMD_C2H_SPIC2_PAYLOAD3_MSK 0x1ff
#define FWCMD_C2H_SPIC2_PAYLOAD4_SH 0
#define FWCMD_C2H_SPIC2_PAYLOAD4_MSK 0xff
#define FWCMD_C2H_SPIC2_PAYLOAD5_SH 8
#define FWCMD_C2H_SPIC2_PAYLOAD5_MSK 0xff
#define FWCMD_C2H_SPIC2_PAYLOAD6_SH 16
#define FWCMD_C2H_SPIC2_PAYLOAD6_MSK 0xff
#define FWCMD_C2H_SPIC2_PAYLOAD7_SH 24
#define FWCMD_C2H_SPIC2_PAYLOAD7_MSK 0x1ff
#define FWCMD_C2H_LPS_ONOFF_TEST_TYPE_SH 0
#define FWCMD_C2H_LPS_ONOFF_TEST_TYPE_MSK 0xffffffff
#define FWCMD_C2H_LPS_ONOFF_TEST_RESULT_SH 0
#define FWCMD_C2H_LPS_ONOFF_TEST_RESULT_MSK 0xffffffff

//
//C2HPKT - CAT(MAC)
//
#define C2H_HDR_CAT_SH 0
#define C2H_HDR_CAT_MSK 0x3
#define C2H_HDR_CLASS_SH 2
#define C2H_HDR_CLASS_MSK 0x3f
#define C2H_HDR_FUNC_SH 8
#define C2H_HDR_FUNC_MSK 0xff
#define C2H_HDR_DEL_TYPE_SH 16
#define C2H_HDR_DEL_TYPE_MSK 0xf
#define C2H_HDR_C2H_SEQ_SH 24
#define C2H_HDR_C2H_SEQ_MSK 0xff
#define C2H_HDR_TOTAL_LEN_SH 0
#define C2H_HDR_TOTAL_LEN_MSK 0x3fff
#define FWCMD_C2H_REC_ACK_CAT_SH 0
#define FWCMD_C2H_REC_ACK_CAT_MSK 0x3
#define FWCMD_C2H_REC_ACK_CLASS_SH 2
#define FWCMD_C2H_REC_ACK_CLASS_MSK 0x3f
#define FWCMD_C2H_REC_ACK_FUNC_SH 8
#define FWCMD_C2H_REC_ACK_FUNC_MSK 0xff
#define FWCMD_C2H_REC_ACK_H2C_SEQ_SH 16
#define FWCMD_C2H_REC_ACK_H2C_SEQ_MSK 0xff
#define FWCMD_C2H_DONE_ACK_CAT_SH 0
#define FWCMD_C2H_DONE_ACK_CAT_MSK 0x3
#define FWCMD_C2H_DONE_ACK_CLASS_SH 2
#define FWCMD_C2H_DONE_ACK_CLASS_MSK 0x3f
#define FWCMD_C2H_DONE_ACK_FUNC_SH 8
#define FWCMD_C2H_DONE_ACK_FUNC_MSK 0xff
#define FWCMD_C2H_DONE_ACK_H2C_RETURN_SH 16
#define FWCMD_C2H_DONE_ACK_H2C_RETURN_MSK 0xff
#define FWCMD_C2H_DONE_ACK_H2C_SEQ_SH 24
#define FWCMD_C2H_DONE_ACK_H2C_SEQ_MSK 0xff
#define FWCMD_C2H_C2H_LOG_LOG_MSG_SH 0
#define FWCMD_C2H_C2H_LOG_LOG_MSG_MSK 0xffffffff
#define FWCMD_C2H_BCN_CNT_PORT_MBSSID_IDX_SH 0
#define FWCMD_C2H_BCN_CNT_PORT_MBSSID_IDX_MSK 0x7f
#define FWCMD_C2H_BCN_CNT_BAND_IDX BIT(7)
#define FWCMD_C2H_BCN_CNT_CCA_FAIL_CNT_SH 8
#define FWCMD_C2H_BCN_CNT_CCA_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_EDCCA_FAIL_CNT_SH 12
#define FWCMD_C2H_BCN_CNT_EDCCA_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_NAV_FAIL_CNT_SH 16
#define FWCMD_C2H_BCN_CNT_NAV_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_TXON_FAIL_CNT_SH 20
#define FWCMD_C2H_BCN_CNT_TXON_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_MAC_FAIL_CNT_SH 24
#define FWCMD_C2H_BCN_CNT_MAC_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_OTHERS_FAIL_CNT_SH 28
#define FWCMD_C2H_BCN_CNT_OTHERS_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_LOCK_FAIL_CNT_SH 0
#define FWCMD_C2H_BCN_CNT_LOCK_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_CMP_FAIL_CNT_SH 4
#define FWCMD_C2H_BCN_CNT_CMP_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_INVALID_FAIL_CNT_SH 8
#define FWCMD_C2H_BCN_CNT_INVALID_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_SRCHEND_FAIL_CNT_SH 12
#define FWCMD_C2H_BCN_CNT_SRCHEND_FAIL_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CNT_OK_CNT_SH 16
#define FWCMD_C2H_BCN_CNT_OK_CNT_MSK 0xf
#define FWCMD_C2H_BCN_CSAZERO_PORT_MBSSID_IDX_SH 0
#define FWCMD_C2H_BCN_CSAZERO_PORT_MBSSID_IDX_MSK 0x7f
#define FWCMD_C2H_BCN_CSAZERO_BAND_IDX BIT(7)
#define FWCMD_C2H_EFUSE_DUMP_UUID0_SH 16
#define FWCMD_C2H_EFUSE_DUMP_UUID0_MSK 0xff
#define FWCMD_C2H_EFUSE_DUMP_UUID2_SH 24
#define FWCMD_C2H_EFUSE_DUMP_UUID2_MSK 0xff
#define FWCMD_C2H_EFUSE_DUMP_RX_SPATIAL_STREAM_REMARK_SH 24
#define FWCMD_C2H_EFUSE_DUMP_RX_SPATIAL_STREAM_REMARK_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_RX_SPATIAL_STREAM_SH 28
#define FWCMD_C2H_EFUSE_DUMP_RX_SPATIAL_STREAM_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_HCI_TYPE_SH 0
#define FWCMD_C2H_EFUSE_DUMP_HCI_TYPE_MSK 0xf
#define FWCMD_C2H_EFUSE_DUMP_BANDWIDTH_SH 8
#define FWCMD_C2H_EFUSE_DUMP_BANDWIDTH_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_TX_SPATIAL_STREAM_SH 12
#define FWCMD_C2H_EFUSE_DUMP_TX_SPATIAL_STREAM_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_ANT_TX_NUM_SH 16
#define FWCMD_C2H_EFUSE_DUMP_ANT_TX_NUM_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_ANT_RX_NUM_SH 20
#define FWCMD_C2H_EFUSE_DUMP_ANT_RX_NUM_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_CP_TEST_PATTEN0_SH 24
#define FWCMD_C2H_EFUSE_DUMP_CP_TEST_PATTEN0_MSK 0xff
#define FWCMD_C2H_EFUSE_DUMP_CP_TEST_PATTEN1_SH 0
#define FWCMD_C2H_EFUSE_DUMP_CP_TEST_PATTEN1_MSK 0xff
#define FWCMD_C2H_EFUSE_DUMP_PROTOCOL_REMARK_80211_SH 8
#define FWCMD_C2H_EFUSE_DUMP_PROTOCOL_REMARK_80211_MSK 0x3
#define FWCMD_C2H_EFUSE_DUMP_PROTOCOL_80211_SH 10
#define FWCMD_C2H_EFUSE_DUMP_PROTOCOL_80211_MSK 0x3
#define FWCMD_C2H_EFUSE_DUMP_NIC_ROUTER_REMARK_SH 12
#define FWCMD_C2H_EFUSE_DUMP_NIC_ROUTER_REMARK_MSK 0x3
#define FWCMD_C2H_EFUSE_DUMP_NIC_ROUTER_SH 14
#define FWCMD_C2H_EFUSE_DUMP_NIC_ROUTER_MSK 0x3
#define FWCMD_C2H_EFUSE_DUMP_ANT_TX_NUM_REMARK_SH 16
#define FWCMD_C2H_EFUSE_DUMP_ANT_TX_NUM_REMARK_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_ANT_RX_NUM_REMARK_SH 20
#define FWCMD_C2H_EFUSE_DUMP_ANT_RX_NUM_REMARK_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_BANDWIDTH_REMARK_SH 24
#define FWCMD_C2H_EFUSE_DUMP_BANDWIDTH_REMARK_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_TX_SPATIAL_STREAM_REMARK_SH 28
#define FWCMD_C2H_EFUSE_DUMP_TX_SPATIAL_STREAM_REMARK_MSK 0x7
#define FWCMD_C2H_EFUSE_DUMP_WL_FUNCTION_SUPPORT_SH 0
#define FWCMD_C2H_EFUSE_DUMP_WL_FUNCTION_SUPPORT_MSK 0xf
#define FWCMD_C2H_EFUSE_DUMP_HW_SPECIAL_TYPE_SH 4
#define FWCMD_C2H_EFUSE_DUMP_HW_SPECIAL_TYPE_MSK 0xf
#define FWCMD_C2H_EFUSE_DUMP_UUID3_SH 0
#define FWCMD_C2H_EFUSE_DUMP_UUID3_MSK 0xff
#define FWCMD_C2H_EFUSE_DUMP_UUID1_SH 8
#define FWCMD_C2H_EFUSE_DUMP_UUID1_MSK 0xff
#define FWCMD_C2H_EFUSE_DUMP_PFID_SH 16
#define FWCMD_C2H_EFUSE_DUMP_PFID_MSK 0xff
#define FWCMD_C2H_READ_RSP_VALUE_LEN_SH 0
#define FWCMD_C2H_READ_RSP_VALUE_LEN_MSK 0x7ff
#define FWCMD_C2H_READ_RSP_LS BIT(15)
#define FWCMD_C2H_READ_RSP_OFLD_ID_SH 16
#define FWCMD_C2H_READ_RSP_OFLD_ID_MSK 0xff
#define FWCMD_C2H_READ_RSP_ENTRY_NUM_SH 24
#define FWCMD_C2H_READ_RSP_ENTRY_NUM_MSK 0xff
#define FWCMD_C2H_READ_RSP_OFFSET_SH 0
#define FWCMD_C2H_READ_RSP_OFFSET_MSK 0xffff
#define FWCMD_C2H_READ_RSP_START_SH 0
#define FWCMD_C2H_READ_RSP_START_MSK 0xffffffff
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_ID_SH 0
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_ID_MSK 0xff
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_OP_SH 8
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_OP_MSK 0x7
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_LENGTH_SH 16
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_LENGTH_MSK 0xffff
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_CONTENT_SH 0
#define FWCMD_C2H_PKT_OFLD_RSP_PKT_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_1_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_1_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_2_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_2_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_3_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_3_MSK 0xffffffff
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_4_SH 0
#define FWCMD_C2H_MACID_PAUSE_STATUS_GRP_4_MSK 0xffffffff
#define FWCMD_C2H_FW_GETPKT_RPT_MACID_SH 0
#define FWCMD_C2H_FW_GETPKT_RPT_MACID_MSK 0xff
#define FWCMD_C2H_FW_GETPKT_RPT_PKT_TYPE_SH 8
#define FWCMD_C2H_FW_GETPKT_RPT_PKT_TYPE_MSK 0xf
#define FWCMD_C2H_TSF32_TOGL_RPT_BAND BIT(0)
#define FWCMD_C2H_TSF32_TOGL_RPT_PORT_SH 1
#define FWCMD_C2H_TSF32_TOGL_RPT_PORT_MSK 0x7
#define FWCMD_C2H_TSF32_TOGL_RPT_STATUS_SH 4
#define FWCMD_C2H_TSF32_TOGL_RPT_STATUS_MSK 0xfff
#define FWCMD_C2H_TSF32_TOGL_RPT_EARLY_SH 16
#define FWCMD_C2H_TSF32_TOGL_RPT_EARLY_MSK 0xffff
#define FWCMD_C2H_TSF32_TOGL_RPT_TSF_L_SH 0
#define FWCMD_C2H_TSF32_TOGL_RPT_TSF_L_MSK 0xffffffff
#define FWCMD_C2H_TSF32_TOGL_RPT_TSF_H_SH 0
#define FWCMD_C2H_TSF32_TOGL_RPT_TSF_H_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_RPT_MODE_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_RPT_MODE_MSK 0x7
#define FWCMD_C2H_USR_TX_RPT_INFO_MACID_SH 8
#define FWCMD_C2H_USR_TX_RPT_INFO_MACID_MSK 0xff
#define FWCMD_C2H_USR_TX_RPT_INFO_AC_SH 16
#define FWCMD_C2H_USR_TX_RPT_INFO_AC_MSK 0x3
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_BE_1K_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_BE_1K_MSK 0xffff
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_BK_1K_SH 16
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_BK_1K_MSK 0xffff
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_VI_1K_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_VI_1K_MSK 0xffff
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_VO_1K_SH 16
#define FWCMD_C2H_USR_TX_RPT_INFO_PENDING_VO_1K_MSK 0xffff
#define FWCMD_C2H_USR_TX_RPT_INFO_FREERUN_CNT_FIRST_IN_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_FREERUN_CNT_FIRST_IN_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_FREERUN_CNT_FIRST_OUT_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_FREERUN_CNT_FIRST_OUT_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_FREERUN_CNT_LAST_OUT_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_FREERUN_CNT_LAST_OUT_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_BE_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_BE_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_BK_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_BK_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_VI_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_VI_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_VO_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_DROP_NUM_VO_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_BE_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_BE_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_BK_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_BK_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_VI_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_VI_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_VO_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_TX_OK_NUM_VO_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_RX_CLEAR_US_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_RX_CLEAR_US_MSK 0xffffffff
#define FWCMD_C2H_USR_TX_RPT_INFO_BUSY_US_SH 0
#define FWCMD_C2H_USR_TX_RPT_INFO_BUSY_US_MSK 0xffffffff
#define FWCMD_C2H_CMD_OFLD_RSP_RESULT BIT(0)
#define FWCMD_C2H_CMD_OFLD_RSP_CMD_NUM_SH 8
#define FWCMD_C2H_CMD_OFLD_RSP_CMD_NUM_MSK 0xff
#define FWCMD_C2H_CMD_OFLD_RSP_OFFSET_SH 0
#define FWCMD_C2H_CMD_OFLD_RSP_OFFSET_MSK 0xffffffff
#define FWCMD_C2H_CMD_OFLD_RSP_EXP_VAL_SH 0
#define FWCMD_C2H_CMD_OFLD_RSP_EXP_VAL_MSK 0xffffffff
#define FWCMD_C2H_CMD_OFLD_RSP_R_VAL_SH 0
#define FWCMD_C2H_CMD_OFLD_RSP_R_VAL_MSK 0xffffffff
#define FWCMD_C2H_WAIT_ANNOUNCE_WAIT_CASE_SH 0
#define FWCMD_C2H_WAIT_ANNOUNCE_WAIT_CASE_MSK 0xf
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID0_SH 8
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID0_MSK 0xff
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID1_SH 16
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID1_MSK 0xff
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID2_SH 24
#define FWCMD_C2H_WAIT_ANNOUNCE_MACID2_MSK 0xff
#define FWCMD_C2H_AOAC_REPORT_AOAC_REPORT_SH 0
#define FWCMD_C2H_AOAC_REPORT_AOAC_REPORT_MSK 0xffffffff
#define FWCMD_C2H_READ_WOW_CAM_VALUE_LEN_SH 0
#define FWCMD_C2H_READ_WOW_CAM_VALUE_LEN_MSK 0x7ff
#define FWCMD_C2H_READ_WOW_CAM_IDX_SH 24
#define FWCMD_C2H_READ_WOW_CAM_IDX_MSK 0xff
#define FWCMD_C2H_READ_WOW_CAM_WOW_CAM_SH 0
#define FWCMD_C2H_READ_WOW_CAM_WOW_CAM_MSK 0xffffffff
#define FWCMD_C2H_MCC_RCV_ACK_GROUP_SH 0
#define FWCMD_C2H_MCC_RCV_ACK_GROUP_MSK 0x3
#define FWCMD_C2H_MCC_RCV_ACK_H2C_FUNC_SH 8
#define FWCMD_C2H_MCC_RCV_ACK_H2C_FUNC_MSK 0xff
#define FWCMD_C2H_MCC_REQ_ACK_GROUP_SH 0
#define FWCMD_C2H_MCC_REQ_ACK_GROUP_MSK 0x3
#define FWCMD_C2H_MCC_REQ_ACK_H2C_RETURN_SH 2
#define FWCMD_C2H_MCC_REQ_ACK_H2C_RETURN_MSK 0x3f
#define FWCMD_C2H_MCC_REQ_ACK_H2C_FUNC_SH 8
#define FWCMD_C2H_MCC_REQ_ACK_H2C_FUNC_MSK 0xff
#define FWCMD_C2H_MCC_TSF_RPT_MACID_X_SH 0
#define FWCMD_C2H_MCC_TSF_RPT_MACID_X_MSK 0xff
#define FWCMD_C2H_MCC_TSF_RPT_MACID_Y_SH 8
#define FWCMD_C2H_MCC_TSF_RPT_MACID_Y_MSK 0xff
#define FWCMD_C2H_MCC_TSF_RPT_GROUP_SH 16
#define FWCMD_C2H_MCC_TSF_RPT_GROUP_MSK 0x3
#define FWCMD_C2H_MCC_TSF_RPT_TSF_LOW_X_SH 0
#define FWCMD_C2H_MCC_TSF_RPT_TSF_LOW_X_MSK 0xffffffff
#define FWCMD_C2H_MCC_TSF_RPT_TSF_HIGH_X_SH 0
#define FWCMD_C2H_MCC_TSF_RPT_TSF_HIGH_X_MSK 0xffffffff
#define FWCMD_C2H_MCC_TSF_RPT_TSF_LOW_Y_SH 0
#define FWCMD_C2H_MCC_TSF_RPT_TSF_LOW_Y_MSK 0xffffffff
#define FWCMD_C2H_MCC_TSF_RPT_TSF_HIGH_Y_SH 0
#define FWCMD_C2H_MCC_TSF_RPT_TSF_HIGH_Y_MSK 0xffffffff
#define FWCMD_C2H_MCC_STATUS_RPT_STATUS_SH 0
#define FWCMD_C2H_MCC_STATUS_RPT_STATUS_MSK 0x3f
#define FWCMD_C2H_MCC_STATUS_RPT_GROUP_SH 6
#define FWCMD_C2H_MCC_STATUS_RPT_GROUP_MSK 0x3
#define FWCMD_C2H_MCC_STATUS_RPT_MACID_SH 8
#define FWCMD_C2H_MCC_STATUS_RPT_MACID_MSK 0xff
#define FWCMD_C2H_MCC_STATUS_RPT_TSF_LOW_SH 0
#define FWCMD_C2H_MCC_STATUS_RPT_TSF_LOW_MSK 0xffffffff
#define FWCMD_C2H_MCC_STATUS_RPT_TSF_HIGH_SH 0
#define FWCMD_C2H_MCC_STATUS_RPT_TSF_HIGH_MSK 0xffffffff
#define FWCMD_C2H_PLAT_FLASH_WRITE_ADDR_SH 0
#define FWCMD_C2H_PLAT_FLASH_WRITE_ADDR_MSK 0xffffffff
#define FWCMD_C2H_PLAT_FLASH_WRITE_LENGTH_SH 0
#define FWCMD_C2H_PLAT_FLASH_WRITE_LENGTH_MSK 0xffffffff
#define FWCMD_C2H_PLAT_FLASH_ERASE_ADDR_SH 0
#define FWCMD_C2H_PLAT_FLASH_ERASE_ADDR_MSK 0xffffffff
#define FWCMD_C2H_PLAT_FLASH_ERASE_LENGTH_SH 0
#define FWCMD_C2H_PLAT_FLASH_ERASE_LENGTH_MSK 0xffffffff
#define FWCMD_C2H_PLAT_FLASH_READ_ADDR_SH 0
#define FWCMD_C2H_PLAT_FLASH_READ_ADDR_MSK 0xffffffff
#define FWCMD_C2H_PLAT_FLASH_READ_LENGTH_SH 0
#define FWCMD_C2H_PLAT_FLASH_READ_LENGTH_MSK 0xffffffff
#define FWCMD_C2H_PLAT_FLASH_READ_PAYLOAD_SH 0
#define FWCMD_C2H_PLAT_FLASH_READ_PAYLOAD_MSK 0xffffffff
#define FWCMD_C2H_FCS_RPT_STATUS_SH 0
#define FWCMD_C2H_FCS_RPT_STATUS_MSK 0xffffffff
#define FWCMD_C2H_WPS_RPT_STATE_SH 0
#define FWCMD_C2H_WPS_RPT_STATE_MSK 0xff
#define FWCMD_C2H_PORT_INIT_STAT_BAND BIT(0)
#define FWCMD_C2H_PORT_INIT_STAT_PORT_SH 1
#define FWCMD_C2H_PORT_INIT_STAT_PORT_MSK 0x7
#define FWCMD_C2H_PORT_INIT_STAT_CFG_MBID_IDX_SH 8
#define FWCMD_C2H_PORT_INIT_STAT_CFG_MBID_IDX_MSK 0xff
#define FWCMD_C2H_PORT_INIT_STAT_CFG_TYPE_SH 16
#define FWCMD_C2H_PORT_INIT_STAT_CFG_TYPE_MSK 0xff
#define FWCMD_C2H_PORT_INIT_STAT_STEP_SH 24
#define FWCMD_C2H_PORT_INIT_STAT_STEP_MSK 0xff
#define FWCMD_C2H_PORT_INIT_STAT_CFG_VAL_SH 0
#define FWCMD_C2H_PORT_INIT_STAT_CFG_VAL_MSK 0xffffffff
#define FWCMD_C2H_PORT_INIT_STAT_RET_SH 0
#define FWCMD_C2H_PORT_INIT_STAT_RET_MSK 0xffffffff
#define FWCMD_C2H_PORT_CFG_STAT_BAND BIT(0)
#define FWCMD_C2H_PORT_CFG_STAT_PORT_SH 1
#define FWCMD_C2H_PORT_CFG_STAT_PORT_MSK 0x7
#define FWCMD_C2H_PORT_CFG_STAT_MBSSID_IDX_SH 8
#define FWCMD_C2H_PORT_CFG_STAT_MBSSID_IDX_MSK 0xff
#define FWCMD_C2H_PORT_CFG_STAT_TYPE_SH 16
#define FWCMD_C2H_PORT_CFG_STAT_TYPE_MSK 0xff
#define FWCMD_C2H_PORT_CFG_STAT_VAL_SH 0
#define FWCMD_C2H_PORT_CFG_STAT_VAL_MSK 0xffffffff
#define FWCMD_C2H_PORT_CFG_STAT_RET_SH 0
#define FWCMD_C2H_PORT_CFG_STAT_RET_MSK 0xffffffff

//
//C2HPKT - CAT(OutSrc, Phydm)
//
#define C2H_HDR_CAT_SH 0
#define C2H_HDR_CAT_MSK 0x3
#define C2H_HDR_CLASS_SH 2
#define C2H_HDR_CLASS_MSK 0x3f
#define C2H_HDR_FUNC_SH 8
#define C2H_HDR_FUNC_MSK 0xff
#define C2H_HDR_DEL_TYPE_SH 16
#define C2H_HDR_DEL_TYPE_MSK 0xf
#define C2H_HDR_C2H_SEQ_SH 24
#define C2H_HDR_C2H_SEQ_MSK 0xff
#define C2H_HDR_TOTAL_LEN_SH 0
#define C2H_HDR_TOTAL_LEN_MSK 0x3fff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff

//
//C2HPKT - CAT(OutSrc, RF)
//
#define C2H_HDR_CAT_SH 0
#define C2H_HDR_CAT_MSK 0x3
#define C2H_HDR_CLASS_SH 2
#define C2H_HDR_CLASS_MSK 0x3f
#define C2H_HDR_FUNC_SH 8
#define C2H_HDR_FUNC_MSK 0xff
#define C2H_HDR_DEL_TYPE_SH 16
#define C2H_HDR_DEL_TYPE_MSK 0xf
#define C2H_HDR_C2H_SEQ_SH 24
#define C2H_HDR_C2H_SEQ_MSK 0xff
#define C2H_HDR_TOTAL_LEN_SH 0
#define C2H_HDR_TOTAL_LEN_MSK 0x3fff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff

//
//C2HPKT - CAT(OutSrc, BTC)
//
#define C2H_HDR_CAT_SH 0
#define C2H_HDR_CAT_MSK 0x3
#define C2H_HDR_CLASS_SH 2
#define C2H_HDR_CLASS_MSK 0x3f
#define C2H_HDR_FUNC_SH 8
#define C2H_HDR_FUNC_MSK 0xff
#define C2H_HDR_DEL_TYPE_SH 16
#define C2H_HDR_DEL_TYPE_MSK 0xf
#define C2H_HDR_C2H_SEQ_SH 24
#define C2H_HDR_C2H_SEQ_MSK 0xff
#define C2H_HDR_TOTAL_LEN_SH 0
#define C2H_HDR_TOTAL_LEN_MSK 0x3fff
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_SH 0
#define FWCMD_C2H_EXAMPLE_EXAMPLE_CONTENT_MSK 0xffffffff

// struct for halmac//
struct fwcmd_hdr {
	u32 hdr0;
	u32 hdr1;
};

//
//H2CREG
//
struct fwcmd_h2creg_hdr {
	u32 dword0;
};

struct fwcmd_h2creg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_h2creg_lb {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_cnsl_cmd {
	u32 dword0;
};

struct fwcmd_fwerr {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_hidden_get {
	u32 dword0;
};

struct fwcmd_getpkt_inform {
	u32 dword0;
};

struct fwcmd_sch_tx_en {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_wow_trx_stop {
	u32 dword0;
};


//
//C2HREG
//
struct fwcmd_c2hreg_hdr {
	u32 dword0;
};

struct fwcmd_c2hreg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_c2hreg_lb {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_err_rpt {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_err_msg {
	u32 dword0;
};

struct fwcmd_efuse_hidden {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_tx_pause_rpt {
	u32 dword0;
};

struct fwcmd_aoac_rpt_1 {
	u32 dword0;
};

struct fwcmd_aoac_rpt_2 {
	u32 dword0;
};

struct fwcmd_aoac_rpt_3 {
	u32 dword0;
};

struct fwcmd_io_ofld_result {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};


//
//H2CPKT - CAT(TEST)
//
struct fwcmd_h2c_lb {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_plat_spic_test {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_plat_fl_write {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_plat_fl_erase {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_pl_flash_read {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_long_run {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_lps_test {
	u32 dword0;
};

struct fwcmd_lps_onoff_test {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_fw_status {
	u32 dword0;
};


//
//H2CPKT - CAT(MAC)
//
struct fwcmd_log_cfg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_general_pkt {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_c2h_rpt_cfg {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_wlan_dump_cmd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_fw_dbgreg_cfg {
	u32 dword0;
};

struct fwcmd_keep_alive {
	u32 dword0;
};

struct fwcmd_disconnect_detect {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_wow_global {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_gtk_ofld {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_arp_ofld {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_ndp_ofld {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_realwow {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_nlo {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_wakeup_ctrl {
	u32 dword0;
};

struct fwcmd_negative_pattern {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_dev2hst_gpio {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_uphy_ctrl {
	u32 dword0;
};

struct fwcmd_wow_cam_upd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_aoac_report_req {
	u32 dword0;
};

struct fwcmd_wow_stop_fw_trx {
	u32 dword0;
};

struct fwcmd_lps_parm {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_p2p_act {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_fwhdr_dl {
	u32 dword0;
};

struct fwcmd_fwhdr_redl {
	u32 dword0;
};

struct fwcmd_twt_announce_upd {
	u32 dword0;
};

struct fwcmd_twtinfo_upd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_twt_stansp_upd {
	u32 dword0;
};

struct fwcmd_tblud {
	u32 dword0;
};

struct fwcmd_dctlinfo_ud {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
};

struct fwcmd_cctlinfo_ud {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
};

struct fwcmd_shcut_update {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
};

struct fwcmd_bcn_upd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_ss_ulsta_upd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_f2pdbg_set {
	u32 dword0;
};

struct fwcmd_wlaninfo_get {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_addrcam_info {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
};

struct fwcmd_joininfo {
	u32 dword0;
};

struct fwcmd_dl_grp_upd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_ul_grp_upd {
	u32 dword0;
};

struct fwcmd_mu_sta_upd {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_fwrole_maintain {
	u32 dword0;
};

struct fwcmd_dump_efuse {
	u32 dword0;
};

struct fwcmd_packet_ofld {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_read_ofld {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_write_ofld {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_conf_ofld {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_sys_init {
	u32 dword0;
};

struct fwcmd_trx_init {
	u32 dword0;
};

struct fwcmd_intf_init {
	u32 dword0;
};

struct fwcmd_macid_pause {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_rx_fwd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
};

struct fwcmd_en_mac_hdr_conv {
	u32 dword0;
};

struct fwcmd_set_hwseq_reg {
	u32 dword0;
};

struct fwcmd_hwamsdu_reg {
	u32 dword0;
};

struct fwcmd_amsdu_cut_reg {
	u32 dword0;
};

struct fwcmd_tcpip_chksum_offload_reg {
	u32 dword0;
};

struct fwcmd_usr_edca {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_tsf32_togl {
	u32 dword0;
};

struct fwcmd_cmd_ofld_reg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_usr_tx_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_cmd_ofld_pkt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_ofld_cfg {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_seccam_info {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_set_snd_para {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
	u32 dword28;
	u32 dword29;
	u32 dword30;
	u32 dword31;
	u32 dword32;
	u32 dword33;
	u32 dword34;
	u32 dword35;
	u32 dword36;
	u32 dword37;
	u32 dword38;
	u32 dword39;
	u32 dword40;
	u32 dword41;
	u32 dword42;
	u32 dword43;
	u32 dword44;
	u32 dword45;
	u32 dword46;
	u32 dword47;
	u32 dword48;
	u32 dword49;
	u32 dword50;
	u32 dword51;
	u32 dword52;
	u32 dword53;
	u32 dword54;
	u32 dword55;
	u32 dword56;
	u32 dword57;
	u32 dword58;
	u32 dword59;
	u32 dword60;
	u32 dword61;
	u32 dword62;
	u32 dword63;
	u32 dword64;
	u32 dword65;
	u32 dword66;
	u32 dword67;
	u32 dword68;
	u32 dword69;
	u32 dword70;
	u32 dword71;
	u32 dword72;
	u32 dword73;
	u32 dword74;
	u32 dword75;
	u32 dword76;
	u32 dword77;
};

struct fwcmd_get_csi_buf {
	u32 dword0;
};

struct fwcmd_set_csi_buf {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_get_snd_sts {
	u32 dword0;
};

struct fwcmd_set_snd_sts {
	u32 dword0;
};

struct fwcmd_init_snd_mer {
	u32 dword0;
};

struct fwcmd_init_snd_mee {
	u32 dword0;
};

struct fwcmd_csi_fix_rate {
	u32 dword0;
};

struct fwcmd_csi_rrsc {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_set_mu_table {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
};

struct fwcmd_set_csi_para_reg {
	u32 dword0;
};

struct fwcmd_hw_snd_pr {
	u32 dword0;
};

struct fwcmd_set_snd_para_v1 {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
	u32 dword17;
	u32 dword18;
	u32 dword19;
	u32 dword20;
	u32 dword21;
	u32 dword22;
	u32 dword23;
	u32 dword24;
	u32 dword25;
	u32 dword26;
	u32 dword27;
	u32 dword28;
	u32 dword29;
	u32 dword30;
	u32 dword31;
	u32 dword32;
	u32 dword33;
	u32 dword34;
	u32 dword35;
	u32 dword36;
	u32 dword37;
	u32 dword38;
	u32 dword39;
	u32 dword40;
	u32 dword41;
	u32 dword42;
	u32 dword43;
	u32 dword44;
	u32 dword45;
	u32 dword46;
	u32 dword47;
	u32 dword48;
	u32 dword49;
	u32 dword50;
	u32 dword51;
	u32 dword52;
	u32 dword53;
	u32 dword54;
	u32 dword55;
	u32 dword56;
	u32 dword57;
	u32 dword58;
	u32 dword59;
	u32 dword60;
	u32 dword61;
	u32 dword62;
	u32 dword63;
	u32 dword64;
	u32 dword65;
	u32 dword66;
	u32 dword67;
	u32 dword68;
	u32 dword69;
	u32 dword70;
	u32 dword71;
	u32 dword72;
	u32 dword73;
	u32 dword74;
	u32 dword75;
	u32 dword76;
	u32 dword77;
	u32 dword78;
	u32 dword79;
	u32 dword80;
	u32 dword81;
	u32 dword82;
	u32 dword83;
	u32 dword84;
	u32 dword85;
	u32 dword86;
	u32 dword87;
	u32 dword88;
	u32 dword89;
	u32 dword90;
	u32 dword91;
	u32 dword92;
	u32 dword93;
	u32 dword94;
	u32 dword95;
	u32 dword96;
	u32 dword97;
	u32 dword98;
	u32 dword99;
	u32 dword100;
	u32 dword101;
	u32 dword102;
	u32 dword103;
};

struct fwcmd_ba_cam {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_ie_cam {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_add_mcc {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_start_mcc {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_stop_mcc {
	u32 dword0;
};

struct fwcmd_del_mcc_group {
	u32 dword0;
};

struct fwcmd_reset_mcc_group {
	u32 dword0;
};

struct fwcmd_mcc_req_tsf {
	u32 dword0;
};

struct fwcmd_mcc_macid_bitmap {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_mcc_sync {
	u32 dword0;
};

struct fwcmd_mcc_set_duration {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_scsi_tx {
	u32 dword0;
};

struct fwcmd_usb_switch {
	u32 dword0;
};

typedef struct _H2C_AGG_ {
	/* dword0 */
	u32 pld;
} H2C_AGG, *PH2C_AGG;

struct fwcmd_plat_flash_write {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_plat_flash_erase {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_plat_flash_read {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_fcs {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
};

struct fwcmd_cfg_wps {
	u32 dword0;
};

struct fwcmd_port_init {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_port_cfg {
	u32 dword0;
	u32 dword1;
};


//
//H2CPKT - CAT(Table)
//
struct fwcmd_mude_para_tblud {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_mudecision_para {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_mu_fixinfo {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_ul_fixinfo_tblud {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
	u32 dword16;
};

struct fwcmd_ul_fixinfo {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
};

struct fwcmd_ul_fixinfo_sta_info {
	u32 dword0;
};

struct fwcmd_ul_fixinfo_ul_rua_sta_ent {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_addr_cam {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
};

struct fwcmd_bssid_cam {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_sec_cam {
	u32 dword0;
};

struct fwcmd_fixmode_para_tblud {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_fixmode_para {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_write_ofld_req {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_read_ofld_req {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_conf_ofld_req_cmd {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_dctrl {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_cctrl {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_ie_cam_info {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_plat_auto_test {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
};

struct fwcmd_h2creg_sch_tx_pause {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_cmd_ofld {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};


//
//H2CPKT - CAT(OutSrc,Phydm)
//
struct fwcmd_example {
	u32 dword0;
};

struct fwcmd_macid_cfg {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_rssi_ra_config {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};


//
//H2CPKT - CAT(OutSrc, RF)
//

//
//H2CPKT - CAT(OutSrc, BTC)
//
struct fwcmd_tdma {
	u32 dword0;
};


//
//C2HPKT - CAT(TEST)
//
struct fwcmd_c2h_lb {
	u32 dword0;
};

struct fwcmd_test_phy_rpt {
	u32 dword0;
};

struct fwcmd_spic {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_spic2 {
	u32 dword0;
	u32 dword1;
};


//
//C2HPKT - CAT(MAC)
//
struct fwcmd_rec_ack {
	u32 dword0;
};

struct fwcmd_done_ack {
	u32 dword0;
};

struct fwcmd_c2h_log {
	u32 dword0;
};

struct fwcmd_bcn_cnt {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_bcn_csazero {
	u32 dword0;
};

struct fwcmd_efuse_dump {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
};

struct fwcmd_read_rsp {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_pkt_ofld_rsp {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_fw_getpkt_rpt {
	u32 dword0;
};

struct fwcmd_tsf32_togl_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_usr_tx_rpt_info {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
	u32 dword5;
	u32 dword6;
	u32 dword7;
	u32 dword8;
	u32 dword9;
	u32 dword10;
	u32 dword11;
	u32 dword12;
	u32 dword13;
	u32 dword14;
	u32 dword15;
};

struct fwcmd_cmd_ofld_rsp {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
};

struct fwcmd_wait_announce {
	u32 dword0;
};

struct fwcmd_aoac_report {
	u32 dword0;
};

struct fwcmd_read_wow_cam {
	u32 dword0;
	u32 dword1;
};

struct fwcmd_mcc_rcv_ack {
	u32 dword0;
};

struct fwcmd_mcc_req_ack {
	u32 dword0;
};

struct fwcmd_mcc_tsf_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
	u32 dword3;
	u32 dword4;
};

struct fwcmd_mcc_status_rpt {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_rx_dbg {
	u32 dword0;
};

struct fwcmd_scsi_rx {
	u32 dword0;
};

struct fwcmd_fcs_rpt {
	u32 dword0;
};

struct fwcmd_wps_rpt {
	u32 dword0;
};

struct fwcmd_port_init_stat {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};

struct fwcmd_port_cfg_stat {
	u32 dword0;
	u32 dword1;
	u32 dword2;
};


//
//C2HPKT - CAT(OutSrc, Phydm)
//

//
//C2HPKT - CAT(OutSrc, RF)
//

//
//C2HPKT - CAT(OutSrc, BTC)
//

#endif
