#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
TOP_SRCDIR=${TOP_SRCDIR-"../../../rheolef"}
GEODIR=${GEODIR-"../../../rheolef/nfem/data"}
BINDIR=../bin
COL=${COL-"col"}

status=0

#
# io-tests
#
qmgcad_list=`/bin/ls ${GEODIR}/*.qmgcad`
for x in ${qmgcad_list}; do
    echo "      ${COL} < $x | ${BINDIR}/cad -input-qmg -cad -"
    ${COL} < $x | ${BINDIR}/cad -input-qmg -cad - >/dev/null 2>/dev/null
    if test $? -ne 0; then status=1; echo "        => *NO*"; fi
done
#
# qmg2cad conversion
#
echo "      ${COL} < ${GEODIR}/square-qmg.qmgcad | ${BINDIR}/cad -input-qmg -cad -"
${COL} < ${GEODIR}/square-qmg.qmgcad | ${BINDIR}/cad -input-qmg -cad - 2>/dev/null | \
    diff -bw ${GEODIR}/square-qmg.cad - # >/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

exit ${status}

