#!/bin/sh

PWD=`pwd`
PF="$PWD/sandbox"

LIB_PATH="$PF/$PREFIX_LIB"

if [ "$LD_LIBRARY_PATH" = '' ]
then
 export LD_LIBRARY_PATH="$LIB_PATH"
else
 export LD_LIBRARY_PATH="$LIB_PATH:$LD_LIBRARY_PATH"
fi
export PATH="$LIB_PATH:$PATH"
export BIN_PATH="$PF/$PREFIX_BIN"

OK=0
FAILED=0

if [ "$TEST_NAME" != '' ]
then
 echo "Test Name       : $TEST_NAME"
 if [ "$TEST_DESC" != '' ]
 then
  echo "Test Description: $TEST_DESC"
 fi
 echo '---------------------'
fi

_ok() {
 OK=`expr $OK + 1`
}
_failed() {
 FAILED=`expr $FAILED + 1`
}

disp_sum() {
 SUM=`expr $OK + $FAILED`
 echo
 echo "Done $SUM tests: $OK ok, $FAILED failed."
 echo
}

ret() {
 exit $FAILED
}

#ll
