A link was used without a name parameter. Erroneous code example:

```ignore (cannot-test-this-because-rustdoc-stops-compile-fail-before-codegen)
#[link(kind = "dylib")] extern {}
// error: `#[link(...)]` specified without `name = "foo"`
```

Please add the name parameter to allow the rust compiler to find the library
you want. Example:

```no_run
#[link(kind = "dylib", name = "some_lib")] extern {} // ok!
```
