/****************************************************************************/
// Eclipse SUMO, Simulation of Urban MObility; see https://eclipse.org/sumo
// Copyright (C) 2001-2018 German Aerospace Center (DLR) and others.
// This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v2.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v20.html
// SPDX-License-Identifier: EPL-2.0
/****************************************************************************/
/// @file    GUITextures.h
/// @author  Pablo Alvarez Lopez
/// @date    Jul 2016
/// @version $Id$
///
// An enumeration of gifs used by the gui applications
/****************************************************************************/
#ifndef GUITextures_h
#define GUITextures_h


// ===========================================================================
// included modules
// ===========================================================================
#include <config.h>


// ===========================================================================
// enumerations
// ===========================================================================
/**
 * @enum GUITexture
 * @brief An enumeration of gifs used by the gui applications
 */
enum GUITexture {
    GNETEXTURE_E3 = 0,
    GNETEXTURE_E3SELECTED,
    GNETEXTURE_EMPTY,
    GNETEXTURE_EMPTYSELECTED,
    GNETEXTURE_LOCK,
    GNETEXTURE_LOCKSELECTED,
    GNETEXTURE_NOTMOVING,
    GNETEXTURE_NOTMOVINGSELECTED,
    GNETEXTURE_REROUTER,
    GNETEXTURE_REROUTERSELECTED,
    GNETEXTURE_ROUTEPROBE,
    GNETEXTURE_ROUTEPROBESELECTED,
    GNETEXTURE_TLS,
    GNETEXTURE_VAPORIZER,
    GNETEXTURE_VAPORIZERSELECTED,
    GNETEXTURE_VARIABLESPEEDSIGN,
    GNETEXTURE_VARIABLESPEEDSIGNSELECTED,
    GNETEXTURE_LANEBIKE,
    GNETEXTURE_LANEBUS,
    GNETEXTURE_LANEPEDESTRIAN,
    GIF_MAX
};


#endif

/****************************************************************************/

