/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "uosmbox.h"

gint uos_proc_mbox		(UosFolderItem	*dest,
             const gchar	*mbox,
                         GHashTable	*folder_table){
    return proc_mbox		(dest,mbox,folder_table);
}

gint uos_proc_mbox_full	(UosFolderItem	*dest,
             const gchar	*mbox,
             GHashTable	*folder_table,
             gboolean	 apply_filter,
             gboolean	 filter_junk){
    return proc_mbox_full	(dest,mbox,folder_table,apply_filter,filter_junk);
}


gint uos_lock_mbox		(const gchar	*base,
             UosLockType	 type){
    return lock_mbox		(base,type);
}

gint uos_unlock_mbox	(const gchar	*base,
             gint		 fd,
             UosLockType	 type){
    return unlock_mbox	(base,fd,type);
}

gint uos_copy_mbox		(const gchar	*src,
             const gchar	*dest){
    return copy_mbox		(src,dest);
}

void uos_empty_mbox		(const gchar	*mbox){
    empty_mbox		(mbox);
}

