/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __UOSSSL_H__
#define __UOSSSL_H__

#include "libsylph/ssl.h"

#if USE_SSL
#include "uossocket.h"

typedef SSLMethod UosSSLMethod;
typedef SSLType UosSSLType;
typedef SSLVerifyFunc UosSSLVerifyFunc;

void uos_ssl_init				(void);
void uos_ssl_done				(void);
gboolean uos_ssl_init_socket		(UosSockInfo	*sockinfo, gchar **errorchar);
gboolean uos_ssl_init_socket_with_method	(UosSockInfo	*sockinfo,
                     UosSSLMethod	 method, char **errorchar);
void uos_ssl_done_socket			(UosSockInfo	*sockinfo);

void uos_ssl_set_verify_func		(UosSSLVerifyFunc	 func);

#endif /* USE_SSL */

#endif /* __UOSSSL_H__ */
