#!/bin/bash
# Match model name of machine, like "UX31A".

HEAD="[utcs]"

is_productname_exists() {
  local NAME="$1"
  grep -q "${NAME}" /sys/class/dmi/id/product_name 2>/dev/null
}

# Check PCI device with id
is_pci_exists() {
  local PCI_ID="$1"
  local PCI_INFO
  PCI_INFO=$(lspci -d "${PCI_ID}" 2>/dev/null)
  test -n "${PCI_INFO}"
}

is_usb_exists() {
  local USB_ID="$1"
  local USB_INFO
  USB_INFO="$(lsusb -d "${USB_ID}" 2>/dev/null)"
  test -n "${USB_INFO}"
}

is_linux_version_4_19() {
  local UNAME_R=`uname -r`
  local VERSION
  local PATCHLEVEL
  local SUBLEVEL
  VERSION="$(echo $UNAME_R | awk -F '[.-]' '{print $1}' 2>/dev/null)"
  PATCHLEVEL="$(echo $UNAME_R | awk -F '[.-]' '{print $2}' 2>/dev/null)"
  SUBLEVEL="$(echo $UNAME_R | awk -F '[.-]' '{print $3}' 2>/dev/null)"
  if [ $VERSION -eq 4 ] && [ $PATCHLEVEL -eq 19 ]; then
	  return 0
  else
	  return 1
  fi
}

is_linux_version_5_10() {
  local UNAME_R=`uname -r`
  local VERSION
  local PATCHLEVEL
  local SUBLEVEL
  VERSION="$(echo $UNAME_R | awk -F '[.-]' '{print $1}' 2>/dev/null)"
  PATCHLEVEL="$(echo $UNAME_R | awk -F '[.-]' '{print $2}' 2>/dev/null)"
  SUBLEVEL="$(echo $UNAME_R | awk -F '[.-]' '{print $3}' 2>/dev/null)"
  if [ $VERSION -eq 5 ] && [ $PATCHLEVEL -eq 10 ]; then
	  return 0
  else
	  return 1
  fi
}

is_installed() {
  local PKGNAME=$1
  local EXIST
  EXIST=$(dpkg --get-selections $PKGNAME 2>/dev/null)
  test -n "${EXIST}"
}

msg() {
	echo ${HEAD} "$1"
}

warn() {
	echo ${HEAD} "$1"
}

head() {
  echo ${HEAD} ${1}
}

force_overwrite_install() {
  local PKGNAME="$1"
  DEBIAN_FRONTEND="noninteractive" apt-get -y \
    -o Dpkg::Options::="--force-overwrite" \
    -o Dpkg::Options::="--force-confdef" \
    -o Dpkg::Options::="--force-confold" \
    --no-install-recommends --no-install-suggests \
    --allow-unauthenticated \
    install $PKGNAME
}

safe_install() {
  local PKGNAME="$1"
  DEBIAN_FRONTEND="noninteractive" apt-get -y \
    -o Dpkg::Options::="--force-confdef" \
    -o Dpkg::Options::="--force-confold" \
    --no-install-recommends --no-install-suggests \
    --allow-unauthenticated \
    install $PKGNAME
}

is_arch_x86_64() {
  local ARCH=`arch`
  if [ "$ARCH" == "x86_64" ]; then
    return 0
  else
    return 1
  fi
}

is_arch_aarch64() {
  local ARCH=`arch`
  if [ "$ARCH" == "aarch64" ]; then
    return 0
  else
    return 1
  fi
}

is_arch_loongarch() {
  local ARCH=`arch`
  if [ "$ARCH" == "loongarch64" ]; then
    return 0
  else
    return 1
  fi
}

is_arch_mips() {
  local ARCH=`arch`
  if [ "$ARCH" == "mips64el" ]; then
    return 0
  else
    return 1
  fi
}

is_arch_sw() {
  local ARCH=`arch`
  if [ "$ARCH" == "sw_64" ]; then
    return 0
  else
    return 1
  fi
}