/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.texture;

import org.j3d.renderer.java3d.texture.FixedTextureCache;
import org.j3d.renderer.java3d.texture.J3DTextureCache;
import org.j3d.renderer.java3d.texture.LRUTextureCache;
import org.j3d.renderer.java3d.texture.WeakRefTextureCache;
import org.j3d.texture.CacheAlreadySetException;
import org.j3d.texture.TextureCacheFactory;
import org.j3d.util.IntHashMap;

public class J3DTextureCacheFactory
implements TextureCacheFactory {
    private static final int NO_CACHE_SET = -1;
    private static final int DEFAULT_CACHE_ID = 1;
    private static IntHashMap cacheMap = new IntHashMap();
    private static int defaultCacheType = -1;

    private J3DTextureCacheFactory() {
    }

    public static void setDefaultCacheType(int n) throws CacheAlreadySetException {
        if (defaultCacheType != -1) {
            throw new CacheAlreadySetException();
        }
        defaultCacheType = n;
    }

    public static J3DTextureCache getCache() {
        if (defaultCacheType == -1) {
            String string = System.getProperty("org.j3d.texture.DefaultCacheType");
            defaultCacheType = string == null ? 1 : (string.equals("fixed") ? 1 : (string.equals("lru") ? 2 : (string.equals("weakref") ? 3 : 1)));
        }
        return J3DTextureCacheFactory.getCache(defaultCacheType);
    }

    public static J3DTextureCache getCache(int n) {
        J3DTextureCache j3DTextureCache = (J3DTextureCache)cacheMap.get(n);
        if (j3DTextureCache == null) {
            switch (n) {
                case 1: {
                    j3DTextureCache = new FixedTextureCache();
                    cacheMap.put(1, j3DTextureCache);
                    break;
                }
                case 2: {
                    j3DTextureCache = new LRUTextureCache();
                    cacheMap.put(2, j3DTextureCache);
                    break;
                }
                case 3: {
                    j3DTextureCache = new WeakRefTextureCache();
                    cacheMap.put(3, j3DTextureCache);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid cache type");
                }
            }
        }
        return j3DTextureCache;
    }

    public static void registerCacheType(int n, J3DTextureCache j3DTextureCache) {
        if (n <= 10) {
            throw new IllegalArgumentException("Invalid cacheType value");
        }
        cacheMap.put(n, j3DTextureCache);
    }
}

