// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gles_3_1_autogen.cpp:
//   Capture functions for the OpenGL ES 3.1 entry points.

#include "libANGLE/capture/capture_gles_3_1_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/capture/FrameCapture.h"
#include "libANGLE/capture/gl_enum_utils.h"
#include "libANGLE/validationES31.h"

using namespace angle;

namespace gl
{

CallCapture CaptureActiveShaderProgram(const State &glState,
                                       bool isCallValid,
                                       ProgramPipelineID pipelinePacked,
                                       ShaderProgramID programPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);
    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    return CallCapture(angle::EntryPoint::GLActiveShaderProgram, std::move(paramBuffer));
}

CallCapture CaptureBindImageTexture(const State &glState,
                                    bool isCallValid,
                                    GLuint unit,
                                    TextureID texturePacked,
                                    GLint level,
                                    GLboolean layered,
                                    GLint layer,
                                    GLenum access,
                                    GLenum format)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("unit", ParamType::TGLuint, unit);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("layered", ParamType::TGLboolean, layered);
    paramBuffer.addValueParam("layer", ParamType::TGLint, layer);
    paramBuffer.addEnumParam("access", GLenumGroup::BufferAccessARB, ParamType::TGLenum, access);
    paramBuffer.addEnumParam("format", GLenumGroup::InternalFormat, ParamType::TGLenum, format);

    return CallCapture(angle::EntryPoint::GLBindImageTexture, std::move(paramBuffer));
}

CallCapture CaptureBindProgramPipeline(const State &glState,
                                       bool isCallValid,
                                       ProgramPipelineID pipelinePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);

    return CallCapture(angle::EntryPoint::GLBindProgramPipeline, std::move(paramBuffer));
}

CallCapture CaptureBindVertexBuffer(const State &glState,
                                    bool isCallValid,
                                    GLuint bindingindex,
                                    BufferID bufferPacked,
                                    GLintptr offset,
                                    GLsizei stride)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bindingindex", ParamType::TGLuint, bindingindex);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    return CallCapture(angle::EntryPoint::GLBindVertexBuffer, std::move(paramBuffer));
}

CallCapture CaptureCreateShaderProgramv(const State &glState,
                                        bool isCallValid,
                                        ShaderType typePacked,
                                        GLsizei count,
                                        const GLchar *const *strings,
                                        GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("typePacked", ParamType::TShaderType, typePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture stringsParam("strings", ParamType::TGLcharConstPointerPointer);
        InitParamValue(ParamType::TGLcharConstPointerPointer, strings, &stringsParam.value);
        CaptureCreateShaderProgramv_strings(glState, isCallValid, typePacked, count, strings,
                                            &stringsParam);
        paramBuffer.addParam(std::move(stringsParam));
    }
    else
    {
        ParamCapture stringsParam("strings", ParamType::TGLcharConstPointerPointer);
        InitParamValue(ParamType::TGLcharConstPointerPointer,
                       static_cast<const GLchar *const *>(nullptr), &stringsParam.value);
        paramBuffer.addParam(std::move(stringsParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLCreateShaderProgramv, std::move(paramBuffer));
}

CallCapture CaptureDeleteProgramPipelines(const State &glState,
                                          bool isCallValid,
                                          GLsizei n,
                                          const ProgramPipelineID *pipelinesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture pipelinesPackedParam("pipelinesPacked",
                                          ParamType::TProgramPipelineIDConstPointer);
        InitParamValue(ParamType::TProgramPipelineIDConstPointer, pipelinesPacked,
                       &pipelinesPackedParam.value);
        CaptureDeleteProgramPipelines_pipelinesPacked(glState, isCallValid, n, pipelinesPacked,
                                                      &pipelinesPackedParam);
        paramBuffer.addParam(std::move(pipelinesPackedParam));
    }
    else
    {
        ParamCapture pipelinesPackedParam("pipelinesPacked",
                                          ParamType::TProgramPipelineIDConstPointer);
        InitParamValue(ParamType::TProgramPipelineIDConstPointer,
                       static_cast<const ProgramPipelineID *>(nullptr),
                       &pipelinesPackedParam.value);
        paramBuffer.addParam(std::move(pipelinesPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLDeleteProgramPipelines, std::move(paramBuffer));
}

CallCapture CaptureDispatchCompute(const State &glState,
                                   bool isCallValid,
                                   GLuint num_groups_x,
                                   GLuint num_groups_y,
                                   GLuint num_groups_z)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("num_groups_x", ParamType::TGLuint, num_groups_x);
    paramBuffer.addValueParam("num_groups_y", ParamType::TGLuint, num_groups_y);
    paramBuffer.addValueParam("num_groups_z", ParamType::TGLuint, num_groups_z);

    return CallCapture(angle::EntryPoint::GLDispatchCompute, std::move(paramBuffer));
}

CallCapture CaptureDispatchComputeIndirect(const State &glState,
                                           bool isCallValid,
                                           GLintptr indirect)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("indirect", ParamType::TGLintptr, indirect);

    return CallCapture(angle::EntryPoint::GLDispatchComputeIndirect, std::move(paramBuffer));
}

CallCapture CaptureDrawArraysIndirect(const State &glState,
                                      bool isCallValid,
                                      PrimitiveMode modePacked,
                                      const void *indirect)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);

    if (isCallValid)
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indirect, &indirectParam.value);
        CaptureDrawArraysIndirect_indirect(glState, isCallValid, modePacked, indirect,
                                           &indirectParam);
        paramBuffer.addParam(std::move(indirectParam));
    }
    else
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indirectParam.value);
        paramBuffer.addParam(std::move(indirectParam));
    }

    return CallCapture(angle::EntryPoint::GLDrawArraysIndirect, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsIndirect(const State &glState,
                                        bool isCallValid,
                                        PrimitiveMode modePacked,
                                        DrawElementsType typePacked,
                                        const void *indirect)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    if (isCallValid)
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, indirect, &indirectParam.value);
        CaptureDrawElementsIndirect_indirect(glState, isCallValid, modePacked, typePacked, indirect,
                                             &indirectParam);
        paramBuffer.addParam(std::move(indirectParam));
    }
    else
    {
        ParamCapture indirectParam("indirect", ParamType::TvoidConstPointer);
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indirectParam.value);
        paramBuffer.addParam(std::move(indirectParam));
    }

    return CallCapture(angle::EntryPoint::GLDrawElementsIndirect, std::move(paramBuffer));
}

CallCapture CaptureFramebufferParameteri(const State &glState,
                                         bool isCallValid,
                                         GLenum target,
                                         GLenum pname,
                                         GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLenumGroup::FramebufferParameterName, ParamType::TGLenum,
                             pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLFramebufferParameteri, std::move(paramBuffer));
}

CallCapture CaptureGenProgramPipelines(const State &glState,
                                       bool isCallValid,
                                       GLsizei n,
                                       ProgramPipelineID *pipelinesPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    if (isCallValid)
    {
        ParamCapture pipelinesPackedParam("pipelinesPacked", ParamType::TProgramPipelineIDPointer);
        InitParamValue(ParamType::TProgramPipelineIDPointer, pipelinesPacked,
                       &pipelinesPackedParam.value);
        CaptureGenProgramPipelines_pipelinesPacked(glState, isCallValid, n, pipelinesPacked,
                                                   &pipelinesPackedParam);
        paramBuffer.addParam(std::move(pipelinesPackedParam));
    }
    else
    {
        ParamCapture pipelinesPackedParam("pipelinesPacked", ParamType::TProgramPipelineIDPointer);
        InitParamValue(ParamType::TProgramPipelineIDPointer,
                       static_cast<ProgramPipelineID *>(nullptr), &pipelinesPackedParam.value);
        paramBuffer.addParam(std::move(pipelinesPackedParam));
    }

    return CallCapture(angle::EntryPoint::GLGenProgramPipelines, std::move(paramBuffer));
}

CallCapture CaptureGetBooleani_v(const State &glState,
                                 bool isCallValid,
                                 GLenum target,
                                 GLuint index,
                                 GLboolean *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::BufferTargetARB, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture dataParam("data", ParamType::TGLbooleanPointer);
        InitParamValue(ParamType::TGLbooleanPointer, data, &dataParam.value);
        CaptureGetBooleani_v_data(glState, isCallValid, target, index, data, &dataParam);
        paramBuffer.addParam(std::move(dataParam));
    }
    else
    {
        ParamCapture dataParam("data", ParamType::TGLbooleanPointer);
        InitParamValue(ParamType::TGLbooleanPointer, static_cast<GLboolean *>(nullptr),
                       &dataParam.value);
        paramBuffer.addParam(std::move(dataParam));
    }

    return CallCapture(angle::EntryPoint::GLGetBooleani_v, std::move(paramBuffer));
}

CallCapture CaptureGetFramebufferParameteriv(const State &glState,
                                             bool isCallValid,
                                             GLenum target,
                                             GLenum pname,
                                             GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLenumGroup::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("pname", GLenumGroup::FramebufferAttachmentParameterName,
                             ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetFramebufferParameteriv_params(glState, isCallValid, target, pname, params,
                                                &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetFramebufferParameteriv, std::move(paramBuffer));
}

CallCapture CaptureGetMultisamplefv(const State &glState,
                                    bool isCallValid,
                                    GLenum pname,
                                    GLuint index,
                                    GLfloat *val)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLenumGroup::DefaultGroup, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    if (isCallValid)
    {
        ParamCapture valParam("val", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, val, &valParam.value);
        CaptureGetMultisamplefv_val(glState, isCallValid, pname, index, val, &valParam);
        paramBuffer.addParam(std::move(valParam));
    }
    else
    {
        ParamCapture valParam("val", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &valParam.value);
        paramBuffer.addParam(std::move(valParam));
    }

    return CallCapture(angle::EntryPoint::GLGetMultisamplefv, std::move(paramBuffer));
}

CallCapture CaptureGetProgramInterfaceiv(const State &glState,
                                         bool isCallValid,
                                         ShaderProgramID programPacked,
                                         GLenum programInterface,
                                         GLenum pname,
                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLenumGroup::ProgramInterface, ParamType::TGLenum,
                             programInterface);
    paramBuffer.addEnumParam("pname", GLenumGroup::ProgramInterfacePName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetProgramInterfaceiv_params(glState, isCallValid, programPacked, programInterface,
                                            pname, params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetProgramInterfaceiv, std::move(paramBuffer));
}

CallCapture CaptureGetProgramPipelineInfoLog(const State &glState,
                                             bool isCallValid,
                                             ProgramPipelineID pipelinePacked,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLchar *infoLog)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetProgramPipelineInfoLog_length(glState, isCallValid, pipelinePacked, bufSize,
                                                length, infoLog, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture infoLogParam("infoLog", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, infoLog, &infoLogParam.value);
        CaptureGetProgramPipelineInfoLog_infoLog(glState, isCallValid, pipelinePacked, bufSize,
                                                 length, infoLog, &infoLogParam);
        paramBuffer.addParam(std::move(infoLogParam));
    }
    else
    {
        ParamCapture infoLogParam("infoLog", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &infoLogParam.value);
        paramBuffer.addParam(std::move(infoLogParam));
    }

    return CallCapture(angle::EntryPoint::GLGetProgramPipelineInfoLog, std::move(paramBuffer));
}

CallCapture CaptureGetProgramPipelineiv(const State &glState,
                                        bool isCallValid,
                                        ProgramPipelineID pipelinePacked,
                                        GLenum pname,
                                        GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);
    paramBuffer.addEnumParam("pname", GLenumGroup::PipelineParameterName, ParamType::TGLenum,
                             pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetProgramPipelineiv_params(glState, isCallValid, pipelinePacked, pname, params,
                                           &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetProgramPipelineiv, std::move(paramBuffer));
}

CallCapture CaptureGetProgramResourceIndex(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           GLenum programInterface,
                                           const GLchar *name,
                                           GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLenumGroup::ProgramInterface, ParamType::TGLenum,
                             programInterface);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureGetProgramResourceIndex_name(glState, isCallValid, programPacked, programInterface,
                                            name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetProgramResourceIndex, std::move(paramBuffer));
}

CallCapture CaptureGetProgramResourceLocation(const State &glState,
                                              bool isCallValid,
                                              ShaderProgramID programPacked,
                                              GLenum programInterface,
                                              const GLchar *name,
                                              GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLenumGroup::ProgramInterface, ParamType::TGLenum,
                             programInterface);

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureGetProgramResourceLocation_name(glState, isCallValid, programPacked,
                                               programInterface, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetProgramResourceLocation, std::move(paramBuffer));
}

CallCapture CaptureGetProgramResourceName(const State &glState,
                                          bool isCallValid,
                                          ShaderProgramID programPacked,
                                          GLenum programInterface,
                                          GLuint index,
                                          GLsizei bufSize,
                                          GLsizei *length,
                                          GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLenumGroup::ProgramInterface, ParamType::TGLenum,
                             programInterface);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetProgramResourceName_length(glState, isCallValid, programPacked, programInterface,
                                             index, bufSize, length, name, &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture nameParam("name", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, name, &nameParam.value);
        CaptureGetProgramResourceName_name(glState, isCallValid, programPacked, programInterface,
                                           index, bufSize, length, name, &nameParam);
        paramBuffer.addParam(std::move(nameParam));
    }
    else
    {
        ParamCapture nameParam("name", ParamType::TGLcharPointer);
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr), &nameParam.value);
        paramBuffer.addParam(std::move(nameParam));
    }

    return CallCapture(angle::EntryPoint::GLGetProgramResourceName, std::move(paramBuffer));
}

CallCapture CaptureGetProgramResourceiv(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        GLenum programInterface,
                                        GLuint index,
                                        GLsizei propCount,
                                        const GLenum *props,
                                        GLsizei bufSize,
                                        GLsizei *length,
                                        GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("programInterface", GLenumGroup::ProgramInterface, ParamType::TGLenum,
                             programInterface);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("propCount", ParamType::TGLsizei, propCount);

    if (isCallValid)
    {
        ParamCapture propsParam("props", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, props, &propsParam.value);
        CaptureGetProgramResourceiv_props(glState, isCallValid, programPacked, programInterface,
                                          index, propCount, props, bufSize, length, params,
                                          &propsParam);
        paramBuffer.addParam(std::move(propsParam));
    }
    else
    {
        ParamCapture propsParam("props", ParamType::TGLenumConstPointer);
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &propsParam.value);
        paramBuffer.addParam(std::move(propsParam));
    }

    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    if (isCallValid)
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetProgramResourceiv_length(glState, isCallValid, programPacked, programInterface,
                                           index, propCount, props, bufSize, length, params,
                                           &lengthParam);
        paramBuffer.addParam(std::move(lengthParam));
    }
    else
    {
        ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
        paramBuffer.addParam(std::move(lengthParam));
    }

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetProgramResourceiv_params(glState, isCallValid, programPacked, programInterface,
                                           index, propCount, props, bufSize, length, params,
                                           &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetProgramResourceiv, std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameterfv(const State &glState,
                                          bool isCallValid,
                                          TextureTarget targetPacked,
                                          GLint level,
                                          GLenum pname,
                                          GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLenumGroup::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetTexLevelParameterfv_params(glState, isCallValid, targetPacked, level, pname,
                                             params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexLevelParameterfv, std::move(paramBuffer));
}

CallCapture CaptureGetTexLevelParameteriv(const State &glState,
                                          bool isCallValid,
                                          TextureTarget targetPacked,
                                          GLint level,
                                          GLenum pname,
                                          GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("pname", GLenumGroup::GetTextureParameter, ParamType::TGLenum, pname);

    if (isCallValid)
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetTexLevelParameteriv_params(glState, isCallValid, targetPacked, level, pname,
                                             params, &paramsParam);
        paramBuffer.addParam(std::move(paramsParam));
    }
    else
    {
        ParamCapture paramsParam("params", ParamType::TGLintPointer);
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
        paramBuffer.addParam(std::move(paramsParam));
    }

    return CallCapture(angle::EntryPoint::GLGetTexLevelParameteriv, std::move(paramBuffer));
}

CallCapture CaptureIsProgramPipeline(const State &glState,
                                     bool isCallValid,
                                     ProgramPipelineID pipelinePacked,
                                     GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsProgramPipeline, std::move(paramBuffer));
}

CallCapture CaptureMemoryBarrier(const State &glState, bool isCallValid, GLbitfield barriers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("barriers", GLenumGroup::MemoryBarrierMask, ParamType::TGLbitfield,
                             barriers);

    return CallCapture(angle::EntryPoint::GLMemoryBarrier, std::move(paramBuffer));
}

CallCapture CaptureMemoryBarrierByRegion(const State &glState,
                                         bool isCallValid,
                                         GLbitfield barriers)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("barriers", GLenumGroup::MemoryBarrierMask, ParamType::TGLbitfield,
                             barriers);

    return CallCapture(angle::EntryPoint::GLMemoryBarrierByRegion, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1f(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLfloat v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);

    return CallCapture(angle::EntryPoint::GLProgramUniform1f, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1fv(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLsizei count,
                                     const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniform1fv_value(glState, isCallValid, programPacked, locationPacked, count,
                                       value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform1fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1i(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLint v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);

    return CallCapture(angle::EntryPoint::GLProgramUniform1i, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1iv(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLsizei count,
                                     const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
        CaptureProgramUniform1iv_value(glState, isCallValid, programPacked, locationPacked, count,
                                       value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform1iv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1ui(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLuint v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);

    return CallCapture(angle::EntryPoint::GLProgramUniform1ui, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform1uiv(const State &glState,
                                      bool isCallValid,
                                      ShaderProgramID programPacked,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureProgramUniform1uiv_value(glState, isCallValid, programPacked, locationPacked, count,
                                        value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform1uiv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2f(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLfloat v0,
                                    GLfloat v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);

    return CallCapture(angle::EntryPoint::GLProgramUniform2f, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2fv(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLsizei count,
                                     const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniform2fv_value(glState, isCallValid, programPacked, locationPacked, count,
                                       value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform2fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2i(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLint v0,
                                    GLint v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);

    return CallCapture(angle::EntryPoint::GLProgramUniform2i, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2iv(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLsizei count,
                                     const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
        CaptureProgramUniform2iv_value(glState, isCallValid, programPacked, locationPacked, count,
                                       value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform2iv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2ui(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLuint v0,
                                     GLuint v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLuint, v1);

    return CallCapture(angle::EntryPoint::GLProgramUniform2ui, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform2uiv(const State &glState,
                                      bool isCallValid,
                                      ShaderProgramID programPacked,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureProgramUniform2uiv_value(glState, isCallValid, programPacked, locationPacked, count,
                                        value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform2uiv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3f(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLfloat v0,
                                    GLfloat v1,
                                    GLfloat v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLfloat, v2);

    return CallCapture(angle::EntryPoint::GLProgramUniform3f, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3fv(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLsizei count,
                                     const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniform3fv_value(glState, isCallValid, programPacked, locationPacked, count,
                                       value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform3fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3i(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLint v0,
                                    GLint v1,
                                    GLint v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLint, v2);

    return CallCapture(angle::EntryPoint::GLProgramUniform3i, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3iv(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLsizei count,
                                     const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
        CaptureProgramUniform3iv_value(glState, isCallValid, programPacked, locationPacked, count,
                                       value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform3iv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3ui(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLuint v0,
                                     GLuint v1,
                                     GLuint v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLuint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLuint, v2);

    return CallCapture(angle::EntryPoint::GLProgramUniform3ui, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform3uiv(const State &glState,
                                      bool isCallValid,
                                      ShaderProgramID programPacked,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureProgramUniform3uiv_value(glState, isCallValid, programPacked, locationPacked, count,
                                        value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform3uiv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4f(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLfloat v0,
                                    GLfloat v1,
                                    GLfloat v2,
                                    GLfloat v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLfloat, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLfloat, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLfloat, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLfloat, v3);

    return CallCapture(angle::EntryPoint::GLProgramUniform4f, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4fv(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLsizei count,
                                     const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniform4fv_value(glState, isCallValid, programPacked, locationPacked, count,
                                       value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform4fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4i(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    UniformLocation locationPacked,
                                    GLint v0,
                                    GLint v1,
                                    GLint v2,
                                    GLint v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLint, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLint, v3);

    return CallCapture(angle::EntryPoint::GLProgramUniform4i, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4iv(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLsizei count,
                                     const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
        CaptureProgramUniform4iv_value(glState, isCallValid, programPacked, locationPacked, count,
                                       value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLintConstPointer);
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform4iv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4ui(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     UniformLocation locationPacked,
                                     GLuint v0,
                                     GLuint v1,
                                     GLuint v2,
                                     GLuint v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLuint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLuint, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLuint, v3);

    return CallCapture(angle::EntryPoint::GLProgramUniform4ui, std::move(paramBuffer));
}

CallCapture CaptureProgramUniform4uiv(const State &glState,
                                      bool isCallValid,
                                      ShaderProgramID programPacked,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureProgramUniform4uiv_value(glState, isCallValid, programPacked, locationPacked, count,
                                        value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniform4uiv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix2fv(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           UniformLocation locationPacked,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix2fv_value(glState, isCallValid, programPacked, locationPacked,
                                             count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix2fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix2x3fv(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             UniformLocation locationPacked,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix2x3fv_value(glState, isCallValid, programPacked, locationPacked,
                                               count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix2x3fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix2x4fv(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             UniformLocation locationPacked,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix2x4fv_value(glState, isCallValid, programPacked, locationPacked,
                                               count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix2x4fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix3fv(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           UniformLocation locationPacked,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix3fv_value(glState, isCallValid, programPacked, locationPacked,
                                             count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix3fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix3x2fv(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             UniformLocation locationPacked,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix3x2fv_value(glState, isCallValid, programPacked, locationPacked,
                                               count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix3x2fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix3x4fv(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             UniformLocation locationPacked,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix3x4fv_value(glState, isCallValid, programPacked, locationPacked,
                                               count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix3x4fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix4fv(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           UniformLocation locationPacked,
                                           GLsizei count,
                                           GLboolean transpose,
                                           const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix4fv_value(glState, isCallValid, programPacked, locationPacked,
                                             count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix4fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix4x2fv(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             UniformLocation locationPacked,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix4x2fv_value(glState, isCallValid, programPacked, locationPacked,
                                               count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix4x2fv, std::move(paramBuffer));
}

CallCapture CaptureProgramUniformMatrix4x3fv(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             UniformLocation locationPacked,
                                             GLsizei count,
                                             GLboolean transpose,
                                             const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    if (isCallValid)
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureProgramUniformMatrix4x3fv_value(glState, isCallValid, programPacked, locationPacked,
                                               count, transpose, value, &valueParam);
        paramBuffer.addParam(std::move(valueParam));
    }
    else
    {
        ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
        paramBuffer.addParam(std::move(valueParam));
    }

    return CallCapture(angle::EntryPoint::GLProgramUniformMatrix4x3fv, std::move(paramBuffer));
}

CallCapture CaptureSampleMaski(const State &glState,
                               bool isCallValid,
                               GLuint maskNumber,
                               GLbitfield mask)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("maskNumber", ParamType::TGLuint, maskNumber);
    paramBuffer.addEnumParam("mask", GLenumGroup::DefaultGroup, ParamType::TGLbitfield, mask);

    return CallCapture(angle::EntryPoint::GLSampleMaski, std::move(paramBuffer));
}

CallCapture CaptureTexStorage2DMultisample(const State &glState,
                                           bool isCallValid,
                                           TextureType targetPacked,
                                           GLsizei samples,
                                           GLenum internalformat,
                                           GLsizei width,
                                           GLsizei height,
                                           GLboolean fixedsamplelocations)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLenumGroup::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("fixedsamplelocations", ParamType::TGLboolean, fixedsamplelocations);

    return CallCapture(angle::EntryPoint::GLTexStorage2DMultisample, std::move(paramBuffer));
}

CallCapture CaptureUseProgramStages(const State &glState,
                                    bool isCallValid,
                                    ProgramPipelineID pipelinePacked,
                                    GLbitfield stages,
                                    ShaderProgramID programPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);
    paramBuffer.addEnumParam("stages", GLenumGroup::UseProgramStageMask, ParamType::TGLbitfield,
                             stages);
    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    return CallCapture(angle::EntryPoint::GLUseProgramStages, std::move(paramBuffer));
}

CallCapture CaptureValidateProgramPipeline(const State &glState,
                                           bool isCallValid,
                                           ProgramPipelineID pipelinePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("pipelinePacked", ParamType::TProgramPipelineID, pipelinePacked);

    return CallCapture(angle::EntryPoint::GLValidateProgramPipeline, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribBinding(const State &glState,
                                       bool isCallValid,
                                       GLuint attribindex,
                                       GLuint bindingindex)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("attribindex", ParamType::TGLuint, attribindex);
    paramBuffer.addValueParam("bindingindex", ParamType::TGLuint, bindingindex);

    return CallCapture(angle::EntryPoint::GLVertexAttribBinding, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribFormat(const State &glState,
                                      bool isCallValid,
                                      GLuint attribindex,
                                      GLint size,
                                      VertexAttribType typePacked,
                                      GLboolean normalized,
                                      GLuint relativeoffset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("attribindex", ParamType::TGLuint, attribindex);
    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("normalized", ParamType::TGLboolean, normalized);
    paramBuffer.addValueParam("relativeoffset", ParamType::TGLuint, relativeoffset);

    return CallCapture(angle::EntryPoint::GLVertexAttribFormat, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribIFormat(const State &glState,
                                       bool isCallValid,
                                       GLuint attribindex,
                                       GLint size,
                                       VertexAttribType typePacked,
                                       GLuint relativeoffset)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("attribindex", ParamType::TGLuint, attribindex);
    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("relativeoffset", ParamType::TGLuint, relativeoffset);

    return CallCapture(angle::EntryPoint::GLVertexAttribIFormat, std::move(paramBuffer));
}

CallCapture CaptureVertexBindingDivisor(const State &glState,
                                        bool isCallValid,
                                        GLuint bindingindex,
                                        GLuint divisor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("bindingindex", ParamType::TGLuint, bindingindex);
    paramBuffer.addValueParam("divisor", ParamType::TGLuint, divisor);

    return CallCapture(angle::EntryPoint::GLVertexBindingDivisor, std::move(paramBuffer));
}

}  // namespace gl
