#ifndef UD_HIST_H
#define UD_HIST_H

#include "udposix.h"
#include "limits.h"


typedef struct {
    long	*bin;
    HIST_TYPE	start;
    HIST_TYPE	stop;
    HIST_TYPE	inc;
    long	nbin;
    long	toolow;
    long	toohigh;
    long	total;
} Histogram;


UD_EXTERN_FUNC(int hist_init, (
    Histogram	*hist,
    HIST_TYPE	start,
    HIST_TYPE	inc,
    long	nbin
));
UD_EXTERN_FUNC(void hist_clear, (
    Histogram	*hist
));
UD_EXTERN_FUNC(void hist_add, (
    Histogram	*hist,
    HIST_TYPE	value
));
UD_EXTERN_FUNC(long hist_get, (
    Histogram	*hist,
    long	index
));
UD_EXTERN_FUNC(long hist_total, (
    Histogram	*hist
));
UD_EXTERN_FUNC(void hist_destroy, (
    Histogram	*hist
));


#endif	/* header file lockout */
