// file      : xsd-frontend/semantic-graph/fundamental.hxx
// copyright : Copyright (c) 2005-2014 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

// Note, that this file is automatically generated!
//

#ifndef XSD_FRONTEND_SEMANTIC_GRAPH_FUNDAMENTAL_HXX
#define XSD_FRONTEND_SEMANTIC_GRAPH_FUNDAMENTAL_HXX

#include <xsd-frontend/semantic-graph/elements.hxx>

namespace XSDFrontend
{
  namespace SemanticGraph
  {
    namespace Fundamental
    {
      //
      //
      class Type: public virtual SemanticGraph::Type
      {
      protected:
        Type ();
      };


      //
      //
      class Byte: public virtual Type
      {
      public:
        Byte (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class UnsignedByte: public virtual Type
      {
      public:
        UnsignedByte (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Short: public virtual Type
      {
      public:
        Short (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class UnsignedShort: public virtual Type
      {
      public:
        UnsignedShort (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Int: public virtual Type
      {
      public:
        Int (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class UnsignedInt: public virtual Type
      {
      public:
        UnsignedInt (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Long: public virtual Type
      {
      public:
        Long (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class UnsignedLong: public virtual Type
      {
      public:
        UnsignedLong (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Integer: public virtual Type
      {
      public:
        Integer (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class NonPositiveInteger: public virtual Type
      {
      public:
        NonPositiveInteger (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class NonNegativeInteger: public virtual Type
      {
      public:
        NonNegativeInteger (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class PositiveInteger: public virtual Type
      {
      public:
        PositiveInteger (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class NegativeInteger: public virtual Type
      {
      public:
        NegativeInteger (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Boolean: public virtual Type
      {
      public:
        Boolean (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Float: public virtual Type
      {
      public:
        Float (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Double: public virtual Type
      {
      public:
        Double (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Decimal: public virtual Type
      {
      public:
        Decimal (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class String: public virtual Type
      {
      public:
        String (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class NormalizedString: public virtual Type
      {
      public:
        NormalizedString (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Token: public virtual Type
      {
      public:
        Token (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Name: public virtual Type
      {
      public:
        Name (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class NameToken: public virtual Type
      {
      public:
        NameToken (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class NameTokens: public virtual Type
      {
      public:
        NameTokens (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class NCName: public virtual Type
      {
      public:
        NCName (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Language: public virtual Type
      {
      public:
        Language (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class QName: public virtual Type
      {
      public:
        QName (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Id: public virtual Type
      {
      public:
        Id (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class IdRef: public virtual Type,
                   public virtual Specialization
      {
      public:
        IdRef (Path const& file,
               unsigned long line,
               unsigned long column);
      };


      //
      //
      class IdRefs: public virtual Type,
                    public virtual Specialization
      {
      public:
        IdRefs (Path const& file,
                unsigned long line,
                unsigned long column);
      };


      //
      //
      class AnyURI: public virtual Type
      {
      public:
        AnyURI (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Base64Binary: public virtual Type
      {
      public:
        Base64Binary (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class HexBinary: public virtual Type
      {
      public:
        HexBinary (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Date: public virtual Type
      {
      public:
        Date (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class DateTime: public virtual Type
      {
      public:
        DateTime (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Duration: public virtual Type
      {
      public:
        Duration (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Day: public virtual Type
      {
      public:
        Day (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Month: public virtual Type
      {
      public:
        Month (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class MonthDay: public virtual Type
      {
      public:
        MonthDay (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Year: public virtual Type
      {
      public:
        Year (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class YearMonth: public virtual Type
      {
      public:
        YearMonth (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Time: public virtual Type
      {
      public:
        Time (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Entity: public virtual Type
      {
      public:
        Entity (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Entities: public virtual Type
      {
      public:
        Entities (Path const& file,
            unsigned long line,
            unsigned long column);
      };


      //
      //
      class Notation: public virtual Type
      {
      public:
        Notation (Path const& file,
            unsigned long line,
            unsigned long column);
      };
    }
  }
}

#endif  // XSD_FRONTEND_SEMANTIC_GRAPH_FUNDAMENTAL_HXX
