//
// Created by uos on 2022/3/17.
//

#include "ProgressWidget.h"
#include <QVBoxLayout>
#include <DFontSizeManager>

ProgressWidget::ProgressWidget(const QString &mainTitle, const QString &subTitle,
                               const QString &warning, DWidget *parent)
    : DWidget(parent)
{
    this->setAccessibleName("ProgressWidget");
    //垂直布局
    QVBoxLayout *verticalLayout = new QVBoxLayout(this);
    m_waterProgress = new DWaterProgress(this);
    m_waterProgress->setAccessibleName("ProgressWidget_DWaterProgress");
    m_waterProgress->setValue(0);
    m_waterProgress->setTextVisible(true);
    m_waterProgress->setFixedSize(98, 98);
    verticalLayout->addWidget(m_waterProgress);
    verticalLayout->setAlignment(m_waterProgress, Qt::AlignHCenter);
    verticalLayout->addSpacing(25);

    m_mainTitle = new DLabel(this);
    m_mainTitle->setText(mainTitle);
    m_mainTitle->setAccessibleName("ProgressWidget_mainTitle");
    auto font = m_mainTitle->font();
    // font.setPointSize(14);
    font.setPixelSize(14);
    font.setWeight(QFont::Medium);
    m_mainTitle->setFont(font);
    DFontSizeManager::instance()->bind(m_mainTitle, DFontSizeManager::T6);
    m_mainTitle->setAlignment(Qt::AlignCenter);

    verticalLayout->addWidget(m_mainTitle);
    verticalLayout->addSpacing(20);

    auto hLayout = new QHBoxLayout;
    hLayout->setAlignment(Qt::AlignCenter);
    m_subTitle = new DLabel(this);
    m_subTitle->setText(subTitle);
    m_subTitle->setAccessibleName("ProgressWidget_subTitle");
    m_subTitle->setAlignment(Qt::AlignCenter);
    font = m_subTitle->font();
    font.setPixelSize(11);
    font.setWeight(QFont::Normal);
    m_subTitle->setFont(font);
    DFontSizeManager::instance()->bind(m_subTitle, DFontSizeManager::T9);
    // m_subTitle->setStyleSheet("QLabel {"
    //                          "font-family: SourceHanSansSC, SourceHanSansSC-Normal;"
    //                          "font-size: 12px;"
    //                          "font-weight: 500;"
    //                          "color: #000000;"
    //                          "}");
    hLayout->addWidget(m_subTitle);
    hLayout->addSpacing(10);

    m_remainTime = new DLabel;
    QFont remainTimeFont = font;
    remainTimeFont.setWeight(QFont::Normal);
    m_remainTime->setFont(remainTimeFont);
    m_remainTime->setAccessibleName("ProgressWidget_remainTime");
    DFontSizeManager::instance()->bind(m_remainTime, DFontSizeManager::T9);
    hLayout->addWidget(m_remainTime);
    verticalLayout->addLayout(hLayout);
    verticalLayout->addStretch();

    m_warning = new DLabel(this);
    m_warning->setText(warning);
    m_warning->setAccessibleName("ProgressWidget_warning");
    m_warning->setAlignment(Qt::AlignCenter);
    m_warning->setWordWrap(true);
    m_warning->setStyleSheet("QLabel {"
                             "color: #ff5736;"
                             "}");
    QFont warnFont = m_warning->font();
    warnFont.setPixelSize(14);
    warnFont.setWeight(QFont::Medium);
    m_warning->setFont(warnFont);
    DFontSizeManager::instance()->bind(m_warning, DFontSizeManager::T6);
    verticalLayout->addWidget(m_warning);
    verticalLayout->setAlignment(Qt::AlignCenter);
    verticalLayout->setContentsMargins(0, 138, 0, 10);
}

void ProgressWidget::start()
{
    m_waterProgress->start();
}

void ProgressWidget::stop(bool success)
{
    m_waterProgress->stop();
}

void ProgressWidget::setValue(int value)
{
    m_waterProgress->setValue(value);
}

void ProgressWidget::setMainTitle(const QString &mainTitle)
{
    m_mainTitle->setText(mainTitle);
}

void ProgressWidget::setSubTitle(const QString &subTitle)
{
    m_subTitle->setText(subTitle);
}

void ProgressWidget::setWarning(const QString &warning)
{
    m_warning->setText(warning);
}

void ProgressWidget::setRemainTime(int remainSecond)
{
    int hours = remainSecond / 3600;
    int minute = (remainSecond - hours * 3600) / 60;
    int second = (remainSecond - hours * 3600 - minute * 60);

    auto remainTime = QString("%1:%2:%3")
            .arg(hours, 2, 10, QLatin1Char('0'))
            .arg(minute, 2, 10, QLatin1Char('0') )
            .arg(second, 2, 10, QLatin1Char('0'));
    m_remainTime->setText(remainTime);
}


ProgressWidgetV2::ProgressWidgetV2(const QString &mainTitle, const QString &subTitle,
                               const QString &warning, DWidget *parent)
        : DWidget(parent)
{
    this->setAccessibleName("ProgressWidgetV2");
    this->setFixedHeight(600);

    m_icon = new DLabel(this);
    m_icon->setFixedSize(149, 149);
    m_progressBar = new DProgressBar(this);
    m_progressBar->setAccessibleName("ProgressWidgetV2_progressBar");
    m_progressBar->setValue(90);
    m_progressBar->setTextVisible(false);
    m_progressBar->setRange(0, 100);
    m_progressBar->setFixedSize(280,8);

    m_mainTitle = new DLabel(this);
    m_mainTitle->setText(mainTitle);
    m_mainTitle->setAccessibleName("ProgressWidgetV2_mainTitle");
    auto font = m_mainTitle->font();
    // font.setPointSize(14);
    font.setPixelSize(20);
    font.setWeight(QFont::Bold);
    m_mainTitle->setFont(font);
    DFontSizeManager::instance()->bind(m_mainTitle, DFontSizeManager::T4);
    m_mainTitle->setAlignment(Qt::AlignCenter);
    m_progress = new DLabel;
    m_progress->setFont(font);
    DFontSizeManager::instance()->bind(m_progress, DFontSizeManager::T4);

    m_subTitle = new DTipLabel;
    m_subTitle->setText(subTitle);
    m_subTitle->setAccessibleName("ProgressWidgetV2_subTitle");
    m_subTitle->setAlignment(Qt::AlignCenter);
    font = m_subTitle->font();
    font.setPixelSize(11);
    font.setWeight(QFont::Normal);
    m_subTitle->setFont(font);
    DFontSizeManager::instance()->bind(m_subTitle, DFontSizeManager::T8);

    m_remainTime = new DTipLabel;
    QFont remainTimeFont = font;
    remainTimeFont.setWeight(QFont::Normal);
    m_remainTime->setFont(remainTimeFont);
    m_remainTime->setAccessibleName("ProgressWidgetV2_remainTime");
    DFontSizeManager::instance()->bind(m_remainTime, DFontSizeManager::T8);

    m_warning = new DLabel(this);
    m_warning->setText(warning);
    m_warning->setAccessibleName("ProgressWidgetV2_warning");
    m_warning->setAlignment(Qt::AlignCenter);
    m_warning->setWordWrap(true);
    m_warning->setStyleSheet("QLabel {"
                             "color: #ff5736;"
                             "}");
    QFont warnFont = m_warning->font();
    warnFont.setPixelSize(14);
    warnFont.setWeight(QFont::Normal);
    m_warning->setFont(warnFont);
    DFontSizeManager::instance()->bind(m_warning, DFontSizeManager::T6);
    initLayout();
}

void ProgressWidgetV2::initLayout()
{
    m_mainVLayout = new QVBoxLayout(this);
    m_mainVLayout->setContentsMargins(0, 84, 0, 10);

    QHBoxLayout *progressHLayout = new QHBoxLayout;
    progressHLayout->setAlignment(Qt::AlignCenter);
    progressHLayout->addWidget(m_mainTitle);
    progressHLayout->addSpacing(10);
    progressHLayout->addWidget(m_progress);

    m_mainVLayout->addWidget(m_icon, 0, Qt::AlignHCenter);
    m_mainVLayout->addSpacing(23);
    m_mainVLayout->addLayout(progressHLayout);
    m_mainVLayout->addSpacing(23);
    m_mainVLayout->addWidget(m_progressBar);
    m_mainVLayout->setAlignment(m_progressBar, Qt::AlignHCenter);
    m_mainVLayout->addSpacing(18);

    QHBoxLayout *hLayout = new QHBoxLayout;
    hLayout->setAlignment(Qt::AlignCenter);
    hLayout->addWidget(m_subTitle);
    hLayout->addSpacing(10);
    hLayout->addWidget(m_remainTime);

    m_mainVLayout->addLayout(hLayout);
    m_mainVLayout->addStretch();
    m_mainVLayout->addWidget(m_warning);
    m_mainVLayout->addSpacing(57);
    m_mainVLayout->setAlignment(Qt::AlignCenter);

}

void ProgressWidgetV2::setValue(int value)
{
    m_progressBar->setValue(value);
    QString curProgress = QString("%1%").arg(value);
    m_progress->setText(curProgress);
}

void ProgressWidgetV2::setMainTitle(const QString &mainTitle)
{
    m_mainTitle->setText(mainTitle);
}

void ProgressWidgetV2::setSubTitle(const QString &subTitle)
{
    m_subTitle->setText(subTitle);
}

void ProgressWidgetV2::setWarning(const QString &warning)
{
    m_warning->setText(warning);
}

void ProgressWidgetV2::setRemainTime(int remainSecond)
{
    int hours = remainSecond / 3600;
    int minute = (remainSecond - hours * 3600) / 60;
    int second = (remainSecond - hours * 3600 - minute * 60);

    auto remainTime = QString("%1:%2:%3")
            .arg(hours, 2, 10, QLatin1Char('0'))
            .arg(minute, 2, 10, QLatin1Char('0') )
            .arg(second, 2, 10, QLatin1Char('0'));
    m_remainTime->setText(remainTime);
}

void ProgressWidgetV2::setIconPixmap(const QPixmap &iconPix)
{
    m_icon->setPixmap(iconPix);
}
