# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network vnet create",
)
class Create(AAZCommand):
    """Create a virtual network.

    You may also create a subnet at the same time by specifying a subnet name and (optionally) an address prefix. To learn about how to create a virtual network visit https://learn.microsoft.com/azure/virtual-network/manage-virtual-network#create-a-virtual-network.

    :example: Create a virtual network with a specific address prefix and one subnet.
        az network vnet create -g MyResourceGroup -n MyVnet --address-prefix 10.0.0.0/16 --subnet-name MySubnet --subnet-prefixes 10.0.0.0/24

    :example: Create a virtual network.
        az network vnet create --address-prefixes 10.0.0.0/16 --name MyVirtualNetwork --resource-group MyResourceGroup --subnet-name MyAseSubnet --subnet-prefixes 10.0.0.0/24
    """

    _aaz_info = {
        "version": "2015-06-15",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/virtualnetworks/{}", "2015-06-15"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The virtual network (VNet) name.",
            required=True,
        )
        _args_schema.location = AAZResourceLocationArg(
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.address_prefixes = AAZListArg(
            options=["--address-prefixes"],
            help="Space-separated list of IP address prefixes for the VNet. Default: 10.0.0.0/16.",
            default=["10.0.0.0/16"],
        )
        _args_schema.dns_servers = AAZListArg(
            options=["--dns-servers"],
            help="Space-separated list of DNS server IP addresses.",
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            help="Space-separated tags: key[=value] [key[=value] ...].",
        )

        address_prefixes = cls._args_schema.address_prefixes
        address_prefixes.Element = AAZStrArg()

        dns_servers = cls._args_schema.dns_servers
        dns_servers.Element = AAZStrArg()

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        # define Arg Group "Parameters"

        # define Arg Group "Properties"

        # define Arg Group "Subnet"

        _args_schema = cls._args_schema
        _args_schema.subnets = AAZListArg(
            options=["--subnets"],
            arg_group="Subnet",
            help="Manage a list of subnets in a Virtual Network (similar to `az network vnet subnet`).",
        )

        subnets = cls._args_schema.subnets
        subnets.Element = AAZObjectArg()

        _element = cls._args_schema.subnets.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The subnet name.",
        )
        _element.address_prefix = AAZStrArg(
            options=["address-prefix"],
            help="The address prefix for the subnet.",
        )
        _element.network_security_group = AAZObjectArg(
            options=["nsg", "network-security-group"],
            help="The reference to the NetworkSecurityGroup resource.",
        )
        _element.route_table = AAZObjectArg(
            options=["route-table"],
            help="The reference to the RouteTable resource.",
        )

        network_security_group = cls._args_schema.subnets.Element.network_security_group
        network_security_group.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/networkSecurityGroups/{}",
            ),
        )
        network_security_group.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        network_security_group.security_rules = AAZListArg(
            options=["security-rules"],
            help="A collection of security rules of the network security group.",
        )
        network_security_group.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        security_rules = cls._args_schema.subnets.Element.network_security_group.security_rules
        security_rules.Element = AAZObjectArg()

        _element = cls._args_schema.subnets.Element.network_security_group.security_rules.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/networkSecurityGroups/{}/securityRules/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.access = AAZStrArg(
            options=["access"],
            help="The network traffic is allowed or denied.",
            enum={"Allow": "Allow", "Deny": "Deny"},
        )
        _element.description = AAZStrArg(
            options=["description"],
            help="A description for this rule. Restricted to 140 chars.",
        )
        _element.destination_address_prefix = AAZStrArg(
            options=["destination-address-prefix"],
            help="The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.",
        )
        _element.destination_port_range = AAZStrArg(
            options=["destination-port-range"],
            help="The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.",
        )
        _element.direction = AAZStrArg(
            options=["direction"],
            help="The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.",
            enum={"Inbound": "Inbound", "Outbound": "Outbound"},
        )
        _element.priority = AAZIntArg(
            options=["priority"],
            help="The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="Network protocol this rule applies to.",
            enum={"*": "*", "Tcp": "Tcp", "Udp": "Udp"},
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        _element.source_address_prefix = AAZStrArg(
            options=["source-address-prefix"],
            help="The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.",
        )
        _element.source_port_range = AAZStrArg(
            options=["source-port-range"],
            help="The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.",
        )

        tags = cls._args_schema.subnets.Element.network_security_group.tags
        tags.Element = AAZStrArg()

        route_table = cls._args_schema.subnets.Element.route_table
        route_table.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/routeTables/{}",
            ),
        )
        route_table.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        route_table.routes = AAZListArg(
            options=["routes"],
            help="Collection of routes contained within a route table.",
        )
        route_table.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        routes = cls._args_schema.subnets.Element.route_table.routes
        routes.Element = AAZObjectArg()

        _element = cls._args_schema.subnets.Element.route_table.routes.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/routeTables/{}/routes/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.address_prefix = AAZStrArg(
            options=["address-prefix"],
            help="The destination CIDR to which the route applies.",
        )
        _element.next_hop_ip_address = AAZStrArg(
            options=["next-hop-ip-address"],
            help="The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.",
        )
        _element.next_hop_type = AAZStrArg(
            options=["next-hop-type"],
            help="The type of Azure hop the packet should be sent to.",
            enum={"Internet": "Internet", "None": "None", "VirtualAppliance": "VirtualAppliance", "VirtualNetworkGateway": "VirtualNetworkGateway", "VnetLocal": "VnetLocal"},
        )

        tags = cls._args_schema.subnets.Element.route_table.tags
        tags.Element = AAZStrArg()
        return cls._args_schema

    _args_ip_configuration_create = None

    @classmethod
    def _build_args_ip_configuration_create(cls, _schema):
        if cls._args_ip_configuration_create is not None:
            _schema.etag = cls._args_ip_configuration_create.etag
            _schema.id = cls._args_ip_configuration_create.id
            _schema.name = cls._args_ip_configuration_create.name
            _schema.private_ip_address = cls._args_ip_configuration_create.private_ip_address
            _schema.private_ip_allocation_method = cls._args_ip_configuration_create.private_ip_allocation_method
            _schema.public_ip_address = cls._args_ip_configuration_create.public_ip_address
            _schema.subnet = cls._args_ip_configuration_create.subnet
            return

        cls._args_ip_configuration_create = AAZObjectArg()

        ip_configuration_create = cls._args_ip_configuration_create
        ip_configuration_create.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        ip_configuration_create.id = AAZStrArg(
            options=["id"],
            help="Resource Identifier.",
        )
        ip_configuration_create.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        ip_configuration_create.private_ip_address = AAZStrArg(
            options=["private-ip-address"],
            help="The private IP address of the IP configuration.",
        )
        ip_configuration_create.private_ip_allocation_method = AAZStrArg(
            options=["private-ip-allocation-method"],
            help="The private IP allocation method. Possible values are 'Static' and 'Dynamic'.",
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        ip_configuration_create.public_ip_address = AAZObjectArg(
            options=["public-ip-address"],
            help="The reference of the public IP resource.",
        )
        cls._build_args_public_ip_address_create(ip_configuration_create.public_ip_address)
        ip_configuration_create.subnet = AAZObjectArg(
            options=["subnet"],
            help="The reference of the subnet resource.",
        )
        cls._build_args_subnet_create(ip_configuration_create.subnet)

        _schema.etag = cls._args_ip_configuration_create.etag
        _schema.id = cls._args_ip_configuration_create.id
        _schema.name = cls._args_ip_configuration_create.name
        _schema.private_ip_address = cls._args_ip_configuration_create.private_ip_address
        _schema.private_ip_allocation_method = cls._args_ip_configuration_create.private_ip_allocation_method
        _schema.public_ip_address = cls._args_ip_configuration_create.public_ip_address
        _schema.subnet = cls._args_ip_configuration_create.subnet

    _args_network_interface_ip_configuration_create = None

    @classmethod
    def _build_args_network_interface_ip_configuration_create(cls, _schema):
        if cls._args_network_interface_ip_configuration_create is not None:
            _schema.etag = cls._args_network_interface_ip_configuration_create.etag
            _schema.id = cls._args_network_interface_ip_configuration_create.id
            _schema.load_balancer_backend_address_pools = cls._args_network_interface_ip_configuration_create.load_balancer_backend_address_pools
            _schema.load_balancer_inbound_nat_rules = cls._args_network_interface_ip_configuration_create.load_balancer_inbound_nat_rules
            _schema.name = cls._args_network_interface_ip_configuration_create.name
            _schema.primary = cls._args_network_interface_ip_configuration_create.primary
            _schema.private_ip_address = cls._args_network_interface_ip_configuration_create.private_ip_address
            _schema.private_ip_allocation_method = cls._args_network_interface_ip_configuration_create.private_ip_allocation_method
            _schema.provisioning_state = cls._args_network_interface_ip_configuration_create.provisioning_state
            _schema.public_ip_address = cls._args_network_interface_ip_configuration_create.public_ip_address
            _schema.subnet = cls._args_network_interface_ip_configuration_create.subnet
            return

        cls._args_network_interface_ip_configuration_create = AAZObjectArg()

        network_interface_ip_configuration_create = cls._args_network_interface_ip_configuration_create
        network_interface_ip_configuration_create.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        network_interface_ip_configuration_create.id = AAZStrArg(
            options=["id"],
            help="Resource Identifier.",
        )
        network_interface_ip_configuration_create.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        network_interface_ip_configuration_create.load_balancer_backend_address_pools = AAZListArg(
            options=["load-balancer-backend-address-pools"],
            help="The reference of LoadBalancerBackendAddressPool resource.",
        )
        network_interface_ip_configuration_create.load_balancer_inbound_nat_rules = AAZListArg(
            options=["load-balancer-inbound-nat-rules"],
            help="A list of references of LoadBalancerInboundNatRules.",
        )
        network_interface_ip_configuration_create.primary = AAZBoolArg(
            options=["primary"],
            help="Gets whether this is a primary customer address on the network interface.",
        )
        network_interface_ip_configuration_create.private_ip_address = AAZStrArg(
            options=["private-ip-address"],
        )
        network_interface_ip_configuration_create.private_ip_allocation_method = AAZStrArg(
            options=["private-ip-allocation-method"],
            help="Defines how a private IP address is assigned. Possible values are: 'Static' and 'Dynamic'.",
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        network_interface_ip_configuration_create.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
        )
        network_interface_ip_configuration_create.public_ip_address = AAZObjectArg(
            options=["public-ip-address"],
            help="Public IP address resource.",
        )
        cls._build_args_public_ip_address_create(network_interface_ip_configuration_create.public_ip_address)
        network_interface_ip_configuration_create.subnet = AAZObjectArg(
            options=["subnet"],
        )
        cls._build_args_subnet_create(network_interface_ip_configuration_create.subnet)

        load_balancer_backend_address_pools = cls._args_network_interface_ip_configuration_create.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectArg()

        _element = cls._args_network_interface_ip_configuration_create.load_balancer_backend_address_pools.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource Identifier.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Gets name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.backend_ip_configurations = AAZListArg(
            options=["backend-ip-configurations"],
            help="Gets collection of references to IP addresses defined in network interfaces.",
        )
        _element.outbound_nat_rule = AAZObjectArg(
            options=["outbound-nat-rule"],
            help="Gets outbound rules that use this backend address pool.",
        )
        cls._build_args_sub_resource_create(_element.outbound_nat_rule)
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="Get provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )

        backend_ip_configurations = cls._args_network_interface_ip_configuration_create.load_balancer_backend_address_pools.Element.backend_ip_configurations
        backend_ip_configurations.Element = AAZObjectArg()
        cls._build_args_network_interface_ip_configuration_create(backend_ip_configurations.Element)

        load_balancer_inbound_nat_rules = cls._args_network_interface_ip_configuration_create.load_balancer_inbound_nat_rules
        load_balancer_inbound_nat_rules.Element = AAZObjectArg()

        _element = cls._args_network_interface_ip_configuration_create.load_balancer_inbound_nat_rules.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource Identifier.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Gets name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.backend_ip_configuration = AAZObjectArg(
            options=["backend-ip-configuration"],
            help="A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations is forwarded to the backed IP.",
        )
        cls._build_args_network_interface_ip_configuration_create(_element.backend_ip_configuration)
        _element.backend_port = AAZIntArg(
            options=["backend-port"],
            help="The port used for the internal endpoint. Acceptable values range from 1 to 65535.",
        )
        _element.enable_floating_ip = AAZBoolArg(
            options=["enable-floating-ip"],
            help="Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.",
        )
        _element.frontend_ip_configuration = AAZObjectArg(
            options=["frontend-ip-configuration"],
            help="A reference to frontend IP addresses.",
        )
        cls._build_args_sub_resource_create(_element.frontend_ip_configuration)
        _element.frontend_port = AAZIntArg(
            options=["frontend-port"],
            help="The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.",
        )
        _element.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'",
            enum={"Tcp": "Tcp", "Udp": "Udp"},
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )

        _schema.etag = cls._args_network_interface_ip_configuration_create.etag
        _schema.id = cls._args_network_interface_ip_configuration_create.id
        _schema.load_balancer_backend_address_pools = cls._args_network_interface_ip_configuration_create.load_balancer_backend_address_pools
        _schema.load_balancer_inbound_nat_rules = cls._args_network_interface_ip_configuration_create.load_balancer_inbound_nat_rules
        _schema.name = cls._args_network_interface_ip_configuration_create.name
        _schema.primary = cls._args_network_interface_ip_configuration_create.primary
        _schema.private_ip_address = cls._args_network_interface_ip_configuration_create.private_ip_address
        _schema.private_ip_allocation_method = cls._args_network_interface_ip_configuration_create.private_ip_allocation_method
        _schema.provisioning_state = cls._args_network_interface_ip_configuration_create.provisioning_state
        _schema.public_ip_address = cls._args_network_interface_ip_configuration_create.public_ip_address
        _schema.subnet = cls._args_network_interface_ip_configuration_create.subnet

    _args_network_security_group_create = None

    @classmethod
    def _build_args_network_security_group_create(cls, _schema):
        if cls._args_network_security_group_create is not None:
            _schema.default_security_rules = cls._args_network_security_group_create.default_security_rules
            _schema.etag = cls._args_network_security_group_create.etag
            _schema.id = cls._args_network_security_group_create.id
            _schema.location = cls._args_network_security_group_create.location
            _schema.network_interfaces = cls._args_network_security_group_create.network_interfaces
            _schema.resource_guid = cls._args_network_security_group_create.resource_guid
            _schema.security_rules = cls._args_network_security_group_create.security_rules
            _schema.subnets = cls._args_network_security_group_create.subnets
            _schema.tags = cls._args_network_security_group_create.tags
            return

        cls._args_network_security_group_create = AAZObjectArg()

        network_security_group_create = cls._args_network_security_group_create
        network_security_group_create.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        network_security_group_create.id = AAZResourceIdArg(
            options=["id"],
            help="Resource Identifier.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/networkSecurityGroups/{}",
            ),
        )
        network_security_group_create.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        network_security_group_create.default_security_rules = AAZListArg(
            options=["default-security-rules"],
            help="The default security rules of network security group.",
        )
        network_security_group_create.network_interfaces = AAZListArg(
            options=["network-interfaces"],
            help="A collection of references to network interfaces.",
        )
        network_security_group_create.resource_guid = AAZStrArg(
            options=["resource-guid"],
            help="The resource GUID property of the network security group resource.",
        )
        network_security_group_create.security_rules = AAZListArg(
            options=["security-rules"],
            help="A collection of security rules of the network security group.",
        )
        network_security_group_create.subnets = AAZListArg(
            options=["subnets"],
            help="A collection of references to subnets.",
        )
        network_security_group_create.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        default_security_rules = cls._args_network_security_group_create.default_security_rules
        default_security_rules.Element = AAZObjectArg()
        cls._build_args_security_rule_create(default_security_rules.Element)

        network_interfaces = cls._args_network_security_group_create.network_interfaces
        network_interfaces.Element = AAZObjectArg()

        _element = cls._args_network_security_group_create.network_interfaces.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource Identifier.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/networkInterfaces/{}",
            ),
        )
        _element.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _element.dns_settings = AAZObjectArg(
            options=["dns-settings"],
            help="The DNS settings in network interface.",
        )
        _element.enable_ip_forwarding = AAZBoolArg(
            options=["enable-ip-forwarding"],
            help="Indicates whether IP forwarding is enabled on this network interface.",
        )
        _element.ip_configurations = AAZListArg(
            options=["ip-configurations"],
            help="A list of IPConfigurations of the network interface.",
        )
        _element.mac_address = AAZStrArg(
            options=["mac-address"],
            help="The MAC address of the network interface.",
        )
        _element.network_security_group = AAZObjectArg(
            options=["network-security-group"],
            help="The reference of the NetworkSecurityGroup resource.",
        )
        cls._build_args_network_security_group_create(_element.network_security_group)
        _element.primary = AAZBoolArg(
            options=["primary"],
            help="Gets whether this is a primary network interface on a virtual machine.",
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        _element.resource_guid = AAZStrArg(
            options=["resource-guid"],
            help="The resource GUID property of the network interface resource.",
        )
        _element.virtual_machine = AAZObjectArg(
            options=["virtual-machine"],
            help="The reference of a virtual machine.",
        )
        cls._build_args_sub_resource_create(_element.virtual_machine)
        _element.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        dns_settings = cls._args_network_security_group_create.network_interfaces.Element.dns_settings
        dns_settings.applied_dns_servers = AAZListArg(
            options=["applied-dns-servers"],
            help="If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from all NICs that are part of the Availability Set. This property is what is configured on each of those VMs.",
        )
        dns_settings.dns_servers = AAZListArg(
            options=["dns-servers"],
            help="List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be the only value in dnsServers collection.",
        )
        dns_settings.internal_dns_name_label = AAZStrArg(
            options=["internal-dns-name-label"],
            help="Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.",
        )
        dns_settings.internal_fqdn = AAZStrArg(
            options=["internal-fqdn"],
            help="Fully qualified DNS name supporting internal communications between VMs in the same virtual network.",
        )

        applied_dns_servers = cls._args_network_security_group_create.network_interfaces.Element.dns_settings.applied_dns_servers
        applied_dns_servers.Element = AAZStrArg()

        dns_servers = cls._args_network_security_group_create.network_interfaces.Element.dns_settings.dns_servers
        dns_servers.Element = AAZStrArg()

        ip_configurations = cls._args_network_security_group_create.network_interfaces.Element.ip_configurations
        ip_configurations.Element = AAZObjectArg()
        cls._build_args_network_interface_ip_configuration_create(ip_configurations.Element)

        tags = cls._args_network_security_group_create.network_interfaces.Element.tags
        tags.Element = AAZStrArg()

        security_rules = cls._args_network_security_group_create.security_rules
        security_rules.Element = AAZObjectArg()
        cls._build_args_security_rule_create(security_rules.Element)

        subnets = cls._args_network_security_group_create.subnets
        subnets.Element = AAZObjectArg()
        cls._build_args_subnet_create(subnets.Element)

        tags = cls._args_network_security_group_create.tags
        tags.Element = AAZStrArg()

        _schema.default_security_rules = cls._args_network_security_group_create.default_security_rules
        _schema.etag = cls._args_network_security_group_create.etag
        _schema.id = cls._args_network_security_group_create.id
        _schema.location = cls._args_network_security_group_create.location
        _schema.network_interfaces = cls._args_network_security_group_create.network_interfaces
        _schema.resource_guid = cls._args_network_security_group_create.resource_guid
        _schema.security_rules = cls._args_network_security_group_create.security_rules
        _schema.subnets = cls._args_network_security_group_create.subnets
        _schema.tags = cls._args_network_security_group_create.tags

    _args_public_ip_address_create = None

    @classmethod
    def _build_args_public_ip_address_create(cls, _schema):
        if cls._args_public_ip_address_create is not None:
            _schema.dns_settings = cls._args_public_ip_address_create.dns_settings
            _schema.etag = cls._args_public_ip_address_create.etag
            _schema.idle_timeout_in_minutes = cls._args_public_ip_address_create.idle_timeout_in_minutes
            _schema.ip_address = cls._args_public_ip_address_create.ip_address
            _schema.ip_configuration = cls._args_public_ip_address_create.ip_configuration
            _schema.location = cls._args_public_ip_address_create.location
            _schema.provisioning_state = cls._args_public_ip_address_create.provisioning_state
            _schema.public_ip_allocation_method = cls._args_public_ip_address_create.public_ip_allocation_method
            _schema.resource_guid = cls._args_public_ip_address_create.resource_guid
            _schema.tags = cls._args_public_ip_address_create.tags
            return

        cls._args_public_ip_address_create = AAZObjectArg()

        public_ip_address_create = cls._args_public_ip_address_create
        public_ip_address_create.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        public_ip_address_create.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        public_ip_address_create.dns_settings = AAZObjectArg(
            options=["dns-settings"],
            help="The FQDN of the DNS record associated with the public IP address.",
        )
        public_ip_address_create.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The idle timeout of the public IP address.",
        )
        public_ip_address_create.ip_address = AAZStrArg(
            options=["ip-address"],
        )
        public_ip_address_create.ip_configuration = AAZObjectArg(
            options=["ip-configuration"],
            help="IPConfiguration",
        )
        cls._build_args_ip_configuration_create(public_ip_address_create.ip_configuration)
        public_ip_address_create.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        public_ip_address_create.public_ip_allocation_method = AAZStrArg(
            options=["public-ip-allocation-method"],
            help="The public IP allocation method. Possible values are: 'Static' and 'Dynamic'.",
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        public_ip_address_create.resource_guid = AAZStrArg(
            options=["resource-guid"],
            help="The resource GUID property of the public IP resource.",
        )
        public_ip_address_create.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        dns_settings = cls._args_public_ip_address_create.dns_settings
        dns_settings.domain_name_label = AAZStrArg(
            options=["domain-name-label"],
            help="Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.",
        )
        dns_settings.fqdn = AAZStrArg(
            options=["fqdn"],
            help="Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.",
        )
        dns_settings.reverse_fqdn = AAZStrArg(
            options=["reverse-fqdn"],
            help="Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN. ",
        )

        tags = cls._args_public_ip_address_create.tags
        tags.Element = AAZStrArg()

        _schema.dns_settings = cls._args_public_ip_address_create.dns_settings
        _schema.etag = cls._args_public_ip_address_create.etag
        _schema.idle_timeout_in_minutes = cls._args_public_ip_address_create.idle_timeout_in_minutes
        _schema.ip_address = cls._args_public_ip_address_create.ip_address
        _schema.ip_configuration = cls._args_public_ip_address_create.ip_configuration
        _schema.location = cls._args_public_ip_address_create.location
        _schema.provisioning_state = cls._args_public_ip_address_create.provisioning_state
        _schema.public_ip_allocation_method = cls._args_public_ip_address_create.public_ip_allocation_method
        _schema.resource_guid = cls._args_public_ip_address_create.resource_guid
        _schema.tags = cls._args_public_ip_address_create.tags

    _args_security_rule_create = None

    @classmethod
    def _build_args_security_rule_create(cls, _schema):
        if cls._args_security_rule_create is not None:
            _schema.access = cls._args_security_rule_create.access
            _schema.description = cls._args_security_rule_create.description
            _schema.destination_address_prefix = cls._args_security_rule_create.destination_address_prefix
            _schema.destination_port_range = cls._args_security_rule_create.destination_port_range
            _schema.direction = cls._args_security_rule_create.direction
            _schema.etag = cls._args_security_rule_create.etag
            _schema.name = cls._args_security_rule_create.name
            _schema.priority = cls._args_security_rule_create.priority
            _schema.protocol = cls._args_security_rule_create.protocol
            _schema.provisioning_state = cls._args_security_rule_create.provisioning_state
            _schema.source_address_prefix = cls._args_security_rule_create.source_address_prefix
            _schema.source_port_range = cls._args_security_rule_create.source_port_range
            return

        cls._args_security_rule_create = AAZObjectArg()

        security_rule_create = cls._args_security_rule_create
        security_rule_create.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        security_rule_create.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        security_rule_create.access = AAZStrArg(
            options=["access"],
            help="The network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'.",
            enum={"Allow": "Allow", "Deny": "Deny"},
        )
        security_rule_create.description = AAZStrArg(
            options=["description"],
            help="A description for this rule. Restricted to 140 chars.",
        )
        security_rule_create.destination_address_prefix = AAZStrArg(
            options=["destination-address-prefix"],
            help="The destination address prefix. CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.",
        )
        security_rule_create.destination_port_range = AAZStrArg(
            options=["destination-port-range"],
            help="The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.",
        )
        security_rule_create.direction = AAZStrArg(
            options=["direction"],
            help="The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'.",
            enum={"Inbound": "Inbound", "Outbound": "Outbound"},
        )
        security_rule_create.priority = AAZIntArg(
            options=["priority"],
            help="The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.",
        )
        security_rule_create.protocol = AAZStrArg(
            options=["protocol"],
            help="Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and '*'.",
            enum={"*": "*", "Tcp": "Tcp", "Udp": "Udp"},
        )
        security_rule_create.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        security_rule_create.source_address_prefix = AAZStrArg(
            options=["source-address-prefix"],
            help="The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from. ",
        )
        security_rule_create.source_port_range = AAZStrArg(
            options=["source-port-range"],
            help="The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.",
        )

        _schema.access = cls._args_security_rule_create.access
        _schema.description = cls._args_security_rule_create.description
        _schema.destination_address_prefix = cls._args_security_rule_create.destination_address_prefix
        _schema.destination_port_range = cls._args_security_rule_create.destination_port_range
        _schema.direction = cls._args_security_rule_create.direction
        _schema.etag = cls._args_security_rule_create.etag
        _schema.name = cls._args_security_rule_create.name
        _schema.priority = cls._args_security_rule_create.priority
        _schema.protocol = cls._args_security_rule_create.protocol
        _schema.provisioning_state = cls._args_security_rule_create.provisioning_state
        _schema.source_address_prefix = cls._args_security_rule_create.source_address_prefix
        _schema.source_port_range = cls._args_security_rule_create.source_port_range

    _args_sub_resource_create = None

    @classmethod
    def _build_args_sub_resource_create(cls, _schema):
        if cls._args_sub_resource_create is not None:
            _schema.id = cls._args_sub_resource_create.id
            return

        cls._args_sub_resource_create = AAZObjectArg()

        sub_resource_create = cls._args_sub_resource_create
        sub_resource_create.id = AAZStrArg(
            options=["id"],
            help="Resource Identifier.",
        )

        _schema.id = cls._args_sub_resource_create.id

    _args_subnet_create = None

    @classmethod
    def _build_args_subnet_create(cls, _schema):
        if cls._args_subnet_create is not None:
            _schema.address_prefix = cls._args_subnet_create.address_prefix
            _schema.etag = cls._args_subnet_create.etag
            _schema.ip_configurations = cls._args_subnet_create.ip_configurations
            _schema.name = cls._args_subnet_create.name
            _schema.network_security_group = cls._args_subnet_create.network_security_group
            _schema.route_table = cls._args_subnet_create.route_table
            return

        cls._args_subnet_create = AAZObjectArg()

        subnet_create = cls._args_subnet_create
        subnet_create.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        subnet_create.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        subnet_create.address_prefix = AAZStrArg(
            options=["address-prefix"],
            help="The address prefix for the subnet.",
        )
        subnet_create.ip_configurations = AAZListArg(
            options=["ip-configurations"],
            help="Gets an array of references to the network interface IP configurations using subnet.",
        )
        subnet_create.network_security_group = AAZObjectArg(
            options=["network-security-group"],
            help="The reference of the NetworkSecurityGroup resource.",
        )
        cls._build_args_network_security_group_create(subnet_create.network_security_group)
        subnet_create.route_table = AAZObjectArg(
            options=["route-table"],
            help="The reference of the RouteTable resource.",
        )

        ip_configurations = cls._args_subnet_create.ip_configurations
        ip_configurations.Element = AAZObjectArg()
        cls._build_args_ip_configuration_create(ip_configurations.Element)

        route_table = cls._args_subnet_create.route_table
        route_table.etag = AAZStrArg(
            options=["etag"],
            help="Gets a unique read-only string that changes whenever the resource is updated.",
        )
        route_table.id = AAZResourceIdArg(
            options=["id"],
            help="Resource Identifier.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/routeTables/{}",
            ),
        )
        route_table.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        route_table.routes = AAZListArg(
            options=["routes"],
            help="Collection of routes contained within a route table.",
        )
        route_table.subnets = AAZListArg(
            options=["subnets"],
            help="A collection of references to subnets.",
        )
        route_table.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        routes = cls._args_subnet_create.route_table.routes
        routes.Element = AAZObjectArg()

        _element = cls._args_subnet_create.route_table.routes.Element
        _element.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource Identifier.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/routeTables/{}/routes/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.address_prefix = AAZStrArg(
            options=["address-prefix"],
            help="The destination CIDR to which the route applies.",
        )
        _element.next_hop_ip_address = AAZStrArg(
            options=["next-hop-ip-address"],
            help="The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.",
        )
        _element.next_hop_type = AAZStrArg(
            options=["next-hop-type"],
            help="The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'",
            enum={"Internet": "Internet", "None": "None", "VirtualAppliance": "VirtualAppliance", "VirtualNetworkGateway": "VirtualNetworkGateway", "VnetLocal": "VnetLocal"},
        )
        _element.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )

        subnets = cls._args_subnet_create.route_table.subnets
        subnets.Element = AAZObjectArg()
        cls._build_args_subnet_create(subnets.Element)

        tags = cls._args_subnet_create.route_table.tags
        tags.Element = AAZStrArg()

        _schema.address_prefix = cls._args_subnet_create.address_prefix
        _schema.etag = cls._args_subnet_create.etag
        _schema.ip_configurations = cls._args_subnet_create.ip_configurations
        _schema.name = cls._args_subnet_create.name
        _schema.network_security_group = cls._args_subnet_create.network_security_group
        _schema.route_table = cls._args_subnet_create.route_table

    def _execute_operations(self):
        self.pre_operations()
        yield self.VirtualNetworksCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class VirtualNetworksCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "virtualNetworkName", self.ctx.args.name,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2015-06-15",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("location", AAZStrType, ".location")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("addressSpace", AAZObjectType)
                properties.set_prop("dhcpOptions", AAZObjectType)
                properties.set_prop("subnets", AAZListType, ".subnets")

            address_space = _builder.get(".properties.addressSpace")
            if address_space is not None:
                address_space.set_prop("addressPrefixes", AAZListType, ".address_prefixes")

            address_prefixes = _builder.get(".properties.addressSpace.addressPrefixes")
            if address_prefixes is not None:
                address_prefixes.set_elements(AAZStrType, ".")

            dhcp_options = _builder.get(".properties.dhcpOptions")
            if dhcp_options is not None:
                dhcp_options.set_prop("dnsServers", AAZListType, ".dns_servers")

            dns_servers = _builder.get(".properties.dhcpOptions.dnsServers")
            if dns_servers is not None:
                dns_servers.set_elements(AAZStrType, ".")

            subnets = _builder.get(".properties.subnets")
            if subnets is not None:
                subnets.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.subnets[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.subnets[].properties")
            if properties is not None:
                properties.set_prop("addressPrefix", AAZStrType, ".address_prefix")
                properties.set_prop("networkSecurityGroup", AAZObjectType, ".network_security_group")
                properties.set_prop("routeTable", AAZObjectType, ".route_table")

            network_security_group = _builder.get(".properties.subnets[].properties.networkSecurityGroup")
            if network_security_group is not None:
                network_security_group.set_prop("id", AAZStrType, ".id")
                network_security_group.set_prop("location", AAZStrType, ".location")
                network_security_group.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                network_security_group.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties.subnets[].properties.networkSecurityGroup.properties")
            if properties is not None:
                properties.set_prop("securityRules", AAZListType, ".security_rules")

            security_rules = _builder.get(".properties.subnets[].properties.networkSecurityGroup.properties.securityRules")
            if security_rules is not None:
                security_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.subnets[].properties.networkSecurityGroup.properties.securityRules[]")
            if _elements is not None:
                _elements.set_prop("etag", AAZStrType, ".etag")
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.subnets[].properties.networkSecurityGroup.properties.securityRules[].properties")
            if properties is not None:
                properties.set_prop("access", AAZStrType, ".access", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("description", AAZStrType, ".description")
                properties.set_prop("destinationAddressPrefix", AAZStrType, ".destination_address_prefix", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("destinationPortRange", AAZStrType, ".destination_port_range")
                properties.set_prop("direction", AAZStrType, ".direction", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("priority", AAZIntType, ".priority")
                properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
                properties.set_prop("sourceAddressPrefix", AAZStrType, ".source_address_prefix", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("sourcePortRange", AAZStrType, ".source_port_range")

            tags = _builder.get(".properties.subnets[].properties.networkSecurityGroup.tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            route_table = _builder.get(".properties.subnets[].properties.routeTable")
            if route_table is not None:
                route_table.set_prop("id", AAZStrType, ".id")
                route_table.set_prop("location", AAZStrType, ".location")
                route_table.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                route_table.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties.subnets[].properties.routeTable.properties")
            if properties is not None:
                properties.set_prop("routes", AAZListType, ".routes")

            routes = _builder.get(".properties.subnets[].properties.routeTable.properties.routes")
            if routes is not None:
                routes.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.subnets[].properties.routeTable.properties.routes[]")
            if _elements is not None:
                _elements.set_prop("etag", AAZStrType, ".etag")
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.subnets[].properties.routeTable.properties.routes[].properties")
            if properties is not None:
                properties.set_prop("addressPrefix", AAZStrType, ".address_prefix")
                properties.set_prop("nextHopIpAddress", AAZStrType, ".next_hop_ip_address")
                properties.set_prop("nextHopType", AAZStrType, ".next_hop_type", typ_kwargs={"flags": {"required": True}})

            tags = _builder.get(".properties.subnets[].properties.routeTable.tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()

            _schema_on_200_201 = cls._schema_on_200_201
            _schema_on_200_201.etag = AAZStrType()
            _schema_on_200_201.id = AAZStrType()
            _schema_on_200_201.location = AAZStrType()
            _schema_on_200_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200_201.tags = AAZDictType()
            _schema_on_200_201.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties
            properties.address_space = AAZObjectType(
                serialized_name="addressSpace",
            )
            properties.dhcp_options = AAZObjectType(
                serialized_name="dhcpOptions",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )
            properties.resource_guid = AAZStrType(
                serialized_name="resourceGuid",
            )
            properties.subnets = AAZListType()

            address_space = cls._schema_on_200_201.properties.address_space
            address_space.address_prefixes = AAZListType(
                serialized_name="addressPrefixes",
            )

            address_prefixes = cls._schema_on_200_201.properties.address_space.address_prefixes
            address_prefixes.Element = AAZStrType()

            dhcp_options = cls._schema_on_200_201.properties.dhcp_options
            dhcp_options.dns_servers = AAZListType(
                serialized_name="dnsServers",
            )

            dns_servers = cls._schema_on_200_201.properties.dhcp_options.dns_servers
            dns_servers.Element = AAZStrType()

            subnets = cls._schema_on_200_201.properties.subnets
            subnets.Element = AAZObjectType()
            _CreateHelper._build_schema_subnet_read(subnets.Element)

            tags = cls._schema_on_200_201.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200_201


class _CreateHelper:
    """Helper class for Create"""

    @classmethod
    def _build_schema_ip_configuration_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("etag", AAZStrType, ".etag")
        _builder.set_prop("id", AAZStrType, ".id")
        _builder.set_prop("name", AAZStrType, ".name")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties")
        if properties is not None:
            properties.set_prop("privateIPAddress", AAZStrType, ".private_ip_address")
            properties.set_prop("privateIPAllocationMethod", AAZStrType, ".private_ip_allocation_method")
            cls._build_schema_public_ip_address_create(properties.set_prop("publicIPAddress", AAZObjectType, ".public_ip_address"))
            cls._build_schema_subnet_create(properties.set_prop("subnet", AAZObjectType, ".subnet"))

    @classmethod
    def _build_schema_network_interface_ip_configuration_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("etag", AAZStrType, ".etag")
        _builder.set_prop("id", AAZStrType, ".id")
        _builder.set_prop("name", AAZStrType, ".name")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties")
        if properties is not None:
            properties.set_prop("loadBalancerBackendAddressPools", AAZListType, ".load_balancer_backend_address_pools")
            properties.set_prop("loadBalancerInboundNatRules", AAZListType, ".load_balancer_inbound_nat_rules")
            properties.set_prop("primary", AAZBoolType, ".primary")
            properties.set_prop("privateIPAddress", AAZStrType, ".private_ip_address")
            properties.set_prop("privateIPAllocationMethod", AAZStrType, ".private_ip_allocation_method")
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            cls._build_schema_public_ip_address_create(properties.set_prop("publicIPAddress", AAZObjectType, ".public_ip_address"))
            cls._build_schema_subnet_create(properties.set_prop("subnet", AAZObjectType, ".subnet"))

        load_balancer_backend_address_pools = _builder.get(".properties.loadBalancerBackendAddressPools")
        if load_balancer_backend_address_pools is not None:
            load_balancer_backend_address_pools.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.loadBalancerBackendAddressPools[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties.loadBalancerBackendAddressPools[].properties")
        if properties is not None:
            properties.set_prop("backendIPConfigurations", AAZListType, ".backend_ip_configurations")
            cls._build_schema_sub_resource_create(properties.set_prop("outboundNatRule", AAZObjectType, ".outbound_nat_rule"))
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")

        backend_ip_configurations = _builder.get(".properties.loadBalancerBackendAddressPools[].properties.backendIPConfigurations")
        if backend_ip_configurations is not None:
            cls._build_schema_network_interface_ip_configuration_create(backend_ip_configurations.set_elements(AAZObjectType, "."))

        load_balancer_inbound_nat_rules = _builder.get(".properties.loadBalancerInboundNatRules")
        if load_balancer_inbound_nat_rules is not None:
            load_balancer_inbound_nat_rules.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.loadBalancerInboundNatRules[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties.loadBalancerInboundNatRules[].properties")
        if properties is not None:
            cls._build_schema_network_interface_ip_configuration_create(properties.set_prop("backendIPConfiguration", AAZObjectType, ".backend_ip_configuration"))
            properties.set_prop("backendPort", AAZIntType, ".backend_port")
            properties.set_prop("enableFloatingIP", AAZBoolType, ".enable_floating_ip")
            cls._build_schema_sub_resource_create(properties.set_prop("frontendIPConfiguration", AAZObjectType, ".frontend_ip_configuration"))
            properties.set_prop("frontendPort", AAZIntType, ".frontend_port")
            properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
            properties.set_prop("protocol", AAZStrType, ".protocol")
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")

    @classmethod
    def _build_schema_network_security_group_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("etag", AAZStrType, ".etag")
        _builder.set_prop("id", AAZStrType, ".id")
        _builder.set_prop("location", AAZStrType, ".location")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
        _builder.set_prop("tags", AAZDictType, ".tags")

        properties = _builder.get(".properties")
        if properties is not None:
            properties.set_prop("defaultSecurityRules", AAZListType, ".default_security_rules")
            properties.set_prop("networkInterfaces", AAZListType, ".network_interfaces")
            properties.set_prop("resourceGuid", AAZStrType, ".resource_guid")
            properties.set_prop("securityRules", AAZListType, ".security_rules")
            properties.set_prop("subnets", AAZListType, ".subnets")

        default_security_rules = _builder.get(".properties.defaultSecurityRules")
        if default_security_rules is not None:
            cls._build_schema_security_rule_create(default_security_rules.set_elements(AAZObjectType, "."))

        network_interfaces = _builder.get(".properties.networkInterfaces")
        if network_interfaces is not None:
            network_interfaces.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.networkInterfaces[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("location", AAZStrType, ".location")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _elements.set_prop("tags", AAZDictType, ".tags")

        properties = _builder.get(".properties.networkInterfaces[].properties")
        if properties is not None:
            properties.set_prop("dnsSettings", AAZObjectType, ".dns_settings")
            properties.set_prop("enableIPForwarding", AAZBoolType, ".enable_ip_forwarding")
            properties.set_prop("ipConfigurations", AAZListType, ".ip_configurations")
            properties.set_prop("macAddress", AAZStrType, ".mac_address")
            cls._build_schema_network_security_group_create(properties.set_prop("networkSecurityGroup", AAZObjectType, ".network_security_group"))
            properties.set_prop("primary", AAZBoolType, ".primary")
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            properties.set_prop("resourceGuid", AAZStrType, ".resource_guid")
            cls._build_schema_sub_resource_create(properties.set_prop("virtualMachine", AAZObjectType, ".virtual_machine"))

        dns_settings = _builder.get(".properties.networkInterfaces[].properties.dnsSettings")
        if dns_settings is not None:
            dns_settings.set_prop("appliedDnsServers", AAZListType, ".applied_dns_servers")
            dns_settings.set_prop("dnsServers", AAZListType, ".dns_servers")
            dns_settings.set_prop("internalDnsNameLabel", AAZStrType, ".internal_dns_name_label")
            dns_settings.set_prop("internalFqdn", AAZStrType, ".internal_fqdn")

        applied_dns_servers = _builder.get(".properties.networkInterfaces[].properties.dnsSettings.appliedDnsServers")
        if applied_dns_servers is not None:
            applied_dns_servers.set_elements(AAZStrType, ".")

        dns_servers = _builder.get(".properties.networkInterfaces[].properties.dnsSettings.dnsServers")
        if dns_servers is not None:
            dns_servers.set_elements(AAZStrType, ".")

        ip_configurations = _builder.get(".properties.networkInterfaces[].properties.ipConfigurations")
        if ip_configurations is not None:
            cls._build_schema_network_interface_ip_configuration_create(ip_configurations.set_elements(AAZObjectType, "."))

        tags = _builder.get(".properties.networkInterfaces[].tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

        security_rules = _builder.get(".properties.securityRules")
        if security_rules is not None:
            cls._build_schema_security_rule_create(security_rules.set_elements(AAZObjectType, "."))

        subnets = _builder.get(".properties.subnets")
        if subnets is not None:
            cls._build_schema_subnet_create(subnets.set_elements(AAZObjectType, "."))

        tags = _builder.get(".tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_public_ip_address_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("etag", AAZStrType, ".etag")
        _builder.set_prop("location", AAZStrType, ".location")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
        _builder.set_prop("tags", AAZDictType, ".tags")

        properties = _builder.get(".properties")
        if properties is not None:
            properties.set_prop("dnsSettings", AAZObjectType, ".dns_settings")
            properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
            properties.set_prop("ipAddress", AAZStrType, ".ip_address")
            cls._build_schema_ip_configuration_create(properties.set_prop("ipConfiguration", AAZObjectType, ".ip_configuration"))
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            properties.set_prop("publicIPAllocationMethod", AAZStrType, ".public_ip_allocation_method")
            properties.set_prop("resourceGuid", AAZStrType, ".resource_guid")

        dns_settings = _builder.get(".properties.dnsSettings")
        if dns_settings is not None:
            dns_settings.set_prop("domainNameLabel", AAZStrType, ".domain_name_label")
            dns_settings.set_prop("fqdn", AAZStrType, ".fqdn")
            dns_settings.set_prop("reverseFqdn", AAZStrType, ".reverse_fqdn")

        tags = _builder.get(".tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_security_rule_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("etag", AAZStrType, ".etag")
        _builder.set_prop("name", AAZStrType, ".name")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties")
        if properties is not None:
            properties.set_prop("access", AAZStrType, ".access", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("description", AAZStrType, ".description")
            properties.set_prop("destinationAddressPrefix", AAZStrType, ".destination_address_prefix", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("destinationPortRange", AAZStrType, ".destination_port_range")
            properties.set_prop("direction", AAZStrType, ".direction", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("priority", AAZIntType, ".priority")
            properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            properties.set_prop("sourceAddressPrefix", AAZStrType, ".source_address_prefix", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("sourcePortRange", AAZStrType, ".source_port_range")

    @classmethod
    def _build_schema_sub_resource_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    @classmethod
    def _build_schema_subnet_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("etag", AAZStrType, ".etag")
        _builder.set_prop("name", AAZStrType, ".name")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties")
        if properties is not None:
            properties.set_prop("addressPrefix", AAZStrType, ".address_prefix")
            properties.set_prop("ipConfigurations", AAZListType, ".ip_configurations")
            cls._build_schema_network_security_group_create(properties.set_prop("networkSecurityGroup", AAZObjectType, ".network_security_group"))
            properties.set_prop("routeTable", AAZObjectType, ".route_table")

        ip_configurations = _builder.get(".properties.ipConfigurations")
        if ip_configurations is not None:
            cls._build_schema_ip_configuration_create(ip_configurations.set_elements(AAZObjectType, "."))

        route_table = _builder.get(".properties.routeTable")
        if route_table is not None:
            route_table.set_prop("etag", AAZStrType, ".etag")
            route_table.set_prop("id", AAZStrType, ".id")
            route_table.set_prop("location", AAZStrType, ".location")
            route_table.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            route_table.set_prop("tags", AAZDictType, ".tags")

        properties = _builder.get(".properties.routeTable.properties")
        if properties is not None:
            properties.set_prop("routes", AAZListType, ".routes")
            properties.set_prop("subnets", AAZListType, ".subnets")

        routes = _builder.get(".properties.routeTable.properties.routes")
        if routes is not None:
            routes.set_elements(AAZObjectType, ".")

        _elements = _builder.get(".properties.routeTable.properties.routes[]")
        if _elements is not None:
            _elements.set_prop("etag", AAZStrType, ".etag")
            _elements.set_prop("id", AAZStrType, ".id")
            _elements.set_prop("name", AAZStrType, ".name")
            _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties.routeTable.properties.routes[].properties")
        if properties is not None:
            properties.set_prop("addressPrefix", AAZStrType, ".address_prefix")
            properties.set_prop("nextHopIpAddress", AAZStrType, ".next_hop_ip_address")
            properties.set_prop("nextHopType", AAZStrType, ".next_hop_type", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")

        subnets = _builder.get(".properties.routeTable.properties.subnets")
        if subnets is not None:
            cls._build_schema_subnet_create(subnets.set_elements(AAZObjectType, "."))

        tags = _builder.get(".properties.routeTable.tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

    _schema_ip_configuration_read = None

    @classmethod
    def _build_schema_ip_configuration_read(cls, _schema):
        if cls._schema_ip_configuration_read is not None:
            _schema.etag = cls._schema_ip_configuration_read.etag
            _schema.id = cls._schema_ip_configuration_read.id
            _schema.name = cls._schema_ip_configuration_read.name
            _schema.properties = cls._schema_ip_configuration_read.properties
            return

        cls._schema_ip_configuration_read = _schema_ip_configuration_read = AAZObjectType()

        ip_configuration_read = _schema_ip_configuration_read
        ip_configuration_read.etag = AAZStrType()
        ip_configuration_read.id = AAZStrType()
        ip_configuration_read.name = AAZStrType()
        ip_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_ip_configuration_read.properties
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        _schema.etag = cls._schema_ip_configuration_read.etag
        _schema.id = cls._schema_ip_configuration_read.id
        _schema.name = cls._schema_ip_configuration_read.name
        _schema.properties = cls._schema_ip_configuration_read.properties

    _schema_network_interface_ip_configuration_read = None

    @classmethod
    def _build_schema_network_interface_ip_configuration_read(cls, _schema):
        if cls._schema_network_interface_ip_configuration_read is not None:
            _schema.etag = cls._schema_network_interface_ip_configuration_read.etag
            _schema.id = cls._schema_network_interface_ip_configuration_read.id
            _schema.name = cls._schema_network_interface_ip_configuration_read.name
            _schema.properties = cls._schema_network_interface_ip_configuration_read.properties
            return

        cls._schema_network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read = AAZObjectType()

        network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read
        network_interface_ip_configuration_read.etag = AAZStrType()
        network_interface_ip_configuration_read.id = AAZStrType()
        network_interface_ip_configuration_read.name = AAZStrType()
        network_interface_ip_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_network_interface_ip_configuration_read.properties
        properties.load_balancer_backend_address_pools = AAZListType(
            serialized_name="loadBalancerBackendAddressPools",
        )
        properties.load_balancer_inbound_nat_rules = AAZListType(
            serialized_name="loadBalancerInboundNatRules",
        )
        properties.primary = AAZBoolType()
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        load_balancer_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties
        properties.backend_ip_configurations = AAZListType(
            serialized_name="backendIPConfigurations",
        )
        properties.load_balancing_rules = AAZListType(
            serialized_name="loadBalancingRules",
            flags={"read_only": True},
        )
        properties.outbound_nat_rule = AAZObjectType(
            serialized_name="outboundNatRule",
        )
        cls._build_schema_sub_resource_read(properties.outbound_nat_rule)
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        backend_ip_configurations = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.backend_ip_configurations
        backend_ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

        load_balancing_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools.Element.properties.load_balancing_rules
        load_balancing_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancing_rules.Element)

        load_balancer_inbound_nat_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules
        load_balancer_inbound_nat_rules.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules.Element.properties
        properties.backend_ip_configuration = AAZObjectType(
            serialized_name="backendIPConfiguration",
        )
        cls._build_schema_network_interface_ip_configuration_read(properties.backend_ip_configuration)
        properties.backend_port = AAZIntType(
            serialized_name="backendPort",
        )
        properties.enable_floating_ip = AAZBoolType(
            serialized_name="enableFloatingIP",
        )
        properties.frontend_ip_configuration = AAZObjectType(
            serialized_name="frontendIPConfiguration",
        )
        cls._build_schema_sub_resource_read(properties.frontend_ip_configuration)
        properties.frontend_port = AAZIntType(
            serialized_name="frontendPort",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.protocol = AAZStrType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        _schema.etag = cls._schema_network_interface_ip_configuration_read.etag
        _schema.id = cls._schema_network_interface_ip_configuration_read.id
        _schema.name = cls._schema_network_interface_ip_configuration_read.name
        _schema.properties = cls._schema_network_interface_ip_configuration_read.properties

    _schema_network_security_group_read = None

    @classmethod
    def _build_schema_network_security_group_read(cls, _schema):
        if cls._schema_network_security_group_read is not None:
            _schema.etag = cls._schema_network_security_group_read.etag
            _schema.id = cls._schema_network_security_group_read.id
            _schema.location = cls._schema_network_security_group_read.location
            _schema.name = cls._schema_network_security_group_read.name
            _schema.properties = cls._schema_network_security_group_read.properties
            _schema.tags = cls._schema_network_security_group_read.tags
            _schema.type = cls._schema_network_security_group_read.type
            return

        cls._schema_network_security_group_read = _schema_network_security_group_read = AAZObjectType()

        network_security_group_read = _schema_network_security_group_read
        network_security_group_read.etag = AAZStrType()
        network_security_group_read.id = AAZStrType()
        network_security_group_read.location = AAZStrType()
        network_security_group_read.name = AAZStrType(
            flags={"read_only": True},
        )
        network_security_group_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        network_security_group_read.tags = AAZDictType()
        network_security_group_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_security_group_read.properties
        properties.default_security_rules = AAZListType(
            serialized_name="defaultSecurityRules",
        )
        properties.network_interfaces = AAZListType(
            serialized_name="networkInterfaces",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )
        properties.security_rules = AAZListType(
            serialized_name="securityRules",
        )
        properties.subnets = AAZListType()

        default_security_rules = _schema_network_security_group_read.properties.default_security_rules
        default_security_rules.Element = AAZObjectType()
        cls._build_schema_security_rule_read(default_security_rules.Element)

        network_interfaces = _schema_network_security_group_read.properties.network_interfaces
        network_interfaces.Element = AAZObjectType()

        _element = _schema_network_security_group_read.properties.network_interfaces.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.location = AAZStrType()
        _element.name = AAZStrType(
            flags={"read_only": True},
        )
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.tags = AAZDictType()
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_security_group_read.properties.network_interfaces.Element.properties
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.enable_ip_forwarding = AAZBoolType(
            serialized_name="enableIPForwarding",
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
        )
        properties.mac_address = AAZStrType(
            serialized_name="macAddress",
        )
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_network_security_group_read(properties.network_security_group)
        properties.primary = AAZBoolType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )
        properties.virtual_machine = AAZObjectType(
            serialized_name="virtualMachine",
        )
        cls._build_schema_sub_resource_read(properties.virtual_machine)

        dns_settings = _schema_network_security_group_read.properties.network_interfaces.Element.properties.dns_settings
        dns_settings.applied_dns_servers = AAZListType(
            serialized_name="appliedDnsServers",
        )
        dns_settings.dns_servers = AAZListType(
            serialized_name="dnsServers",
        )
        dns_settings.internal_dns_name_label = AAZStrType(
            serialized_name="internalDnsNameLabel",
        )
        dns_settings.internal_fqdn = AAZStrType(
            serialized_name="internalFqdn",
        )

        applied_dns_servers = _schema_network_security_group_read.properties.network_interfaces.Element.properties.dns_settings.applied_dns_servers
        applied_dns_servers.Element = AAZStrType()

        dns_servers = _schema_network_security_group_read.properties.network_interfaces.Element.properties.dns_settings.dns_servers
        dns_servers.Element = AAZStrType()

        ip_configurations = _schema_network_security_group_read.properties.network_interfaces.Element.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(ip_configurations.Element)

        tags = _schema_network_security_group_read.properties.network_interfaces.Element.tags
        tags.Element = AAZStrType()

        security_rules = _schema_network_security_group_read.properties.security_rules
        security_rules.Element = AAZObjectType()
        cls._build_schema_security_rule_read(security_rules.Element)

        subnets = _schema_network_security_group_read.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_network_security_group_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_network_security_group_read.etag
        _schema.id = cls._schema_network_security_group_read.id
        _schema.location = cls._schema_network_security_group_read.location
        _schema.name = cls._schema_network_security_group_read.name
        _schema.properties = cls._schema_network_security_group_read.properties
        _schema.tags = cls._schema_network_security_group_read.tags
        _schema.type = cls._schema_network_security_group_read.type

    _schema_public_ip_address_read = None

    @classmethod
    def _build_schema_public_ip_address_read(cls, _schema):
        if cls._schema_public_ip_address_read is not None:
            _schema.etag = cls._schema_public_ip_address_read.etag
            _schema.id = cls._schema_public_ip_address_read.id
            _schema.location = cls._schema_public_ip_address_read.location
            _schema.name = cls._schema_public_ip_address_read.name
            _schema.properties = cls._schema_public_ip_address_read.properties
            _schema.tags = cls._schema_public_ip_address_read.tags
            _schema.type = cls._schema_public_ip_address_read.type
            return

        cls._schema_public_ip_address_read = _schema_public_ip_address_read = AAZObjectType()

        public_ip_address_read = _schema_public_ip_address_read
        public_ip_address_read.etag = AAZStrType()
        public_ip_address_read.id = AAZStrType()
        public_ip_address_read.location = AAZStrType()
        public_ip_address_read.name = AAZStrType(
            flags={"read_only": True},
        )
        public_ip_address_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        public_ip_address_read.tags = AAZDictType()
        public_ip_address_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_public_ip_address_read.properties
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.ip_address = AAZStrType(
            serialized_name="ipAddress",
        )
        properties.ip_configuration = AAZObjectType(
            serialized_name="ipConfiguration",
        )
        cls._build_schema_ip_configuration_read(properties.ip_configuration)
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_allocation_method = AAZStrType(
            serialized_name="publicIPAllocationMethod",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )

        dns_settings = _schema_public_ip_address_read.properties.dns_settings
        dns_settings.domain_name_label = AAZStrType(
            serialized_name="domainNameLabel",
        )
        dns_settings.fqdn = AAZStrType()
        dns_settings.reverse_fqdn = AAZStrType(
            serialized_name="reverseFqdn",
        )

        tags = _schema_public_ip_address_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_public_ip_address_read.etag
        _schema.id = cls._schema_public_ip_address_read.id
        _schema.location = cls._schema_public_ip_address_read.location
        _schema.name = cls._schema_public_ip_address_read.name
        _schema.properties = cls._schema_public_ip_address_read.properties
        _schema.tags = cls._schema_public_ip_address_read.tags
        _schema.type = cls._schema_public_ip_address_read.type

    _schema_security_rule_read = None

    @classmethod
    def _build_schema_security_rule_read(cls, _schema):
        if cls._schema_security_rule_read is not None:
            _schema.etag = cls._schema_security_rule_read.etag
            _schema.id = cls._schema_security_rule_read.id
            _schema.name = cls._schema_security_rule_read.name
            _schema.properties = cls._schema_security_rule_read.properties
            return

        cls._schema_security_rule_read = _schema_security_rule_read = AAZObjectType()

        security_rule_read = _schema_security_rule_read
        security_rule_read.etag = AAZStrType()
        security_rule_read.id = AAZStrType()
        security_rule_read.name = AAZStrType()
        security_rule_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_security_rule_read.properties
        properties.access = AAZStrType(
            flags={"required": True},
        )
        properties.description = AAZStrType()
        properties.destination_address_prefix = AAZStrType(
            serialized_name="destinationAddressPrefix",
            flags={"required": True},
        )
        properties.destination_port_range = AAZStrType(
            serialized_name="destinationPortRange",
        )
        properties.direction = AAZStrType(
            flags={"required": True},
        )
        properties.priority = AAZIntType()
        properties.protocol = AAZStrType(
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.source_address_prefix = AAZStrType(
            serialized_name="sourceAddressPrefix",
            flags={"required": True},
        )
        properties.source_port_range = AAZStrType(
            serialized_name="sourcePortRange",
        )

        _schema.etag = cls._schema_security_rule_read.etag
        _schema.id = cls._schema_security_rule_read.id
        _schema.name = cls._schema_security_rule_read.name
        _schema.properties = cls._schema_security_rule_read.properties

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id

    _schema_subnet_read = None

    @classmethod
    def _build_schema_subnet_read(cls, _schema):
        if cls._schema_subnet_read is not None:
            _schema.etag = cls._schema_subnet_read.etag
            _schema.id = cls._schema_subnet_read.id
            _schema.name = cls._schema_subnet_read.name
            _schema.properties = cls._schema_subnet_read.properties
            return

        cls._schema_subnet_read = _schema_subnet_read = AAZObjectType()

        subnet_read = _schema_subnet_read
        subnet_read.etag = AAZStrType()
        subnet_read.id = AAZStrType()
        subnet_read.name = AAZStrType()
        subnet_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties
        properties.address_prefix = AAZStrType(
            serialized_name="addressPrefix",
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
        )
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_network_security_group_read(properties.network_security_group)
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.route_table = AAZObjectType(
            serialized_name="routeTable",
        )

        ip_configurations = _schema_subnet_read.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()
        cls._build_schema_ip_configuration_read(ip_configurations.Element)

        route_table = _schema_subnet_read.properties.route_table
        route_table.etag = AAZStrType()
        route_table.id = AAZStrType()
        route_table.location = AAZStrType()
        route_table.name = AAZStrType(
            flags={"read_only": True},
        )
        route_table.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        route_table.tags = AAZDictType()
        route_table.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.route_table.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.routes = AAZListType()
        properties.subnets = AAZListType()

        routes = _schema_subnet_read.properties.route_table.properties.routes
        routes.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.route_table.properties.routes.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.route_table.properties.routes.Element.properties
        properties.address_prefix = AAZStrType(
            serialized_name="addressPrefix",
        )
        properties.next_hop_ip_address = AAZStrType(
            serialized_name="nextHopIpAddress",
        )
        properties.next_hop_type = AAZStrType(
            serialized_name="nextHopType",
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        subnets = _schema_subnet_read.properties.route_table.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_subnet_read.properties.route_table.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_subnet_read.etag
        _schema.id = cls._schema_subnet_read.id
        _schema.name = cls._schema_subnet_read.name
        _schema.properties = cls._schema_subnet_read.properties


__all__ = ["Create"]
