/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "log.h"
#include "dtk_screenace_x11.h"

#include <xcb/xcb.h>
#include <X11/Xlib.h>
#include <X11/X.h>

int initX11ScreenAce()
{
    log_warn("xInitScreenAce is not available \n");
    return 0;
}

void destoryX11ScreenAce()
{
    log_warn("xDestoryScreenAce is not available \n");
}

bool xSetProtectedWindow(int32_t window)
{
    Display *dpy;
    dpy = XOpenDisplay(NULL);

    if (!dpy) {
        log_error(stderr, "Can not open display \n");
        return false;
    }

    bool bStatus = XUaceExtSetProtectedWindow(dpy, window);
    XCloseDisplay(dpy);
    return bStatus;
}

bool xRemoveProtectedWindow(int32_t window)
{
    Display *dpy;
    dpy = XOpenDisplay(NULL);

    if (!dpy) {
        log_error(stderr, "Can not open display \n");
        return false;
    }

    bool bStatus = XUaceExtRemoveProtectedWindow(dpy, window);
    XCloseDisplay(dpy);
    return bStatus;
}

bool xSetScreenShotTools(const char *name)
{
    Display *dpy;
    dpy = XOpenDisplay(NULL);

    if (!dpy) {
        log_error(stderr, "Can not open display \n");
        return false;
    }

    bool bStatus = XUaceExtSetScreenShotTools(dpy, name);
    return bStatus;
}

bool xRemoveScreenShotTools(char *name)
{
    Display *dpy;
    dpy = XOpenDisplay(NULL);

    if (!dpy) {
        log_error(stderr, "Can not open display \n");
        return false;
    }

    bool bStatus = XUaceExtRemoveScreenShotTools(dpy, name);
    return bStatus;
}

void xFreeScreenShotTools()
{
    Display *dpy;
    dpy = XOpenDisplay(NULL);

    if (!dpy) {
        log_error(stderr, "Can not open display \n");
        return;
    }

    XUaceExtFreeScreenShotTools(dpy);
}

void xSetProhibited(const char* white_lists, bool prohibit)
{

}