@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!/usr/bin/perl -w
#line 15
#
# ecaccess-certificate-create: Create Certificate for the ECtools
#
# Laurent.Gougeon@ecmwf.int - 2010-10-15

use ECMWF::ECaccess;
use Getopt::Long;
use Pod::Usage;
use Term::ReadKey;

my %opt = ( version => 0, help => 0, manual => 0, retry => 0, debug => 0 );

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if !GetOptions(
	\%opt,
	qw(
	  version
	  help|?
	  manual
	  retry=i
	  debug
	  )
);

# Display version if requested
die ECMWF::ECaccess->VERSION . "\n" if ( $opt{version} );

pod2usage( -noperldoc => 1, -exit => 1, verbose => 1 ) if ( $opt{help} );
pod2usage( -noperldoc => 1, -exit => 1, verbose => 2 ) if ( $opt{manual} );

my $userid = $ARGV[0];

# Get the userid if not specified
if ( not($userid) ) {
	print "Please enter your user-id: ";
	$userid = <STDIN>;
	chomp($userid);
}

# Get the passcode
print "Your passcode: ";
ReadMode('noecho') if ( -t STDIN && -t STDOUT );
my $passcode = <STDIN>;
ReadMode('normal') if ( -t STDIN && -t STDOUT );
chomp($passcode);
print "\n";

# Create the ECaccess Controler
my $ecaccess = ECMWF::ECaccess->new( $opt{retry}, $opt{debug});

# Create the certificate
$ecaccess->getCertificate( $userid, $passcode );

__END__
=head1 NAME

ecaccess-certificate-create - Create Certificate for the ECtools

=head1 SYNOPSIS

B<ecaccess-certificate-create -version|-help|-manual>

B<ecaccess-certificate-create [-debug] [>I<user-id>B<]>

=head1 DESCRIPTION

This command allow creating a Certificate with your ECMWF User Identifier and
Security Token. The Certificate is required to use the ECtools. It is stored
in your home directory ($HOME/.eccert.crt). If you don't specify your ECMWF
User Identifier on the command-line then you will be prompted for it.

=head1 ARGUMENTS

=over 8

=item I<user-id> (optional)

The ECMWF User Identifier to use.

=back

=head1 OPTIONS

=over 8

=item B<-version>

Display version number and exits.

=item B<-help>

Print a brief help message and exits.

=item B<-manual>

Prints the manual page and exits.

=item B<-retry> I<count>

Number of SSL connection retries per 5s to ECMWF. This parameter only apply to the
initial SSL connection initiated by the command to the ECMWF server. It does not
apply to all the subsequent requests made afteward as it is mainly targeting errors
that can happen from time to time during the SSL handshake. Default is no retry.

=item B<-debug>

Display the SOAP and SSL messages exchanged.

=back

=head1 EXAMPLES

B<ecaccess-certificate-create> I<xyz>

Create a new ECaccess Certificate for the ECMWF User Identifier I<xyz> and store it
in the "$HOME/.eccert.crt" File.

=head1 SEE ALSO

B<ecaccess-certificate-list> and B<ecaccess>.

=cut

__END__
:endofperl
