/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.PCA;
import jalview.appletgui.AlignFrame;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.CutAndPasteTransfer;
import jalview.appletgui.EmbmenuFrame;
import jalview.appletgui.RotatableCanvas;
import jalview.bin.JalviewLite;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequencePoint;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class PCAPanel
extends EmbmenuFrame
implements Runnable,
ActionListener,
ItemListener {
    PCA pca;
    int top;
    RotatableCanvas rc;
    AlignViewport av;
    SequenceI[] seqs;
    AlignmentView seqstrings;
    Panel jPanel2 = new Panel();
    Label jLabel1 = new Label();
    Label jLabel2 = new Label();
    Label jLabel3 = new Label();
    protected Choice xCombobox = new Choice();
    protected Choice yCombobox = new Choice();
    protected Choice zCombobox = new Choice();
    FlowLayout flowLayout1 = new FlowLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    MenuBar menuBar1 = new MenuBar();
    Menu menu1 = new Menu();
    Menu menu2 = new Menu();
    protected CheckboxMenuItem labels = new CheckboxMenuItem();
    MenuItem values = new MenuItem();
    MenuItem inputData = new MenuItem();

    public PCAPanel(AlignViewport av) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 1; i < 8; ++i) {
            this.xCombobox.addItem("dim " + i);
            this.yCombobox.addItem("dim " + i);
            this.zCombobox.addItem("dim " + i);
        }
        this.av = av;
        this.seqstrings = av.getAlignmentView(av.getSelectionGroup() != null);
        this.seqs = av.getSelectionGroup() == null ? av.alignment.getSequencesArray() : av.getSelectionGroup().getSequencesInOrder(av.alignment);
        SeqCigar[] sq = this.seqstrings.getSequences();
        int length = sq[0].getWidth();
        for (int i = 0; i < this.seqs.length; ++i) {
            if (sq[i].getWidth() == length) continue;
            System.out.println("Sequences must be equal length for PCA analysis");
            return;
        }
        this.rc = new RotatableCanvas(av);
        this.embedMenuIfNeeded(this.rc);
        this.add((Component)this.rc, "Center");
        JalviewLite.addFrame(this, "Principal component analysis", 400, 400);
        Thread worker = new Thread(this);
        worker.start();
    }

    public void run() {
        int ii;
        this.pca = new PCA(this.seqstrings.getSequenceStrings(' '));
        this.pca.run();
        for (ii = 0; ii < this.seqs.length && this.seqs[ii] != null; ++ii) {
        }
        double[][] comps = new double[ii][ii];
        for (int i = 0; i < ii; ++i) {
            if (!(this.pca.getEigenvalue(i) > 1.0E-4)) continue;
            comps[i] = this.pca.component(i);
        }
        this.xCombobox.select(0);
        this.yCombobox.select(1);
        this.zCombobox.select(2);
        this.top = this.pca.getM().rows - 1;
        Vector<SequencePoint> points = new Vector<SequencePoint>();
        float[][] scores = this.pca.getComponents(this.top - 1, this.top - 2, this.top - 3, 100.0f);
        for (int i = 0; i < this.pca.getM().rows; ++i) {
            SequencePoint sp = new SequencePoint(this.seqs[i], scores[i]);
            points.addElement(sp);
        }
        this.rc.setPoints(points, this.pca.getM().rows);
        this.rc.repaint();
        this.seqs = null;
        this.repaint();
    }

    void doDimensionChange() {
        if (this.top == 0) {
            return;
        }
        int dim1 = this.top - this.xCombobox.getSelectedIndex();
        int dim2 = this.top - this.yCombobox.getSelectedIndex();
        int dim3 = this.top - this.zCombobox.getSelectedIndex();
        float[][] scores = this.pca.getComponents(dim1, dim2, dim3, 100.0f);
        for (int i = 0; i < this.pca.getM().rows; ++i) {
            ((SequencePoint)this.rc.points.elementAt((int)i)).coord = scores[i];
        }
        this.rc.img = null;
        this.rc.rotmat.setIdentity();
        this.rc.initAxes();
        this.rc.paint(this.rc.getGraphics());
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.inputData) {
            this.showOriginalData();
        } else {
            this.values_actionPerformed();
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.xCombobox) {
            this.xCombobox_actionPerformed();
        } else if (evt.getSource() == this.yCombobox) {
            this.yCombobox_actionPerformed();
        } else if (evt.getSource() == this.zCombobox) {
            this.zCombobox_actionPerformed();
        }
    }

    protected void xCombobox_actionPerformed() {
        this.doDimensionChange();
    }

    protected void yCombobox_actionPerformed() {
        this.doDimensionChange();
    }

    protected void zCombobox_actionPerformed() {
        this.doDimensionChange();
    }

    public void values_actionPerformed() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer(false, null);
        Frame frame = new Frame();
        frame.add(cap);
        JalviewLite.addFrame(frame, "PCA details", 500, 500);
        cap.setText(this.pca.getDetails());
    }

    void showOriginalData() {
        char gc = '-';
        try {
            gc = this.av.getGapCharacter();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Object[] alAndColsel = this.seqstrings.getAlignmentAndColumnSelection(gc);
        if (alAndColsel != null && alAndColsel[0] != null) {
            Alignment al = new Alignment((SequenceI[])alAndColsel[0]);
            AlignFrame af = new AlignFrame(al, this.av.applet, "Original Data for PCA", false);
            af.viewport.setHiddenColumns((ColumnSelection)alAndColsel[1]);
        }
    }

    public void labels_itemStateChanged(ItemEvent itemEvent) {
        this.rc.showLabels(this.labels.getState());
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.flowLayout1);
        this.jLabel1.setFont(new Font("Verdana", 0, 12));
        this.jLabel1.setText("x=");
        this.jLabel2.setFont(new Font("Verdana", 0, 12));
        this.jLabel2.setText("y=");
        this.jLabel3.setFont(new Font("Verdana", 0, 12));
        this.jLabel3.setText("z=");
        this.jPanel2.setBackground(Color.white);
        this.zCombobox.setFont(new Font("Verdana", 0, 12));
        this.zCombobox.addItemListener(this);
        this.yCombobox.setFont(new Font("Verdana", 0, 12));
        this.yCombobox.addItemListener(this);
        this.xCombobox.setFont(new Font("Verdana", 0, 12));
        this.xCombobox.addItemListener(this);
        this.setMenuBar(this.menuBar1);
        this.menu1.setLabel("File");
        this.menu2.setLabel("View");
        this.labels.setLabel("Labels");
        this.labels.addItemListener(this);
        this.values.setLabel("Output Values...");
        this.values.addActionListener(this);
        this.inputData.setLabel("Input Data...");
        this.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.jLabel1, null);
        this.jPanel2.add((Component)this.xCombobox, null);
        this.jPanel2.add((Component)this.jLabel2, null);
        this.jPanel2.add((Component)this.yCombobox, null);
        this.jPanel2.add((Component)this.jLabel3, null);
        this.jPanel2.add((Component)this.zCombobox, null);
        this.menuBar1.add(this.menu1);
        this.menuBar1.add(this.menu2);
        this.menu2.add(this.labels);
        this.menu1.add(this.values);
        this.menu1.add(this.inputData);
        this.inputData.addActionListener(this);
    }
}

