/*
 * Decompiled with CFR 0.152.
 */
package jalview.commands;

import jalview.commands.EditCommand;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;

public class SlideSequencesCommand
extends EditCommand {
    boolean gapsInsertedBegin = false;

    public SlideSequencesCommand(String description, SequenceI[] seqsLeft, SequenceI[] seqsRight, int slideSize, char gapChar) {
        this.description = description;
        int lSize = seqsLeft.length;
        this.gapsInsertedBegin = false;
        block0: for (int i = 0; i < lSize; ++i) {
            for (int j = 0; j < slideSize; ++j) {
                if (Comparison.isGap(seqsLeft[i].getCharAt(j))) continue;
                this.gapsInsertedBegin = true;
                continue block0;
            }
        }
        this.edits = !this.gapsInsertedBegin ? new EditCommand.Edit[]{(EditCommand)this.new EditCommand.Edit(1, seqsLeft, 0, slideSize, gapChar)} : new EditCommand.Edit[]{(EditCommand)this.new EditCommand.Edit(0, seqsRight, 0, slideSize, gapChar)};
        this.performEdit(0, null);
    }

    public boolean getGapsInsertedBegin() {
        return this.gapsInsertedBegin;
    }

    public boolean appendSlideCommand(SlideSequencesCommand command) {
        boolean same = false;
        if (command.edits[0].seqs.length == this.edits[0].seqs.length) {
            same = true;
            for (int i = 0; i < command.edits[0].seqs.length; ++i) {
                if (this.edits[0].seqs[i] == command.edits[0].seqs[i]) continue;
                same = false;
            }
        }
        if (same) {
            EditCommand.Edit[] temp = new EditCommand.Edit[command.edits.length + 1];
            System.arraycopy(command.edits, 0, temp, 0, command.edits.length);
            command.edits = temp;
            command.edits[command.edits.length - 1] = this.edits[0];
        }
        return same;
    }
}

