/**
 * Copyright (c) 2013-2016 Jens Deters http://www.jensd.de
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package de.jensd.fx.glyphs.icons525;

import de.jensd.fx.glyphs.GlyphIcons;

/**
 *
 * Icon Enum based on 525Icons v2.0
 *
 * @author Jens Deters (mail@jensd.de)
 * @version 2.0
 */
public enum Icons525 implements GlyphIcons {

    _3D("\ue84A"),
    _500PX("\ue645"),
    _5STAR_SHADOW("\ue6EA"),
    ACROBAT("\ue6FA"),
    ADD_TO_CART("\ue71B"),
    ADDRESS_BOOK("\ue7F2"),
    ADDTHIS("\ue63D"),
    AFTER_EFFECTS("\ue687"),
    AIM("\ue63F"),
    ALARM("\ue808"),
    ALGOLIA("\ue857"),
    AMAZON("\ue6FC"),
    ANDROID("\ue7D3"),
    ANGELLIST("\ue6CC"),
    ANGLE("\ue738"),
    ANGLE2("\ue739"),
    ANGLE_DOUBLE("\ue73A"),
    ANGULAR("\ue6CA"),
    APP_LAUNCHER("\ue6E2"),
    APP_STORE("\ue835"),
    APPLE("\ue7D6"),
    AQUARIUS("\ue6BE"),
    ARCHIVE("\ue66C"),
    ARCHIVE_BOX("\ue6F0"),
    ARIES("\ue6B4"),
    ARRIVING_FLIGHT("\ue82A"),
    ARROW("\ue737"),
    ARROW2("\ue828"),
    ARROW_SIGN("\ue734"),
    ARROWS("\ue768"),
    ASTERISK("\ue6EE"),
    ASTERISK2("\ue6F4"),
    AT("\ue6E8"),
    ATOM("\ue842"),
    ATTACHMENT("\ue705"),
    ATTRACTION("\ue76D"),
    AUDITION("\ue689"),
    BACKWARD_CIRCLE("\ue7B6"),
    BADGE("\ue6F3"),
    BARCODE("\ue71C"),
    BASKET("\ue71A"),
    BATTERY_0("\ue628"),
    BATTERY_1("\ue629"),
    BATTERY_2("\ue62A"),
    BATTERY_3("\ue62B"),
    BATTERY_CHARGING("\ue62C"),
    BEHANCE("\ue643"),
    BIN("\ue741"),
    BING("\ue698"),
    BIOHAZARD("\ue6C4"),
    BITNAMI("\ue7FA"),
    BLOCS("\ue83B"),
    BLOG("\ue834"),
    BLOGGER("\ue64B"),
    BLUERAY("\ue6F1"),
    BLUETOOTH("\ue695"),
    BOOK("\ue684"),
    BOOKM_BLK("\ue729"),
    BOOKS("\ue66D"),
    BOOTSTRAP("\ue7D9"),
    BRACKETS("\ue83D"),
    BRIDGE("\ue68A"),
    BUCKET("\ue760"),
    BULLET("\ue6EB"),
    BUS("\ue7EB"),
    BY("\ue748"),
    CAB("\ue7EA"),
    CALCULATOR("\ue696"),
    CALENDAR("\ue66A"),
    CALENDAR_OPEN("\ue669"),
    CAMERA("\ue7BA"),
    CAMERA_RETRO("\ue7B9"),
    CANCEL("\ue798"),
    CANCEL_CIRCLE("\ue796"),
    CANCER("\ue6B7"),
    CAPRICORN("\ue6BD"),
    CARD_CLUB("\ue67A"),
    CARD_DIAMOND("\ue67C"),
    CARD_HEART("\ue67B"),
    CARD_SPADE("\ue679"),
    CARET("\ue73B"),
    CARET_CIRCLE("\ue73C"),
    CC("\ue747"),
    CC_MASTERCARD("\ue70F"),
    CC_PAYPAL("\ue710"),
    CC_VISA("\ue70E"),
    CE_MARK("\ue683"),
    CELCIUS("\ue6C0"),
    CHAR("\ue6C3"),
    CHAT("\ue78A"),
    CHAT2("\ue833"),
    CHECKBOX_CHECKED("\ue779"),
    CHEVRON("\ue735"),
    CHEVRON_CIRCLE("\ue736"),
    CHROME("\ue7AA"),
    CIRCLE("\ue7DB"),
    CIRCLE_0("\ue65D"),
    CIRCLE_1("\ue65E"),
    CIRCLE_2("\ue65F"),
    CIRCLE_3("\ue660"),
    CIRCLE_4("\ue661"),
    CIRCLE_5("\ue662"),
    CIRCLE_6("\ue663"),
    CIRCLE_7("\ue664"),
    CIRCLE_8("\ue665"),
    CIRCLE_9("\ue666"),
    CIRCLE_ANGLE("\ue732"),
    CIRCLE_ARROW("\ue730"),
    CIRCLE_ARROW_O("\ue731"),
    CIRCLE_DOWNLOAD("\ue677"),
    CIRCLE_FACEBOOK("\ue781"),
    CIRCLE_GITHUB("\ue79B"),
    CIRCLE_GOOGLEPLUS("\ue782"),
    CIRCLE_INSTAGRAM("\ue783"),
    CIRCLE_LINKEDIN("\ue787"),
    CIRCLE_MAIL("\ue784"),
    CIRCLE_MINUS("\ue793"),
    CIRCLE_O("\ue7DD"),
    CIRCLE_O_NOTCH("\ue765"),
    CIRCLE_PINTEREST("\ue786"),
    CIRCLE_SHARE("\ue785"),
    CIRCLE_THINLINE("\ue7DC"),
    CIRCLE_TWITTER("\ue788"),
    CIRCLE_UPLOAD("\ue676"),
    CIRCLE_YOUTUBE("\ue789"),
    CIRCLEADD("\ue792"),
    CIRCLEDELETE("\ue794"),
    CIRCLESELECT("\ue795"),
    CLOCK("\ue772"),
    CLOUDY("\ue6D9"),
    CODE("\ue83E"),
    CODEANYWHERE("\ue762"),
    CODEPEN("\ue7A6"),
    CODERWALL("\ue6D0"),
    COFFEE("\ue7E6"),
    COGS("\ue770"),
    COLOURS("\ue75F"),
    COMMENT("\ue78B"),
    COMMENT2("\ue7EF"),
    COMMENT_QUOTE("\ue78C"),
    COMPASS("\ue809"),
    CONNECTION_WIFI("\ue691"),
    CONSTRUCTION("\ue771"),
    CONTACTS("\ue7B0"),
    COPY("\ue707"),
    CREATIVECLOUD("\ue6D6"),
    CREDITCARD("\ue70D"),
    CSS3("\ue75E"),
    CSSDECK("\ue837"),
    CUT("\ue706"),
    CUTLERY("\ue7E7"),
    CYCLING("\ue81D"),
    DATABASE("\ue674"),
    DECO_BULLET("\ue6EC"),
    DELICIOUS("\ue648"),
    DEPARTING_FLIGHT("\ue829"),
    DESKTOP("\ue7E0"),
    DEVIANTART("\ue7C7"),
    DICE_FIVE("\ue77E"),
    DICE_FOUR("\ue77D"),
    DICE_ONE("\ue77A"),
    DICE_SIX("\ue77F"),
    DICE_THREE("\ue77C"),
    DICE_TWO("\ue77B"),
    DIGG("\ue64C"),
    DISAPPOINTED_FACE("\ue6AF"),
    DISC("\ue7F5"),
    DOMAIN2("\ue73E"),
    DOWNLOAD("\ue682"),
    DREAMWEAVER("\ue68B"),
    DRIBBBLE("\ue638"),
    DROPBOX("\ue7C6"),
    DRUPAL8("\ue7FF"),
    DVD("\ue6F2"),
    EDIT("\ue746"),
    EJECT("\ue659"),
    EJECT_CIRCLE("\ue7B8"),
    EL_HAZARD("\ue831"),
    ELLIPSIS("\ue774"),
    ENVATO("\ue838"),
    ENVELOPE("\ue714"),
    ENVELOPE_O("\ue713"),
    ETSY("\ue62E"),
    EVERNOTE("\ue642"),
    EXCEL("\ue60A"),
    EXCHANGE("\ue601"),
    EXCLAMATION_CIRCLE("\ue7DF"),
    EXPAND("\ue72E"),
    EXPOSURE("\ue686"),
    EYE("\ue80C"),
    EYEDROPPER("\ue745"),
    FACEBOOK("\ue649"),
    FACEBOOK2("\ue7A4"),
    FAHRENHEIT("\ue6C1"),
    FAMILY("\ue821"),
    FAST_FORWARD("\ue657"),
    FAVORITES("\ue728"),
    FEEDLY("\ue6C6"),
    FILE_AI("\ue619"),
    FILE_ASP("\ue622"),
    FILE_AVI("\ue612"),
    FILE_CSS("\ue61E"),
    FILE_DOCX("\ue60F"),
    FILE_EPS("\ue61A"),
    FILE_EXE("\ue61D"),
    FILE_GIF("\ue618"),
    FILE_HTML("\ue621"),
    FILE_JPG("\ue617"),
    FILE_JS("\ue61F"),
    FILE_MOV("\ue614"),
    FILE_MP3("\ue610"),
    FILE_MP4("\ue613"),
    FILE_O("\ue709"),
    FILE_OTF("\ue623"),
    FILE_PDF("\ue61B"),
    FILE_PHP("\ue620"),
    FILE_PNG("\ue615"),
    FILE_PSD("\ue616"),
    FILE_RAR("\ue625"),
    FILE_RAW("\ue811"),
    FILE_SQL("\ue61C"),
    FILE_SVG("\ue626"),
    FILE_TTF("\ue810"),
    FILE_TXT("\ue627"),
    FILE_WAV("\ue611"),
    FILE_ZIP("\ue624"),
    FILES("\ue6A8"),
    FILM("\ue76B"),
    FIND_IN_PAGE("\ue65B"),
    FINDER("\ue7D7"),
    FINGERPRINT("\ue701"),
    FIRE_EXTINGUISHER("\ue75A"),
    FIREFOX("\ue7AB"),
    FIREWORKS("\ue68C"),
    FLASHPLAYER("\ue636"),
    FLICKR("\ue63B"),
    FLIPBOARD("\ue644"),
    FOOD_WASTE("\ue82E"),
    FORWARD("\ue656"),
    FORWARD_CIRCLE("\ue7B7"),
    FOURSQUARE("\ue631"),
    FRAME("\ue7F0"),
    FROWNING_FACE("\ue6B2"),
    FULLSCR("\ue72C"),
    FULLSCR_ESC("\ue72D"),
    G_TRANSLATE("\ue65C"),
    G_WALLET("\ue711"),
    GEMINI("\ue6B6"),
    GETTYIMAGES("\ue66B"),
    GITHUB("\ue637"),
    GITLAB("\ue69F"),
    GLIDE("\ue6A0"),
    GLOBE("\ue6E4"),
    GLOBE_2("\ue73D"),
    GMAIL("\ue7A5"),
    GO("\ue6DF"),
    GO2("\ue780"),
    GOOGLE("\ue79F"),
    GOOGLE_DRIVE("\ue7CA"),
    GOOGLE_PLAY("\ue6FB"),
    GOOGLE_WD("\ue69C"),
    GOOGLEPLUS("\ue7A0"),
    GRAV("\ue635"),
    GREEN_DOT("\ue7F9"),
    GROUP("\ue7B1"),
    HANGOUTS("\ue7CB"),
    HD("\ue65A"),
    HEADPHONES("\ue6D3"),
    HEART("\ue777"),
    HEART_O("\ue80D"),
    HEROKU("\ue850"),
    HOME("\ue703"),
    HOME2("\ue704"),
    HOOTSUITE("\ue69D"),
    HTML5("\ue75D"),
    ICLOUD("\ue6CE"),
    ICQ("\ue63A"),
    IE("\ue7AC"),
    ILLUSTRATOR("\ue688"),
    IMAGE("\ue7BD"),
    IMAGE_GALLERY("\ue7BB"),
    IMAGE_GALLERY2("\ue7BC"),
    IMAGE_PORTRAIT("\ue7BE"),
    IMDB("\ue719"),
    IMPORT("\ue715"),
    INDESIGN("\ue68D"),
    INFINITY("\ue761"),
    INFO("\ue71F"),
    INFO_CIRCLE("\ue71D"),
    INFO_CIRCLE2("\ue71E"),
    INSTAGRAM("\ue64E"),
    INT_ALPINE("\ue74F"),
    INT_BED("\ue753"),
    INT_BICYCLE("\ue845"),
    INT_BUS("\ue754"),
    INT_CAR_RENTAL("\ue822"),
    INT_DEPARTURE("\ue825"),
    INT_ELEVATOR("\ue751"),
    INT_EXIT("\ue848"),
    INT_FIRSTAID("\ue759"),
    INT_FUEL("\ue758"),
    INT_GENTS("\ue75C"),
    INT_GUARD("\ue750"),
    INT_HELIPORT("\ue846"),
    INT_LADIES("\ue75B"),
    INT_LIGHTHOUSE("\ue844"),
    INT_LITTER("\ue752"),
    INT_LOCKER("\ue74E"),
    INT_P("\ue757"),
    INT_PHONE("\ue756"),
    INT_PLANE("\ue755"),
    INT_SHIP("\ue823"),
    INT_SWIM("\ue74D"),
    INT_TOILETS("\ue824"),
    INT_TRAIN("\ue74C"),
    INT_TRAM("\ue847"),
    INT_WATER("\ue74B"),
    INT_WHEELCHAIR("\ue74A"),
    ISSUU("\ue630"),
    ITUNES("\ue7C4"),
    JOOMLA("\ue79D"),
    JQUERY("\ue7A8"),
    JQUERY_UI("\ue83A"),
    JSDELIVR("\ue6C5"),
    JSFIDDLE("\ue79E"),
    KAKAOTALK("\ue819"),
    KEY("\ue67D"),
    KEYBOARD("\ue718"),
    KIK("\ue633"),
    KISSING_FACE("\ue6AE"),
    KLOUT("\ue851"),
    LAPTOP("\ue7E1"),
    LASTFM("\ue6F9"),
    LAUGHING_SMILING_EYES("\ue6AB"),
    LAUNCHPAD("\ue76A"),
    LEO("\ue6B8"),
    LESS("\ue840"),
    LIBRA("\ue6BA"),
    LIBRARY("\ue6FF"),
    LIGHTNING("\ue6DB"),
    LIGHTROOM("\ue68E"),
    LINE("\ue6C9"),
    LINK("\ue673"),
    LINKEDIN("\ue79A"),
    LINUX("\ue7D2"),
    LIVESTREAM("\ue7D8"),
    LOCK("\ue667"),
    LOCK_OPEN("\ue668"),
    LOGOUT("\ue81B"),
    LONDON_TUBE("\ue670"),
    MAGENTO("\ue84F"),
    MAIL_SEND("\ue6DE"),
    MAIL_SEND2("\ue812"),
    MAP("\ue80A"),
    MAP2("\ue80B"),
    MAP_MARKER("\ue671"),
    MARKER("\ue813"),
    MARKETPLACE("\ue699"),
    MARS("\ue80F"),
    MAXCDN("\ue6CB"),
    MEDIUM("\ue7FC"),
    MEDKIT("\ue7F4"),
    MEETUP("\ue6A2"),
    MENU("\ue775"),
    MESSENGER("\ue7C1"),
    METAL_GLASS_WASTE("\ue82F"),
    MIC("\ue6D2"),
    MICROSOFT("\ue60D"),
    MISC_WASTE("\ue82B"),
    MIXCLOUD("\ue7FE"),
    MODX("\ue800"),
    MOON("\ue6E5"),
    MOUSE("\ue6F8"),
    MOVIE_CLAPPER("\ue6E7"),
    MS_EDGE("\ue7A9"),
    MSN("\ue7C0"),
    MUSICALNOTE("\ue67E"),
    MYSPACE("\ue7CF"),
    NEWSPAPER("\ue697"),
    NODE_JS("\ue854"),
    NOENTRY("\ue76C"),
    NOTEPAD("\ue7F1"),
    NOTIFICATIONS("\ue6E0"),
    OFFICE("\ue60B"),
    OFFICE365("\ue60C"),
    OK("\ue799"),
    ONEDRIVE("\ue6D5"),
    ONENOTE("\ue602"),
    OPACITY("\ue849"),
    OPERA("\ue7AD"),
    OUTLOOK("\ue603"),
    PAGELINES("\ue7A2"),
    PAINTBRUSH("\ue742"),
    PALETTE("\ue6F7"),
    PAPER_WASTE("\ue82D"),
    PARTLY_CLOUDY("\ue6D8"),
    PASTE("\ue708"),
    PATH("\ue7FB"),
    PAUSE("\ue654"),
    PAUSE_CIRCLE("\ue7B4"),
    PAYPAL("\ue7FD"),
    PENCIL("\ue743"),
    PENCIL2("\ue744"),
    PERSEVERING_FACE("\ue6B1"),
    PHONE("\ue716"),
    PHONE_VOL("\ue6CF"),
    PHONEGAP("\ue83C"),
    PHOTOSHOP("\ue690"),
    PHP("\ue841"),
    PICASA("\ue640"),
    PIE("\ue6C2"),
    PINTEREST("\ue639"),
    PISCES("\ue6BF"),
    PLASTIC_WASTE("\ue82C"),
    PLAY("\ue653"),
    PLAY_CIRCLE("\ue7B3"),
    PLAYSTATION("\ue69B"),
    PLUS("\ue807"),
    POCKET("\ue7CD"),
    PODCAST("\ue6A5"),
    POWERPOINT("\ue604"),
    PREMIERE("\ue68F"),
    PRINTER("\ue70B"),
    PRODUCTHUNT("\ue6A6"),
    PROJECT("\ue605"),
    PUBLISHER("\ue606"),
    PYTHON("\ue856"),
    QRCODE("\ue773"),
    QROSS("\ue84D"),
    QUESTION("\ue70C"),
    QUORA("\ue84C"),
    QUOTES1("\ue685"),
    QUOTES2("\ue6A4"),
    QWANT("\ue802"),
    RADIO("\ue717"),
    RADIOACTIVE("\ue680"),
    RAINY("\ue6DA"),
    REACT("\ue843"),
    RECYCLE("\ue6CD"),
    RECYCLE_O("\ue7D1"),
    REDDIT("\ue7A1"),
    REFRESH("\ue766"),
    REGISTERED("\ue702"),
    REMOVE("\ue740"),
    RESPONSIVE("\ue7E5"),
    RSS("\ue769"),
    RUBY("\ue855"),
    RUNNING("\ue81E"),
    SA("\ue749"),
    SAFARI("\ue7AE"),
    SAGITTARIUS("\ue6BC"),
    SASS("\ue83F"),
    SAVE("\ue70A"),
    SCALA("\ue853"),
    SCIENCE("\ue6FE"),
    SCOOPIT("\ue63C"),
    SCORPIO("\ue6BB"),
    SCRIBD("\ue6FD"),
    SD_CARD("\ue72B"),
    SEARCH("\ue763"),
    SELECT("\ue6E1"),
    SELECT_CELLS("\ue66F"),
    SELECT_CIRCLE("\ue797"),
    SHAPES("\ue6E3"),
    SHARE("\ue803"),
    SHARE2("\ue804"),
    SHAREPOINT("\ue607"),
    SHARING("\ue73F"),
    SHRINK("\ue72F"),
    SHUT_DOWN("\ue778"),
    SIGN_IN("\ue805"),
    SIGN_OUT("\ue806"),
    SIGNAL_0("\ue722"),
    SIGNAL_1("\ue723"),
    SIGNAL_2("\ue724"),
    SIGNAL_3("\ue725"),
    SIGNAL_4("\ue726"),
    SIGNAL_5("\ue727"),
    SITEMAP("\ue7F6"),
    SKYPE("\ue7C5"),
    SLACK("\ue6A7"),
    SMARTPHONE("\ue7E3"),
    SMARTWATCH("\ue81A"),
    SMILING_EYES("\ue6AA"),
    SMILING_FACE("\ue6A9"),
    SMILING_HEART_EYES("\ue6AD"),
    SNAPCHAT("\ue6A3"),
    SNOWFLAKE("\ue6DD"),
    SNOWY("\ue6DC"),
    SOUNDCLOUD("\ue7D0"),
    SPINNER("\ue764"),
    SPINNER3("\ue767"),
    SPOTIFY("\ue7C9"),
    SQUARE("\ue7DA"),
    SQUARE_BULLET("\ue6E9"),
    SQUARE_BULLET2("\ue6ED"),
    SQUARE_CALC("\ue776"),
    SQUARE_DIVIDE("\ue790"),
    SQUARE_MINUS("\ue78E"),
    SQUARE_MULTI("\ue78F"),
    SQUARE_PHONE("\ue817"),
    SQUARE_PLUS("\ue78D"),
    SQUARE_SUM("\ue791"),
    SQUARESPACE("\ue634"),
    STACKEXCHANGE("\ue69E"),
    STACKOVERFLOW("\ue62D"),
    STAR_E("\ue6EF"),
    STAR_SMALL("\ue6F5"),
    START_CHAT("\ue712"),
    STATS("\ue830"),
    STEP_FORWARD("\ue658"),
    STOP("\ue655"),
    STOP_CIRCLE("\ue7B5"),
    STOP_SIGN("\ue6E6"),
    STOPWATCH("\ue678"),
    STREET_VIEW("\ue672"),
    STUMBLEUPON("\ue647"),
    SUBLIME_TEXT("\ue852"),
    SUBWAY("\ue7ED"),
    SUITCASE("\ue700"),
    SUNNY("\ue6D7"),
    SURFACE("\ue7E4"),
    SURVEILLANCE_CAM("\ue6D1"),
    SWAY("\ue608"),
    SWIMMING("\ue81F"),
    TABLE("\ue66E"),
    TABLET("\ue7E2"),
    TARGET("\ue6F6"),
    TAURUS("\ue6B5"),
    TELEGRAM("\ue818"),
    TERMINAL("\ue72A"),
    THUMBS_UP("\ue675"),
    TIDAL("\ue7CC"),
    TOGGLE_OFF("\ue721"),
    TOGGLE_ON("\ue720"),
    TRAFFIC_CONE("\ue814"),
    TRAIN("\ue7EC"),
    TRAM("\ue7EE"),
    TREKKING("\ue820"),
    TRIPADVISOR("\ue7C8"),
    TUMBLR("\ue641"),
    TVG("\ue7E9"),
    TWITCH("\ue836"),
    TWITTER("\ue64A"),
    TYPO3("\ue839"),
    UBUNTU("\ue84E"),
    UMBRELLA("\ue832"),
    UNAMUSED_FACE("\ue6B0"),
    UNHAPPY_FACE("\ue6B3"),
    UNIVERSAL_ACCESS("\ue6D4"),
    UP_LEFT("\ue826"),
    UP_LEFT_ARROW("\ue827"),
    UPLOAD("\ue681"),
    USB("\ue693"),
    USB_DRIVE("\ue694"),
    USER("\ue7AF"),
    USER_PLUS("\ue7B2"),
    VCARD_O("\ue7F3"),
    VENUS("\ue80E"),
    VIBER("\ue7C3"),
    VIMEO("\ue7D4"),
    VIRGO("\ue6B9"),
    VISUAL_STUDIO("\ue60E"),
    VIVALDI("\ue801"),
    VKONTAKTE("\ue64D"),
    VLC("\ue7A7"),
    VOLUME_DOWN("\ue650"),
    VOLUME_MUTE("\ue64F"),
    VOLUME_OFF("\ue652"),
    VOLUME_UP("\ue651"),
    W3SCHOOLS("\ue7BF"),
    WALKING("\ue81C"),
    WARNING_SIGN("\ue7DE"),
    WECHAT("\ue6C8"),
    WEEBLY("\ue6C7"),
    WEIBO("\ue7A3"),
    WHATSAPP("\ue7C2"),
    WIFI("\ue692"),
    WINDOW_CLOSE("\ue816"),
    WINDOWS8("\ue7D5"),
    WINE_BOTTLE("\ue7E8"),
    WINKING_FACE("\ue6AC"),
    WIX("\ue6A1"),
    WORD("\ue609"),
    WORDPRESS("\ue79C"),
    WP_ARROW("\ue733"),
    WP_COG("\ue76F"),
    WP_COG_O("\ue76E"),
    WPEXPLORER("\ue84B"),
    WRENCH("\ue815"),
    XBOX("\ue69A"),
    YAHOO("\ue63E"),
    YELP("\ue632"),
    YIN_YANG("\ue67F"),
    YOUTUBE("\ue646"),
    YOUTUBE2("\ue7CE"),
    ZOOM_IN("\ue7F7"),
    ZOOM_OUT("\ue7F8"),
    ZURB("\ue62F"),
    DOCS_COM("\ue600");



    private final String unicode;

    private Icons525(String unicode) {
        this.unicode = unicode;
    }

    @Override
    public String unicode() {
        return unicode;
    }

    @Override
    public String fontFamily() {
        return "\'525icons\'";
    }

}
