//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcustomerlockbox

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// PostClient contains the methods for the Post group.
// Don't use this type directly, use NewPostClient() instead.
type PostClient struct {
	host string
	pl   runtime.Pipeline
}

// NewPostClient creates a new instance of PostClient with the specified values.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewPostClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*PostClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &PostClient{
		host: ep,
		pl:   pl,
	}
	return client, nil
}

// DisableLockbox - Disable Tenant for Lockbox
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2018-02-28-preview
// options - PostClientDisableLockboxOptions contains the optional parameters for the PostClient.DisableLockbox method.
func (client *PostClient) DisableLockbox(ctx context.Context, options *PostClientDisableLockboxOptions) (PostClientDisableLockboxResponse, error) {
	req, err := client.disableLockboxCreateRequest(ctx, options)
	if err != nil {
		return PostClientDisableLockboxResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PostClientDisableLockboxResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PostClientDisableLockboxResponse{}, runtime.NewResponseError(resp)
	}
	return PostClientDisableLockboxResponse{}, nil
}

// disableLockboxCreateRequest creates the DisableLockbox request.
func (client *PostClient) disableLockboxCreateRequest(ctx context.Context, options *PostClientDisableLockboxOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.CustomerLockbox/disableLockbox"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-02-28-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// EnableLockbox - Enable Tenant for Lockbox
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2018-02-28-preview
// options - PostClientEnableLockboxOptions contains the optional parameters for the PostClient.EnableLockbox method.
func (client *PostClient) EnableLockbox(ctx context.Context, options *PostClientEnableLockboxOptions) (PostClientEnableLockboxResponse, error) {
	req, err := client.enableLockboxCreateRequest(ctx, options)
	if err != nil {
		return PostClientEnableLockboxResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PostClientEnableLockboxResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PostClientEnableLockboxResponse{}, runtime.NewResponseError(resp)
	}
	return PostClientEnableLockboxResponse{}, nil
}

// enableLockboxCreateRequest creates the EnableLockbox request.
func (client *PostClient) enableLockboxCreateRequest(ctx context.Context, options *PostClientEnableLockboxOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.CustomerLockbox/enableLockbox"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-02-28-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
