//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdelegatednetwork

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ControllerClient contains the methods for the Controller group.
// Don't use this type directly, use NewControllerClient() instead.
type ControllerClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewControllerClient creates a new instance of ControllerClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewControllerClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ControllerClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ControllerClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreate - Create a dnc controller
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
// parameters - controller type parameters
// options - ControllerClientBeginCreateOptions contains the optional parameters for the ControllerClient.BeginCreate method.
func (client *ControllerClient) BeginCreate(ctx context.Context, resourceGroupName string, resourceName string, parameters DelegatedController, options *ControllerClientBeginCreateOptions) (*runtime.Poller[ControllerClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, resourceName, parameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ControllerClientCreateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ControllerClientCreateResponse](options.ResumeToken, client.pl, nil)
	}
}

// Create - Create a dnc controller
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
func (client *ControllerClient) create(ctx context.Context, resourceGroupName string, resourceName string, parameters DelegatedController, options *ControllerClientBeginCreateOptions) (*http.Response, error) {
	req, err := client.createCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createCreateRequest creates the Create request.
func (client *ControllerClient) createCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters DelegatedController, options *ControllerClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/controller/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// BeginDelete - Deletes the DNC controller
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
// options - ControllerClientBeginDeleteOptions contains the optional parameters for the ControllerClient.BeginDelete method.
func (client *ControllerClient) BeginDelete(ctx context.Context, resourceGroupName string, resourceName string, options *ControllerClientBeginDeleteOptions) (*runtime.Poller[ControllerClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, resourceName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ControllerClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ControllerClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deletes the DNC controller
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
func (client *ControllerClient) deleteOperation(ctx context.Context, resourceGroupName string, resourceName string, options *ControllerClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ControllerClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ControllerClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/controller/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetDetails - Gets details about the specified dnc controller.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
// options - ControllerClientGetDetailsOptions contains the optional parameters for the ControllerClient.GetDetails method.
func (client *ControllerClient) GetDetails(ctx context.Context, resourceGroupName string, resourceName string, options *ControllerClientGetDetailsOptions) (ControllerClientGetDetailsResponse, error) {
	req, err := client.getDetailsCreateRequest(ctx, resourceGroupName, resourceName, options)
	if err != nil {
		return ControllerClientGetDetailsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ControllerClientGetDetailsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ControllerClientGetDetailsResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDetailsHandleResponse(resp)
}

// getDetailsCreateRequest creates the GetDetails request.
func (client *ControllerClient) getDetailsCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, options *ControllerClientGetDetailsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/controller/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDetailsHandleResponse handles the GetDetails response.
func (client *ControllerClient) getDetailsHandleResponse(resp *http.Response) (ControllerClientGetDetailsResponse, error) {
	result := ControllerClientGetDetailsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DelegatedController); err != nil {
		return ControllerClientGetDetailsResponse{}, err
	}
	return result, nil
}

// Patch - Update dnc controller
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-03-15
// resourceGroupName - The name of the resource group. The name is case insensitive.
// resourceName - The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
// parameters - controller type parameters
// options - ControllerClientPatchOptions contains the optional parameters for the ControllerClient.Patch method.
func (client *ControllerClient) Patch(ctx context.Context, resourceGroupName string, resourceName string, parameters ControllerResourceUpdateParameters, options *ControllerClientPatchOptions) (ControllerClientPatchResponse, error) {
	req, err := client.patchCreateRequest(ctx, resourceGroupName, resourceName, parameters, options)
	if err != nil {
		return ControllerClientPatchResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ControllerClientPatchResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ControllerClientPatchResponse{}, runtime.NewResponseError(resp)
	}
	return client.patchHandleResponse(resp)
}

// patchCreateRequest creates the Patch request.
func (client *ControllerClient) patchCreateRequest(ctx context.Context, resourceGroupName string, resourceName string, parameters ControllerResourceUpdateParameters, options *ControllerClientPatchOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/controller/{resourceName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-03-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// patchHandleResponse handles the Patch response.
func (client *ControllerClient) patchHandleResponse(resp *http.Response) (ControllerClientPatchResponse, error) {
	result := ControllerClientPatchResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DelegatedController); err != nil {
		return ControllerClientPatchResponse{}, err
	}
	return result, nil
}
