package main

var sequence = map[int]byte{
	32:  0x47,
	33:  0x5d,
	34:  0x4c,
	35:  0x42,
	36:  0x66,
	37:  0x20,
	38:  0x23,
	39:  0x46,
	40:  0x4e,
	41:  0x57,
	42:  0x45,
	43:  0x3d,
	44:  0x67,
	45:  0x76,
	46:  0x60,
	47:  0x41,
	48:  0x62,
	49:  0x39,
	50:  0x59,
	51:  0x2d,
	52:  0x68,
	53:  0x7e,
	54:  0x7c,
	55:  0x65,
	56:  0x7d,
	57:  0x49,
	58:  0x29,
	59:  0x72,
	60:  0x73,
	61:  0x78,
	62:  0x21,
	63:  0x6e,
	64:  0x5a,
	65:  0x5e,
	66:  0x4a,
	67:  0x3e,
	68:  0x71,
	69:  0x2c,
	70:  0x2a,
	71:  0x54,
	72:  0x3c,
	73:  0x3a,
	74:  0x63,
	75:  0x4f,
	76:  0x43,
	77:  0x75,
	78:  0x27,
	79:  0x79,
	80:  0x5b,
	81:  0x35,
	82:  0x70,
	83:  0x48,
	84:  0x6b,
	85:  0x56,
	86:  0x6f,
	87:  0x34,
	88:  0x32,
	89:  0x6c,
	90:  0x30,
	91:  0x61,
	92:  0x6d,
	93:  0x7b,
	94:  0x2f,
	95:  0x4b,
	96:  0x64,
	97:  0x38,
	98:  0x2b,
	99:  0x2e,
	100: 0x50,
	101: 0x40,
	102: 0x3f,
	103: 0x55,
	104: 0x33,
	105: 0x37,
	106: 0x25,
	107: 0x77,
	108: 0x24,
	109: 0x26,
	110: 0x74,
	111: 0x6a,
	112: 0x28,
	113: 0x53,
	114: 0x4d,
	115: 0x69,
	116: 0x22,
	117: 0x5c,
	118: 0x44,
	119: 0x31,
	120: 0x36,
	121: 0x58,
	122: 0x3b,
	123: 0x7a,
	124: 0x51,
	125: 0x5f,
	126: 0x52,
}

func passcode(s string) (res []byte) {
	res = make([]byte, 16)
	for i := 0; i < len(s) && i < len(res); i++ {
		p := int(s[i]) + i
		if p > 126 {
			p = 32 + p%127
		}
		res[i] = sequence[p]
	}
	return res
}
