% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvest-package.R
\name{read_html}
\alias{read_html}
\title{Static web scraping (with xml2)}
\usage{
read_html(x, encoding = "", ..., options = c("RECOVER", "NOERROR", "NOBLANKS"))
}
\arguments{
\item{x}{Usually a string representing a URL. See \code{\link[xml2:read_xml]{xml2::read_html()}} for
other options.}

\item{encoding}{Specify a default encoding for the document. Unless
otherwise specified XML documents are assumed to be in UTF-8 or
UTF-16. If the document is not UTF-8/16, and lacks an explicit
encoding directive, this allows you to supply a default.}

\item{...}{Additional arguments passed on to methods.}

\item{options}{Set parsing options for the libxml2 parser. Zero or more of
\describe{
  \item{RECOVER}{recover on errors}
  \item{NOENT}{substitute entities}
  \item{DTDLOAD}{load the external subset}
  \item{DTDATTR}{default DTD attributes}
  \item{DTDVALID}{validate with the DTD}
  \item{NOERROR}{suppress error reports}
  \item{NOWARNING}{suppress warning reports}
  \item{PEDANTIC}{pedantic error reporting}
  \item{NOBLANKS}{remove blank nodes}
  \item{SAX1}{use the SAX1 interface internally}
  \item{XINCLUDE}{Implement XInclude substitition}
  \item{NONET}{Forbid network access}
  \item{NODICT}{Do not reuse the context dictionary}
  \item{NSCLEAN}{remove redundant namespaces declarations}
  \item{NOCDATA}{merge CDATA as text nodes}
  \item{NOXINCNODE}{do not generate XINCLUDE START/END nodes}
  \item{COMPACT}{compact small text nodes; no modification of the tree allowed afterwards (will possibly crash if you try to modify the tree)}
  \item{OLD10}{parse using XML-1.0 before update 5}
  \item{NOBASEFIX}{do not fixup XINCLUDE xml:base uris}
  \item{HUGE}{relax any hardcoded limit from the parser}
  \item{OLDSAX}{parse using SAX2 interface before 2.7.0}
  \item{IGNORE_ENC}{ignore internal document encoding hint}
  \item{BIG_LINES}{Store big lines numbers in text PSVI field}
}}
}
\description{
\code{\link[=read_html]{read_html()}} works by performing a HTTP request then parsing the HTML
received using the xml2 package. This is "static" scraping because it
operates only on the raw HTML file. While this works for most sites,
in some cases you will need to use \code{\link[=read_html_live]{read_html_live()}} if the parts of
the page you want to scrape are dynamically generated with javascript.

Generally, we recommend using \code{read_html()} if it works, as it will be
faster and more robust, as it has fewer external dependencies (i.e. it
doesn't rely on the Chrome web browser installed on your computer.)
}
\examples{
# Start by reading a HTML page with read_html():
starwars <- read_html("https://rvest.tidyverse.org/articles/starwars.html")

# Then find elements that match a css selector or XPath expression
# using html_elements(). In this example, each <section> corresponds
# to a different film
films <- starwars \%>\% html_elements("section")
films

# Then use html_element() to extract one element per film. Here
# we the title is given by the text inside <h2>
title <- films \%>\%
  html_element("h2") \%>\%
  html_text2()
title

# Or use html_attr() to get data out of attributes. html_attr() always
# returns a string so we convert it to an integer using a readr function
episode <- films \%>\%
  html_element("h2") \%>\%
  html_attr("data-id") \%>\%
  readr::parse_integer()
episode
}
