### 万象拼音  [![Ask DeepWiki](https://deepwiki.com/badge.svg)](https://deepwiki.com/amzxyz/rime_wanxiang)
**配套方案** 本方案为万象系列方案标准版(携带声调辅助筛选) （内建同文拼音9、14、18键布局方案）

   [>>辅助码增强版本](https://github.com/amzxyz/rime_wanxiang_pro)  

**基于[万象词库](https://github.com/amzxyz/RIME-LMDG)以及语法模型的基础上修改而来，是一个集成了带调词库、预测模型的基础全拼双拼方案，在这套词库作为底座支撑之下，传统双拼轻松支持、自然龙、龙码等带调方案亦可轻松支持，因此同样是一个集合多种拼音方案的集合，让你不用迁移配置即可轻松切换方案。**

**万象词库中的带声调拼音标注+词组构成+词频是整个万象项目的核心，是使用体验的基石，方案的其它功能皆可自定义，我希望使用者可以基于词库+转写的方式获得输入体验** [万象词库问题收集反馈表](https://docs.qq.com/smartsheet/DWHZsdnZZaGh5bWJI?viewId=vUQPXH&tab=BB08J2)

**由于词库是全局携带声调的，因此这里侧重推荐进阶用户使用：[自然龙](https://github.com/rimeinn/rime-zrlong) 方案，这是一种韵母带声调布局的双拼输入方式，万象已经内置自然龙运算模块，表头即可配置**

---
效果大赏

![效果.png](https://storage.deepin.org/thread/202502200358104987_效果.png)

---

**1. 如何使用：**

不了解rime基础的可以参考友情链接：

[oh my rime](https://www.mintimate.cc/zh/guide/installRime.html) 

[rime参数配置](https://xishansnow.github.io/posts/41ac964d.html)

整个rime配置生态都是通的，里面有非常完整的使用方法，(诸如放到哪里、换个皮肤、什么是用户目录。。。)我不想重复造轮子，如果看完了还能想起万象，欢迎来到你的进阶之旅！

**①第一种方法：快速开始：**

 首先

打开万象项目主方案 ```wanxiang.schema.yaml```，编辑表头，选择方案, 需要注意在手机上使用同文输入法时，长按回车键进入功能菜单选中与方案匹配的布局

```
#############万象拼音声调辅助筛选版本###########################
set_shuru_schema:         #配置此项就是选择什么输入法,同时拆分反查和中英文混输也将匹配该输入方案
  __include: 自然码  #可选解码规则有   全拼, 自然码, 自然龙, 小鹤, 搜狗, 微软  选择一个填入
set_gongjian_mohu:    #可选的值有：26键, 18键, 14键, 9键  注意PC选26键
  __include: 18键
pro_comment_format:           # 超级注释模块
  candidate_length: 1         # 候选词注释提醒的生效长度，0为关闭  但同时清空其它，应当使用开关或者快捷键来处理    
  corrector_type: "{comment}"  #错音错词提示显示类型，比如"({comment})" 
########################以下是方案配置############################################
```

可以说非常清晰了，定义方案名称、拼音类型、以及注释显示逻辑，配置完毕保存。

继续分别打开```wanxiang_radical.schema.yaml```  ```wanxiang_en.schema.yaml``` 分别对反查和英文解码方案进行表头配置

```
###############选择与之匹配的拼音方案#####################

set_shuru_schema:

  __include: algebra_zrm   #可选的选项有（algebra_pinyin, algebra_zrm, algebra_flypy, algebra_mspy, algebra_sogou, algebra_abc, algebra_ziguang）
```

同样选择对应的拼音类型即可，保存后即可部署使用了

**②第二种方法：进阶custom patch法(已经尽量为你简化)强烈推荐：**

方案文件中有一个custom目录，里面存放了一些说明和三个yaml文件，这是帮你预设好的patch方法，你可以对里面的每一条进行仔细阅读修改为合适的选项，它将帮助你固定好你的自定义配置，可以放心覆盖文件更新，其中重点注意的是custom_phrase.txt文件名称你最好自定义一个，custom里面“custom_phrase/user_dict: custom_phrase    # 改成什么就需要手动创建 xxxxxx.txt 文件在用户目录”

这样的你就能保证在覆盖的时候不影响你自己的文件不会被覆盖。

**修改好这三个yaml一定要复制一份到用户目录(即上级目录)，它才能真正生效，祝你顺利！**

**2.亮点功能：**

**功能1**  辅助筛选是通过反查字库来定位，只是通过不同的方案实现，在输入主要拼音后，通过符号``` ` ```  来引导进入反查状态，引导后继续输入`jn`金 则包含金的字就会被选出来；

![截图_选择区域_20240704121635.png](https://storage.deepin.org/thread/202407041149125588_截图_选择区域_20240704121635.png)

引导后继续输入`mu 木`则带`木`的字就会被选出来

![截图_选择区域_20240704121611.png](https://storage.deepin.org/thread/202407041149524870_截图_选择区域_20240704121611.png)

**功能2**  通过 拼音状态下``` `〔反查：部件|笔画〕```来引导拆字模式 举例 `震`  假设你不认识，你可以通过`雨和辰` 来合并输入，拼音状态输入后，继续输入其它字符字母``` ` ```会消失如下图，输入 `yu if` 即雨 辰，结果出现了我们要的震字，且给出了辅助码 `y` 和  `i`  ，`y`是雨的声母`y`，`i`是辰的声母`ch` ，同时通过hspnz分别代表横竖撇捺折，两种类型兼容。

 ![截图_选择区域_20240928112256.png](https://storage.deepin.org/thread/202409280324599355_截图_选择区域_20240928112256.png)

**功能3**  句子中间或者单字输入时需要可以使用更精确"声调辅助"，7890数字按键代表1234声，轻声归并到4声，我们可以在双拼后面插入声调ni3 hl3，或者n3 h3，下面图片说明问题：

![截图_选择区域_20250512101814.png](https://storage.deepin.org/thread/202505120222182012_截图_选择区域_20250512101814.png)

**3.其他功能介绍：**

**日期、时间、节日、节气、问候模板：**

```
#时间：osj 或者 /sj
#日期：orq 或者 /rq
#农历：onl 或者 /nl
#星期：oxq 或者 /xq
#今年第几周：oww 或者 /ww
#节气：ojq 或者 /jq
#日期+时间：ors 或者 /rs
#时间戳：ott 或者 /tt
#大写N日期：N20250315
#节日：ojr 或者 /jr
#问候模板：/day 或者 oday
```

**Unicode：** 大写 U 开头，如 U62fc 得到「拼」。

**数字、金额大写：**  大写 R 开头，如 R1234 得到「一千二百三十四、壹仟贰佰叁拾肆元整」。

 **/符号模式：**  通过输入 /sx 快捷输入关于“数学”的特殊符号，具体能输入什么可以打开 symbols.yaml学习。

 **计算器：**  通过输入大写V引导继续输入如：V3+5  候选框就会有8和3+5=8，基础功能 `+ - * / % ^` 还支持 `sin(x) cos(x)` 等众多运算方式，可以打开super_calculator.lua查看高级函数说明

 **自动上屏：**  例如：三位、四位简码唯一时，自动上屏如`jjkw岌岌可危` `zmhu怎么回事` 。默认未开启，方案文件中`speller:`字段下取消注释这两句开启 `#   auto_select: true  #  auto_select_pattern: ^[a-z]+/|^[a-df-zA-DF-Z]\w{3}|^e\w{4}` ，也可以自定义正则支持其它的需求。

 **错音错字提示：**  例如：输入`gei yu给予`，获得`jǐ yǔ`提示

 **快符与重复上屏：** 例如 ```;q``` 通过单引号键引导的26字母0-9快速符号自动上屏，对整个键盘符号进行补充扩展，而使用双击;;重复上屏上一次的输入，此功能会导致;无法自动上屏。

**超级tips：** 支持将表情、化学式、翻译、简码、车牌 提示等等你能想到得键值数据类型，根据输入编码、高亮候选两种形式的键，获得值提示显示并将通过一个自定义按键直接上屏，默认为"." ，避免了占用候选框，如觉得干扰通过Control+t 进行开关。也可以开关处reset0；

 **声调的使用：** 除了在输入编码的时候可以用于筛选，以及反查显示声调，我们还支持任意长度候选词的注释提示能力，默认开启1个字的长度，输入状态下：Ctrl+a开启和关闭注释候选词带声调，输入状态下：Ctrl+s开启关闭输入码带声调，两个位置两种选择实时开关供你选择。

 **用户词删除：** 不管什么删除都不能直接作用于固定词典，使用Ctrl+del是rime系统删除用户词，他可以将用户词标记为c<=0，假性删除，这是处于多设备同步数据一致性的考虑，万象推出了Lua快捷清理的/del输入一下即可删除，但这是一个危险操作，执行之前必须先同步，使用流程，依次执行：同步、执行/del、重新部署、同步，就可以了。

**手动排序：** 对选中的候选词操作，使用Ctrl+j向左一步，Ctrl+k向右一步，Ctrl+0(零)移除排序。

 **Tab循环切换音节：**  当输入多个字词时想要给前面补充辅助码，可以多次按下tab循环切换，这种可能比那些复杂的快捷键好用一些。

 **翻译模式：**  输入状态按下Ctrl+E快捷键进入翻译模式，原理是opencc查表进行中英文互译，能否翻译取决于词表的丰富度；

 **反查：** 支持``` ` ```引导状态下的显示格式化，同时支持部件组字模式和笔画模式。反查模式不受字符集过滤影响，默认开放大字集,也不受辅助码开关影响，会显示注释，如：功能2相关展示；

 **字符集过滤：** 默认开启过滤，写在charset.dict.yaml的就是可以通过的字表，默认为8105+𰻞𰻞，如果你想什么字在小字集模式可以通过可以写在这里，配套开关【小、大】，快捷键Ctrl+g

![思维导图](https://github.com/amzxyz/rime_wanxiang_pro/blob/main/.github/%E4%B8%87%E8%B1%A1%E8%BE%93%E5%85%A5%E6%96%B9%E6%A1%88.png)

 **3. 词库可移植性：**

- 第一个是如果迁移到你的项目中，第1项中已有解答，或者使用单一变化 - xform/ā/a/

- 词库附带方案的使用，由于rime不可避免的人人都要修改配置，因此我将配置简化，避免多方案部署，带着疑问去使用本方案，有助于了解rime的结构。

```直接的转写：参考项目中自然龙的布局转写方式```

在原来的方案中拼写运算的首位添加一句话，就可以像以前一样使用了，无任何不同，所以可以轻松迁移
##### 无声调：

```
 algebra:
    - xlit/āáǎàōóǒòēéěèīíǐìūúǔùǖǘǚǜü/aaaaooooeeeeiiiiuuuuvvvvv/
    - xform/ń|ň|ǹ/en/ 
    - xform/ńg|ňg|ǹg/eng/
```
##### 末尾数字声调：
```
    - xform/^([a-z]+)$/$1④/
    - xform/^(.*)ā(.*)$/$1a$2①/
    - xform/^(.*)á(.*)$/$1a$2②/
    - xform/^(.*)ǎ(.*)$/$1a$2③/
    - xform/^(.*)à(.*)$/$1a$2④/
    - xform/^(.*)ō(.*)$/$1o$2①/
    - xform/^(.*)ó(.*)$/$1o$2②/
    - xform/^(.*)ǒ(.*)$/$1o$2③/
    - xform/^(.*)ò(.*)$/$1o$2④/
    - xform/^(.*)ē(.*)$/$1e$2①/
    - xform/^(.*)é(.*)$/$1e$2②/
    - xform/^(.*)ě(.*)$/$1e$2③/
    - xform/^(.*)è(.*)$/$1e$2④/
    - xform/^(.*)ī(.*)$/$1i$2①/
    - xform/^(.*)í(.*)$/$1i$2②/
    - xform/^(.*)ǐ(.*)$/$1i$2③/
    - xform/^(.*)ì(.*)$/$1i$2④/
    - xform/^(.*)ū(.*)$/$1u$2①/
    - xform/^(.*)ú(.*)$/$1u$2②/
    - xform/^(.*)ǔ(.*)$/$1u$2③/
    - xform/^(.*)ù(.*)$/$1u$2④/
    - xform/^(.*)ǖ(.*)$/$1v$2①/
    - xform/^(.*)ǘ(.*)$/$1v$2②/
    - xform/^(.*)ǚ(.*)$/$1v$2③/
    - xform/^(.*)ǜ(.*)$/$1v$2④/
    - xform/^(.*)ü(.*)$/$1v$2/
    - xform/^(.*)ń(.*)$/$1n$2②/
    - xform/^(.*)ň(.*)$/$1n$2③/
    - xform/^(.*)ǹ(.*)$/$1n$2④/
    - xlit/①②③④/7890
```
##### 数字跟随元音声调：
```
    - xform/ā/a1 
    - xform/á/a2 
    - xform/ǎ/a3 
    - xform/à/a4 
    - xform/ō/o1
    - xform/ó/o2
    - xform/ǒ/o3
    - xform/ò/o4
    - xform/ē/e1 
    - xform/é/e2 
    - xform/ě/e3 
    - xform/è/e4 
    - xform/ī/i1 
    - xform/í/i2 
    - xform/ǐ/i3 
    - xform/ì/i4 
    - xform/ū/u1 
    - xform/ú/u2 
    - xform/ǔ/u3 
    - xform/ù/u4 
    - xform/ǖ/v1 
    - xform/ǘ/v2 
    - xform/ǚ/v3 
    - xform/ǜ/v4 
    - xform/ü/v1
```
**4. 同文说明**：由于同文不具备拼音筛选器，因此想要体验特别好的小于26键的输入是不现实的，而依托万象拼音强大的词频与语言模型一定程度上弥补了这种不足。为了实现9键、14键、18键这几种常用的涉及到共键的输入方式，我们需要整体对方案层面进行运算处理，对同文主题进行深度定制，共同配合之下才能实现共键输入，下面我从几个方面阐述和说明。

**定制原理：** 

1. 对同文输入法皮肤进行定制，实现共键单发，例如WE共键，按下只发送w；
2. 对方案拼写运算进行结构化处理，将共键字母中例如WE中的e转换为w，多个字母同样处理；
3. 配合定制键盘即可打字。
   

**注意事项：**
1. 使用低于26键时，可以注释掉开关中的中英文切换，使用键盘来切换，避免逻辑冲突；
2. 使用低于26键时，中英文混输、反查基本上是废了，因为无法精准输出单键字母；
3. 使用低于26键时，由于实现方法不同于大厂，严格考虑能否接受口水聊天级别的轻量化使用，有更高追求的直接使用26健
4. 使用低于26键时，修改键盘布局要修改wanxiang方案表头部分，和同文键盘同时切换（长按回车键弹出功能菜单选择对应布局）才能正常使用
   

<img src="https://storage.deepin.org/thread/202409250204031318_26.jpg" width="400">             <img src="https://storage.deepin.org/thread/202409250204112540_18.jpg" width="400">   
<img src="https://storage.deepin.org/thread/202409250204092790_14.jpg" width="400">             <img src="https://storage.deepin.org/thread/202409250204064425_9.jpg" width="400"> 

**5. 简化配置和加载项：**

从前我们对声调的利用需要配置专门的外挂词库，形式包括：

- 外挂方案，然后挂接到主方案中，进行反查；

- 通过opencc转换器覆盖，两种坏处，一个是需要加载独立文件，另一个是覆盖性的注释不利于多态共存，比如平时显示辅助码的时候，出现单一的错词提示的时候做不到都显示和逻辑替换；

- lua脚本的需要复杂的逻辑，加载文件，解析格式深加工格式，遍历候选，提交替换结果。

 

以前做好这几件事需要多个字表、多个lua协同，配置文件里要引入多个加载器。

而现在注释本来的面目就是带着声调的，你只需要完全暴露注释，他就是显示拼音声调的形态，你可以使用lua简单的加个括号等等简易的格式操作，可以借助lua接口将其替换到输入码preedit、注释comment，在反查时由于rime本身的注释生成特性，多音字都会被一一罗列到注释里，你无需额外维护多音字字表。在用户态里的感知就是无需复杂配置，无需加载过多的文件，节约内存开销，提升性能，减少方案文件维护成本。

 **鸣谢:**

   项目英文词库初期选自"[rime-ice](https://github.com/iDvel/rime-ice)"

   拼音标注来自万象词库与语法模型项目，并在该项目下进行鸣谢！

   感谢网友的热情提报问题，使得模型和词库体验进一步提升。

 **赞赏:**
   如果觉得项目好用，可以请AMZ喝咖啡

   <img src="https://github.com/amzxyz/rime_wanxiang_pro/blob/main/.github/%E8%B5%9E%E8%B5%8F.jpeg" width="400">   

 ## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=amzxyz/RIME-LMDG,amzxyz/rime_wanxiang,amzxyz/rime_wanxiang_pro&type=Date)](https://www.star-history.com/#amzxyz/RIME-LMDG&amzxyz/rime_wanxiang&amzxyz/rime_wanxiang_pro&Date)
