#ifndef COMMON_H
#define COMMON_H
#include <string>

#define SERVICE_NAME "org.deepin.EventLog1"
#define OBJECT_PATH "/org/deepin/EventLog1"
#define SERVICE_INTERFACE "org.deepin.EventLog1"
#define MAJOR_VERSION 1
#define MINOR_VERSION 1
#define MICRO_VERSION 0

#define DATA_PREFIX "event"

#define SYSLOG_NAME "deepin-eventlog"
#define MAX_PACKAGE_LEN 128
#define LOG_PATH "/var/lib/deepin/event-log/"
#define LOG_NAME "event"
#define INCREASE_CODE "/var/lib/deepin/event-log/increment/"
#define ARCHIVE_PERIOD 1
#define SCAN_PERIOD 10
#define MAX_QUEUESIZE 10000

#define MODE_FIELD "mode"
#define POLICY_FIELD "policy"
#define REPORT_MODE_FIELD "reportMode"

enum TASKTYPE
{
    UNKNOWN       = 1,
    WRITE_CACHE   = 2,
    ARCHIVE_LOG   = 3,
};

enum REPORTMODE
{
    BROADCAST         = 1,
    REPORT            = 2,
    REPORT_AND_BROADCAST = BROADCAST | REPORT,
};

struct TaskInfo
{
    TASKTYPE type;
    std::string data;

    TaskInfo() = default;

    TaskInfo(TASKTYPE t, const std::string &str):type(t), data(str)
    {
        ;
    }
};

#endif // COMMON_H
