// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef LLAMACPPPLUGIN_H
#define LLAMACPPPLUGIN_H

#include "inferenceplugin.h"

GLOBAL_BEGIN_NAMESPACE
class LlamacppModelConfig;
class LlamaModelWrapper;
class LlamacppPlugin : public QObject, public InferencePlugin
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID InferencePlugin_Meta_IID FILE "plugin.json")
    Q_INTERFACES(GLOBAL_NAMESPACE::InferencePlugin)
public:
    LlamacppPlugin(QObject *parent = nullptr);
    ~LlamacppPlugin();
    bool initialize(const QVariantHash &params) override;
    ModelProxy* loadModel(const QString &name, const QString &imgDir, const QVariantHash &params);
    static LlamaModelWrapper *createModelWrapper(const QString &name, const QStringList &archs);
private:
    bool inited = false;
};

GLOBAL_END_NAMESPACE

#endif // LLAMACPPPLUGIN_H
