// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef MODELRUNNER_H
#define MODELRUNNER_H

#include "global_header.h"

#include "modelinfo.h"
#include "modelproxy.h"
#include "backendmetaobject.h"

#include <QThread>
#include <QQueue>
#include <QMutex>
#include <QWaitCondition>

GLOBAL_BEGIN_NAMESPACE

class ModelTask
{
public:
    ModelTask(class ModelRunner *);
    virtual ~ModelTask();
    virtual void doTask() = 0;
protected:
    class ModelRunner *runner = nullptr;
};

class ModelRunner : public QThread
{
    Q_OBJECT
public:
    explicit ModelRunner(QObject *parent = nullptr);
    ~ModelRunner();

    void postTask(QSharedPointer<ModelTask> task);
    bool recvTask(QSharedPointer<ModelTask> task);
    void terminate();
signals:

protected:
    void run() override;
public:
    ModelInfoPointer modelInfo;
    BackendMetaObjectPointer backendmo;
    QSharedPointer<InferencePlugin> backendIns;
    QSharedPointer<ModelProxy> modelProxy;
    QString modelFormat;
    QString chatTmpl;
private:
    QQueue<QSharedPointer<ModelTask>> taskQueue;
    QMutex taskMtx;
    QWaitCondition taskConditon;
    bool running = false;
    QMutex resultMtx;
    QWaitCondition resultConditon;
    QList<QSharedPointer<ModelTask>> resultList;
};

GLOBAL_END_NAMESPACE

#endif // MODELRUNNER_H
