# deepin-system-update-tools

deepin system update tools that one part of the deepin-system-update other part of deepin-system-fixpkg

## Getting started

This project requires Go to be installed. On OS X with Homebrew you can just run `brew install go`.

Running it then should be as simple as:

```console
$ make
$ ./bin/deepin-system-update
```

### Testing

``make test``

## Development Documentation

### Project Structure
```bash
├── cmd # command entry point
│   ├── deepin-system-fixpkg
│   └── deepin-system-update
├── configs # config configuration
│   └── config.json
├── CONTRIBUTING.md
├── go.mod
├── go.sum
├── internal # internal library
│   ├── checks
│   ├── config
│   ├── controller
│   ├── utils
│   └── version
├── main.go
├── Makefile
├── pkg # shared library
│   ├── log
│   ├── models
│   └── utils
├── README.md
└── tools # tools path
    └── sturn
```

### Configuration With V20

Download golang

```bash
wget https://doraemon.uniontech.com/dist/library/go/go1.15.15/go1.15.15.linux-amd64.tar.gz -o /tmp/go1.15.15.linux-amd64.tar.gz
mkdir ~/go/go-v1.15.15
tar xf /tmp/go1.15.15.linux-amd64.tar.gz -C ~/go/go-v1.15.15
```

Setting golang environment
```bash
cat << EOF >> ~/go/.goenv
export HOME_APPS=$HOME
export GOPATH="${HOME_APPS}/go"
export GO15_VERSION="1.15.15"
export GO15_HOME="${HOME_APPS}/go/go-v${GO15_VERSION}"
export GO_VERSION_MAIN="15"
export GO_VERSION="1.15.15"
export GOROOT="${HOME_APPS}/go/go-v${GO_VERSION}"
export GOPROXY="https://goproxy.cn,direct"
export GOPRIVATE="pkg.deepin.com"
export PATH="${GOROOT}/bin:${GOPATH}/bin:${PATH}"
EOF

cat << EOF >> ~/.bashrc
if [ -f ~/go/.goenv ]; then
    . ~/go/.goenv
fi
EOF
```