/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.text.RuleBasedCollator;
import java.util.Comparator;
import net.sf.saxon.Platform;
import net.sf.saxon.Version;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.RuleBasedSubstringMatcher;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.str.UnicodeString;

public class SimpleCollation
implements StringCollator {
    private Comparator<? super String> comparator;
    private final String uri;
    private static final Platform platform = Version.platform;

    public SimpleCollation(String uri, Comparator<? super String> comparator) {
        this.uri = uri;
        this.comparator = comparator;
    }

    @Override
    public String getCollationURI() {
        return this.uri;
    }

    @Override
    public int compareStrings(UnicodeString o1, UnicodeString o2) {
        return this.comparator.compare(o1.toString(), o2.toString());
    }

    @Override
    public boolean comparesEqual(UnicodeString s1, UnicodeString s2) {
        return this.comparator.compare(s1.toString(), s2.toString()) == 0;
    }

    public Comparator<? super String> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<? super String> comparator) {
        this.comparator = comparator;
    }

    @Override
    public AtomicMatchKey getCollationKey(UnicodeString s2) {
        return platform.getCollationKey(this, s2.toString());
    }

    public SubstringMatcher getSubstringMatcher() {
        if (this.comparator instanceof SubstringMatcher) {
            return (SubstringMatcher)((Object)this.comparator);
        }
        if (this.comparator instanceof RuleBasedCollator) {
            return new RuleBasedSubstringMatcher(this.uri, (RuleBasedCollator)this.comparator);
        }
        return null;
    }
}

