/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "screenshotconfig.h"

#include <QFileInfo>
#include <QMap>
#include <QtXml>
#include <QStandardPaths>
#include <QSize>

#define SCREENSHOT_CONFIG_PATH "/usr/share/prohibitscreenshot/prohibitscreenshotDbus.conf"

ScreenShotConfig *ScreenShotConfig::m_pConfig = nullptr;
ScreenShotConfig *ScreenShotConfig::instance()
{
    if (m_pConfig == nullptr) {
        m_pConfig = new ScreenShotConfig;
    }
    return m_pConfig;
}

ScreenShotConfig::ScreenShotConfig(QObject *parent)
    : QObject(parent)
{
    initConfig();
}

ScreenShotConfig::~ScreenShotConfig()
{
    if (m_pConfig != nullptr) {
        delete m_pConfig;
        m_pConfig = nullptr;
    }
}

bool ScreenShotConfig::prohibited()
{
    return m_prohibited;
}

void ScreenShotConfig::setProhibited(bool bProhibited)
{
    if (m_prohibited == bProhibited) {
        return;
    }
    m_prohibited = bProhibited;
}

QStringList ScreenShotConfig::accessOnPathList()
{
    return m_accessOnPath;
}

QStringList ScreenShotConfig::accessOffPathList()
{
    return m_accessOffPath;
}

QStringList ScreenShotConfig::accessOnClientClassList()
{
    return m_accessOnClientClass;
}

QStringList ScreenShotConfig::accessOffClientClassList()
{
    return m_accessOffClientClass;
}

QStringList ScreenShotConfig::screenshotToolBlackList()
{
    return m_screenshotToolBlackList;
}

void ScreenShotConfig::initConfig()
{
    QFile file(SCREENSHOT_CONFIG_PATH);
    if (!file.open(QFile::ReadOnly))
        return;

    QDomDocument doc;
    if (!doc.setContent(&file)) {
        file.close();
        return;
    }
    file.close();

    QDomElement root = doc.documentElement();
    for (int i = 0; i < root.childNodes().count(); i++) {
        QDomNode rootNode = root.childNodes().at(i);
        if (rootNode.nodeName() == "application") {
            QMap<QString, QVariant> mapInfo;
            QDomNode node = rootNode.firstChild();
            if (!node.isNull()) {
                if (node.toElement().text() != "") {
                    mapInfo["wmclass"] = node.toElement().text();
                }
            }
            QDomNamedNodeMap attrsMap = rootNode.attributes();
            for (int j = 0; j < attrsMap.count(); j++) {
                mapInfo[attrsMap.item(j).nodeName()] = attrsMap.item(j).nodeValue().remove(QRegExp("\\s"));
            }
            m_screenShotAccessList << mapInfo;
        } else if (rootNode.nodeName() == "screenshot_tool_blacklist") {
            m_screenshotToolBlackList = rootNode.toElement().text().split(",");
        }
    }
    dispatchAttributes();
}

void ScreenShotConfig::dispatchAttributes()
{
    for (int i = 0; i < m_screenShotAccessList.count(); i++) {
        QMap<QString, QVariant> screenShotAccessInfo = m_screenShotAccessList.at(i);
        if (screenShotAccessInfo["access_interface"] == "on") {
            m_accessOnPath << screenShotAccessInfo["path"].toString().split(",");
            m_accessOnClientClass << screenShotAccessInfo["wmclass"].toString().split(",");
            m_accessOnPath.removeAll(QString());
            m_accessOnClientClass.removeAll(QString());

        } else if (screenShotAccessInfo["access_interface"] == "off") {
            m_accessOffPath << screenShotAccessInfo["path"].toString().split(",");
            m_accessOffClientClass << screenShotAccessInfo["wmclass"].toString().split(",");
            m_accessOffPath.removeAll(QString());
            m_accessOffClientClass.removeAll(QString());
        }
    }

}
