/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DDE_SECURITY_INTERFACE_H
#define DDE_SECURITY_INTERFACE_H

#include "wayland_dnd.h"
#include "wayland-dde-security-client-protocol.h"

typedef struct _Dnd_Session {
    uint32_t seesionId;
    uint32_t types;
    uint32_t client;
    uint32_t target;
    uint32_t serial;
    Permission result;

    struct security_session *ddeSession;
    struct wl_list link;
} DndSession;

typedef struct _dde_security {
    struct dde_security *ddeSecurity;
    struct wl_list sessions;

    struct dtk_array* ace_clients;
} DdeSecurity;

DdeSecurity *init_dde_security();
void destory_dde_security(DdeSecurity *security);

int get_security_session(SessionType types);
int destroy_security_session(int session);
void report_security_verified(int session, Permission result);
struct dtk_array* get_security_clients();

void handle_dde_security(void *data,
                         void *wl_registry,
                         uint32_t name,
                         const char *interface,
                         uint32_t version);
#endif
