/*****************************************************************************
 Copyright (c) 2023, Intel Corporation

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
     * Neither the name of Intel Corporation nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*****************************************************************************/

/* AES-CCM, RFC3610 */
#include "aead_test.h"

const struct aead_test ccm_128_test_json[] = {
        /* Vectors from https://tools.ietf.org/html/rfc3610 */
        { 104, 128, 64, 1, "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x03\x02\x01\x00\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x58\x8c\x97\x9a\x61\xc6\x63\xd2\xf0\x66"
          "\xd0\xc2\xc0\xf9\x89\x80\x6d\x5f\x6b\x61\xda\xc3\x84\x17\xe8\xd1\x2c\xfd"
          "\xf9\x26\xe0",
          "", 1, 64, 248 },
        { 104, 128, 64, 2, "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x04\x03\x02\x01\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x72\xc9\x1a\x36\xe1\x35\xf8\xcf\x29\x1c"
          "\xa8\x94\x08\x5c\x87\xe3\xcc\x15\xc4\x39\xc9\xe4\x3a\x3b\xa0\x91\xd5\x6e"
          "\x10\x40\x09\x16",
          "", 1, 64, 256 },
        { 104, 128, 64, 3, "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x05\x04\x03\x02\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x51\xb1\xe5\xf4\x4a\x19\x7d\x1d\xa4\x6b"
          "\x0f\x8e\x2d\x28\x2a\xe8\x71\xe8\x38\xbb\x64\xda\x85\x96\x57\x4a\xda\xa7"
          "\x6f\xbd\x9f\xb0\xc5",
          "", 1, 64, 264 },
        { 104, 128, 64, 4, "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x06\x05\x04\x03\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\xa2\x8c\x68\x65\x93\x9a"
          "\x9a\x79\xfa\xaa\x5c\x4c\x2a\x9d\x4a\x91\xcd\xac\x8c\x96\xc8\x61\xb9\xc9"
          "\xe6\x1e\xf1",
          "", 1, 96, 248 },
        { 104, 128, 64, 5, "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x07\x06\x05\x04\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\xdc\xf1\xfb\x7b\x5d\x9e"
          "\x23\xfb\x9d\x4e\x13\x12\x53\x65\x8a\xd8\x6e\xbd\xca\x3e\x51\xe8\x3f\x07"
          "\x7d\x9c\x2d\x93",
          "", 1, 96, 256 },
        { 104, 128, 64, 6, "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x08\x07\x06\x05\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x6f\xc1\xb0\x11\xf0\x06"
          "\x56\x8b\x51\x71\xa4\x2d\x95\x3d\x46\x9b\x25\x70\xa4\xbd\x87\x40\x5a\x04"
          "\x43\xac\x91\xcb\x94",
          "", 1, 96, 264 },
        { 104, 128, 80, 7, "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x09\x08\x07\x06\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x01\x35\xd1\xb2\xc9\x5f\x41\xd5\xd1\xd4"
          "\xfe\xc1\x85\xd1\x66\xb8\x09\x4e\x99\x9d\xfe\xd9\x6c\x04\x8c\x56\x60\x2c"
          "\x97\xac\xbb\x74\x90",
          "", 1, 64, 248 },
        { 104, 128, 80, 8, "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x0a\x09\x08\x07\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x7b\x75\x39\x9a\xc0\x83\x1d\xd2\xf0\xbb"
          "\xd7\x58\x79\xa2\xfd\x8f\x6c\xae\x6b\x6c\xd9\xb7\xdb\x24\xc1\x7b\x44\x33"
          "\xf4\x34\x96\x3f\x34\xb4",
          "", 1, 64, 256 },
        { 104, 128, 80, 9, "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x0b\x0a\x09\x08\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x82\x53\x1a\x60\xcc\x24\x94\x5a\x4b\x82"
          "\x79\x18\x1a\xb5\xc8\x4d\xf2\x1c\xe7\xf9\xb7\x3f\x42\xe1\x97\xea\x9c\x07"
          "\xe5\x6b\x5e\xb1\x7e\x5f\x4e",
          "", 1, 64, 264 },
        { 104, 128, 80, 10, "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x0c\x0b\x0a\x09\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x07\x34\x25\x94\x15\x77"
          "\x85\x15\x2b\x07\x40\x98\x33\x0a\xbb\x14\x1b\x94\x7b\x56\x6a\xa9\x40\x6b"
          "\x4d\x99\x99\x88\xdd",
          "", 1, 96, 248 },
        { 104, 128, 80, 11, "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x0d\x0c\x0b\x0a\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x67\x6b\xb2\x03\x80\xb0"
          "\xe3\x01\xe8\xab\x79\x59\x0a\x39\x6d\xa7\x8b\x83\x49\x34\xf5\x3a\xa2\xe9"
          "\x10\x7a\x8b\x6c\x02\x2c",
          "", 1, 96, 256 },
        { 104, 128, 80, 12, "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x0e\x0d\x0c\x0b\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\xc0\xff\xa0\xd6\xf0\x5b"
          "\xdb\x67\xf2\x4d\x43\xa4\x33\x8d\x2a\xa4\xbe\xd7\xb2\x0e\x43\xcd\x1a\xa3"
          "\x16\x62\xe7\xad\x65\xd6\xdb",
          "", 1, 96, 264 },
        { 104, 128, 64, 13, "\xd7\x82\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b",
          "\x00\x41\x2b\x4e\xa9\xcd\xbe\x3c\x96\x96\x76\x6c\xfa", "",
          "\x0b\xe1\xa8\x8b\xac\xe0\x18\xb1\x08\xe8\xcf\x97\xd8\x20\xea\x25\x84\x60"
          "\xe9\x6a\xd9\xcf\x52\x89\x05\x4d\x89\x5c\xea\xc4\x7c",
          "\x0b\xe1\xa8\x8b\xac\xe0\x18\xb1\x4c\xb9\x7f\x86\xa2\xa4\x68\x9a\x87\x79"
          "\x47\xab\x80\x91\xef\x53\x86\xa6\xff\xbd\xd0\x80\xf8\xe7\x8c\xf7\xcb\x0c"
          "\xdd\xd7\xb3",
          "", 1, 64, 248 },
        { 104, 128, 64, 14, "\xd7\x82\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b",
          "\x00\x33\x56\x8e\xf7\xb2\x63\x3c\x96\x96\x76\x6c\xfa", "",
          "\x63\x01\x8f\x76\xdc\x8a\x1b\xcb\x90\x20\xea\x6f\x91\xbd\xd8\x5a\xfa\x00"
          "\x39\xba\x4b\xaf\xf9\xbf\xb7\x9c\x70\x28\x94\x9c\xd0\xec",
          "\x63\x01\x8f\x76\xdc\x8a\x1b\xcb\x4c\xcb\x1e\x7c\xa9\x81\xbe\xfa\xa0\x72"
          "\x6c\x55\xd3\x78\x06\x12\x98\xc8\x5c\x92\x81\x4a\xbc\x33\xc5\x2e\xe8\x1d"
          "\x7d\x77\xc0\x8a",
          "", 1, 64, 256 },
        { 104, 128, 64, 15, "\xd7\x82\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b",
          "\x00\x10\x3f\xe4\x13\x36\x71\x3c\x96\x96\x76\x6c\xfa", "",
          "\xaa\x6c\xfa\x36\xca\xe8\x6b\x40\xb9\x16\xe0\xea\xcc\x1c\x00\xd7\xdc\xec"
          "\x68\xec\x0b\x3b\xbb\x1a\x02\xde\x8a\x2d\x1a\xa3\x46\x13\x2e",
          "\xaa\x6c\xfa\x36\xca\xe8\x6b\x40\xb1\xd2\x3a\x22\x20\xdd\xc0\xac\x90\x0d"
          "\x9a\xa0\x3c\x61\xfc\xf4\xa5\x59\xa4\x41\x77\x67\x08\x97\x08\xa7\x76\x79"
          "\x6e\xdb\x72\x35\x06",
          "", 1, 64, 264 },
        { 104, 128, 64, 16, "\xd7\x82\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b",
          "\x00\x76\x4c\x63\xb8\x05\x8e\x3c\x96\x96\x76\x6c\xfa", "",
          "\xd0\xd0\x73\x5c\x53\x1e\x1b\xec\xf0\x49\xc2\x44\x12\xda\xac\x56\x30\xef"
          "\xa5\x39\x6f\x77\x0c\xe1\xa6\x6b\x21\xf7\xb2\x10\x1c",
          "\xd0\xd0\x73\x5c\x53\x1e\x1b\xec\xf0\x49\xc2\x44\x14\xd2\x53\xc3\x96\x7b"
          "\x70\x60\x9b\x7c\xbb\x7c\x49\x91\x60\x28\x32\x45\x26\x9a\x6f\x49\x97\x5b"
          "\xca\xde\xaf",
          "", 1, 96, 248 },
        { 104, 128, 64, 17, "\xd7\x82\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b",
          "\x00\xf8\xb6\x78\x09\x4e\x3b\x3c\x96\x96\x76\x6c\xfa", "",
          "\x77\xb6\x0f\x01\x1c\x03\xe1\x52\x58\x99\xbc\xae\xe8\x8b\x6a\x46\xc7\x8d"
          "\x63\xe5\x2e\xb8\xc5\x46\xef\xb5\xde\x6f\x75\xe9\xcc\x0d",
          "\x77\xb6\x0f\x01\x1c\x03\xe1\x52\x58\x99\xbc\xae\x55\x45\xff\x1a\x08\x5e"
          "\xe2\xef\xbf\x52\xb2\xe0\x4b\xee\x1e\x23\x36\xc7\x3e\x3f\x76\x2c\x0c\x77"
          "\x44\xfe\x7e\x3c",
          "", 1, 96, 256 },
        { 104, 128, 64, 18, "\xd7\x82\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b",
          "\x00\xd5\x60\x91\x2d\x3f\x70\x3c\x96\x96\x76\x6c\xfa", "",
          "\xcd\x90\x44\xd2\xb7\x1f\xdb\x81\x20\xea\x60\xc0\x64\x35\xac\xba\xfb\x11"
          "\xa8\x2e\x2f\x07\x1d\x7c\xa4\xa5\xeb\xd9\x3a\x80\x3b\xa8\x7f",
          "\xcd\x90\x44\xd2\xb7\x1f\xdb\x81\x20\xea\x60\xc0\x00\x97\x69\xec\xab\xdf"
          "\x48\x62\x55\x94\xc5\x92\x51\xe6\x03\x57\x22\x67\x5e\x04\xc8\x47\x09\x9e"
          "\x5a\xe0\x70\x45\x51",
          "", 1, 96, 264 },
        { 104, 128, 80, 19, "\xd7\x82\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b",
          "\x00\x42\xff\xf8\xf1\x95\x1c\x3c\x96\x96\x76\x6c\xfa", "",
          "\xd8\x5b\xc7\xe6\x9f\x94\x4f\xb8\x8a\x19\xb9\x50\xbc\xf7\x1a\x01\x8e\x5e"
          "\x67\x01\xc9\x17\x87\x65\x98\x09\xd6\x7d\xbe\xdd\x18",
          "\xd8\x5b\xc7\xe6\x9f\x94\x4f\xb8\xbc\x21\x8d\xaa\x94\x74\x27\xb6\xdb\x38"
          "\x6a\x99\xac\x1a\xef\x23\xad\xe0\xb5\x29\x39\xcb\x6a\x63\x7c\xf9\xbe\xc2"
          "\x40\x88\x97\xc6\xba",
          "", 1, 64, 248 },
        { 104, 128, 80, 20, "\xd7\x82\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b",
          "\x00\x92\x0f\x40\xe5\x6c\xdc\x3c\x96\x96\x76\x6c\xfa", "",
          "\x74\xa0\xeb\xc9\x06\x9f\x5b\x37\x17\x61\x43\x3c\x37\xc5\xa3\x5f\xc1\xf3"
          "\x9f\x40\x63\x02\xeb\x90\x7c\x61\x63\xbe\x38\xc9\x84\x37",
          "\x74\xa0\xeb\xc9\x06\x9f\x5b\x37\x58\x10\xe6\xfd\x25\x87\x40\x22\xe8\x03"
          "\x61\xa4\x78\xe3\xe9\xcf\x48\x4a\xb0\x4f\x44\x7e\xff\xf6\xf0\xa4\x77\xcc"
          "\x2f\xc9\xbf\x54\x89\x44",
          "", 1, 64, 256 },
        { 104, 128, 80, 21, "\xd7\x82\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b",
          "\x00\x27\xca\x0c\x71\x20\xbc\x3c\x96\x96\x76\x6c\xfa", "",
          "\x44\xa3\xaa\x3a\xae\x64\x75\xca\xa4\x34\xa8\xe5\x85\x00\xc6\xe4\x15\x30"
          "\x53\x88\x62\xd6\x86\xea\x9e\x81\x30\x1b\x5a\xe4\x22\x6b\xfa",
          "\x44\xa3\xaa\x3a\xae\x64\x75\xca\xf2\xbe\xed\x7b\xc5\x09\x8e\x83\xfe\xb5"
          "\xb3\x16\x08\xf8\xe2\x9c\x38\x81\x9a\x89\xc8\xe7\x76\xf1\x54\x4d\x41\x51"
          "\xa4\xed\x3a\x8b\x87\xb9\xce",
          "", 1, 64, 264 },
        { 104, 128, 80, 22, "\xd7\x82\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b",
          "\x00\x5b\x8c\xcb\xcd\x9a\xf8\x3c\x96\x96\x76\x6c\xfa", "",
          "\xec\x46\xbb\x63\xb0\x25\x20\xc3\x3c\x49\xfd\x70\xb9\x6b\x49\xe2\x1d\x62"
          "\x17\x41\x63\x28\x75\xdb\x7f\x6c\x92\x43\xd2\xd7\xc2",
          "\xec\x46\xbb\x63\xb0\x25\x20\xc3\x3c\x49\xfd\x70\x31\xd7\x50\xa0\x9d\xa3"
          "\xed\x7f\xdd\xd4\x9a\x20\x32\xaa\xbf\x17\xec\x8e\xbf\x7d\x22\xc8\x08\x8c"
          "\x66\x6b\xe5\xc1\x97",
          "", 1, 96, 248 },
        { 104, 128, 80, 23, "\xd7\x82\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b",
          "\x00\x3e\xbe\x94\x04\x4b\x9a\x3c\x96\x96\x76\x6c\xfa", "",
          "\x47\xa6\x5a\xc7\x8b\x3d\x59\x42\x27\xe8\x5e\x71\xe2\xfc\xfb\xb8\x80\x44"
          "\x2c\x73\x1b\xf9\x51\x67\xc8\xff\xd7\x89\x5e\x33\x70\x76",
          "\x47\xa6\x5a\xc7\x8b\x3d\x59\x42\x27\xe8\x5e\x71\xe8\x82\xf1\xdb\xd3\x8c"
          "\xe3\xed\xa7\xc2\x3f\x04\xdd\x65\x07\x1e\xb4\x13\x42\xac\xdf\x7e\x00\xdc"
          "\xce\xc7\xae\x52\x98\x7d",
          "", 1, 96, 256 },
        { 104, 128, 80, 24, "\xd7\x82\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b",
          "\x00\x8d\x49\x3b\x30\xae\x8b\x3c\x96\x96\x76\x6c\xfa", "",
          "\x6e\x37\xa6\xef\x54\x6d\x95\x5d\x34\xab\x60\x59\xab\xf2\x1c\x0b\x02\xfe"
          "\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\xd4",
          "\x6e\x37\xa6\xef\x54\x6d\x95\x5d\x34\xab\x60\x59\xf3\x29\x05\xb8\x8a\x64"
          "\x1b\x04\xb9\xc9\xff\xb5\x8c\xc3\x90\x90\x0f\x3d\xa1\x2a\xb1\x6d\xce\x9e"
          "\x82\xef\xa1\x6d\xa6\x20\x59",
          "", 1, 96, 264 },
        { 104, 128, 80, 25, "\xd7\x82\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b",
          "\x00\x8d\x49\x3b\x30\xae\x8b\x3c\x96\x96\x76\x6c\xfa", "",
          "\x6e\x37\xa6\xef\x54\x6d\x95\x5d\x34\xab\x60\x59\xab\xf2\x1c\x0b\x02\xfe"
          "\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f"
          "\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d"
          "\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3"
          "\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81"
          "\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3"
          "\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12"
          "\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17"
          "\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe"
          "\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f"
          "\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d"
          "\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3"
          "\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81"
          "\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3"
          "\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12"
          "\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17"
          "\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe"
          "\xb8\x8f\x85\x6d\xf4\xa3",
          "\x6e\x37\xa6\xef\x54\x6d\x95\x5d\x34\xab\x60\x59\xf3\x29\x05\xb8\x8a\x64"
          "\x1b\x04\xb9\xc9\xff\xb5\x8c\xc3\x90\x90\x0f\x3d\xa1\x2a\x67\x22\xc6\x10"
          "\xce\x6f\xe2\x08\x0c\x38\xd7\xae\x61\x82\x21\x3d\x59\x67\xf3\x26\x72\x53"
          "\x78\x37\xe4\xba\xa7\xed\x92\x52\xd6\x01\xa5\x66\x52\x20\x6c\x51\xdb\x15"
          "\x6c\xf8\x59\x38\xaf\x28\x4d\xb7\x5f\x2a\xc8\xb0\x6e\x37\x77\x89\xb0\x6d"
          "\xc3\xe5\xf2\x2a\xa6\xf7\xdb\xcc\x37\x79\x88\x0e\x8f\x05\xa9\xe1\x9e\x11"
          "\x90\x3d\x2a\xb9\x70\x13\x9d\xc3\x93\xad\xe2\x5d\xff\xdd\x19\x0f\xb9\x9e"
          "\x74\x88\xab\x82\x0c\xa0\x2e\x71\xa6\x32\xeb\xa4\xba\x10\xf6\x61\x7b\x1b"
          "\x2a\x38\x80\xeb\xe9\x09\x01\x33\x94\x8f\xb3\xd4\xad\x6c\xd8\x5e\x85\x98"
          "\xc5\x9c\x11\x62\x2c\x60\x32\xae\x70\xe1\x66\x73\x09\x1e\x20\x55\xb7\x20"
          "\x77\x86\x09\xc8\x1c\xfe\x86\xa7\x08\x40\x43\xe7\xad\xb2\x5b\x39\x64\xcb"
          "\x13\x1f\x8d\xd2\x4f\xcc\xc5\xaa\xf1\xd6\x31\xfc\x34\x9e\x5f\x90\xc4\xb7"
          "\xe0\x07\x9c\xcd\xfb\xea\xe3\x75\xb5\x7b\x29\xd4\x73\x81\xef\x9c\x2e\xac"
          "\xf9\xa7\x39\x2a\xf8\xe2\xea\x3a\x6a\xdf\xd0\x3a\xca\x29\xd3\x13\x13\x9a"
          "\x2c\x70\xa4\xa9\x40\x1d\xec\xc7\xc9\x6b\xf7\x23\xd4\x53\x49\xd0\x05\xce"
          "\x15\x65\xce\x1f\x89\xe2\xbe\xe0\xfa\x3f\x59\x4a\x89\x99\xe5\xdb\xa0\xe8"
          "\x54\x72\x42\x69\x79\x63\x68\x91\xc9\x2c\xfc\x58\xd4\x30\xfe\xe3\x62\x5f"
          "\xdc\x49\xef\x32\x58\x83\x27\xa9\xed\xec\xf3\x1d\xfb\xea\x0a\x89",
          "", 1, 96, 2496 },
        { 56, 128, 32, 26, "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f",
          "\x10\x11\x12\x13\x14\x15\x16", "", "\x00\x01\x02\x03\x04\x05\x06\x07\x20\x21\x22\x23",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x71\x62\x01\x5b\x4d\xac\x25\x5d", "", 1, 64, 96 },
        { 104, 128, 64, 27, "\xc9\x7c\x1f\x67\xce\x37\x11\x85\x51\x4a\x8a\x19\xf2\xbd\xd5\x2f",
          "\x00\x50\x30\xf1\x84\x44\x08\xb5\x03\x97\x76\xe7\x0c", "",
          "\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\xf1\x84\x44\x08\xab\xae\xa5\xb8"
          "\xfc\xba\x00\x00\xf8\xba\x1a\x55\xd0\x2f\x85\xae\x96\x7b\xb6\x2f\xb6\xcd"
          "\xa8\xeb\x7e\x78\xa0\x50",
          "\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\xf1\x84\x44\x08\xab\xae\xa5\xb8"
          "\xfc\xba\x00\x00\xf3\xd0\xa2\xfe\x9a\x3d\xbf\x23\x42\xa6\x43\xe4\x32\x46"
          "\xe8\x0c\x3c\x04\xd0\x19\x78\x45\xce\x0b\x16\xf9\x76\x23",
          "", 1, 176, 336 },
        { 104, 128, 64, 28, "\xc9\x7c\x1f\x67\xce\x37\x11\x85\x51\x4a\x8a\x19\xf2\xbd\xd5\x2f",
          "\x00\x50\x30\xf1\x84\x44\x08\xb5\x03\x97\x76\xe7\x0c", "",
          "\xf8\xba\x1a\x55\xd0\x2f\x85\xae\x96\x7b\xb6\x2f\xb6\xcd\xa8\xeb\x7e\x78"
          "\xa0\x50",
          "\xf3\xd0\xa2\xfe\x9a\x3d\xbf\x23\x42\xa6\x43\xe4\x32\x46\xe8\x0c\x3c\x04"
          "\xd0\x19\x41\x83\x21\x89\xa3\xd3\x1b\x43",
          "", 1, 0, 160 },
        { 56, 128, 48, 29, "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f",
          "\x10\x11\x12\x13\x14\x15\x16", "", "\x00\x01\x02\x03\x04\x05\x06\x07\x20\x21\x22\x23",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x71\x62\x01\x5b\xb0\xc9\x5e\x58\x03\x6e", "", 1, 64,
          96 },
        { 56, 128, 64, 30, "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f",
          "\x10\x11\x12\x13\x14\x15\x16", "", "\x00\x01\x02\x03\x04\x05\x06\x07\x20\x21\x22\x23",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x71\x62\x01\x5b\xd0\xad\x86\xfd\x33\xc2"
          "\x69\x86",
          "", 1, 64, 96 },
        { 56, 128, 80, 31, "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f",
          "\x10\x11\x12\x13\x14\x15\x16", "", "\x00\x01\x02\x03\x04\x05\x06\x07\x20\x21\x22\x23",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x71\x62\x01\x5b\x05\x12\xda\xbf\xd9\x72"
          "\xa6\x68\x53\xc1",
          "", 1, 64, 96 },
        { 56, 128, 96, 32, "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f",
          "\x10\x11\x12\x13\x14\x15\x16", "", "\x00\x01\x02\x03\x04\x05\x06\x07\x20\x21\x22\x23",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x71\x62\x01\x5b\xba\x03\xbf\x8c\xe0\xd6"
          "\x00\xa4\x48\x6f\xcc\xb3",
          "", 1, 64, 96 },
        { 56, 128, 112, 33, "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f",
          "\x10\x11\x12\x13\x14\x15\x16", "", "\x00\x01\x02\x03\x04\x05\x06\x07\x20\x21\x22\x23",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x71\x62\x01\x5b\x6b\x9b\xfb\xfe\xa8\x2c"
          "\x04\x77\x8e\x67\xf5\x18\x46\xc6",
          "", 1, 64, 96 },
        { 56, 128, 128, 34, "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f",
          "\x10\x11\x12\x13\x14\x15\x16", "", "\x00\x01\x02\x03\x04\x05\x06\x07\x20\x21\x22\x23",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x71\x62\x01\x5b\x2b\xb5\x7c\x0a\xf4\x5e"
          "\x4d\x83\x04\xf0\x5f\x45\x99\x3f\x15\x17",
          "", 1, 64, 96 },
        { 56, 128, 32, 35, "\x4a\xe7\x01\x10\x3c\x63\xde\xca\x5b\x5a\x39\x39\xd7\xd0\x59\x92",
          "\x5a\x8a\xa4\x85\xc3\x16\xe9", "", "", "\x02\x20\x9f\x55", "", 1, 0, 0 },
        { 104, 128, 64, 36, "\xc9\x7c\x1f\x67\xce\x37\x11\x85\x51\x4a\x8a\x19\xf2\xbd\xd5\x2f",
          "\x00\x50\x30\xf1\x84\x44\x08\xb5\x03\x97\x76\xe7\x0c", "",
          "\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\xf1\x84\x44\x08\xf8\xba\x1a\x55"
          "\xd0\x2f\x85\xae\x96\x7b\xb6\x2f\xb6\xcd\xa8\xeb\x7e\x78\xa0\x50",
          "\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\xf1\x84\x44\x08\xf3\xd0\xa2\xfe"
          "\x9a\x3d\xbf\x23\x42\xa6\x43\xe4\x32\x46\xe8\x0c\x3c\x04\xd0\x19\x60\x76"
          "\xe8\xe2\x0c\x0a\xf6\xdf",
          "", 1, 112, 272 },
        { 104, 128, 64, 37, "\xc9\x7c\x1f\x67\xce\x37\x11\x85\x51\x4a\x8a\x19\xf2\xbd\xd5\x2f",
          "\x00\x50\x30\xf1\x84\x44\x08\xb5\x03\x97\x76\xe7\x0c", "",
          "\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\xf1\x84\x44\x08\xab\xae\xa5\xb8"
          "\xfc\xba\x00\x00\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\xf8\xba\x1a\x55"
          "\xd0\x2f\x85\xae\x96\x7b\xb6\x2f\xb6\xcd\xa8\xeb\x7e\x78\xa0\x50",
          "\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\xf1\x84\x44\x08\xab\xae\xa5\xb8"
          "\xfc\xba\x00\x00\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\xf3\xd0\xa2\xfe"
          "\x9a\x3d\xbf\x23\x42\xa6\x43\xe4\x32\x46\xe8\x0c\x3c\x04\xd0\x19\x35\x0d"
          "\xa5\xaa\x1e\x71\x82\x35",
          "", 1, 256, 416 },
        { 104, 128, 64, 38, "\xc9\x7c\x1f\x67\xce\x37\x11\x85\x51\x4a\x8a\x19\xf2\xbd\xd5\x2f",
          "\x00\x50\x30\xf1\x84\x44\x08\xb5\x03\x97\x76\xe7\x0c", "",
          "\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\xf1\x84\x44\x08\xab\xae\xa5\xb8"
          "\xfc\xba\x00\x00\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\x00\x01\x02\x03"
          "\xf8\xba\x1a\x55\xd0\x2f\x85\xae\x96\x7b\xb6\x2f\xb6\xcd\xa8\xeb\x7e\x78"
          "\xa0\x50",
          "\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\xf1\x84\x44\x08\xab\xae\xa5\xb8"
          "\xfc\xba\x00\x00\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\x00\x01\x02\x03"
          "\xf3\xd0\xa2\xfe\x9a\x3d\xbf\x23\x42\xa6\x43\xe4\x32\x46\xe8\x0c\x3c\x04"
          "\xd0\x19\x26\x5a\x04\xb1\x56\xff\x9f\x0e",
          "", 1, 288, 448 },
        { 104, 128, 64, 39, "\xc9\x7c\x1f\x67\xce\x37\x11\x85\x51\x4a\x8a\x19\xf2\xbd\xd5\x2f",
          "\x00\x50\x30\xf1\x84\x44\x08\xb5\x03\x97\x76\xe7\x0c", "",
          "\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\xf1\x84\x44\x08\xab\xae\xa5\xb8"
          "\xfc\xba\x00\x00\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\x00\x01\x02\x03"
          "\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\xf8\xba\x1a\x55\xd0\x2f\x85\xae"
          "\x96\x7b\xb6\x2f\xb6\xcd\xa8\xeb\x7e\x78\xa0\x50",
          "\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\xf1\x84\x44\x08\xab\xae\xa5\xb8"
          "\xfc\xba\x00\x00\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\x00\x01\x02\x03"
          "\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\xf3\xd0\xa2\xfe\x9a\x3d\xbf\x23"
          "\x42\xa6\x43\xe4\x32\x46\xe8\x0c\x3c\x04\xd0\x19\x07\x55\x13\x40\x2b\x11"
          "\x6d\xd5",
          "", 1, 368, 528 },
        { 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0 }
};

const struct aead_test ccm_256_test_json[] = {
        /* Vectors from https://tools.ietf.org/html/rfc3610 */
        { 104, 256, 64, 1,
          "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf\xc0\xc1"
          "\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x03\x02\x01\x00\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x21\x61\x63\xde\xcf\x74\xe0\x0c\xab\x04"
          "\x56\xff\x45\xcd\xa7\x17\x1f\xa5\x96\xd7\x0f\x76\x91\xca\x8a\xfa\xa2\x3f"
          "\x22\x3e\x64",
          "", 1, 64, 248 },
        { 104, 256, 64, 2,
          "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf\xc0\xc1"
          "\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x04\x03\x02\x01\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x61\x6a\x60\x6d\x54\x41\x94\xab\x29\xd2"
          "\xa9\x86\x14\xda\x02\x40\x14\xfa\xc5\xce\x97\x0a\xa1\xe9\xf1\xa3\xed\x0e"
          "\xe1\x2a\x9b\x69",
          "", 1, 64, 256 },
        { 104, 256, 64, 3,
          "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf\xc0\xc1"
          "\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x05\x04\x03\x02\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x75\x4c\xdd\xea\x13\x59\x9b\x30\xba\xc6"
          "\xd4\x0d\x12\x0d\x43\x0a\x2b\x44\xc4\x0b\x1f\xde\x31\x24\xc4\x9e\xd2\xc4"
          "\xf4\x04\xdc\xf3\xeb",
          "", 1, 64, 264 },
        { 104, 256, 64, 4,
          "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf\xc0\xc1"
          "\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x06\x05\x04\x03\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x5c\x14\xc7\x8c\x02\xc5"
          "\xa2\x64\xd8\xdf\x46\x57\x88\x34\xef\x27\xc1\xa3\x01\xef\xda\x9e\x13\xc7"
          "\x00\xcc\x63",
          "", 1, 96, 248 },
        { 104, 256, 64, 5,
          "\xc0\xc1\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf\xc0\xc1"
          "\xc2\xc3\xc4\xc5\xc6\xc7\xc8\xc9\xca\xcb\xcc\xcd\xce\xcf",
          "\x00\x00\x00\x07\x06\x05\x04\xa0\xa1\xa2\xa3\xa4\xa5", "",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11"
          "\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f",
          "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0b\x2c\xf8\x28\xa5\x5a\x7d"
          "\xef\xf1\x63\x3d\x26\x72\xa0\x7b\x35\x2c\x3d\xc5\xb4\xe5\x8f\xc4\x9d\x90"
          "\xbe\x78\x94\xa5",
          "", 1, 96, 256 },
        { 104, 256, 80, 6,
          "\xd7\x82\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b\xd7\x82"
          "\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b",
          "\x00\x92\x0f\x40\xe5\x6c\xdc\x3c\x96\x96\x76\x6c\xfa", "",
          "\x74\xa0\xeb\xc9\x06\x9f\x5b\x37\x17\x61\x43\x3c\x37\xc5\xa3\x5f\xc1\xf3"
          "\x9f\x40\x63\x02\xeb\x90\x7c\x61\x63\xbe\x38\xc9\x84\x37",
          "\x74\xa0\xeb\xc9\x06\x9f\x5b\x37\x8e\xef\xd9\x8c\x25\x6f\xef\xcd\xc3\xc0"
          "\xad\x3c\x42\xb1\xd7\x44\x2b\x44\x75\x41\xc3\xb1\x18\x85\x90\x59\x3c\x67"
          "\xe2\xf7\x9e\x2a\xce\x9e",
          "", 1, 64, 256 },
        { 104, 256, 80, 7,
          "\xd7\x82\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b\xd7\x82"
          "\x8d\x13\xb2\xb0\xbd\xc3\x25\xa7\x62\x36\xdf\x93\xcc\x6b",
          "\x00\x8d\x49\x3b\x30\xae\x8b\x3c\x96\x96\x76\x6c\xfa", "",
          "\x6e\x37\xa6\xef\x54\x6d\x95\x5d\x34\xab\x60\x59\xab\xf2\x1c\x0b\x02\xfe"
          "\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f"
          "\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d"
          "\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3"
          "\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81"
          "\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3"
          "\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12"
          "\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17"
          "\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe"
          "\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f"
          "\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d"
          "\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3"
          "\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81"
          "\xbc\xe3\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3"
          "\xcc\x12\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12"
          "\x85\x17\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17"
          "\x02\xfe\xb8\x8f\x85\x6d\xf4\xa3\x73\x81\xbc\xe3\xcc\x12\x85\x17\x02\xfe"
          "\xb8\x8f\x85\x6d\xf4\xa3",
          "\x6e\x37\xa6\xef\x54\x6d\x95\x5d\x34\xab\x60\x59\x23\x68\x7a\x56\x54\x09"
          "\x51\xb0\x13\x4f\x65\xe9\xcd\xe6\xac\x57\x22\x59\x28\xe3\x93\xea\xa6\xc5"
          "\x14\xbf\x9d\x1d\x5d\xb0\xa3\x16\xb2\x4a\x09\xe8\x9a\xd2\xe4\x04\x66\x01"
          "\x84\xd3\xaf\x85\x02\x69\xf4\xa2\x43\x5c\x98\x13\xf1\x96\x99\x68\xc1\x8c"
          "\x4b\x3f\x69\xce\x05\x26\x12\x76\xdb\xb7\x7d\x99\xcc\x0b\x6e\x43\x03\x75"
          "\xff\xd9\x85\x8e\x1c\x4e\x7d\x0f\x4d\xfd\x1c\x6a\x1e\x5c\xf4\x17\x3a\xa9"
          "\x1f\xf8\xd0\xad\xf8\xb6\x8b\xc1\xb5\xff\x71\x6f\xbe\x18\x92\xed\x43\x73"
          "\x04\xed\xb9\x78\x35\xa4\x70\x99\xdd\x62\xc0\x68\x84\x68\x5f\x37\x3c\x9f"
          "\xdd\x8b\xfb\x75\x82\x47\xae\x1b\x21\x54\x5e\x1e\x43\x7c\x63\xc5\xb5\x47"
          "\xa7\x65\x56\x47\xba\xc5\x30\x4b\x4a\xad\xa5\x68\x5d\x22\x31\xb8\x92\x25"
          "\x4d\x42\x8b\x51\xf8\xfb\xba\x1a\xaa\x86\x71\x3e\x22\xc0\x7f\xd7\x58\xd0"
          "\x25\x90\xf5\x18\xf7\xe9\x69\xe3\x6f\x5e\x1c\x38\xa3\x52\xa3\x49\x4b\x70"
          "\x1e\xb6\x13\x65\xf7\x1a\xf9\xe0\x03\x94\x2b\x4b\xd9\xb0\x18\xa8\x2a\xda"
          "\x80\xd4\x88\xd3\x0b\x37\xe1\x4a\xbe\xbf\xd9\x2c\x84\xd1\xf5\x56\x5c\x79"
          "\x14\x77\x1b\x9d\x34\x65\x22\x39\x78\x4d\xee\x29\x9a\x80\x42\x2a\xaf\x3d"
          "\x84\xb7\x3c\x60\xa6\x08\x4c\xbb\x2b\x8e\xdb\x94\x4d\x72\x08\x1b\x29\xd1"
          "\xe9\xdb\xe9\x53\x2c\xc0\x22\xe0\x75\x27\x61\x2e\x26\xe4\x80\x2a\xb0\xd3"
          "\xf4\x4e\x90\x91\x92\xdb\x92\xe1\x4f\x3d\x53\x58\xc8\x86\x18\x5d",
          "", 1, 96, 2496 },
        { 56, 256, 32, 8,
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x40\x41"
          "\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f",
          "\x10\x11\x12\x13\x14\x15\x16", "", "\x00\x01\x02\x03\x04\x05\x06\x07\x20\x21\x22\x23",
          "\x00\x01\x02\x03\x04\x05\x06\x07\xd0\xb5\x4a\x05\x45\x50\xab\xab", "", 1, 64, 96 },
        { 104, 256, 64, 9,
          "\xc9\x7c\x1f\x67\xce\x37\x11\x85\x51\x4a\x8a\x19\xf2\xbd\xd5\x2f\xc9\x7c"
          "\x1f\x67\xce\x37\x11\x85\x51\x4a\x8a\x19\xf2\xbd\xd5\x2f",
          "\x00\x50\x30\xf1\x84\x44\x08\xb5\x03\x97\x76\xe7\x0c", "",
          "\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\xf1\x84\x44\x08\xab\xae\xa5\xb8"
          "\xfc\xba\x00\x00\xf8\xba\x1a\x55\xd0\x2f\x85\xae\x96\x7b\xb6\x2f\xb6\xcd"
          "\xa8\xeb\x7e\x78\xa0\x50",
          "\x08\x40\x0f\xd2\xe1\x28\xa5\x7c\x50\x30\xf1\x84\x44\x08\xab\xae\xa5\xb8"
          "\xfc\xba\x00\x00\x12\x2a\xb4\xd4\x01\xc3\x1a\x55\xe0\x59\x6a\x5e\xcc\x37"
          "\xdb\xd4\xa2\xb5\x3f\xd8\x42\x1d\xb8\xe9\xbf\x60\x3f\xe8",
          "", 1, 176, 336 },
        { 56, 256, 80, 10,
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x40\x41"
          "\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f",
          "\x10\x11\x12\x13\x14\x15\x16", "", "\x00\x01\x02\x03\x04\x05\x06\x07\x20\x21\x22\x23",
          "\x00\x01\x02\x03\x04\x05\x06\x07\xd0\xb5\x4a\x05\xf8\x16\xab\xe3\xa7\xc9"
          "\x26\xb4\x3d\xea",
          "", 1, 64, 96 },
        { 104, 256, 64, 11,
          "\xc9\x7c\x1f\x67\xce\x37\x11\x85\x51\x4a\x8a\x19\xf2\xbd\xd5\x2f\xc9\x7c"
          "\x1f\x67\xce\x37\x11\x85\x51\x4a\x8a\x19\xf2\xbd\xd5\x2f",
          "\x00\x50\x30\xf1\x84\x44\x08\xb5\x03\x97\x76\xe7\x0c", "",
          "\xf8\xba\x1a\x55\xd0\x2f\x85\xae\x96\x7b\xb6\x2f\xb6\xcd\xa8\xeb\x7e\x78"
          "\xa0\x50",
          "\x12\x2a\xb4\xd4\x01\xc3\x1a\x55\xe0\x59\x6a\x5e\xcc\x37\xdb\xd4\xa2\xb5"
          "\x3f\xd8\x1c\x89\xde\xf3\x72\x03\x96\x19",
          "", 1, 0, 160 },
        { 56, 256, 128, 12,
          "\x40\x41\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f\x40\x41"
          "\x42\x43\x44\x45\x46\x47\x48\x49\x4a\x4b\x4c\x4d\x4e\x4f",
          "\x10\x11\x12\x13\x14\x15\x16", "", "\x00\x01\x02\x03\x04\x05\x06\x07\x20\x21\x22\x23",
          "\x00\x01\x02\x03\x04\x05\x06\x07\xd0\xb5\x4a\x05\x45\x80\xd7\x1d\xa5\x34"
          "\x5f\x7c\xf9\x11\xb9\x95\x19\x86\x90\x30",
          "", 1, 64, 96 },
        { 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0 }
};
