; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=RV64,RV64I
; RUN: llc -mtriple=riscv64 -verify-machineinstrs -mattr=+zba < %s \
; RUN:   | FileCheck %s -check-prefixes=RV64,RV64ZBA

; The patterns for the 'W' suffixed RV64I instructions have the potential of
; missing cases. This file checks all the variants of
; sign-extended/zero-extended/any-extended inputs and outputs.

; The 64-bit add instruction can safely be used when the result is anyext.

define i32 @aext_addw_aext_aext(i32 %a, i32 %b) nounwind {
; RV64-LABEL: aext_addw_aext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define i32 @aext_addw_aext_sext(i32 %a, i32 signext %b) nounwind {
; RV64-LABEL: aext_addw_aext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define i32 @aext_addw_aext_zext(i32 %a, i32 zeroext %b) nounwind {
; RV64-LABEL: aext_addw_aext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define i32 @aext_addw_sext_aext(i32 signext %a, i32 %b) nounwind {
; RV64-LABEL: aext_addw_sext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define i32 @aext_addw_sext_sext(i32 signext %a, i32 signext %b) nounwind {
; RV64-LABEL: aext_addw_sext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define i32 @aext_addw_sext_zext(i32 signext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: aext_addw_sext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define i32 @aext_addw_zext_aext(i32 zeroext %a, i32 %b) nounwind {
; RV64-LABEL: aext_addw_zext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define i32 @aext_addw_zext_sext(i32 zeroext %a, i32 signext %b) nounwind {
; RV64-LABEL: aext_addw_zext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define i32 @aext_addw_zext_zext(i32 zeroext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: aext_addw_zext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

; Always select addw when a signext result is required.

define signext i32 @sext_addw_aext_aext(i32 %a, i32 %b) nounwind {
; RV64-LABEL: sext_addw_aext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_addw_aext_sext(i32 %a, i32 signext %b) nounwind {
; RV64-LABEL: sext_addw_aext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_addw_aext_zext(i32 %a, i32 zeroext %b) nounwind {
; RV64-LABEL: sext_addw_aext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_addw_sext_aext(i32 signext %a, i32 %b) nounwind {
; RV64-LABEL: sext_addw_sext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_addw_sext_sext(i32 signext %a, i32 signext %b) nounwind {
; RV64-LABEL: sext_addw_sext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_addw_sext_zext(i32 signext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: sext_addw_sext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_addw_zext_aext(i32 zeroext %a, i32 %b) nounwind {
; RV64-LABEL: sext_addw_zext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_addw_zext_sext(i32 zeroext %a, i32 signext %b) nounwind {
; RV64-LABEL: sext_addw_zext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_addw_zext_zext(i32 zeroext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: sext_addw_zext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    addw a0, a0, a1
; RV64-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

; 64-bit add followed by zero-extension is a safe option when a zeroext result
; is required.

define zeroext i32 @zext_addw_aext_aext(i32 %a, i32 %b) nounwind {
; RV64I-LABEL: zext_addw_aext_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_addw_aext_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    addw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_addw_aext_sext(i32 %a, i32 signext %b) nounwind {
; RV64I-LABEL: zext_addw_aext_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_addw_aext_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    addw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_addw_aext_zext(i32 %a, i32 zeroext %b) nounwind {
; RV64I-LABEL: zext_addw_aext_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_addw_aext_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    addw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_addw_sext_aext(i32 signext %a, i32 %b) nounwind {
; RV64I-LABEL: zext_addw_sext_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_addw_sext_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    addw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_addw_sext_sext(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: zext_addw_sext_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_addw_sext_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    addw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_addw_sext_zext(i32 signext %a, i32 zeroext %b) nounwind {
; RV64I-LABEL: zext_addw_sext_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_addw_sext_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    addw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_addw_zext_aext(i32 zeroext %a, i32 %b) nounwind {
; RV64I-LABEL: zext_addw_zext_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_addw_zext_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    addw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_addw_zext_sext(i32 zeroext %a, i32 signext %b) nounwind {
; RV64I-LABEL: zext_addw_zext_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_addw_zext_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    addw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_addw_zext_zext(i32 zeroext %a, i32 zeroext %b) nounwind {
; RV64I-LABEL: zext_addw_zext_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_addw_zext_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    addw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = add i32 %a, %b
  ret i32 %1
}

; 64-bit sub is safe for an anyext result.

define i32 @aext_subw_aext_aext(i32 %a, i32 %b) nounwind {
; RV64-LABEL: aext_subw_aext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define i32 @aext_subw_aext_sext(i32 %a, i32 signext %b) nounwind {
; RV64-LABEL: aext_subw_aext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define i32 @aext_subw_aext_zext(i32 %a, i32 zeroext %b) nounwind {
; RV64-LABEL: aext_subw_aext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define i32 @aext_subw_sext_aext(i32 signext %a, i32 %b) nounwind {
; RV64-LABEL: aext_subw_sext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define i32 @aext_subw_sext_sext(i32 signext %a, i32 signext %b) nounwind {
; RV64-LABEL: aext_subw_sext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define i32 @aext_subw_sext_zext(i32 signext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: aext_subw_sext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define i32 @aext_subw_zext_aext(i32 zeroext %a, i32 %b) nounwind {
; RV64-LABEL: aext_subw_zext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define i32 @aext_subw_zext_sext(i32 zeroext %a, i32 signext %b) nounwind {
; RV64-LABEL: aext_subw_zext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define i32 @aext_subw_zext_zext(i32 zeroext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: aext_subw_zext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

; Always select subw for a signext result.

define signext i32 @sext_subw_aext_aext(i32 %a, i32 %b) nounwind {
; RV64-LABEL: sext_subw_aext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_subw_aext_sext(i32 %a, i32 signext %b) nounwind {
; RV64-LABEL: sext_subw_aext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_subw_aext_zext(i32 %a, i32 zeroext %b) nounwind {
; RV64-LABEL: sext_subw_aext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_subw_sext_aext(i32 signext %a, i32 %b) nounwind {
; RV64-LABEL: sext_subw_sext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_subw_sext_sext(i32 signext %a, i32 signext %b) nounwind {
; RV64-LABEL: sext_subw_sext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_subw_sext_zext(i32 signext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: sext_subw_sext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_subw_zext_aext(i32 zeroext %a, i32 %b) nounwind {
; RV64-LABEL: sext_subw_zext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_subw_zext_sext(i32 zeroext %a, i32 signext %b) nounwind {
; RV64-LABEL: sext_subw_zext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_subw_zext_zext(i32 zeroext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: sext_subw_zext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    subw a0, a0, a1
; RV64-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

; 64-bit sub followed by zero-extension is safe for a zeroext result.

define zeroext i32 @zext_subw_aext_aext(i32 %a, i32 %b) nounwind {
; RV64I-LABEL: zext_subw_aext_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    subw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_subw_aext_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    subw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_subw_aext_sext(i32 %a, i32 signext %b) nounwind {
; RV64I-LABEL: zext_subw_aext_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    subw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_subw_aext_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    subw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_subw_aext_zext(i32 %a, i32 zeroext %b) nounwind {
; RV64I-LABEL: zext_subw_aext_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    subw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_subw_aext_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    subw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_subw_sext_aext(i32 signext %a, i32 %b) nounwind {
; RV64I-LABEL: zext_subw_sext_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    subw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_subw_sext_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    subw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_subw_sext_sext(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: zext_subw_sext_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    subw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_subw_sext_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    subw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_subw_sext_zext(i32 signext %a, i32 zeroext %b) nounwind {
; RV64I-LABEL: zext_subw_sext_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    subw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_subw_sext_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    subw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_subw_zext_aext(i32 zeroext %a, i32 %b) nounwind {
; RV64I-LABEL: zext_subw_zext_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    subw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_subw_zext_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    subw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_subw_zext_sext(i32 zeroext %a, i32 signext %b) nounwind {
; RV64I-LABEL: zext_subw_zext_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    subw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_subw_zext_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    subw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_subw_zext_zext(i32 zeroext %a, i32 zeroext %b) nounwind {
; RV64I-LABEL: zext_subw_zext_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    subw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_subw_zext_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    subw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = sub i32 %a, %b
  ret i32 %1
}

; 64-bit sll is a safe choice for an anyext result.

define i32 @aext_sllw_aext_aext(i32 %a, i32 %b) nounwind {
; RV64-LABEL: aext_sllw_aext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define i32 @aext_sllw_aext_sext(i32 %a, i32 signext %b) nounwind {
; RV64-LABEL: aext_sllw_aext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define i32 @aext_sllw_aext_zext(i32 %a, i32 zeroext %b) nounwind {
; RV64-LABEL: aext_sllw_aext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define i32 @aext_sllw_sext_aext(i32 signext %a, i32 %b) nounwind {
; RV64-LABEL: aext_sllw_sext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define i32 @aext_sllw_sext_sext(i32 signext %a, i32 signext %b) nounwind {
; RV64-LABEL: aext_sllw_sext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define i32 @aext_sllw_sext_zext(i32 signext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: aext_sllw_sext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define i32 @aext_sllw_zext_aext(i32 zeroext %a, i32 %b) nounwind {
; RV64-LABEL: aext_sllw_zext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define i32 @aext_sllw_zext_sext(i32 zeroext %a, i32 signext %b) nounwind {
; RV64-LABEL: aext_sllw_zext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define i32 @aext_sllw_zext_zext(i32 zeroext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: aext_sllw_zext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sllw_aext_aext(i32 %a, i32 %b) nounwind {
; RV64-LABEL: sext_sllw_aext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sllw_aext_sext(i32 %a, i32 signext %b) nounwind {
; RV64-LABEL: sext_sllw_aext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sllw_aext_zext(i32 %a, i32 zeroext %b) nounwind {
; RV64-LABEL: sext_sllw_aext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sllw_sext_aext(i32 signext %a, i32 %b) nounwind {
; RV64-LABEL: sext_sllw_sext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sllw_sext_sext(i32 signext %a, i32 signext %b) nounwind {
; RV64-LABEL: sext_sllw_sext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sllw_sext_zext(i32 signext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: sext_sllw_sext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sllw_zext_aext(i32 zeroext %a, i32 %b) nounwind {
; RV64-LABEL: sext_sllw_zext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sllw_zext_sext(i32 zeroext %a, i32 signext %b) nounwind {
; RV64-LABEL: sext_sllw_zext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sllw_zext_zext(i32 zeroext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: sext_sllw_zext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    sllw a0, a0, a1
; RV64-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

; 64-bit sll followed by zero-extension for a zeroext result.

define zeroext i32 @zext_sllw_aext_aext(i32 %a, i32 %b) nounwind {
; RV64I-LABEL: zext_sllw_aext_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sllw_aext_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sllw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sllw_aext_sext(i32 %a, i32 signext %b) nounwind {
; RV64I-LABEL: zext_sllw_aext_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sllw_aext_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sllw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sllw_aext_zext(i32 %a, i32 zeroext %b) nounwind {
; RV64I-LABEL: zext_sllw_aext_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sllw_aext_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sllw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sllw_sext_aext(i32 signext %a, i32 %b) nounwind {
; RV64I-LABEL: zext_sllw_sext_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sllw_sext_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sllw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sllw_sext_sext(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: zext_sllw_sext_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sllw_sext_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sllw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sllw_sext_zext(i32 signext %a, i32 zeroext %b) nounwind {
; RV64I-LABEL: zext_sllw_sext_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sllw_sext_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sllw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sllw_zext_aext(i32 zeroext %a, i32 %b) nounwind {
; RV64I-LABEL: zext_sllw_zext_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sllw_zext_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sllw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sllw_zext_sext(i32 zeroext %a, i32 signext %b) nounwind {
; RV64I-LABEL: zext_sllw_zext_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sllw_zext_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sllw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sllw_zext_zext(i32 zeroext %a, i32 zeroext %b) nounwind {
; RV64I-LABEL: zext_sllw_zext_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sllw_zext_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sllw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = shl i32 %a, %b
  ret i32 %1
}

define i32 @aext_srlw_aext_aext(i32 %a, i32 %b) nounwind {
; RV64-LABEL: aext_srlw_aext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define i32 @aext_srlw_aext_sext(i32 %a, i32 signext %b) nounwind {
; RV64-LABEL: aext_srlw_aext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define i32 @aext_srlw_aext_zext(i32 %a, i32 zeroext %b) nounwind {
; RV64-LABEL: aext_srlw_aext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define i32 @aext_srlw_sext_aext(i32 signext %a, i32 %b) nounwind {
; RV64-LABEL: aext_srlw_sext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define i32 @aext_srlw_sext_sext(i32 signext %a, i32 signext %b) nounwind {
; RV64-LABEL: aext_srlw_sext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define i32 @aext_srlw_sext_zext(i32 signext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: aext_srlw_sext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define i32 @aext_srlw_zext_aext(i32 zeroext %a, i32 %b) nounwind {
; RV64-LABEL: aext_srlw_zext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define i32 @aext_srlw_zext_sext(i32 zeroext %a, i32 signext %b) nounwind {
; RV64-LABEL: aext_srlw_zext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define i32 @aext_srlw_zext_zext(i32 zeroext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: aext_srlw_zext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_srlw_aext_aext(i32 %a, i32 %b) nounwind {
; RV64-LABEL: sext_srlw_aext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_srlw_aext_sext(i32 %a, i32 signext %b) nounwind {
; RV64-LABEL: sext_srlw_aext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_srlw_aext_zext(i32 %a, i32 zeroext %b) nounwind {
; RV64-LABEL: sext_srlw_aext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_srlw_sext_aext(i32 signext %a, i32 %b) nounwind {
; RV64-LABEL: sext_srlw_sext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_srlw_sext_sext(i32 signext %a, i32 signext %b) nounwind {
; RV64-LABEL: sext_srlw_sext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_srlw_sext_zext(i32 signext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: sext_srlw_sext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_srlw_zext_aext(i32 zeroext %a, i32 %b) nounwind {
; RV64-LABEL: sext_srlw_zext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_srlw_zext_sext(i32 zeroext %a, i32 signext %b) nounwind {
; RV64-LABEL: sext_srlw_zext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_srlw_zext_zext(i32 zeroext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: sext_srlw_zext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    srlw a0, a0, a1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_srlw_aext_aext(i32 %a, i32 %b) nounwind {
; RV64I-LABEL: zext_srlw_aext_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_srlw_aext_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    srlw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_srlw_aext_sext(i32 %a, i32 signext %b) nounwind {
; RV64I-LABEL: zext_srlw_aext_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_srlw_aext_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    srlw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_srlw_aext_zext(i32 %a, i32 zeroext %b) nounwind {
; RV64I-LABEL: zext_srlw_aext_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_srlw_aext_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    srlw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_srlw_sext_aext(i32 signext %a, i32 %b) nounwind {
; RV64I-LABEL: zext_srlw_sext_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_srlw_sext_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    srlw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_srlw_sext_sext(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: zext_srlw_sext_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_srlw_sext_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    srlw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_srlw_sext_zext(i32 signext %a, i32 zeroext %b) nounwind {
; RV64I-LABEL: zext_srlw_sext_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_srlw_sext_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    srlw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_srlw_zext_aext(i32 zeroext %a, i32 %b) nounwind {
; RV64I-LABEL: zext_srlw_zext_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_srlw_zext_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    srlw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_srlw_zext_sext(i32 zeroext %a, i32 signext %b) nounwind {
; RV64I-LABEL: zext_srlw_zext_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_srlw_zext_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    srlw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_srlw_zext_zext(i32 zeroext %a, i32 zeroext %b) nounwind {
; RV64I-LABEL: zext_srlw_zext_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_srlw_zext_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    srlw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = lshr i32 %a, %b
  ret i32 %1
}

define i32 @aext_sraw_aext_aext(i32 %a, i32 %b) nounwind {
; RV64-LABEL: aext_sraw_aext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define i32 @aext_sraw_aext_sext(i32 %a, i32 signext %b) nounwind {
; RV64-LABEL: aext_sraw_aext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define i32 @aext_sraw_aext_zext(i32 %a, i32 zeroext %b) nounwind {
; RV64-LABEL: aext_sraw_aext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define i32 @aext_sraw_sext_aext(i32 signext %a, i32 %b) nounwind {
; RV64-LABEL: aext_sraw_sext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define i32 @aext_sraw_sext_sext(i32 signext %a, i32 signext %b) nounwind {
; RV64-LABEL: aext_sraw_sext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define i32 @aext_sraw_sext_zext(i32 signext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: aext_sraw_sext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define i32 @aext_sraw_zext_aext(i32 zeroext %a, i32 %b) nounwind {
; RV64-LABEL: aext_sraw_zext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define i32 @aext_sraw_zext_sext(i32 zeroext %a, i32 signext %b) nounwind {
; RV64-LABEL: aext_sraw_zext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define i32 @aext_sraw_zext_zext(i32 zeroext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: aext_sraw_zext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sraw_aext_aext(i32 %a, i32 %b) nounwind {
; RV64-LABEL: sext_sraw_aext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sraw_aext_sext(i32 %a, i32 signext %b) nounwind {
; RV64-LABEL: sext_sraw_aext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sraw_aext_zext(i32 %a, i32 zeroext %b) nounwind {
; RV64-LABEL: sext_sraw_aext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sraw_sext_aext(i32 signext %a, i32 %b) nounwind {
; RV64-LABEL: sext_sraw_sext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sraw_sext_sext(i32 signext %a, i32 signext %b) nounwind {
; RV64-LABEL: sext_sraw_sext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sraw_sext_zext(i32 signext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: sext_sraw_sext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sraw_zext_aext(i32 zeroext %a, i32 %b) nounwind {
; RV64-LABEL: sext_sraw_zext_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sraw_zext_sext(i32 zeroext %a, i32 signext %b) nounwind {
; RV64-LABEL: sext_sraw_zext_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define signext i32 @sext_sraw_zext_zext(i32 zeroext %a, i32 zeroext %b) nounwind {
; RV64-LABEL: sext_sraw_zext_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraw a0, a0, a1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sraw_aext_aext(i32 %a, i32 %b) nounwind {
; RV64I-LABEL: zext_sraw_aext_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sraw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sraw_aext_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sraw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sraw_aext_sext(i32 %a, i32 signext %b) nounwind {
; RV64I-LABEL: zext_sraw_aext_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sraw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sraw_aext_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sraw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sraw_aext_zext(i32 %a, i32 zeroext %b) nounwind {
; RV64I-LABEL: zext_sraw_aext_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sraw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sraw_aext_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sraw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sraw_sext_aext(i32 signext %a, i32 %b) nounwind {
; RV64I-LABEL: zext_sraw_sext_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sraw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sraw_sext_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sraw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sraw_sext_sext(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: zext_sraw_sext_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sraw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sraw_sext_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sraw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sraw_sext_zext(i32 signext %a, i32 zeroext %b) nounwind {
; RV64I-LABEL: zext_sraw_sext_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sraw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sraw_sext_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sraw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sraw_zext_aext(i32 zeroext %a, i32 %b) nounwind {
; RV64I-LABEL: zext_sraw_zext_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sraw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sraw_zext_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sraw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sraw_zext_sext(i32 zeroext %a, i32 signext %b) nounwind {
; RV64I-LABEL: zext_sraw_zext_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sraw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sraw_zext_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sraw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

define zeroext i32 @zext_sraw_zext_zext(i32 zeroext %a, i32 zeroext %b) nounwind {
; RV64I-LABEL: zext_sraw_zext_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sraw a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sraw_zext_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sraw a0, a0, a1
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = ashr i32 %a, %b
  ret i32 %1
}

; addiw should be selected when there is a signext result.

define i32 @aext_addiw_aext(i32 %a) nounwind {
; RV64-LABEL: aext_addiw_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    addiw a0, a0, 1
; RV64-NEXT:    ret
  %1 = add i32 %a, 1
  ret i32 %1
}

define i32 @aext_addiw_sext(i32 signext %a) nounwind {
; RV64-LABEL: aext_addiw_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    addiw a0, a0, 2
; RV64-NEXT:    ret
  %1 = add i32 %a, 2
  ret i32 %1
}

define i32 @aext_addiw_zext(i32 zeroext %a) nounwind {
; RV64-LABEL: aext_addiw_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    addiw a0, a0, 3
; RV64-NEXT:    ret
  %1 = add i32 %a, 3
  ret i32 %1
}

define signext i32 @sext_addiw_aext(i32 %a) nounwind {
; RV64-LABEL: sext_addiw_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    addiw a0, a0, 4
; RV64-NEXT:    ret
  %1 = add i32 %a, 4
  ret i32 %1
}

define signext i32 @sext_addiw_sext(i32 signext %a) nounwind {
; RV64-LABEL: sext_addiw_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    addiw a0, a0, 5
; RV64-NEXT:    ret
  %1 = add i32 %a, 5
  ret i32 %1
}

define signext i32 @sext_addiw_zext(i32 zeroext %a) nounwind {
; RV64-LABEL: sext_addiw_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    addiw a0, a0, 6
; RV64-NEXT:    ret
  %1 = add i32 %a, 6
  ret i32 %1
}

define zeroext i32 @zext_addiw_aext(i32 %a) nounwind {
; RV64I-LABEL: zext_addiw_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addiw a0, a0, 7
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_addiw_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    addiw a0, a0, 7
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = add i32 %a, 7
  ret i32 %1
}

define zeroext i32 @zext_addiw_sext(i32 signext %a) nounwind {
; RV64I-LABEL: zext_addiw_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addiw a0, a0, 8
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_addiw_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    addiw a0, a0, 8
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = add i32 %a, 8
  ret i32 %1
}

define zeroext i32 @zext_addiw_zext(i32 zeroext %a) nounwind {
; RV64I-LABEL: zext_addiw_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addiw a0, a0, 9
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_addiw_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    addiw a0, a0, 9
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = add i32 %a, 9
  ret i32 %1
}

; slliw should be selected whenever the return is signext.

define i32 @aext_slliw_aext(i32 %a) nounwind {
; RV64-LABEL: aext_slliw_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    slliw a0, a0, 1
; RV64-NEXT:    ret
  %1 = shl i32 %a, 1
  ret i32 %1
}

define i32 @aext_slliw_sext(i32 signext %a) nounwind {
; RV64-LABEL: aext_slliw_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    slliw a0, a0, 2
; RV64-NEXT:    ret
  %1 = shl i32 %a, 2
  ret i32 %1
}

define i32 @aext_slliw_zext(i32 zeroext %a) nounwind {
; RV64-LABEL: aext_slliw_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    slliw a0, a0, 3
; RV64-NEXT:    ret
  %1 = shl i32 %a, 3
  ret i32 %1
}

define signext i32 @sext_slliw_aext(i32 %a) nounwind {
; RV64-LABEL: sext_slliw_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    slliw a0, a0, 4
; RV64-NEXT:    ret
  %1 = shl i32 %a, 4
  ret i32 %1
}

define signext i32 @sext_slliw_sext(i32 signext %a) nounwind {
; RV64-LABEL: sext_slliw_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    slliw a0, a0, 5
; RV64-NEXT:    ret
  %1 = shl i32 %a, 5
  ret i32 %1
}

define signext i32 @sext_slliw_zext(i32 zeroext %a) nounwind {
; RV64-LABEL: sext_slliw_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    slliw a0, a0, 6
; RV64-NEXT:    ret
  %1 = shl i32 %a, 6
  ret i32 %1
}

; TODO: the constant shifts could be combined.

define zeroext i32 @zext_slliw_aext(i32 %a) nounwind {
; RV64I-LABEL: zext_slliw_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 39
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_slliw_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    slliw a0, a0, 7
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = shl i32 %a, 7
  ret i32 %1
}

define zeroext i32 @zext_slliw_sext(i32 signext %a) nounwind {
; RV64I-LABEL: zext_slliw_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 40
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_slliw_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    slliw a0, a0, 8
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = shl i32 %a, 8
  ret i32 %1
}

define zeroext i32 @zext_slliw_zext(i32 zeroext %a) nounwind {
; RV64I-LABEL: zext_slliw_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 41
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_slliw_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    slliw a0, a0, 9
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = shl i32 %a, 9
  ret i32 %1
}

; srliw should be selected unless the first operand is zeroext, when srli is
; equivalent.

define i32 @aext_srliw_aext(i32 %a) nounwind {
; RV64-LABEL: aext_srliw_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    srliw a0, a0, 1
; RV64-NEXT:    ret
  %1 = lshr i32 %a, 1
  ret i32 %1
}

define i32 @aext_srliw_sext(i32 signext %a) nounwind {
; RV64-LABEL: aext_srliw_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    srliw a0, a0, 2
; RV64-NEXT:    ret
  %1 = lshr i32 %a, 2
  ret i32 %1
}

define i32 @aext_srliw_zext(i32 zeroext %a) nounwind {
; RV64-LABEL: aext_srliw_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    srli a0, a0, 3
; RV64-NEXT:    ret
  %1 = lshr i32 %a, 3
  ret i32 %1
}

define signext i32 @sext_srliw_aext(i32 %a) nounwind {
; RV64-LABEL: sext_srliw_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    srliw a0, a0, 4
; RV64-NEXT:    ret
  %1 = lshr i32 %a, 4
  ret i32 %1
}

define signext i32 @sext_srliw_sext(i32 signext %a) nounwind {
; RV64-LABEL: sext_srliw_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    srliw a0, a0, 5
; RV64-NEXT:    ret
  %1 = lshr i32 %a, 5
  ret i32 %1
}

define signext i32 @sext_srliw_zext(i32 zeroext %a) nounwind {
; RV64-LABEL: sext_srliw_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    srli a0, a0, 6
; RV64-NEXT:    ret
  %1 = lshr i32 %a, 6
  ret i32 %1
}

define zeroext i32 @zext_srliw_aext(i32 %a) nounwind {
; RV64-LABEL: zext_srliw_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    srliw a0, a0, 7
; RV64-NEXT:    ret
  %1 = lshr i32 %a, 7
  ret i32 %1
}

define zeroext i32 @zext_srliw_sext(i32 signext %a) nounwind {
; RV64-LABEL: zext_srliw_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    srliw a0, a0, 8
; RV64-NEXT:    ret
  %1 = lshr i32 %a, 8
  ret i32 %1
}

define zeroext i32 @zext_srliw_zext(i32 zeroext %a) nounwind {
; RV64-LABEL: zext_srliw_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    srli a0, a0, 9
; RV64-NEXT:    ret
  %1 = lshr i32 %a, 9
  ret i32 %1
}

; srai is equivalent to sraiw if the first operand is sign-extended.

define i32 @aext_sraiw_aext(i32 %a) nounwind {
; RV64-LABEL: aext_sraiw_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraiw a0, a0, 1
; RV64-NEXT:    ret
  %1 = ashr i32 %a, 1
  ret i32 %1
}

define i32 @aext_sraiw_sext(i32 signext %a) nounwind {
; RV64-LABEL: aext_sraiw_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    srai a0, a0, 2
; RV64-NEXT:    ret
  %1 = ashr i32 %a, 2
  ret i32 %1
}

define i32 @aext_sraiw_zext(i32 zeroext %a) nounwind {
; RV64-LABEL: aext_sraiw_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraiw a0, a0, 3
; RV64-NEXT:    ret
  %1 = ashr i32 %a, 3
  ret i32 %1
}

define signext i32 @sext_sraiw_aext(i32 %a) nounwind {
; RV64-LABEL: sext_sraiw_aext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraiw a0, a0, 4
; RV64-NEXT:    ret
  %1 = ashr i32 %a, 4
  ret i32 %1
}

define signext i32 @sext_sraiw_sext(i32 signext %a) nounwind {
; RV64-LABEL: sext_sraiw_sext:
; RV64:       # %bb.0:
; RV64-NEXT:    srai a0, a0, 5
; RV64-NEXT:    ret
  %1 = ashr i32 %a, 5
  ret i32 %1
}

define signext i32 @sext_sraiw_zext(i32 zeroext %a) nounwind {
; RV64-LABEL: sext_sraiw_zext:
; RV64:       # %bb.0:
; RV64-NEXT:    sraiw a0, a0, 6
; RV64-NEXT:    ret
  %1 = ashr i32 %a, 6
  ret i32 %1
}

; TODO: The sext.w+srli can be replaced with sraiw with Zba.
define zeroext i32 @zext_sraiw_aext(i32 %a) nounwind {
; RV64I-LABEL: zext_sraiw_aext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    slli a0, a0, 25
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sraiw_aext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sraiw a0, a0, 7
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = ashr i32 %a, 7
  ret i32 %1
}

define zeroext i32 @zext_sraiw_sext(i32 signext %a) nounwind {
; RV64I-LABEL: zext_sraiw_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sraiw_sext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    srli a0, a0, 8
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = ashr i32 %a, 8
  ret i32 %1
}

; TODO: The sext.w+srli can be replaced with sraiw with Zba.
define zeroext i32 @zext_sraiw_zext(i32 zeroext %a) nounwind {
; RV64I-LABEL: zext_sraiw_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    slli a0, a0, 23
; RV64I-NEXT:    srli a0, a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBA-LABEL: zext_sraiw_zext:
; RV64ZBA:       # %bb.0:
; RV64ZBA-NEXT:    sraiw a0, a0, 9
; RV64ZBA-NEXT:    zext.w a0, a0
; RV64ZBA-NEXT:    ret
  %1 = ashr i32 %a, 9
  ret i32 %1
}
