import ES2015 = require('./es2015');

interface ES2016 {
    readonly 'Abstract Equality Comparison': typeof import('./2016/AbstractEqualityComparison');
    readonly 'Abstract Relational Comparison': typeof import('./2016/AbstractRelationalComparison');
    readonly 'Strict Equality Comparison': typeof import('./2016/StrictEqualityComparison');
    readonly AdvanceStringIndex: typeof import('./2016/AdvanceStringIndex');
    readonly ArrayCreate: typeof import('./2016/ArrayCreate');
    readonly ArraySetLength: typeof import('./2016/ArraySetLength');
    readonly ArraySpeciesCreate: typeof import('./2016/ArraySpeciesCreate');
    readonly Call: typeof import('./2016/Call');
    readonly CanonicalNumericIndexString: typeof import('./2016/CanonicalNumericIndexString');
    readonly CompletePropertyDescriptor: typeof import('./2016/CompletePropertyDescriptor');
    readonly CreateDataProperty: typeof import('./2016/CreateDataProperty');
    readonly CreateDataPropertyOrThrow: typeof import('./2016/CreateDataPropertyOrThrow');
    readonly CreateHTML: typeof import('./2016/CreateHTML');
    readonly CreateIterResultObject: typeof import('./2016/CreateIterResultObject');
    readonly CreateListFromArrayLike: typeof import('./2016/CreateListFromArrayLike');
    readonly CreateMethodProperty: typeof import('./2016/CreateMethodProperty');
    readonly DateFromTime: typeof import('./2016/DateFromTime');
    readonly Day: typeof import('./2016/Day');
    readonly DayFromYear: typeof import('./2016/DayFromYear');
    readonly DaysInYear: typeof import('./2016/DaysInYear');
    readonly DayWithinYear: typeof import('./2016/DayWithinYear');
    readonly DefinePropertyOrThrow: typeof import('./2016/DefinePropertyOrThrow');
    readonly DeletePropertyOrThrow: typeof import('./2016/DeletePropertyOrThrow');
    readonly EnumerableOwnNames: typeof import('./2016/EnumerableOwnNames');
    readonly FromPropertyDescriptor: typeof import('./2016/FromPropertyDescriptor');
    readonly Get: typeof import('./2016/Get');
    readonly GetIterator: typeof import('./2016/GetIterator');
    readonly GetMethod: typeof import('./2016/GetMethod');
    readonly GetOwnPropertyKeys: typeof import('./2016/GetOwnPropertyKeys');
    readonly GetPrototypeFromConstructor: typeof import('./2016/GetPrototypeFromConstructor');
    readonly GetSubstitution: typeof import('./2016/GetSubstitution');
    readonly GetV: typeof import('./2016/GetV');
    readonly HasOwnProperty: typeof import('./2016/HasOwnProperty');
    readonly HasProperty: typeof import('./2016/HasProperty');
    readonly HourFromTime: typeof import('./2016/HourFromTime');
    readonly InLeapYear: typeof import('./2016/InLeapYear');
    readonly InstanceofOperator: typeof import('./2016/InstanceofOperator');
    readonly Invoke: typeof import('./2016/Invoke');
    readonly IsAccessorDescriptor: typeof import('./2016/IsAccessorDescriptor');
    readonly IsArray: typeof import('./2016/IsArray');
    readonly IsCallable: typeof import('./2016/IsCallable');
    readonly IsConcatSpreadable: typeof import('./2016/IsConcatSpreadable');
    readonly IsConstructor: typeof import('./2016/IsConstructor');
    readonly IsDataDescriptor: typeof import('./2016/IsDataDescriptor');
    readonly IsExtensible: typeof import('./2016/IsExtensible');
    readonly IsGenericDescriptor: typeof import('./2016/IsGenericDescriptor');
    readonly IsInteger: typeof import('./2016/IsInteger');
    readonly IsPromise: typeof import('./2016/IsPromise');
    readonly IsPropertyDescriptor: typeof import('./2016/IsPropertyDescriptor');
    readonly IsPropertyKey: typeof import('./2016/IsPropertyKey');
    readonly IsRegExp: typeof import('./2016/IsRegExp');
    readonly IterableToArrayLike: typeof import('./2016/IterableToArrayLike');
    readonly IteratorClose: typeof import('./2016/IteratorClose');
    readonly IteratorComplete: typeof import('./2016/IteratorComplete');
    readonly IteratorNext: typeof import('./2016/IteratorNext');
    readonly IteratorStep: typeof import('./2016/IteratorStep');
    readonly IteratorValue: typeof import('./2016/IteratorValue');
    readonly MakeDate: typeof import('./2016/MakeDate');
    readonly MakeDay: typeof import('./2016/MakeDay');
    readonly MakeTime: typeof import('./2016/MakeTime');
    readonly MinFromTime: typeof import('./2016/MinFromTime');
    readonly modulo: typeof import('./2016/modulo');
    readonly MonthFromTime: typeof import('./2016/MonthFromTime');
    readonly msFromTime: typeof import('./2016/msFromTime');
    readonly ObjectCreate: typeof import('./2016/ObjectCreate');
    readonly OrdinaryDefineOwnProperty: typeof import('./2016/OrdinaryDefineOwnProperty');
    readonly OrdinaryGetOwnProperty: typeof import('./2016/OrdinaryGetOwnProperty');
    readonly OrdinaryGetPrototypeOf: typeof import('./2016/OrdinaryGetPrototypeOf');
    readonly OrdinaryHasInstance: typeof import('./2016/OrdinaryHasInstance');
    readonly OrdinaryHasProperty: typeof import('./2016/OrdinaryHasProperty');
    readonly OrdinarySetPrototypeOf: typeof import('./2016/OrdinarySetPrototypeOf');
    readonly RegExpExec: typeof import('./2016/RegExpExec');
    readonly RequireObjectCoercible: typeof import('./2016/RequireObjectCoercible');
    readonly SameValue: typeof import('./2016/SameValue');
    readonly SameValueNonNumber: typeof import('./2016/SameValueNonNumber');
    readonly SameValueZero: typeof import('./2016/SameValueZero');
    readonly SecFromTime: typeof import('./2016/SecFromTime');
    readonly Set: typeof import('./2016/Set');
    readonly SetFunctionName: typeof import('./2016/SetFunctionName');
    readonly SetIntegrityLevel: typeof import('./2016/SetIntegrityLevel');
    readonly SpeciesConstructor: typeof import('./2016/SpeciesConstructor');
    readonly SymbolDescriptiveString: typeof import('./2016/SymbolDescriptiveString');
    readonly TestIntegrityLevel: typeof import('./2016/TestIntegrityLevel');
    readonly thisBooleanValue: typeof import('./2016/thisBooleanValue');
    readonly thisNumberValue: typeof import('./2016/thisNumberValue');
    readonly thisStringValue: typeof import('./2016/thisStringValue');
    readonly thisTimeValue: typeof import('./2016/thisTimeValue');
    readonly TimeClip: typeof import('./2016/TimeClip');
    readonly TimeFromYear: typeof import('./2016/TimeFromYear');
    readonly TimeWithinDay: typeof import('./2016/TimeWithinDay');
    readonly ToBoolean: typeof import('./2016/ToBoolean');
    readonly ToDateString: typeof import('./2016/ToDateString');
    readonly ToInt16: typeof import('./2016/ToInt16');
    readonly ToInt32: typeof import('./2016/ToInt32');
    readonly ToInt8: typeof import('./2016/ToInt8');
    readonly ToInteger: typeof import('./2016/ToInteger');
    readonly ToLength: typeof import('./2016/ToLength');
    readonly ToNumber: typeof import('./2016/ToNumber');
    readonly ToObject: typeof import('./2016/ToObject');
    readonly ToPrimitive: typeof import('./2016/ToPrimitive');
    readonly ToPropertyDescriptor: typeof import('./2016/ToPropertyDescriptor');
    readonly ToPropertyKey: typeof import('./2016/ToPropertyKey');
    readonly ToString: typeof import('./2016/ToString');
    readonly ToUint16: typeof import('./2016/ToUint16');
    readonly ToUint32: typeof import('./2016/ToUint32');
    readonly ToUint8: typeof import('./2016/ToUint8');
    readonly ToUint8Clamp: typeof import('./2016/ToUint8Clamp');
    readonly Type: typeof import('./2016/Type');
    readonly ValidateAndApplyPropertyDescriptor: typeof import('./2016/ValidateAndApplyPropertyDescriptor');
    readonly WeekDay: typeof import('./2016/WeekDay');
    readonly YearFromTime: typeof import('./2016/YearFromTime');
}

declare namespace ES2016 {
    // Re-export types from previous versions
    // - ES2015:
    type PropertyKey = ES2015.PropertyKey;

    // - ES5:
    type GenericDescriptor = ES2015.GenericDescriptor;
    type AccessorDescriptor<T = unknown> = ES2015.AccessorDescriptor<T>;
    type DataDescriptor<T = unknown> = ES2015.DataDescriptor<T>;
    type PropertyDescriptor<T = unknown> = ES2015.PropertyDescriptor<T>;
}

declare const ES2016: ES2016;
export = ES2016;
