// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Align, Buildable, Container, Justification, Menu, Misc, MovementStep, Widget};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkLabel")]
    pub struct Label(Object<ffi::GtkLabel, ffi::GtkLabelClass>) @extends Misc, Widget, @implements Buildable;

    match fn {
        type_ => || ffi::gtk_label_get_type(),
    }
}

impl Label {
    pub const NONE: Option<&'static Label> = None;

    #[doc(alias = "gtk_label_new")]
    pub fn new(str: Option<&str>) -> Label {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_label_new(str.to_glib_none().0)).unsafe_cast() }
    }

    #[doc(alias = "gtk_label_new_with_mnemonic")]
    #[doc(alias = "new_with_mnemonic")]
    pub fn with_mnemonic(str: &str) -> Label {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_label_new_with_mnemonic(str.to_glib_none().0))
                .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Label`] objects.
    ///
    /// This method returns an instance of [`LabelBuilder`](crate::builders::LabelBuilder) which can be used to create [`Label`] objects.
    pub fn builder() -> LabelBuilder {
        LabelBuilder::new()
    }
}

impl Default for Label {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Label`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct LabelBuilder {
    builder: glib::object::ObjectBuilder<'static, Label>,
}

impl LabelBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn angle(self, angle: f64) -> Self {
        Self {
            builder: self.builder.property("angle", angle),
        }
    }

    pub fn attributes(self, attributes: &pango::AttrList) -> Self {
        Self {
            builder: self.builder.property("attributes", attributes.clone()),
        }
    }

    pub fn ellipsize(self, ellipsize: pango::EllipsizeMode) -> Self {
        Self {
            builder: self.builder.property("ellipsize", ellipsize),
        }
    }

    pub fn justify(self, justify: Justification) -> Self {
        Self {
            builder: self.builder.property("justify", justify),
        }
    }

    pub fn label(self, label: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("label", label.into()),
        }
    }

    pub fn lines(self, lines: i32) -> Self {
        Self {
            builder: self.builder.property("lines", lines),
        }
    }

    pub fn max_width_chars(self, max_width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("max-width-chars", max_width_chars),
        }
    }

    pub fn mnemonic_widget(self, mnemonic_widget: &impl IsA<Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("mnemonic-widget", mnemonic_widget.clone().upcast()),
        }
    }

    pub fn pattern(self, pattern: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("pattern", pattern.into()),
        }
    }

    pub fn selectable(self, selectable: bool) -> Self {
        Self {
            builder: self.builder.property("selectable", selectable),
        }
    }

    pub fn single_line_mode(self, single_line_mode: bool) -> Self {
        Self {
            builder: self.builder.property("single-line-mode", single_line_mode),
        }
    }

    pub fn track_visited_links(self, track_visited_links: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("track-visited-links", track_visited_links),
        }
    }

    pub fn use_markup(self, use_markup: bool) -> Self {
        Self {
            builder: self.builder.property("use-markup", use_markup),
        }
    }

    pub fn use_underline(self, use_underline: bool) -> Self {
        Self {
            builder: self.builder.property("use-underline", use_underline),
        }
    }

    pub fn width_chars(self, width_chars: i32) -> Self {
        Self {
            builder: self.builder.property("width-chars", width_chars),
        }
    }

    pub fn wrap(self, wrap: bool) -> Self {
        Self {
            builder: self.builder.property("wrap", wrap),
        }
    }

    pub fn wrap_mode(self, wrap_mode: pango::WrapMode) -> Self {
        Self {
            builder: self.builder.property("wrap-mode", wrap_mode),
        }
    }

    pub fn xalign(self, xalign: f32) -> Self {
        Self {
            builder: self.builder.property("xalign", xalign),
        }
    }

    pub fn yalign(self, yalign: f32) -> Self {
        Self {
            builder: self.builder.property("yalign", yalign),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Label`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Label {
        self.builder.build()
    }
}

pub trait LabelExt: 'static {
    #[doc(alias = "gtk_label_get_angle")]
    #[doc(alias = "get_angle")]
    fn angle(&self) -> f64;

    #[doc(alias = "gtk_label_get_attributes")]
    #[doc(alias = "get_attributes")]
    fn attributes(&self) -> Option<pango::AttrList>;

    #[doc(alias = "gtk_label_get_current_uri")]
    #[doc(alias = "get_current_uri")]
    fn current_uri(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_label_get_ellipsize")]
    #[doc(alias = "get_ellipsize")]
    fn ellipsize(&self) -> pango::EllipsizeMode;

    #[doc(alias = "gtk_label_get_justify")]
    #[doc(alias = "get_justify")]
    fn justify(&self) -> Justification;

    #[doc(alias = "gtk_label_get_label")]
    #[doc(alias = "get_label")]
    fn label(&self) -> glib::GString;

    #[doc(alias = "gtk_label_get_layout")]
    #[doc(alias = "get_layout")]
    fn layout(&self) -> Option<pango::Layout>;

    #[doc(alias = "gtk_label_get_layout_offsets")]
    #[doc(alias = "get_layout_offsets")]
    fn layout_offsets(&self) -> (i32, i32);

    #[doc(alias = "gtk_label_get_line_wrap")]
    #[doc(alias = "get_line_wrap")]
    fn is_line_wrap(&self) -> bool;

    #[doc(alias = "gtk_label_get_line_wrap_mode")]
    #[doc(alias = "get_line_wrap_mode")]
    fn line_wrap_mode(&self) -> pango::WrapMode;

    #[doc(alias = "gtk_label_get_lines")]
    #[doc(alias = "get_lines")]
    fn lines(&self) -> i32;

    #[doc(alias = "gtk_label_get_max_width_chars")]
    #[doc(alias = "get_max_width_chars")]
    fn max_width_chars(&self) -> i32;

    #[doc(alias = "gtk_label_get_mnemonic_keyval")]
    #[doc(alias = "get_mnemonic_keyval")]
    fn mnemonic_keyval(&self) -> u32;

    #[doc(alias = "gtk_label_get_mnemonic_widget")]
    #[doc(alias = "get_mnemonic_widget")]
    fn mnemonic_widget(&self) -> Option<Widget>;

    #[doc(alias = "gtk_label_get_selectable")]
    #[doc(alias = "get_selectable")]
    fn is_selectable(&self) -> bool;

    #[doc(alias = "gtk_label_get_selection_bounds")]
    #[doc(alias = "get_selection_bounds")]
    fn selection_bounds(&self) -> Option<(i32, i32)>;

    #[doc(alias = "gtk_label_get_single_line_mode")]
    #[doc(alias = "get_single_line_mode")]
    fn is_single_line_mode(&self) -> bool;

    #[doc(alias = "gtk_label_get_text")]
    #[doc(alias = "get_text")]
    fn text(&self) -> glib::GString;

    #[doc(alias = "gtk_label_get_track_visited_links")]
    #[doc(alias = "get_track_visited_links")]
    fn tracks_visited_links(&self) -> bool;

    #[doc(alias = "gtk_label_get_use_markup")]
    #[doc(alias = "get_use_markup")]
    fn uses_markup(&self) -> bool;

    #[doc(alias = "gtk_label_get_use_underline")]
    #[doc(alias = "get_use_underline")]
    fn uses_underline(&self) -> bool;

    #[doc(alias = "gtk_label_get_width_chars")]
    #[doc(alias = "get_width_chars")]
    fn width_chars(&self) -> i32;

    #[doc(alias = "gtk_label_get_xalign")]
    #[doc(alias = "get_xalign")]
    fn xalign(&self) -> f32;

    #[doc(alias = "gtk_label_get_yalign")]
    #[doc(alias = "get_yalign")]
    fn yalign(&self) -> f32;

    #[doc(alias = "gtk_label_select_region")]
    fn select_region(&self, start_offset: i32, end_offset: i32);

    #[doc(alias = "gtk_label_set_angle")]
    fn set_angle(&self, angle: f64);

    #[doc(alias = "gtk_label_set_attributes")]
    fn set_attributes(&self, attrs: Option<&pango::AttrList>);

    #[doc(alias = "gtk_label_set_ellipsize")]
    fn set_ellipsize(&self, mode: pango::EllipsizeMode);

    #[doc(alias = "gtk_label_set_justify")]
    fn set_justify(&self, jtype: Justification);

    #[doc(alias = "gtk_label_set_label")]
    fn set_label(&self, str: &str);

    #[doc(alias = "gtk_label_set_line_wrap")]
    fn set_line_wrap(&self, wrap: bool);

    #[doc(alias = "gtk_label_set_line_wrap_mode")]
    fn set_line_wrap_mode(&self, wrap_mode: pango::WrapMode);

    #[doc(alias = "gtk_label_set_lines")]
    fn set_lines(&self, lines: i32);

    #[doc(alias = "gtk_label_set_markup")]
    fn set_markup(&self, str: &str);

    #[doc(alias = "gtk_label_set_markup_with_mnemonic")]
    fn set_markup_with_mnemonic(&self, str: &str);

    #[doc(alias = "gtk_label_set_max_width_chars")]
    fn set_max_width_chars(&self, n_chars: i32);

    #[doc(alias = "gtk_label_set_mnemonic_widget")]
    fn set_mnemonic_widget(&self, widget: Option<&impl IsA<Widget>>);

    #[doc(alias = "gtk_label_set_pattern")]
    fn set_pattern(&self, pattern: &str);

    #[doc(alias = "gtk_label_set_selectable")]
    fn set_selectable(&self, setting: bool);

    #[doc(alias = "gtk_label_set_single_line_mode")]
    fn set_single_line_mode(&self, single_line_mode: bool);

    #[doc(alias = "gtk_label_set_text")]
    fn set_text(&self, str: &str);

    #[doc(alias = "gtk_label_set_text_with_mnemonic")]
    fn set_text_with_mnemonic(&self, str: &str);

    #[doc(alias = "gtk_label_set_track_visited_links")]
    fn set_track_visited_links(&self, track_links: bool);

    #[doc(alias = "gtk_label_set_use_markup")]
    fn set_use_markup(&self, setting: bool);

    #[doc(alias = "gtk_label_set_use_underline")]
    fn set_use_underline(&self, setting: bool);

    #[doc(alias = "gtk_label_set_width_chars")]
    fn set_width_chars(&self, n_chars: i32);

    #[doc(alias = "gtk_label_set_xalign")]
    fn set_xalign(&self, xalign: f32);

    #[doc(alias = "gtk_label_set_yalign")]
    fn set_yalign(&self, yalign: f32);

    #[doc(alias = "cursor-position")]
    fn cursor_position(&self) -> i32;

    #[doc(alias = "selection-bound")]
    fn selection_bound(&self) -> i32;

    fn wraps(&self) -> bool;

    fn set_wrap(&self, wrap: bool);

    #[doc(alias = "wrap-mode")]
    fn wrap_mode(&self) -> pango::WrapMode;

    #[doc(alias = "wrap-mode")]
    fn set_wrap_mode(&self, wrap_mode: pango::WrapMode);

    #[doc(alias = "activate-current-link")]
    fn connect_activate_current_link<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_activate_current_link(&self);

    #[doc(alias = "activate-link")]
    fn connect_activate_link<F: Fn(&Self, &str) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "copy-clipboard")]
    fn connect_copy_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_copy_clipboard(&self);

    #[doc(alias = "move-cursor")]
    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_move_cursor(&self, step: MovementStep, count: i32, extend_selection: bool);

    #[doc(alias = "populate-popup")]
    fn connect_populate_popup<F: Fn(&Self, &Menu) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "angle")]
    fn connect_angle_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "attributes")]
    fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "cursor-position")]
    fn connect_cursor_position_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "ellipsize")]
    fn connect_ellipsize_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "justify")]
    fn connect_justify_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "label")]
    fn connect_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "lines")]
    fn connect_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "max-width-chars")]
    fn connect_max_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "mnemonic-keyval")]
    fn connect_mnemonic_keyval_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "mnemonic-widget")]
    fn connect_mnemonic_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "pattern")]
    fn connect_pattern_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "selectable")]
    fn connect_selectable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "selection-bound")]
    fn connect_selection_bound_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "single-line-mode")]
    fn connect_single_line_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "track-visited-links")]
    fn connect_track_visited_links_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "use-markup")]
    fn connect_use_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "use-underline")]
    fn connect_use_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "width-chars")]
    fn connect_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "wrap")]
    fn connect_wrap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "wrap-mode")]
    fn connect_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Label>> LabelExt for O {
    fn angle(&self) -> f64 {
        unsafe { ffi::gtk_label_get_angle(self.as_ref().to_glib_none().0) }
    }

    fn attributes(&self) -> Option<pango::AttrList> {
        unsafe {
            from_glib_none(ffi::gtk_label_get_attributes(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn current_uri(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_label_get_current_uri(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn ellipsize(&self) -> pango::EllipsizeMode {
        unsafe { from_glib(ffi::gtk_label_get_ellipsize(self.as_ref().to_glib_none().0)) }
    }

    fn justify(&self) -> Justification {
        unsafe { from_glib(ffi::gtk_label_get_justify(self.as_ref().to_glib_none().0)) }
    }

    fn label(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_label_get_label(self.as_ref().to_glib_none().0)) }
    }

    fn layout(&self) -> Option<pango::Layout> {
        unsafe { from_glib_none(ffi::gtk_label_get_layout(self.as_ref().to_glib_none().0)) }
    }

    fn layout_offsets(&self) -> (i32, i32) {
        unsafe {
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            ffi::gtk_label_get_layout_offsets(
                self.as_ref().to_glib_none().0,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
            );
            (x.assume_init(), y.assume_init())
        }
    }

    fn is_line_wrap(&self) -> bool {
        unsafe { from_glib(ffi::gtk_label_get_line_wrap(self.as_ref().to_glib_none().0)) }
    }

    fn line_wrap_mode(&self) -> pango::WrapMode {
        unsafe {
            from_glib(ffi::gtk_label_get_line_wrap_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn lines(&self) -> i32 {
        unsafe { ffi::gtk_label_get_lines(self.as_ref().to_glib_none().0) }
    }

    fn max_width_chars(&self) -> i32 {
        unsafe { ffi::gtk_label_get_max_width_chars(self.as_ref().to_glib_none().0) }
    }

    fn mnemonic_keyval(&self) -> u32 {
        unsafe { ffi::gtk_label_get_mnemonic_keyval(self.as_ref().to_glib_none().0) }
    }

    fn mnemonic_widget(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_label_get_mnemonic_widget(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_selectable(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_label_get_selectable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn selection_bounds(&self) -> Option<(i32, i32)> {
        unsafe {
            let mut start = mem::MaybeUninit::uninit();
            let mut end = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_label_get_selection_bounds(
                self.as_ref().to_glib_none().0,
                start.as_mut_ptr(),
                end.as_mut_ptr(),
            ));
            if ret {
                Some((start.assume_init(), end.assume_init()))
            } else {
                None
            }
        }
    }

    fn is_single_line_mode(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_label_get_single_line_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn text(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_label_get_text(self.as_ref().to_glib_none().0)) }
    }

    fn tracks_visited_links(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_label_get_track_visited_links(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn uses_markup(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_label_get_use_markup(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn uses_underline(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_label_get_use_underline(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn width_chars(&self) -> i32 {
        unsafe { ffi::gtk_label_get_width_chars(self.as_ref().to_glib_none().0) }
    }

    fn xalign(&self) -> f32 {
        unsafe { ffi::gtk_label_get_xalign(self.as_ref().to_glib_none().0) }
    }

    fn yalign(&self) -> f32 {
        unsafe { ffi::gtk_label_get_yalign(self.as_ref().to_glib_none().0) }
    }

    fn select_region(&self, start_offset: i32, end_offset: i32) {
        unsafe {
            ffi::gtk_label_select_region(self.as_ref().to_glib_none().0, start_offset, end_offset);
        }
    }

    fn set_angle(&self, angle: f64) {
        unsafe {
            ffi::gtk_label_set_angle(self.as_ref().to_glib_none().0, angle);
        }
    }

    fn set_attributes(&self, attrs: Option<&pango::AttrList>) {
        unsafe {
            ffi::gtk_label_set_attributes(self.as_ref().to_glib_none().0, attrs.to_glib_none().0);
        }
    }

    fn set_ellipsize(&self, mode: pango::EllipsizeMode) {
        unsafe {
            ffi::gtk_label_set_ellipsize(self.as_ref().to_glib_none().0, mode.into_glib());
        }
    }

    fn set_justify(&self, jtype: Justification) {
        unsafe {
            ffi::gtk_label_set_justify(self.as_ref().to_glib_none().0, jtype.into_glib());
        }
    }

    fn set_label(&self, str: &str) {
        unsafe {
            ffi::gtk_label_set_label(self.as_ref().to_glib_none().0, str.to_glib_none().0);
        }
    }

    fn set_line_wrap(&self, wrap: bool) {
        unsafe {
            ffi::gtk_label_set_line_wrap(self.as_ref().to_glib_none().0, wrap.into_glib());
        }
    }

    fn set_line_wrap_mode(&self, wrap_mode: pango::WrapMode) {
        unsafe {
            ffi::gtk_label_set_line_wrap_mode(
                self.as_ref().to_glib_none().0,
                wrap_mode.into_glib(),
            );
        }
    }

    fn set_lines(&self, lines: i32) {
        unsafe {
            ffi::gtk_label_set_lines(self.as_ref().to_glib_none().0, lines);
        }
    }

    fn set_markup(&self, str: &str) {
        unsafe {
            ffi::gtk_label_set_markup(self.as_ref().to_glib_none().0, str.to_glib_none().0);
        }
    }

    fn set_markup_with_mnemonic(&self, str: &str) {
        unsafe {
            ffi::gtk_label_set_markup_with_mnemonic(
                self.as_ref().to_glib_none().0,
                str.to_glib_none().0,
            );
        }
    }

    fn set_max_width_chars(&self, n_chars: i32) {
        unsafe {
            ffi::gtk_label_set_max_width_chars(self.as_ref().to_glib_none().0, n_chars);
        }
    }

    fn set_mnemonic_widget(&self, widget: Option<&impl IsA<Widget>>) {
        unsafe {
            ffi::gtk_label_set_mnemonic_widget(
                self.as_ref().to_glib_none().0,
                widget.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_pattern(&self, pattern: &str) {
        unsafe {
            ffi::gtk_label_set_pattern(self.as_ref().to_glib_none().0, pattern.to_glib_none().0);
        }
    }

    fn set_selectable(&self, setting: bool) {
        unsafe {
            ffi::gtk_label_set_selectable(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    fn set_single_line_mode(&self, single_line_mode: bool) {
        unsafe {
            ffi::gtk_label_set_single_line_mode(
                self.as_ref().to_glib_none().0,
                single_line_mode.into_glib(),
            );
        }
    }

    fn set_text(&self, str: &str) {
        unsafe {
            ffi::gtk_label_set_text(self.as_ref().to_glib_none().0, str.to_glib_none().0);
        }
    }

    fn set_text_with_mnemonic(&self, str: &str) {
        unsafe {
            ffi::gtk_label_set_text_with_mnemonic(
                self.as_ref().to_glib_none().0,
                str.to_glib_none().0,
            );
        }
    }

    fn set_track_visited_links(&self, track_links: bool) {
        unsafe {
            ffi::gtk_label_set_track_visited_links(
                self.as_ref().to_glib_none().0,
                track_links.into_glib(),
            );
        }
    }

    fn set_use_markup(&self, setting: bool) {
        unsafe {
            ffi::gtk_label_set_use_markup(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    fn set_use_underline(&self, setting: bool) {
        unsafe {
            ffi::gtk_label_set_use_underline(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    fn set_width_chars(&self, n_chars: i32) {
        unsafe {
            ffi::gtk_label_set_width_chars(self.as_ref().to_glib_none().0, n_chars);
        }
    }

    fn set_xalign(&self, xalign: f32) {
        unsafe {
            ffi::gtk_label_set_xalign(self.as_ref().to_glib_none().0, xalign);
        }
    }

    fn set_yalign(&self, yalign: f32) {
        unsafe {
            ffi::gtk_label_set_yalign(self.as_ref().to_glib_none().0, yalign);
        }
    }

    fn cursor_position(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "cursor-position")
    }

    fn selection_bound(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "selection-bound")
    }

    fn wraps(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "wrap")
    }

    fn set_wrap(&self, wrap: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "wrap", wrap)
    }

    fn wrap_mode(&self) -> pango::WrapMode {
        glib::ObjectExt::property(self.as_ref(), "wrap-mode")
    }

    fn set_wrap_mode(&self, wrap_mode: pango::WrapMode) {
        glib::ObjectExt::set_property(self.as_ref(), "wrap-mode", wrap_mode)
    }

    fn connect_activate_current_link<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn activate_current_link_trampoline<
            P: IsA<Label>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkLabel,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-current-link\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    activate_current_link_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_activate_current_link(&self) {
        self.emit_by_name::<()>("activate-current-link", &[]);
    }

    fn connect_activate_link<F: Fn(&Self, &str) -> glib::signal::Inhibit + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn activate_link_trampoline<
            P: IsA<Label>,
            F: Fn(&P, &str) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkLabel,
            uri: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                Label::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(uri),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"activate-link\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    activate_link_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_copy_clipboard<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn copy_clipboard_trampoline<P: IsA<Label>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkLabel,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"copy-clipboard\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    copy_clipboard_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_copy_clipboard(&self) {
        self.emit_by_name::<()>("copy-clipboard", &[]);
    }

    fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_cursor_trampoline<
            P: IsA<Label>,
            F: Fn(&P, MovementStep, i32, bool) + 'static,
        >(
            this: *mut ffi::GtkLabel,
            step: ffi::GtkMovementStep,
            count: libc::c_int,
            extend_selection: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Label::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(step),
                count,
                from_glib(extend_selection),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_cursor(&self, step: MovementStep, count: i32, extend_selection: bool) {
        self.emit_by_name::<()>("move-cursor", &[&step, &count, &extend_selection]);
    }

    fn connect_populate_popup<F: Fn(&Self, &Menu) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn populate_popup_trampoline<
            P: IsA<Label>,
            F: Fn(&P, &Menu) + 'static,
        >(
            this: *mut ffi::GtkLabel,
            menu: *mut ffi::GtkMenu,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Label::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(menu),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"populate-popup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    populate_popup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_angle_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_angle_trampoline<P: IsA<Label>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::angle\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_angle_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attributes_trampoline<P: IsA<Label>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::attributes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_attributes_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_cursor_position_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cursor_position_trampoline<
            P: IsA<Label>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cursor-position\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_cursor_position_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_ellipsize_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_ellipsize_trampoline<P: IsA<Label>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::ellipsize\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_ellipsize_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_justify_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_justify_trampoline<P: IsA<Label>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::justify\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_justify_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_label_trampoline<P: IsA<Label>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::label\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_label_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_lines_trampoline<P: IsA<Label>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_max_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_width_chars_trampoline<
            P: IsA<Label>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-width-chars\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_max_width_chars_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_mnemonic_keyval_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_mnemonic_keyval_trampoline<
            P: IsA<Label>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::mnemonic-keyval\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_mnemonic_keyval_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_mnemonic_widget_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_mnemonic_widget_trampoline<
            P: IsA<Label>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::mnemonic-widget\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_mnemonic_widget_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pattern_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pattern_trampoline<P: IsA<Label>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pattern\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pattern_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_selectable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_selectable_trampoline<P: IsA<Label>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::selectable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_selectable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_selection_bound_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_selection_bound_trampoline<
            P: IsA<Label>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::selection-bound\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_selection_bound_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_single_line_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_single_line_mode_trampoline<
            P: IsA<Label>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::single-line-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_single_line_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_track_visited_links_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_track_visited_links_trampoline<
            P: IsA<Label>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::track-visited-links\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_track_visited_links_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_use_markup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_use_markup_trampoline<P: IsA<Label>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::use-markup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_use_markup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_use_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_use_underline_trampoline<P: IsA<Label>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::use-underline\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_use_underline_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_width_chars_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_width_chars_trampoline<P: IsA<Label>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::width-chars\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_width_chars_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_wrap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_trampoline<P: IsA<Label>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_wrap_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_mode_trampoline<P: IsA<Label>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkLabel,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Label::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_wrap_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Label {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Label")
    }
}
