// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Adjustment, Align, Bin, Buildable, Container, CornerType, DirectionType, PolicyType,
    PositionType, ResizeMode, ScrollType, ShadowType, Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkScrolledWindow")]
    pub struct ScrolledWindow(Object<ffi::GtkScrolledWindow, ffi::GtkScrolledWindowClass>) @extends Bin, Container, Widget, @implements Buildable;

    match fn {
        type_ => || ffi::gtk_scrolled_window_get_type(),
    }
}

impl ScrolledWindow {
    pub const NONE: Option<&'static ScrolledWindow> = None;

    #[doc(alias = "gtk_scrolled_window_new")]
    pub fn new(
        hadjustment: Option<&impl IsA<Adjustment>>,
        vadjustment: Option<&impl IsA<Adjustment>>,
    ) -> ScrolledWindow {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_scrolled_window_new(
                hadjustment.map(|p| p.as_ref()).to_glib_none().0,
                vadjustment.map(|p| p.as_ref()).to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`ScrolledWindow`] objects.
    ///
    /// This method returns an instance of [`ScrolledWindowBuilder`](crate::builders::ScrolledWindowBuilder) which can be used to create [`ScrolledWindow`] objects.
    pub fn builder() -> ScrolledWindowBuilder {
        ScrolledWindowBuilder::new()
    }
}

impl Default for ScrolledWindow {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`ScrolledWindow`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct ScrolledWindowBuilder {
    builder: glib::object::ObjectBuilder<'static, ScrolledWindow>,
}

impl ScrolledWindowBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn hadjustment(self, hadjustment: &impl IsA<Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("hadjustment", hadjustment.clone().upcast()),
        }
    }

    pub fn hscrollbar_policy(self, hscrollbar_policy: PolicyType) -> Self {
        Self {
            builder: self
                .builder
                .property("hscrollbar-policy", hscrollbar_policy),
        }
    }

    pub fn kinetic_scrolling(self, kinetic_scrolling: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("kinetic-scrolling", kinetic_scrolling),
        }
    }

    pub fn max_content_height(self, max_content_height: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("max-content-height", max_content_height),
        }
    }

    pub fn max_content_width(self, max_content_width: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("max-content-width", max_content_width),
        }
    }

    pub fn min_content_height(self, min_content_height: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("min-content-height", min_content_height),
        }
    }

    pub fn min_content_width(self, min_content_width: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("min-content-width", min_content_width),
        }
    }

    pub fn overlay_scrolling(self, overlay_scrolling: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("overlay-scrolling", overlay_scrolling),
        }
    }

    pub fn propagate_natural_height(self, propagate_natural_height: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("propagate-natural-height", propagate_natural_height),
        }
    }

    pub fn propagate_natural_width(self, propagate_natural_width: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("propagate-natural-width", propagate_natural_width),
        }
    }

    pub fn shadow_type(self, shadow_type: ShadowType) -> Self {
        Self {
            builder: self.builder.property("shadow-type", shadow_type),
        }
    }

    pub fn vadjustment(self, vadjustment: &impl IsA<Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("vadjustment", vadjustment.clone().upcast()),
        }
    }

    pub fn vscrollbar_policy(self, vscrollbar_policy: PolicyType) -> Self {
        Self {
            builder: self
                .builder
                .property("vscrollbar-policy", vscrollbar_policy),
        }
    }

    pub fn window_placement(self, window_placement: CornerType) -> Self {
        Self {
            builder: self.builder.property("window-placement", window_placement),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`ScrolledWindow`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> ScrolledWindow {
        self.builder.build()
    }
}

pub trait ScrolledWindowExt: 'static {
    #[doc(alias = "gtk_scrolled_window_get_capture_button_press")]
    #[doc(alias = "get_capture_button_press")]
    fn is_capture_button_press(&self) -> bool;

    #[doc(alias = "gtk_scrolled_window_get_hadjustment")]
    #[doc(alias = "get_hadjustment")]
    fn hadjustment(&self) -> Adjustment;

    #[doc(alias = "gtk_scrolled_window_get_hscrollbar")]
    #[doc(alias = "get_hscrollbar")]
    fn hscrollbar(&self) -> Option<Widget>;

    #[doc(alias = "gtk_scrolled_window_get_kinetic_scrolling")]
    #[doc(alias = "get_kinetic_scrolling")]
    fn is_kinetic_scrolling(&self) -> bool;

    #[doc(alias = "gtk_scrolled_window_get_max_content_height")]
    #[doc(alias = "get_max_content_height")]
    fn max_content_height(&self) -> i32;

    #[doc(alias = "gtk_scrolled_window_get_max_content_width")]
    #[doc(alias = "get_max_content_width")]
    fn max_content_width(&self) -> i32;

    #[doc(alias = "gtk_scrolled_window_get_min_content_height")]
    #[doc(alias = "get_min_content_height")]
    fn min_content_height(&self) -> i32;

    #[doc(alias = "gtk_scrolled_window_get_min_content_width")]
    #[doc(alias = "get_min_content_width")]
    fn min_content_width(&self) -> i32;

    #[doc(alias = "gtk_scrolled_window_get_overlay_scrolling")]
    #[doc(alias = "get_overlay_scrolling")]
    fn is_overlay_scrolling(&self) -> bool;

    #[doc(alias = "gtk_scrolled_window_get_placement")]
    #[doc(alias = "get_placement")]
    fn placement(&self) -> CornerType;

    #[doc(alias = "gtk_scrolled_window_get_policy")]
    #[doc(alias = "get_policy")]
    fn policy(&self) -> (PolicyType, PolicyType);

    #[doc(alias = "gtk_scrolled_window_get_propagate_natural_height")]
    #[doc(alias = "get_propagate_natural_height")]
    fn propagates_natural_height(&self) -> bool;

    #[doc(alias = "gtk_scrolled_window_get_propagate_natural_width")]
    #[doc(alias = "get_propagate_natural_width")]
    fn propagates_natural_width(&self) -> bool;

    #[doc(alias = "gtk_scrolled_window_get_shadow_type")]
    #[doc(alias = "get_shadow_type")]
    fn shadow_type(&self) -> ShadowType;

    #[doc(alias = "gtk_scrolled_window_get_vadjustment")]
    #[doc(alias = "get_vadjustment")]
    fn vadjustment(&self) -> Adjustment;

    #[doc(alias = "gtk_scrolled_window_get_vscrollbar")]
    #[doc(alias = "get_vscrollbar")]
    fn vscrollbar(&self) -> Option<Widget>;

    #[doc(alias = "gtk_scrolled_window_set_capture_button_press")]
    fn set_capture_button_press(&self, capture_button_press: bool);

    #[doc(alias = "gtk_scrolled_window_set_hadjustment")]
    fn set_hadjustment(&self, hadjustment: Option<&impl IsA<Adjustment>>);

    #[doc(alias = "gtk_scrolled_window_set_kinetic_scrolling")]
    fn set_kinetic_scrolling(&self, kinetic_scrolling: bool);

    #[doc(alias = "gtk_scrolled_window_set_max_content_height")]
    fn set_max_content_height(&self, height: i32);

    #[doc(alias = "gtk_scrolled_window_set_max_content_width")]
    fn set_max_content_width(&self, width: i32);

    #[doc(alias = "gtk_scrolled_window_set_min_content_height")]
    fn set_min_content_height(&self, height: i32);

    #[doc(alias = "gtk_scrolled_window_set_min_content_width")]
    fn set_min_content_width(&self, width: i32);

    #[doc(alias = "gtk_scrolled_window_set_overlay_scrolling")]
    fn set_overlay_scrolling(&self, overlay_scrolling: bool);

    #[doc(alias = "gtk_scrolled_window_set_placement")]
    fn set_placement(&self, window_placement: CornerType);

    #[doc(alias = "gtk_scrolled_window_set_policy")]
    fn set_policy(&self, hscrollbar_policy: PolicyType, vscrollbar_policy: PolicyType);

    #[doc(alias = "gtk_scrolled_window_set_propagate_natural_height")]
    fn set_propagate_natural_height(&self, propagate: bool);

    #[doc(alias = "gtk_scrolled_window_set_propagate_natural_width")]
    fn set_propagate_natural_width(&self, propagate: bool);

    #[doc(alias = "gtk_scrolled_window_set_shadow_type")]
    fn set_shadow_type(&self, type_: ShadowType);

    #[doc(alias = "gtk_scrolled_window_set_vadjustment")]
    fn set_vadjustment(&self, vadjustment: Option<&impl IsA<Adjustment>>);

    #[doc(alias = "gtk_scrolled_window_unset_placement")]
    fn unset_placement(&self);

    #[doc(alias = "hscrollbar-policy")]
    fn hscrollbar_policy(&self) -> PolicyType;

    #[doc(alias = "hscrollbar-policy")]
    fn set_hscrollbar_policy(&self, hscrollbar_policy: PolicyType);

    #[doc(alias = "vscrollbar-policy")]
    fn vscrollbar_policy(&self) -> PolicyType;

    #[doc(alias = "vscrollbar-policy")]
    fn set_vscrollbar_policy(&self, vscrollbar_policy: PolicyType);

    #[doc(alias = "window-placement")]
    fn window_placement(&self) -> CornerType;

    #[doc(alias = "window-placement")]
    fn set_window_placement(&self, window_placement: CornerType);

    #[doc(alias = "edge-overshot")]
    fn connect_edge_overshot<F: Fn(&Self, PositionType) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "edge-reached")]
    fn connect_edge_reached<F: Fn(&Self, PositionType) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "move-focus-out")]
    fn connect_move_focus_out<F: Fn(&Self, DirectionType) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_move_focus_out(&self, direction_type: DirectionType);

    #[doc(alias = "scroll-child")]
    fn connect_scroll_child<F: Fn(&Self, ScrollType, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_scroll_child(&self, scroll: ScrollType, horizontal: bool) -> bool;

    #[doc(alias = "hadjustment")]
    fn connect_hadjustment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "hscrollbar-policy")]
    fn connect_hscrollbar_policy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "kinetic-scrolling")]
    fn connect_kinetic_scrolling_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "max-content-height")]
    fn connect_max_content_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "max-content-width")]
    fn connect_max_content_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "min-content-height")]
    fn connect_min_content_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "min-content-width")]
    fn connect_min_content_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "overlay-scrolling")]
    fn connect_overlay_scrolling_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "propagate-natural-height")]
    fn connect_propagate_natural_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "propagate-natural-width")]
    fn connect_propagate_natural_width_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "shadow-type")]
    fn connect_shadow_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "vadjustment")]
    fn connect_vadjustment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "vscrollbar-policy")]
    fn connect_vscrollbar_policy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "window-placement")]
    fn connect_window_placement_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<ScrolledWindow>> ScrolledWindowExt for O {
    fn is_capture_button_press(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_scrolled_window_get_capture_button_press(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn hadjustment(&self) -> Adjustment {
        unsafe {
            from_glib_none(ffi::gtk_scrolled_window_get_hadjustment(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn hscrollbar(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_scrolled_window_get_hscrollbar(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_kinetic_scrolling(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_scrolled_window_get_kinetic_scrolling(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn max_content_height(&self) -> i32 {
        unsafe { ffi::gtk_scrolled_window_get_max_content_height(self.as_ref().to_glib_none().0) }
    }

    fn max_content_width(&self) -> i32 {
        unsafe { ffi::gtk_scrolled_window_get_max_content_width(self.as_ref().to_glib_none().0) }
    }

    fn min_content_height(&self) -> i32 {
        unsafe { ffi::gtk_scrolled_window_get_min_content_height(self.as_ref().to_glib_none().0) }
    }

    fn min_content_width(&self) -> i32 {
        unsafe { ffi::gtk_scrolled_window_get_min_content_width(self.as_ref().to_glib_none().0) }
    }

    fn is_overlay_scrolling(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_scrolled_window_get_overlay_scrolling(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn placement(&self) -> CornerType {
        unsafe {
            from_glib(ffi::gtk_scrolled_window_get_placement(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn policy(&self) -> (PolicyType, PolicyType) {
        unsafe {
            let mut hscrollbar_policy = mem::MaybeUninit::uninit();
            let mut vscrollbar_policy = mem::MaybeUninit::uninit();
            ffi::gtk_scrolled_window_get_policy(
                self.as_ref().to_glib_none().0,
                hscrollbar_policy.as_mut_ptr(),
                vscrollbar_policy.as_mut_ptr(),
            );
            (
                from_glib(hscrollbar_policy.assume_init()),
                from_glib(vscrollbar_policy.assume_init()),
            )
        }
    }

    fn propagates_natural_height(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_scrolled_window_get_propagate_natural_height(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn propagates_natural_width(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_scrolled_window_get_propagate_natural_width(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn shadow_type(&self) -> ShadowType {
        unsafe {
            from_glib(ffi::gtk_scrolled_window_get_shadow_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn vadjustment(&self) -> Adjustment {
        unsafe {
            from_glib_none(ffi::gtk_scrolled_window_get_vadjustment(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn vscrollbar(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(ffi::gtk_scrolled_window_get_vscrollbar(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_capture_button_press(&self, capture_button_press: bool) {
        unsafe {
            ffi::gtk_scrolled_window_set_capture_button_press(
                self.as_ref().to_glib_none().0,
                capture_button_press.into_glib(),
            );
        }
    }

    fn set_hadjustment(&self, hadjustment: Option<&impl IsA<Adjustment>>) {
        unsafe {
            ffi::gtk_scrolled_window_set_hadjustment(
                self.as_ref().to_glib_none().0,
                hadjustment.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_kinetic_scrolling(&self, kinetic_scrolling: bool) {
        unsafe {
            ffi::gtk_scrolled_window_set_kinetic_scrolling(
                self.as_ref().to_glib_none().0,
                kinetic_scrolling.into_glib(),
            );
        }
    }

    fn set_max_content_height(&self, height: i32) {
        unsafe {
            ffi::gtk_scrolled_window_set_max_content_height(self.as_ref().to_glib_none().0, height);
        }
    }

    fn set_max_content_width(&self, width: i32) {
        unsafe {
            ffi::gtk_scrolled_window_set_max_content_width(self.as_ref().to_glib_none().0, width);
        }
    }

    fn set_min_content_height(&self, height: i32) {
        unsafe {
            ffi::gtk_scrolled_window_set_min_content_height(self.as_ref().to_glib_none().0, height);
        }
    }

    fn set_min_content_width(&self, width: i32) {
        unsafe {
            ffi::gtk_scrolled_window_set_min_content_width(self.as_ref().to_glib_none().0, width);
        }
    }

    fn set_overlay_scrolling(&self, overlay_scrolling: bool) {
        unsafe {
            ffi::gtk_scrolled_window_set_overlay_scrolling(
                self.as_ref().to_glib_none().0,
                overlay_scrolling.into_glib(),
            );
        }
    }

    fn set_placement(&self, window_placement: CornerType) {
        unsafe {
            ffi::gtk_scrolled_window_set_placement(
                self.as_ref().to_glib_none().0,
                window_placement.into_glib(),
            );
        }
    }

    fn set_policy(&self, hscrollbar_policy: PolicyType, vscrollbar_policy: PolicyType) {
        unsafe {
            ffi::gtk_scrolled_window_set_policy(
                self.as_ref().to_glib_none().0,
                hscrollbar_policy.into_glib(),
                vscrollbar_policy.into_glib(),
            );
        }
    }

    fn set_propagate_natural_height(&self, propagate: bool) {
        unsafe {
            ffi::gtk_scrolled_window_set_propagate_natural_height(
                self.as_ref().to_glib_none().0,
                propagate.into_glib(),
            );
        }
    }

    fn set_propagate_natural_width(&self, propagate: bool) {
        unsafe {
            ffi::gtk_scrolled_window_set_propagate_natural_width(
                self.as_ref().to_glib_none().0,
                propagate.into_glib(),
            );
        }
    }

    fn set_shadow_type(&self, type_: ShadowType) {
        unsafe {
            ffi::gtk_scrolled_window_set_shadow_type(
                self.as_ref().to_glib_none().0,
                type_.into_glib(),
            );
        }
    }

    fn set_vadjustment(&self, vadjustment: Option<&impl IsA<Adjustment>>) {
        unsafe {
            ffi::gtk_scrolled_window_set_vadjustment(
                self.as_ref().to_glib_none().0,
                vadjustment.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn unset_placement(&self) {
        unsafe {
            ffi::gtk_scrolled_window_unset_placement(self.as_ref().to_glib_none().0);
        }
    }

    fn hscrollbar_policy(&self) -> PolicyType {
        glib::ObjectExt::property(self.as_ref(), "hscrollbar-policy")
    }

    fn set_hscrollbar_policy(&self, hscrollbar_policy: PolicyType) {
        glib::ObjectExt::set_property(self.as_ref(), "hscrollbar-policy", hscrollbar_policy)
    }

    fn vscrollbar_policy(&self) -> PolicyType {
        glib::ObjectExt::property(self.as_ref(), "vscrollbar-policy")
    }

    fn set_vscrollbar_policy(&self, vscrollbar_policy: PolicyType) {
        glib::ObjectExt::set_property(self.as_ref(), "vscrollbar-policy", vscrollbar_policy)
    }

    fn window_placement(&self) -> CornerType {
        glib::ObjectExt::property(self.as_ref(), "window-placement")
    }

    fn set_window_placement(&self, window_placement: CornerType) {
        glib::ObjectExt::set_property(self.as_ref(), "window-placement", window_placement)
    }

    fn connect_edge_overshot<F: Fn(&Self, PositionType) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn edge_overshot_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P, PositionType) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            pos: ffi::GtkPositionType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(pos),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"edge-overshot\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    edge_overshot_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_edge_reached<F: Fn(&Self, PositionType) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn edge_reached_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P, PositionType) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            pos: ffi::GtkPositionType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(pos),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"edge-reached\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    edge_reached_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_move_focus_out<F: Fn(&Self, DirectionType) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_focus_out_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P, DirectionType) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            direction_type: ffi::GtkDirectionType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(direction_type),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-focus-out\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_focus_out_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_focus_out(&self, direction_type: DirectionType) {
        self.emit_by_name::<()>("move-focus-out", &[&direction_type]);
    }

    fn connect_scroll_child<F: Fn(&Self, ScrollType, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn scroll_child_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P, ScrollType, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            scroll: ffi::GtkScrollType,
            horizontal: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(scroll),
                from_glib(horizontal),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"scroll-child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    scroll_child_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_scroll_child(&self, scroll: ScrollType, horizontal: bool) -> bool {
        self.emit_by_name("scroll-child", &[&scroll, &horizontal])
    }

    fn connect_hadjustment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hadjustment_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hadjustment\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hadjustment_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_hscrollbar_policy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hscrollbar_policy_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hscrollbar-policy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hscrollbar_policy_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_kinetic_scrolling_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_kinetic_scrolling_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::kinetic-scrolling\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_kinetic_scrolling_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_max_content_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_content_height_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-content-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_max_content_height_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_max_content_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_content_width_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-content-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_max_content_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_min_content_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_min_content_height_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::min-content-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_min_content_height_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_min_content_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_min_content_width_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::min-content-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_min_content_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_overlay_scrolling_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overlay_scrolling_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::overlay-scrolling\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_overlay_scrolling_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_propagate_natural_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_propagate_natural_height_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::propagate-natural-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_propagate_natural_height_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_propagate_natural_width_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_propagate_natural_width_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::propagate-natural-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_propagate_natural_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_shadow_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_shadow_type_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::shadow-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_shadow_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_vadjustment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_vadjustment_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vadjustment\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vadjustment_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_vscrollbar_policy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_vscrollbar_policy_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vscrollbar-policy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vscrollbar_policy_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_window_placement_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_window_placement_trampoline<
            P: IsA<ScrolledWindow>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkScrolledWindow,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::window-placement\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_window_placement_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for ScrolledWindow {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("ScrolledWindow")
    }
}
