// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, ServerMessage};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "SoupAuthDomain")]
    pub struct AuthDomain(Object<ffi::SoupAuthDomain, ffi::SoupAuthDomainClass>);

    match fn {
        type_ => || ffi::soup_auth_domain_get_type(),
    }
}

impl AuthDomain {
    pub const NONE: Option<&'static AuthDomain> = None;
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::AuthDomain>> Sealed for T {}
}

pub trait AuthDomainExt: IsA<AuthDomain> + sealed::Sealed + 'static {
    #[doc(alias = "soup_auth_domain_accepts")]
    fn accepts(&self, msg: &ServerMessage) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::soup_auth_domain_accepts(
                self.as_ref().to_glib_none().0,
                msg.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_auth_domain_add_path")]
    fn add_path(&self, path: &str) {
        unsafe {
            ffi::soup_auth_domain_add_path(self.as_ref().to_glib_none().0, path.to_glib_none().0);
        }
    }

    #[doc(alias = "soup_auth_domain_challenge")]
    fn challenge(&self, msg: &ServerMessage) {
        unsafe {
            ffi::soup_auth_domain_challenge(self.as_ref().to_glib_none().0, msg.to_glib_none().0);
        }
    }

    #[doc(alias = "soup_auth_domain_check_password")]
    fn check_password(&self, msg: &ServerMessage, username: &str, password: &str) -> bool {
        unsafe {
            from_glib(ffi::soup_auth_domain_check_password(
                self.as_ref().to_glib_none().0,
                msg.to_glib_none().0,
                username.to_glib_none().0,
                password.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_auth_domain_covers")]
    fn covers(&self, msg: &ServerMessage) -> bool {
        unsafe {
            from_glib(ffi::soup_auth_domain_covers(
                self.as_ref().to_glib_none().0,
                msg.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_auth_domain_get_realm")]
    #[doc(alias = "get_realm")]
    fn realm(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_auth_domain_get_realm(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "soup_auth_domain_remove_path")]
    fn remove_path(&self, path: &str) {
        unsafe {
            ffi::soup_auth_domain_remove_path(
                self.as_ref().to_glib_none().0,
                path.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "soup_auth_domain_set_filter")]
    #[doc(alias = "filter")]
    fn set_filter<P: Fn(&AuthDomain, &ServerMessage) -> bool + 'static>(&self, filter: P) {
        let filter_data: Box_<P> = Box_::new(filter);
        unsafe extern "C" fn filter_func<P: Fn(&AuthDomain, &ServerMessage) -> bool + 'static>(
            domain: *mut ffi::SoupAuthDomain,
            msg: *mut ffi::SoupServerMessage,
            user_data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let domain = from_glib_borrow(domain);
            let msg = from_glib_borrow(msg);
            let callback = &*(user_data as *mut P);
            (*callback)(&domain, &msg).into_glib()
        }
        let filter = Some(filter_func::<P> as _);
        unsafe extern "C" fn dnotify_func<P: Fn(&AuthDomain, &ServerMessage) -> bool + 'static>(
            data: glib::ffi::gpointer,
        ) {
            let _callback = Box_::from_raw(data as *mut P);
        }
        let destroy_call3 = Some(dnotify_func::<P> as _);
        let super_callback0: Box_<P> = filter_data;
        unsafe {
            ffi::soup_auth_domain_set_filter(
                self.as_ref().to_glib_none().0,
                filter,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    #[doc(alias = "soup_auth_domain_set_generic_auth_callback")]
    #[doc(alias = "generic-auth-callback")]
    fn set_generic_auth_callback<P: Fn(&AuthDomain, &ServerMessage, &str) -> bool + 'static>(
        &self,
        auth_callback: P,
    ) {
        let auth_callback_data: Box_<P> = Box_::new(auth_callback);
        unsafe extern "C" fn auth_callback_func<
            P: Fn(&AuthDomain, &ServerMessage, &str) -> bool + 'static,
        >(
            domain: *mut ffi::SoupAuthDomain,
            msg: *mut ffi::SoupServerMessage,
            username: *const libc::c_char,
            user_data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let domain = from_glib_borrow(domain);
            let msg = from_glib_borrow(msg);
            let username: Borrowed<glib::GString> = from_glib_borrow(username);
            let callback = &*(user_data as *mut P);
            (*callback)(&domain, &msg, username.as_str()).into_glib()
        }
        let auth_callback = Some(auth_callback_func::<P> as _);
        unsafe extern "C" fn dnotify_func<
            P: Fn(&AuthDomain, &ServerMessage, &str) -> bool + 'static,
        >(
            data: glib::ffi::gpointer,
        ) {
            let _callback = Box_::from_raw(data as *mut P);
        }
        let destroy_call3 = Some(dnotify_func::<P> as _);
        let super_callback0: Box_<P> = auth_callback_data;
        unsafe {
            ffi::soup_auth_domain_set_generic_auth_callback(
                self.as_ref().to_glib_none().0,
                auth_callback,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    //#[doc(alias = "filter-data")]
    //fn filter_data(&self) -> /*Unimplemented*/Basic: Pointer {
    //    ObjectExt::property(self.as_ref(), "filter-data")
    //}

    //#[doc(alias = "filter-data")]
    //fn set_filter_data(&self, filter_data: /*Unimplemented*/Basic: Pointer) {
    //    ObjectExt::set_property(self.as_ref(),"filter-data", filter_data)
    //}

    //#[doc(alias = "generic-auth-data")]
    //fn generic_auth_data(&self) -> /*Unimplemented*/Basic: Pointer {
    //    ObjectExt::property(self.as_ref(), "generic-auth-data")
    //}

    //#[doc(alias = "generic-auth-data")]
    //fn set_generic_auth_data(&self, generic_auth_data: /*Unimplemented*/Basic: Pointer) {
    //    ObjectExt::set_property(self.as_ref(),"generic-auth-data", generic_auth_data)
    //}

    fn is_proxy(&self) -> bool {
        ObjectExt::property(self.as_ref(), "proxy")
    }

    #[doc(alias = "filter-data")]
    fn connect_filter_data_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_filter_data_trampoline<
            P: IsA<AuthDomain>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::SoupAuthDomain,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AuthDomain::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::filter-data\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_filter_data_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "generic-auth-data")]
    fn connect_generic_auth_data_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_generic_auth_data_trampoline<
            P: IsA<AuthDomain>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::SoupAuthDomain,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AuthDomain::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::generic-auth-data\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_generic_auth_data_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<AuthDomain>> AuthDomainExt for O {}
