//
// Created by uos on 2022/3/18.
//

#include "ItemFrame.h"
#include "utils/Utils.h"
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QMouseEvent>
#include <DFontSizeManager>


ItemFrame::ItemFrame(const QString &title, const QString &description, const QString &icon, QWidget *parent)
    : DFrame(parent)
{
    setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Expanding);
    setAttribute(Qt::WA_Hover,true);
    setObjectName("ItemFrame");
    setBackgroundRole(DPalette::ItemBackground);
    setLineWidth(0);

    m_title = new DLabel;
    m_title->setText(title);
    m_description = new DLabel;
    m_description->setText(description);

    m_icon = new DLabel;
    m_icon->setAlignment(Qt::AlignCenter);
//    m_icon->setPixmap(Utils::hidpiPixmap(icon, QSize(96, 96)));
    m_radioPixmap = Utils::hidpiPixmap(":/resources/icons/radio_button.svg", QSize(20, 20));
    m_checkIcon = new DLabel;
    m_checkIcon->setVisible(true);
    m_checkIcon->setFixedSize(QSize(20, 20));
    DFontSizeManager::instance()->bind(m_title, DFontSizeManager::T4);
}

void ItemFrame::setIconPixmap(const QString &iconRes, const QSize &iconSize)
{
    if (nullptr != m_icon) {
        m_icon->setPixmap(Utils::hidpiPixmap(iconRes, iconSize));
    }
}

void ItemFrame::setLayoutStype(int layout)
{
    m_layout = layout;
}

void ItemFrame::initLayout()
{
    QList<int> vLayout = {
            UI::UI_LAYOUT_BACKUP_VERTICAL,
            UI::UI_LAYOUT_RESTORE_VERTICAL,
            UI::UI_LAYOUT_ADVANCE_VERTICAL
    };

    QList<int> hLayout = {
            UI::UI_LAYOUT_BACKUP_HORIZONTAL,
            UI::UI_LAYOUT_RESTORE_HORIZONTAL,
            UI::UI_LAYOUT_ADVANCE_HORIZONTAL
    };

    if (vLayout.contains(m_layout)) {
        this->initVerticalLayout();
    } else if (hLayout.contains(m_layout)) {
        this->initHorizontalLayout();
    } else {
        qWarning()<<"ItemFrame::initLayout, invalid layout, m_layout = "<<m_layout;
    }
}

void ItemFrame::initHorizontalLayout()
{
    QVBoxLayout *centralLayout = new QVBoxLayout(this);
    auto hBoxLayout = new QHBoxLayout;

    hBoxLayout->addStretch();
    hBoxLayout->addWidget(m_checkIcon);

    centralLayout->addLayout(hBoxLayout);
    //centralLayout->addSpacing(10);
    centralLayout->addWidget(m_icon, 0, Qt::AlignHCenter);
    centralLayout->addSpacing(10);

    QVBoxLayout *vLayout = new QVBoxLayout();

    m_title->setAlignment(Qt::AlignTop | Qt::AlignHCenter);
    m_title->setWordWrap(true);
    m_title->setFixedHeight(60);

    QFont font = m_title->font();
    font.setWeight(QFont::ExtraBold);
    font.setPixelSize(18);

    vLayout->addWidget(m_title);
    m_description->hide();
    m_description->setAlignment(Qt::AlignCenter);
    m_description->setWordWrap(true);
    QFont descriptionFont = m_description->font();
    descriptionFont.setPixelSize(12);
    vLayout->addWidget(m_description);
    centralLayout->addLayout(vLayout);
    centralLayout->setSpacing(0);
}

void ItemFrame::initVerticalLayout()
{
    m_title->setAlignment(Qt::AlignTop | Qt::AlignLeft);
    m_title->setWordWrap(true);
//    m_title->setFixedHeight(60);

    QFont font = m_title->font();
    font.setWeight(QFont::Medium);
    font.setPixelSize(18);
    m_title->setFont(font);

    m_description->setAlignment(Qt::AlignLeft);
    m_description->setWordWrap(true);
    m_description->setFixedWidth(450); // 占位置，不然icon左右两个有很多空格
    QFont descriptionFont = m_description->font();
    descriptionFont.setPixelSize(12);

    QVBoxLayout *centralLayout = new QVBoxLayout(this);
    centralLayout->setContentsMargins(0, 0, 0, 0);

    auto iconHBoxLayout = new QHBoxLayout;
    iconHBoxLayout->setSpacing(0);
    iconHBoxLayout->setContentsMargins(0, 0, 0, 0);
    iconHBoxLayout->addWidget(m_icon, 0, Qt::AlignLeft);
//    iconHBoxLayout->addStretch();

    QVBoxLayout *textVLayout = new QVBoxLayout();
    textVLayout->setSpacing(0);
  //  textVLayout->setContentsMargins(0, 10, 0, 0);
    textVLayout->addStretch();
    textVLayout->addWidget(m_title);
    textVLayout->addSpacing(3);
    textVLayout->addWidget(m_description);
    textVLayout->addStretch();
   // textVLayout->setContentsMargins(0, 30, 0, 10);

    QVBoxLayout *checkBoxVLayout = new QVBoxLayout;
    if (Utils::isDirectionRTL()) {
        checkBoxVLayout->setContentsMargins(10, 10, 0, 0);
    } else {
        checkBoxVLayout->setContentsMargins(0, 10, 10, 0);
    }
    checkBoxVLayout->addWidget(m_checkIcon, 0, Qt::AlignTop);
    checkBoxVLayout->addStretch();

    iconHBoxLayout->addLayout(textVLayout);
    auto hBoxLayout = new QHBoxLayout;
    hBoxLayout->addLayout(iconHBoxLayout);
    hBoxLayout->addLayout(checkBoxVLayout);

    centralLayout->addLayout(hBoxLayout);
//    centralLayout->setSpacing(0);
    this->setLayout(centralLayout);
}

void ItemFrame::setCheckState(bool checked)
{
    m_bChecked = checked;
    if (m_bChecked) {
        m_checkIcon->setVisible(true);
        m_checkIcon->setPixmap(m_radioPixmap);
        m_bChecked = true;
    } else {
        m_checkIcon->setPixmap(QPixmap());
        m_bChecked = false;
    }
}

bool ItemFrame::checkState()
{
    return m_bChecked;
}

void ItemFrame::showDescription(bool isShow)
{
    m_description->setVisible(isShow);
}

bool ItemFrame::event(QEvent *e)
{
    if (e->type() == QEvent::HoverEnter) {
        setBackgroundRole(DPalette::ObviousBackground);
    } else if (e->type() == QEvent::HoverLeave) {
        setBackgroundRole(DPalette::ItemBackground);
    } else if (e->type() == QEvent::MouseButtonRelease) {
       if (!m_bChecked) {
           m_checkIcon->setVisible(true);
           m_checkIcon->setPixmap(m_radioPixmap);
           m_bChecked = true;
       }
       Q_EMIT clicked(m_bChecked);
    }
    return QFrame::event(e);
}


